/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.InnerFrozenDepositFactory;
import com.kingdee.eas.fm.fs.InnerFrozenDepositInfo;
import com.kingdee.eas.fm.fs.InnerFrozenDepositType;
import com.kingdee.eas.fm.fs.client.AbstractInnerFrozenDepositEditUI;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.InnerFrozenBillHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class InnerFrozenDepositEditUI
extends AbstractInnerFrozenDepositEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerFrozenDepositEditUI.class);
    private static String resourcePath = "com.kingdee.eas.fm.fs.InnerFrozenDepositResource";
    BigDecimal curInnerAcctBalance = Constants.ZERO;
    BigDecimal totalFrozenAmtDesc = Constants.ZERO;
    BigDecimal useBalanceDesc = Constants.ZERO;
    private InnerFrozenBillHandler handler = InnerFrozenBillHandler.create();
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return super.getBizInterface();
    }

    @Override
    protected String getEditUIName() {
        return super.getEditUIName();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("currency.*");
        return sic;
    }

    @Override
    protected void prmtinnerAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtinnerAccount_dataChanged(e);
        this.setBalanceValue();
    }

    private void setBalanceValue() throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        InnerAccountInfo innerAcctInfo = (InnerAccountInfo)this.prmtinnerAccount.getValue();
        if (innerAcctInfo != null) {
            this.prmtcurCompany.setData((Object)innerAcctInfo.getApplyUnit());
        }
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(true);
        this.curInnerAcctBalance = this.handler.getBalanceValue(currencyInfo, innerAcctInfo);
        this.txtcurBalance.setValue((Object)this.curInnerAcctBalance);
        if (currencyInfo != null && innerAcctInfo != null) {
            this.totalFrozenAmtDesc = this.handler.getFrozenBalanceValue(currencyInfo.getId().toString(), innerAcctInfo.getId().toString());
        }
        this.txttotalFrozenAmt.setValue((Object)this.totalFrozenAmtDesc);
        this.useBalanceDesc = this.curInnerAcctBalance.subtract(this.totalFrozenAmtDesc);
        this.txtuseBalance.setValue((Object)this.useBalanceDesc);
        this.txtfrozenAmt.setValue((Object)Constants.ZERO);
    }

    protected void initUIProp() throws Exception {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.txtfrozenAmt.setHorizontalAlignment(4);
        this.txtfrozenAmt.setRemoveingZeroInDispaly(false);
        this.txtfrozenAmt.setNegatived(false);
        this.txtfrozenAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtcurBalance.setHorizontalAlignment(4);
        this.txtcurBalance.setRemoveingZeroInDispaly(false);
        this.txtuseBalance.setHorizontalAlignment(4);
        this.txtuseBalance.setRemoveingZeroInDispaly(false);
        this.txttotalFrozenAmt.setHorizontalAlignment(4);
        this.txttotalFrozenAmt.setRemoveingZeroInDispaly(false);
        this.txttotalFrozenAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.handler.setInnerAcctF7(this.prmtinnerAccount, true, this.currentCompany.getId().toString());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtcurBalance.setEnabled(false);
        this.txtuseBalance.setEnabled(false);
        this.txttotalFrozenAmt.setEnabled(false);
        this.txtDescription.setMaxLength(100);
        if (this.getUIContext().get("id") != null) {
            this.actionAddNew.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionEdit.setVisible(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getFrozenAmt() != null) {
            this.txtOldForzenAmt.setValue((Object)this.editData.getFrozenAmt().abs());
            this.txtfrozenAmt.setValue((Object)this.editData.getFrozenAmt().abs());
        }
        try {
            if (this.editData.getInnerAccount() != null && this.editData.getCurrency() != null) {
                BigDecimal curInnerAcctBalance = this.handler.getBalanceValue(this.editData.getCurrency(), this.editData.getInnerAccount());
                this.txtcurBalance.setValue((Object)curInnerAcctBalance);
                BigDecimal totalFrozenAmt = this.handler.getFrozenBalanceValue(this.editData.getCurrency().getId().toString(), this.editData.getInnerAccount().getId().toString());
                this.txttotalFrozenAmt.setValue((Object)totalFrozenAmt);
                this.useBalanceDesc = curInnerAcctBalance.subtract(this.totalFrozenAmtDesc);
                this.txtuseBalance.setValue((Object)this.useBalanceDesc);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        String oprtS = this.getOprtState();
        super.storeFields();
        if (InnerFrozenDepositType.UNFROZEN.equals((Object)this.editData.getType())) {
            this.editData.setFrozenAmt(this.txtfrozenAmt.getBigDecimalValue().negate());
        }
        if (oprtS.equals("ADDNEW")) {
            int frozenNumber = 0;
            try {
                if (this.editData.getInnerAccount() != null) {
                    frozenNumber = this.handler.getFrozenNumber(this.editData.getInnerAccount().getId().toString(), this.editData.getCurrency().getId().toString());
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.editData.setFrozenNumber(frozenNumber);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BigDecimal totalFrozeAmt;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        if (this.editData.getFrozenAmt().compareTo(Constants.ZERO) == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"amt_cannot_zero"));
            SysUtil.abort();
        }
        if (InnerFrozenDepositType.UNFROZEN.equals((Object)this.editData.getType()) && (totalFrozeAmt = this.txttotalFrozenAmt.getBigDecimalValue()).compareTo(Constants.ZERO) < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"unFrozenAmtTooBig"));
            SysUtil.abort();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        InnerFrozenDepositInfo objectValue = new InnerFrozenDepositInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        try {
            objectValue.setCurrency(CurrencyUtil.getLocalCurrency());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        objectValue.setType(InnerFrozenDepositType.FROZEN);
        return objectValue;
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionEdit.setEnabled(true);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setEnabled(true);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionAttachment.setVisible(false);
        String oprtS = this.getOprtState();
        if (oprtS.equals("EDIT")) {
            this.prmtinnerAccount.setEnabled(false);
            this.comboCurrency.setEnabled(false);
            this.type.setEnabled(false);
        }
        if (oprtS.equals("ADDNEW")) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        if (oprtS.equals("EDIT")) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        this.checkCanRemove(id);
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected void type_itemStateChanged(ItemEvent e) throws Exception {
        super.type_itemStateChanged(e);
        InnerFrozenDepositType frozenType = (InnerFrozenDepositType)((Object)this.type.getSelectedItem());
        this.txtfrozenAmt.setValue((Object)Constants.ZERO);
        if (InnerFrozenDepositType.UNFROZEN.equals((Object)frozenType)) {
            this.txtfrozenAmt.setCustomForegroundColor(Color.red);
            this.contfrozenAmt.setBoundLabelText(EASResource.getString((String)resourcePath, (String)"unfrozen_amt"));
        } else {
            this.txtfrozenAmt.setCustomForegroundColor(Color.black);
            this.contfrozenAmt.setBoundLabelText(EASResource.getString((String)resourcePath, (String)"frozen_amt"));
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.comboCurrency_itemStateChanged(e);
        CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.txtfrozenAmt.setPrecision(info.getPrecision());
        this.txtcurBalance.setPrecision(info.getPrecision());
        this.txtuseBalance.setPrecision(info.getPrecision());
        this.txttotalFrozenAmt.setPrecision(info.getPrecision());
        this.txtOldForzenAmt.setPrecision(info.getPrecision());
        this.setBalanceValue();
    }

    private void checkCanRemove(String id) {
        String reslut = "0";
        try {
            reslut = InnerFrozenDepositFactory.getRemoteInstance().checkCanRemove(id);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if ("1".equals(reslut)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"cannotremove"));
            SysUtil.abort();
        }
    }

    private void showMsg(ActionEvent e) {
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    @Override
    protected void txtfrozenAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtfrozenAmt_dataChanged(e);
        BigDecimal oldFrozenAmt = Constants.ZERO;
        String oprtS = this.getOprtState();
        InnerFrozenDepositType frozenType = (InnerFrozenDepositType)((Object)this.type.getSelectedItem());
        if (this.txtfrozenAmt.getBigDecimalValue() != null) {
            BigDecimal frozenAmt = this.txtfrozenAmt.getBigDecimalValue();
            if (oprtS.equals("EDIT") && (oldFrozenAmt = this.txtOldForzenAmt.getBigDecimalValue()) != null) {
                frozenAmt = frozenAmt.subtract(oldFrozenAmt);
            }
            if (!oprtS.equals("VIEW")) {
                if (InnerFrozenDepositType.FROZEN.equals((Object)frozenType)) {
                    this.txtuseBalance.setValue((Object)this.useBalanceDesc.subtract(frozenAmt));
                    this.txttotalFrozenAmt.setValue((Object)this.totalFrozenAmtDesc.add(frozenAmt));
                } else {
                    this.txtuseBalance.setValue((Object)this.useBalanceDesc.add(frozenAmt));
                    this.txttotalFrozenAmt.setValue((Object)this.totalFrozenAmtDesc.subtract(frozenAmt));
                }
            }
        }
    }

    public boolean isModify() {
        boolean ifModify = super.isModify();
        if (ifModify && this.getOprtState().equals("EDIT") && this.txtOldForzenAmt.getBigDecimalValue().compareTo(this.txtfrozenAmt.getBigDecimalValue()) == 0) {
            return false;
        }
        return ifModify;
    }
}

