/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.client.AbstractInnerPileOfMoneyUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.InnerPileOfMoneyFilterParam;
import com.kingdee.eas.fm.fs.client.InnerPileOfMoneyFilterUI;
import com.kingdee.eas.fm.fs.client.InnerPileOfMoneyHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InnerPileOfMoneyUI
extends AbstractInnerPileOfMoneyUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerPileOfMoneyUI.class);
    private InnerPileOfMoneyFilterUI filterUI;
    private InnerPileOfMoneyHandler handler;
    private static String resourcePath = "com.kingdee.eas.fm.fs.client.PileOfMoneyResource";
    private BankInfo clearingHouse;

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        InnerPileOfMoneyFilterParam param = (InnerPileOfMoneyFilterParam)this.getFilterParam();
        this.handler = new InnerPileOfMoneyHandler();
        this.txtCurrency.setText(param.getCurrencyName());
        this.txtCurrency.setEditable(false);
        String datePeriod = "";
        datePeriod = param.isByDay() ? Constants.FORMAT_DAY.format(param.getFromDate()) + " - " + Constants.FORMAT_DAY.format(param.getToDate()) : param.getBeginYear() + "-" + param.getBeginMonth() + " - " + param.getEndYear() + "-" + param.getEndMonth();
        this.txtDate.setText(datePeriod);
        this.txtDate.setEditable(false);
        String tempAmount = EASResource.getString((String)resourcePath, (String)"AmountGreater") + param.getInAmount();
        this.txtInAmount.setText(tempAmount);
        this.txtInAmount.setEditable(false);
        tempAmount = EASResource.getString((String)resourcePath, (String)"AmountGreater") + param.getOutAmount();
        this.txtOutAmount.setText(tempAmount);
        this.txtOutAmount.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.getHeadRow(0).getCell("payeeBankAcct").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"105_InnerPileOfMoneyUI"));
        this.tblMain.removeRows();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        IRowSet rs = this.handler.getRowset(this.mainQueryPK, this.mainQuery, param);
        this.handler.setCurrencyFormat(this.tblMain, param);
        try {
            this.handler.fillDataAndGroup(this.tblMain, rs, param);
        }
        catch (SQLException e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new InnerPileOfMoneyFilterUI();
        }
        return this.filterUI;
    }

    private void checkClearHourse(CompanyOrgUnitInfo company) throws Exception {
        if (!FSClientHelper.clearingHouseIsUsed(company.getId().toString())) {
            throw new FSException(FSException.CLEARINGHOUSENOTSETTED);
        }
    }

    private void checkClearHourse() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
    }

    public void onLoad() throws Exception {
        this.checkClearHourse();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        super.onLoad();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.lblCurrency.getBoundLabelText()).append("&[Currency]&| ").append(this.lblDate.getBoundLabelText()).append("&[dateArea]&|").append(this.lblInAmount.getBoundLabelText()).append("&[inAmount]").append(this.lblOutAmount.getBoundLabelText()).append("&[outAmount]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Currency", this.txtCurrency.getText());
        map.put("dateArea", this.txtDate.getText());
        map.put("inAmount", this.txtInAmount.getText());
        map.put("outAmount", this.txtOutAmount.getText());
        return map;
    }
}

