/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.OutstandingEnum;
import com.kingdee.eas.fm.fs.client.AbstractOutstandingFilterUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.OutstandingFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class OutstandingFilterUI
extends AbstractOutstandingFilterUI {
    private CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo companyBaseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.company);
    private String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void init() throws Exception {
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        super.init();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        OutstandingFilterParam param = new OutstandingFilterParam();
        String[] companyIds = this.getCompanyIds();
        param.setCompanyIdAry(companyIds);
        if (this.cboCurrency.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        }
        param.setDc(((OutstandingEnum)((Object)this.cboDC.getSelectedItem())).getValue());
        param.setDays(AccessHelper.getSpiValue((KDSpinner)this.spiDays));
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof OutstandingFilterParam)) {
            return;
        }
        OutstandingFilterParam outstandingFilterParam = (OutstandingFilterParam)param;
        String[] companyIds = outstandingFilterParam.getCompanyIdAry();
        this.setCompanyIds(companyIds);
        String currencyId = outstandingFilterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.cboDC.setSelectedItem((Object)OutstandingEnum.getEnum(outstandingFilterParam.getDc()));
        this.spiDays.setValue((Object)new Integer(outstandingFilterParam.getDays()));
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        this.chkIA.setEnabled(true);
        this.btnCompanySelect.setEnabled(true);
        this.btnCompanySelect.setVisible(true);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.companyBaseCurrency);
        this.cboDC.setSelectedItem((Object)OutstandingEnum.ALL);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 9999, 1);
        this.spiDays.setModel((SpinnerModel)model);
        this.btnCompanySelect.setVisible(false);
    }

    protected Class getParamClass() {
        return OutstandingFilterParam.class;
    }
}

