/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.AbstractPileOfMoneyFilterUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.PileOfMoneyFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Set;
import javax.swing.event.ChangeEvent;

public class PileOfMoneyFilterUI
extends AbstractPileOfMoneyFilterUI {
    public static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";

    protected void init() throws Exception {
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        super.init();
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndMonth);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    @Override
    protected void rdbByMonth_stateChanged(ChangeEvent e) throws Exception {
        this.pnlByMonth.setVisible(false);
        this.pnlByDay.setVisible(false);
        if (this.rdbByMonth.isSelected()) {
            this.pnlByMonth.setVisible(true);
        } else {
            this.pnlByDay.setVisible(true);
        }
    }

    @Override
    protected void cboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        int prec = 2;
        if (!(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum) && this.cboCurrency.getSelectedItem() instanceof CurrencyInfo) {
            CurrencyInfo currInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
            prec = currInfo.getPrecision();
        }
        this.spiInAmount.setPrecision(prec);
        this.spiOutAmount.setPrecision(prec);
    }

    public Object getParam() {
        PileOfMoneyFilterParam para = new PileOfMoneyFilterParam();
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        if (!(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.cboCurrency));
        }
        if (!(this.cboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            para.setCurrencyName((String)AccessHelper.getCboAttribute((KDComboBox)this.cboCurrency, (String)"name"));
        } else {
            para.setCurrencyName(FMSysDefinedEnum.SELECT_ALL.getAlias());
        }
        para.setToDate(this.dtpToDate.getSqlDate());
        para.setFromDate(this.dtpFromDate.getSqlDate());
        para.setInAmount(this.spiInAmount.getBigDecimalValue());
        para.setOutAmount(this.spiOutAmount.getBigDecimalValue());
        para.setIA(this.chkIA.isSelected());
        para.setDispAcctSubTotal(this.chkDispTotal.isSelected());
        para.setDispCompanyTotal(this.chkDispCompanyTotal.isSelected());
        para.setIncludeNotSettled(this.chkIncludeNotSettled.isSelected());
        para.setByDay(this.rdbByDay.isSelected());
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof PileOfMoneyFilterParam)) {
            return;
        }
        PileOfMoneyFilterParam filterParam = (PileOfMoneyFilterParam)param;
        String[] companyIds = filterParam.getCompanyIds();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort((Throwable)e);
        }
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currencyInfo);
            } else {
                this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.spiInAmount.setValue((Object)filterParam.getInAmount());
        this.spiOutAmount.setValue((Object)filterParam.getOutAmount());
        this.dtpToDate.setValue((Object)filterParam.getToDate());
        this.dtpFromDate.setValue((Object)filterParam.getFromDate());
        this.chkIA.setSelected(filterParam.isIA());
        this.chkDispTotal.setSelected(filterParam.isDispAcctSubTotal());
        this.chkDispCompanyTotal.setSelected(filterParam.isDispCompanyTotal());
        this.chkIncludeNotSettled.setSelected(filterParam.isIncludeNotSettled());
        this.rdbByDay.setSelected(filterParam.isByDay());
        this.rdbByMonth.setSelected(!filterParam.isByDay());
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
    }

    public boolean verify() {
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpToDate, (String)"NoDate");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpFromDate, (String)"NoDate");
        if (this.rdbByMonth.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiEndYear) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth)) {
                this.spiBeginYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        } else if (this.dtpToDate.getSqlDate().before(this.dtpFromDate.getSqlDate())) {
            this.dtpFromDate.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckDateFromTo"));
            SysUtil.abort();
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        BankInfo clearingHouse = null;
        try {
            clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(null);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (clearingHouse != null && FSClientHelper.isClearingHouseCompanyId("")) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
    }

    public void clear() {
        super.clear();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.spiInAmount.setValue((Object)Constants.ZERO);
        this.spiOutAmount.setValue((Object)Constants.ZERO);
        this.spiInAmount.setRemoveingZeroInDispaly(false);
        this.spiOutAmount.setRemoveingZeroInDispaly(false);
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
            String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            Set idSet = FMClientHelper.getUserCompanyIds((String)currentUserId);
            this.setCompanyIdSet(idSet);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.chkDispCompanyTotal.setSelected(true);
        this.chkDispTotal.setSelected(false);
        this.rdbByMonth.setSelected(true);
    }

    protected Class getParamClass() {
        return PileOfMoneyFilterParam.class;
    }
}

