/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.AbstractReceiveAccountFilterUI;
import com.kingdee.eas.fm.fs.client.SendRecAcctFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceiveAccountFilterUI
extends AbstractReceiveAccountFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveAccountFilterUI.class);
    CompanyOrgUnitInfo company = null;

    protected void init() throws Exception {
        super.init();
        if (this.company == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.customInit();
    }

    private void customInit() {
        Date beginDate = DateUtil.getFirstDayOfCurMonth();
        Date endDate = new Date();
        this.pkBeginDate.setValue((Object)beginDate);
        this.pkEndDate.setValue((Object)endDate);
        this.cbxUndealed.setSelected(true);
        this.cbxChecked.setSelected(false);
        this.cbxSettled.setSelected(false);
        this.cbxBacked.setSelected(false);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.company.getBaseCurrency());
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    public boolean verify() {
        if (this.pkBeginDate.getValue() == null || this.pkEndDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"110_ReceiveAccountFilterUI"));
            SysUtil.abort();
        }
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDate.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.pkEndDate.getValue()));
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        if (!(this.cbxUndealed.isSelected() || this.cbxChecked.isSelected() || this.cbxSettled.isSelected() || this.cbxBacked.isSelected())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"111_ReceiveAccountFilterUI"));
            SysUtil.abort();
        }
        return true;
    }

    public Object getParam() {
        SendRecAcctFilterParam param = new SendRecAcctFilterParam();
        param.setBeginDate((Date)this.pkBeginDate.getValue());
        param.setEndDate((Date)this.pkEndDate.getValue());
        if (this.comboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setCurrency(null);
        } else {
            param.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        }
        HashSet<String> statusSet = new HashSet<String>();
        if (this.cbxUndealed.isSelected()) {
            statusSet.add("undealed");
        }
        if (this.cbxChecked.isSelected()) {
            statusSet.add("checked");
        }
        if (this.cbxSettled.isSelected()) {
            statusSet.add("settleed");
        }
        if (this.cbxBacked.isSelected()) {
            statusSet.add("backBilled");
        }
        param.setStatusSet(statusSet);
        return param;
    }

    public void setParam(Object param) {
        if (param == null || !(param instanceof SendRecAcctFilterParam)) {
            return;
        }
        SendRecAcctFilterParam filterParam = (SendRecAcctFilterParam)param;
        this.pkBeginDate.setValue((Object)filterParam.getBeginDate());
        this.pkEndDate.setValue((Object)filterParam.getEndDate());
        if (filterParam.getCurrency() != null) {
            this.comboCurrency.setSelectedItem((Object)filterParam.getCurrency());
        } else {
            this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.cbxUndealed.setSelected(false);
        this.cbxChecked.setSelected(false);
        this.cbxSettled.setSelected(false);
        this.cbxBacked.setSelected(false);
        if (filterParam.getStatusSet() != null && !filterParam.getStatusSet().isEmpty()) {
            Set statusSet = filterParam.getStatusSet();
            for (String status : statusSet) {
                if (status.equals("undealed")) {
                    this.cbxUndealed.setSelected(true);
                    continue;
                }
                if (status.equals("checked")) {
                    this.cbxChecked.setSelected(true);
                    continue;
                }
                if (status.equals("settleed")) {
                    this.cbxSettled.setSelected(true);
                    continue;
                }
                if (!status.equals("backBilled")) continue;
                this.cbxBacked.setSelected(true);
            }
        }
    }

    protected Class getParamClass() {
        return SendRecAcctFilterParam.class;
    }
}

