/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.IReckoningAccount;
import com.kingdee.eas.fm.fs.ReckoningAccountFactory;
import com.kingdee.eas.fm.fs.ReckoningAccountInfo;
import com.kingdee.eas.fm.fs.client.AbstractReckoningAccountEditUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ReckoningAccountEditUI
extends AbstractReckoningAccountEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReckoningAccountEditUI.class);
    CompanyOrgUnitInfo company = null;

    public void onLoad() throws Exception {
        if (this.company == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        this.checkEnter();
        super.onLoad();
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        this.initF7Prop();
    }

    private void checkEnter() throws EASBizException, BOSException {
        if (OprtState.VIEW.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return;
        }
        FSClientHelper.checkClearingHouseCompany();
    }

    private void initF7Prop() throws EASBizException, BOSException {
        String companyId = this.company.getId().toString();
        BankInfo currentCH = BankFactory.getRemoteInstance().getClearingHouse(companyId);
        BankInfo parentCH = currentCH.getParentInGroup();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parentInGroup.id", (Object)currentCH.getId().toString()));
        if (parentCH != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)parentCH.getId().toString()));
            filter.setMaskString("#0 OR #1");
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtClearingHouse.setEntityViewInfo(evi);
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.company.getCU().getId().toString()));
        filter2.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.company.getAccountTable().getId().toString()));
        filter2.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter2.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setFilter(filter2);
        AccountPromptBox selector = new AccountPromptBox((IUIObject)this, this.company, filter2, false, true);
        this.prmtAcctView.setEntityViewInfo(evi2);
        this.prmtAcctView.setSelector((KDPromptSelector)selector);
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    public void loadFields() {
        try {
            boolean isReferenced = ((IReckoningAccount)this.getBizInterface()).isReferenced(this.editData.getId());
            this.prmtClearingHouse.setEnabled(!isReferenced);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort(e);
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        this.txtNumber.setRequired(this.txtNumber.isEnabled());
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        boolean isReferenced = ((IReckoningAccount)this.getBizInterface()).isReferenced(this.editData.getId());
        if (isReferenced) {
            this.prmtClearingHouse.setEnabled(false);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected String getEditUIName() {
        return ReckoningAccountEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReckoningAccountFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.*"));
        return sic;
    }

    @Override
    protected IObjectValue createNewData() {
        ReckoningAccountInfo info = new ReckoningAccountInfo();
        info.setCompany(this.company);
        return info;
    }
}

