/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.AbstractReconcileUI;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.ReconcileDetailParam;
import com.kingdee.eas.fm.fs.client.ReconcileDetailUI;
import com.kingdee.eas.fm.fs.client.ReconcileFilterParam;
import com.kingdee.eas.fm.fs.client.ReconcileFilterUI;
import com.kingdee.eas.fm.fs.client.ReconcileHandler;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

public class ReconcileUI
extends AbstractReconcileUI {
    private String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    private ReconcileFilterParam param;
    InnerAccountCollection coll = null;
    private ReconcileFilterUI filterUI;
    private BankInfo clearingHouse;
    boolean refreshTree = false;

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeList_valueChanged(e);
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeList.getModel().getRoot();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        ReconcileFilterParam param = (ReconcileFilterParam)this.getFilterParam();
        Object info = node.getUserObject();
        this.coll = this.getInnerAcctColl(info);
        ReconcileHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        FMClientHelper.clearTable((KDTable)this.tblMain);
        if (this.coll == null || this.coll.size() == 0) {
            return;
        }
        handler.initTable(this.tblMain);
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        handler.setColumnFormat(this.tblMain, param);
        handler.fillData(param, this.coll, this.tblMain);
    }

    private InnerAccountCollection getInnerAcctColl(Object info) throws BOSException {
        InnerAccountCollection coll = new InnerAccountCollection();
        if (info instanceof InnerAccountInfo) {
            coll.add((InnerAccountInfo)info);
        }
        if (info instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            CompanyOrgUnitInfo com = (CompanyOrgUnitInfo)info;
            String lnumber = com.getLongNumber();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String sql = "select fid from t_org_company where flongnumber like '" + lnumber + "!%' or flongnumber='" + lnumber + "'";
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)sql, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)chCompany.getId().toString()));
            ev.setFilter(filter);
            ev.getSelector().add("*");
            ev.getSelector().add("applyUnit.*");
            ev.getSelector().add("acctView.*");
            IInnerAccount ia = InnerAccountFactory.getRemoteInstance();
            coll.addCollection(ia.getInnerAccountCollection(ev));
        }
        return coll;
    }

    protected void execQuery() throws BOSException {
        this.param = (ReconcileFilterParam)this.getFilterParam();
        ReconcileHandler handler = FSAnalysisHandlerFactory.getHandler(this.param);
        CurrencyInfo currency = null;
        try {
            currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.param.getCurrencyId())));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.txtCurrency.setText(currency.getName());
        String datePeriod = "";
        if (this.param.isByPeriod()) {
            datePeriod = this.param.getBeginYear() + "-" + this.param.getBeginMonth() + " - " + this.param.getEndYear() + "-" + this.param.getEndMonth();
        } else {
            DateFormat dateFormat = CtrlFormatUtilities.getDateFormat();
            datePeriod = dateFormat.format(this.param.getBeginDate()) + " - " + dateFormat.format(this.param.getEndDate());
        }
        this.txtPeriodRange.setText(datePeriod);
        this.txtPeriodRange.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        handler.initTree(this.param, this.treeList);
        FMClientHelper.goLeaf((KDTree)this.treeList);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReconcileFilterUI();
        }
        return this.filterUI;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_differentia"));
    }

    private void checkClearHourse() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
    }

    public void onLoad() throws Exception {
        this.checkClearHourse();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.actionViewDetail.setEnabled(true);
        super.onLoad();
        this.refreshTree = true;
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        if (this.coll == null || this.coll.size() == 0) {
            return;
        }
        ReconcileDetailParam detailParam = new ReconcileDetailParam();
        detailParam.setCompanyId(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        detailParam.setInnAcctColl(this.coll);
        detailParam.setCurrencyId(this.param.getCurrencyId());
        detailParam.setByPeriod(this.param.isByPeriod());
        if (detailParam.isByPeriod()) {
            detailParam.setBeginYear(this.param.getBeginYear());
            detailParam.setEndYear(this.param.getEndYear());
            detailParam.setBeginPeriod(this.param.getBeginMonth());
            detailParam.setEndPeriod(this.param.getEndMonth());
        } else {
            detailParam.setBeginDate(this.param.getBeginDate());
            detailParam.setEndDate(this.param.getEndDate());
        }
        detailParam.setIncludeUnPostVoucher(this.param.isIncludeUnPostVoucher());
        BigDecimal beginBalanceDiff = (BigDecimal)this.tblMain.getCell(0, "Difference").getValue();
        if (beginBalanceDiff == null) {
            beginBalanceDiff = SysConstant.BIGZERO;
        }
        detailParam.setBeginBalanceDiff(beginBalanceDiff);
        BigDecimal debitAmountDiff = (BigDecimal)this.tblMain.getCell(1, "Difference").getValue();
        BigDecimal creditAmountDiff = (BigDecimal)this.tblMain.getCell(2, "Difference").getValue();
        if (debitAmountDiff == null) {
            debitAmountDiff = SysConstant.BIGZERO;
        }
        if (creditAmountDiff == null) {
            creditAmountDiff = SysConstant.BIGZERO;
        }
        detailParam.setDiff(debitAmountDiff.subtract(creditAmountDiff));
        BigDecimal endBalanceDiff = (BigDecimal)this.tblMain.getCell(3, "Difference").getValue();
        if (endBalanceDiff == null) {
            endBalanceDiff = SysConstant.BIGZERO;
        }
        detailParam.setEndBalanceDiff(endBalanceDiff);
        ReconcileDetailUI.showDialogWindow((IUIObject)this, detailParam);
        super.actionViewDetail_actionPerformed(e);
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.treeList.requestFocus();
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String periodRange = EASResource.getString((String)this.resourcePath, (String)"PeriodRange") + ":&[PeriodRange]";
        String currency = EASResource.getString((String)this.resourcePath, (String)"Currency") + ":&[Currency]";
        String headString = periodRange + "&|" + currency;
        headerModel.addRow(headString);
    }

    protected void preparePrintPageFooter(HeadFootModel footerModel) {
    }

    protected Map preparePrintVariantMap() {
        Map map = super.preparePrintVariantMap();
        map.put("PeriodRange", this.txtPeriodRange.getText());
        map.put("Currency", this.txtCurrency.getText());
        return map;
    }
}

