/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.ISendAccount;
import com.kingdee.eas.fm.fs.client.AbstractSendAccountEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SendAccountEditUI
extends AbstractSendAccountEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SendAccountEditUI.class);

    public void onLoad() throws Exception {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        super.onLoad();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!company.getId().equals((Object)this.editData.getCompany().getId()) || this.getOprtState().equals("FINDVIEW")) {
            this.actionCheck.setVisible(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_review"));
        this.actionViewBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.menuSubmitOption.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuTool.setVisible(false);
        this.menuWorkflow.setVisible(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        ItemAction[] actions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionSave, this.actionSubmit, this.actionRemove, this.actionCopy, this.actionAttachment, this.actionCreateTo, this.actionCreateFrom, this.actionAddLine, this.actionInsertLine, this.actionRemoveLine, this.actionPrint, this.actionPrintPreview, this.actionFirst, this.actionPre, this.actionNext, this.actionLast, this.actionTraceUp, this.actionTraceDown, this.actionMultiapprove, this.actionNextPerson, this.actionWorkFlowG, this.actionVoucher, this.actionDelVoucher};
        boolean isVisible = false;
        this.setActionVisible(actions, isVisible);
        this.cbxIsBackBill.setEnabled(false);
    }

    private void setActionVisible(ItemAction[] actions, boolean isVisible) {
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setVisible(isVisible);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        int prec = this.editData.getCurrency().getPrecision();
        this.txtAmount.setPrecision(prec);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtAmount.setHorizontalAlignment(4);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("srcSettlementBill.id");
        sic.add("company.id");
        sic.add("currency.*");
        return sic;
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        ((ISendAccount)this.getBizInterface()).check(idSet);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkObjectExists();
        String srcId = this.editData.getSrcSettlementBill().getId().toString();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)srcId, (CompanyOrgUnitInfo)company);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.editData.getId() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }
}

