/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.ISendAccount;
import com.kingdee.eas.fm.fs.SendAcctHelper;
import com.kingdee.eas.fm.fs.client.AbstractSendAccountListUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SendAccountFilterUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SendAccountListUI
extends AbstractSendAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(SendAccountListUI.class);
    SendAccountFilterUI filterUI;
    private FillListener fillListener = new FillListener();

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void onLoad() throws Exception {
        this.checkEnter();
        super.onLoad();
        this.initDataStatus();
        String dformat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("submitDate").getStyleAttributes().setNumberFormat(dformat);
    }

    private void checkEnter() throws EASBizException, BOSException {
        if (OprtState.VIEW.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return;
        }
        FSClientHelper.checkClearingHouseCompany();
    }

    private void initDataStatus() {
        ItemAction[] actions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionAttachment, this.actionCreateTo, this.actionCopyTo, this.actionMultiapprove, this.actionNextPerson, this.actionWorkFlowG, this.actionVoucher, this.actionDelVoucher, this.actionAuditResult, this.actionViewDoProccess};
        boolean isVisible = false;
        int len = actions.length;
        for (int i = 0; i < len; ++i) {
            actions[i].setVisible(isVisible);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_review"));
        this.menuWorkFlow.setVisible(false);
        this.menuTool.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if ("FINDVIEW".equals(this.getOprtState())) {
            return null;
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        return filter;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SendAccountFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        ArrayList idList = this.getSelectedIdValues();
        ((ISendAccount)this.getBizInterface()).check(FMHelper.list2Set((List)idList));
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        this.refreshList();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            SendAcctHelper.setListUITable(SendAccountListUI.this.tblMain, e);
        }
    }
}

