/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.AbstractSettleLedgerHandler;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettleLedgerFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SettleLedgerByCompanyHandler
extends AbstractSettleLedgerHandler {
    @Override
    public void initTree(KDTree treeList, SettleLedgerFilterParam param) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("isLeaf");
        sic.add("isUnion");
        sic.add("parent");
        sic.add("isBizUnit");
        sic.add("isCompanyOrgUnit");
        sic.add("accountTable.id");
        sic.add("accountTable.number");
        CompanyOrgUnitCollection companyCol = FMClientHelper.getCompanyOrgUnitCollection((Set)FMHelper.Array2Set((String[])param.getCompanyIdAry()), (boolean)true, (SelectorItemCollection)sic);
        FSClientHelper.fillInnerAcctByCompanySupportCache(treeList, companyCol, true);
    }

    @Override
    public void initTable(KDTable tblMain, SettleLedgerFilterParam param) throws BOSException {
        super.initTable(tblMain, param);
        tblMain.getColumn(0).getStyleAttributes().setHided(true);
    }

    public void _initTable(KDTable tblMain, SettleLedgerFilterParam param) {
        String column_period = EASResource.getString((String)this.resourcePath, (String)"Period");
        String column_currency = EASResource.getString((String)this.resourcePath, (String)"Currency");
        String column_settlementAmount = EASResource.getString((String)this.resourcePath, (String)"SettlementAmount");
        String column_settlementMoney = EASResource.getString((String)this.resourcePath, (String)"SettlementMoney");
        tblMain.checkParsed();
        IRow headRow = tblMain.addHeadRow();
        tblMain.addColumn().setKey("Project");
        tblMain.addColumn().setKey("currency");
        IColumn column1 = tblMain.addColumn();
        column1.setKey("settlementAmount");
        column1.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn column2 = tblMain.addColumn();
        column2.setKey("settlementMoney");
        column2.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        headRow.getCell("Project").setValue((Object)column_period);
        headRow.getCell("currency").setValue((Object)column_currency);
        headRow.getCell("settlementAmount").setValue((Object)column_settlementAmount);
        headRow.getCell("settlementMoney").setValue((Object)column_settlementMoney);
    }

    private void fillData(KDTable tblMain, SettleLedgerFilterParam param, String innerAccountID, EntityViewInfo mainQuery, IMetaDataPK mainQueryPK) throws Exception {
        String period;
        BigDecimal settleMoney;
        int settleAmount;
        String currencyName;
        String currencyID;
        int month;
        int year;
        IRow row;
        IRowSet initRowSet;
        IRowSet rowSet = this.getRowSet(param, innerAccountID, mainQuery, mainQueryPK);
        HashMap map = new HashMap();
        int i = 0;
        GregorianCalendar begincal = new GregorianCalendar(param.getBeginYear(), param.getBeginMonth() - 1, 1);
        Date openDate = this.getOpenDate();
        GregorianCalendar openCal = new GregorianCalendar();
        openCal.setTime(openDate);
        boolean isBeforeOpenDate = begincal.getTime().before(openDate);
        if (isBeforeOpenDate && begincal.get(2) < openCal.get(2) && (initRowSet = this.getInitRowSet(param.getCurrencyId(), innerAccountID)).next()) {
            row = tblMain.addRow();
            year = initRowSet.getInt("fyear");
            month = initRowSet.getInt("fmonth");
            currencyID = initRowSet.getString("currencyId");
            currencyName = initRowSet.getString("currencyName");
            settleAmount = initRowSet.getInt("settAmt");
            settleMoney = initRowSet.getBigDecimal("moneyAmt");
            period = year + "-" + month;
            row.getCell("Project").setValue((Object)period);
            row.getCell("currency").setValue((Object)currencyName);
            row.getCell("settlementAmount").setValue((Object)new Integer(settleAmount));
            row.getCell("settlementMoney").setValue((Object)settleMoney);
            this.setNumberFormat(row, "settlementMoney", currencyID);
            this.calculateTotal(tblMain, map, currencyID, currencyName, rowSet);
            i = 1;
        }
        while (rowSet.next()) {
            year = rowSet.getInt("YEAR");
            month = rowSet.getInt("MONTH");
            row = tblMain.addRow(i);
            currencyID = rowSet.getString("CURRENCYID");
            currencyName = rowSet.getString("CURRENCYNAME");
            settleAmount = rowSet.getInt("SETTLEMENTAMOUNT");
            settleMoney = rowSet.getBigDecimal("SETTLEMENTMONEY");
            if (isBeforeOpenDate && year == param.getBeginYear() && month == param.getBeginMonth() && (initRowSet = this.getInitRowSet(param.getCurrencyId(), innerAccountID)).next()) {
                settleAmount += initRowSet.getInt("settAmt");
                settleMoney = settleMoney.add(initRowSet.getBigDecimal("moneyAmt"));
            }
            period = year + "-" + month;
            row.getCell("Project").setValue((Object)period);
            row.getCell("currency").setValue((Object)currencyName);
            row.getCell("settlementAmount").setValue((Object)new Integer(settleAmount));
            row.getCell("settlementMoney").setValue((Object)settleMoney);
            this.setNumberFormat(row, "settlementMoney", currencyID);
            this.calculateTotal(tblMain, map, currencyID, currencyName, rowSet);
            ++i;
        }
    }

    private IRowSet getRowSet(SettleLedgerFilterParam param, Object condition, EntityViewInfo mainQuery, IMetaDataPK mainQueryPK) throws SQLException {
        InnerAccountInfo acctInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        EntityViewInfo evi = (EntityViewInfo)mainQuery.clone();
        FilterInfo fi = evi.getFilter();
        if (condition instanceof InnerAccountInfo) {
            acctInfo = (InnerAccountInfo)condition;
            fi.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)acctInfo.getId().toString()));
            try {
                IRowSet rowSet = this.getInnerAccRowSet(param, acctInfo.getId().toString());
                return rowSet;
            }
            catch (BOSException e) {
                SysUtil.abort((Throwable)e);
            }
        } else {
            companyInfo = (CompanyOrgUnitInfo)condition;
            try {
                HashSet<String> set = new HashSet<String>();
                if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
                    String lnumber = companyInfo.getLongNumber();
                    String sql = "select fid from t_org_company where flongnumber like '" + lnumber + "!%' or flongnumber='" + lnumber + "'";
                    IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                    Object[] cids = param.getCompanyIdAry();
                    Arrays.sort(cids);
                    while (rs.next()) {
                        String rid = rs.getString(1);
                        if (Arrays.binarySearch(cids, rid) < 0) continue;
                        set.add(rs.getString(1));
                    }
                }
                set.add(companyInfo.getId().toString());
                IRowSet rowSet = this.getCompanyRowSet(param, set.toArray(new String[set.size()]));
                return rowSet;
            }
            catch (BOSException e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return null;
    }

    private void setRowColor(IRow row) {
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
    }

    private void calculateTotal(KDTable tblMain, Map map, String currencyID, String currencyName, IRowSet rowSet) throws SQLException {
        int settleAmount = rowSet.getInt("SETTLEMENTAMOUNT");
        BigDecimal settleMoney = rowSet.getBigDecimal("SETTLEMENTMONEY");
        settleMoney = settleMoney == null ? Constants.ZERO : settleMoney;
        int outterInSettlementAmount = rowSet.getInt("outterInSettlementAmount");
        BigDecimal outterInSettlementMoney = rowSet.getBigDecimal("outterInSettlementMoney");
        outterInSettlementMoney = outterInSettlementMoney == null ? Constants.ZERO : outterInSettlementMoney;
        int outeroutSettlementAmount = rowSet.getInt("outeroutSettlementAmount");
        BigDecimal outteroutSettlementMoney = rowSet.getBigDecimal("outteroutSettlementMoney");
        outteroutSettlementMoney = outteroutSettlementMoney == null ? Constants.ZERO : outteroutSettlementMoney;
        int innerInSettlementAmount = rowSet.getInt("innerInSettlementAmount");
        BigDecimal innerInSettlementMoney = rowSet.getBigDecimal("innerInSettlementMoney");
        innerInSettlementMoney = innerInSettlementMoney == null ? Constants.ZERO : innerInSettlementMoney;
        int innerOutSettlementAmount = rowSet.getInt("innerOutSettlementAmount");
        BigDecimal innerOutSettlementMoney = rowSet.getBigDecimal("innerOutSettlementMoney");
        innerOutSettlementMoney = innerOutSettlementMoney == null ? Constants.ZERO : innerOutSettlementMoney;
        String column_total = EASResource.getString((String)this.resourcePath, (String)"Total");
        IRow row = (IRow)map.get(currencyID);
        if (row == null) {
            IRow newRow = tblMain.addRow();
            this.setNumberFormat(newRow, "settlementMoney", currencyID);
            this.setNumberFormat(newRow, "outterInSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "outeroutSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "innerInSettlementMoney", currencyID);
            this.setNumberFormat(newRow, "innerOutSettlementMoney", currencyID);
            this.setRowColor(newRow);
            map.put(currencyID, newRow);
            if (map.size() == 1) {
                newRow.getCell("Project").setValue((Object)column_total);
            }
            newRow.getCell("currency").setValue((Object)currencyName);
            newRow.getCell("settlementAmount").setValue((Object)new Integer(settleAmount));
            newRow.getCell("settlementMoney").setValue((Object)settleMoney);
            newRow.getCell("outterInSettlementAmount").setValue((Object)new Integer(outterInSettlementAmount));
            newRow.getCell("outterInSettlementMoney").setValue((Object)outterInSettlementMoney);
            newRow.getCell("outeroutSettlementAmount").setValue((Object)new Integer(outeroutSettlementAmount));
            newRow.getCell("outeroutSettlementMoney").setValue((Object)outteroutSettlementMoney);
            newRow.getCell("innerInSettlementAmount").setValue((Object)new Integer(innerInSettlementAmount));
            newRow.getCell("innerInSettlementMoney").setValue((Object)innerInSettlementMoney);
            newRow.getCell("innerOutSettlementAmount").setValue((Object)new Integer(innerOutSettlementAmount));
            newRow.getCell("innerOutSettlementMoney").setValue((Object)innerOutSettlementMoney);
        } else {
            Integer currencyAmount = (Integer)row.getCell("settlementAmount").getValue();
            row.getCell("settlementAmount").setValue((Object)new Integer(currencyAmount + settleAmount));
            BigDecimal currencyMoney = (BigDecimal)row.getCell("settlementMoney").getValue();
            row.getCell("settlementMoney").setValue((Object)currencyMoney.add(settleMoney));
            currencyAmount = (Integer)row.getCell("outterInSettlementAmount").getValue();
            row.getCell("outterInSettlementAmount").setValue((Object)new Integer(currencyAmount + outterInSettlementAmount));
            currencyMoney = (BigDecimal)row.getCell("outterInSettlementMoney").getValue();
            row.getCell("outterInSettlementMoney").setValue((Object)currencyMoney.add(outterInSettlementMoney));
            currencyAmount = (Integer)row.getCell("outeroutSettlementAmount").getValue();
            row.getCell("outeroutSettlementAmount").setValue((Object)new Integer(currencyAmount + outeroutSettlementAmount));
            currencyMoney = (BigDecimal)row.getCell("outeroutSettlementMoney").getValue();
            row.getCell("outeroutSettlementMoney").setValue((Object)currencyMoney.add(outteroutSettlementMoney));
            currencyAmount = (Integer)row.getCell("innerInSettlementAmount").getValue();
            row.getCell("innerInSettlementAmount").setValue((Object)new Integer(currencyAmount + innerInSettlementAmount));
            currencyMoney = (BigDecimal)row.getCell("innerInSettlementMoney").getValue();
            row.getCell("innerInSettlementMoney").setValue((Object)currencyMoney.add(innerInSettlementMoney));
            currencyAmount = (Integer)row.getCell("innerOutSettlementAmount").getValue();
            row.getCell("innerOutSettlementAmount").setValue((Object)new Integer(currencyAmount + innerOutSettlementAmount));
            currencyMoney = (BigDecimal)row.getCell("innerOutSettlementMoney").getValue();
            row.getCell("innerOutSettlementMoney").setValue((Object)currencyMoney.add(innerOutSettlementMoney));
        }
    }

    @Override
    public void fillData(KDTable tblMain, SettleLedgerFilterParam param, Object condition, EntityViewInfo evi, IMetaDataPK mainQueryPK) throws Exception {
        IRowSet rowSet = this.getRowSet(param, condition, evi, mainQueryPK);
        int year = 0;
        int month = 0;
        HashMap map = new HashMap();
        int i = 0;
        while (rowSet.next()) {
            year = rowSet.getInt("fYEAR");
            month = rowSet.getInt("fMONTH");
            IRow row = tblMain.addRow(i);
            String currencyID = rowSet.getString("CURRENCYID");
            String currencyName = rowSet.getString("CURRENCYNAME");
            String period = year + "-" + month;
            row.getCell("Project").setValue((Object)period);
            row.getCell("currency").setValue((Object)currencyName);
            int settleAmount = rowSet.getInt("SETTLEMENTAMOUNT");
            row.getCell("settlementAmount").setValue((Object)new Integer(settleAmount));
            BigDecimal settleMoney = rowSet.getBigDecimal("SETTLEMENTMONEY");
            row.getCell("settlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("SETTLEMENTAMOUNT");
            row.getCell("settlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("SETTLEMENTMONEY");
            row.getCell("settlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("outterInSettlementAmount");
            row.getCell("outterInSettlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("outterInSettlementMoney");
            row.getCell("outterInSettlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("outeroutSettlementAmount");
            row.getCell("outeroutSettlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("outteroutSettlementMoney");
            row.getCell("outeroutSettlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("innerInSettlementAmount");
            row.getCell("innerInSettlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("innerInSettlementMoney");
            row.getCell("innerInSettlementMoney").setValue((Object)settleMoney);
            settleAmount = rowSet.getInt("innerOutSettlementAmount");
            row.getCell("innerOutSettlementAmount").setValue((Object)new Integer(settleAmount));
            settleMoney = rowSet.getBigDecimal("innerOutSettlementMoney");
            row.getCell("innerOutSettlementMoney").setValue((Object)settleMoney);
            this.setNumberFormat(row, "settlementMoney", currencyID);
            this.setNumberFormat(row, "outterInSettlementMoney", currencyID);
            this.setNumberFormat(row, "outeroutSettlementMoney", currencyID);
            this.setNumberFormat(row, "innerInSettlementMoney", currencyID);
            this.setNumberFormat(row, "innerOutSettlementMoney", currencyID);
            this.calculateTotal(tblMain, map, currencyID, currencyName, rowSet);
            ++i;
        }
    }

    protected IRowSet getCompanyRowSet(SettleLedgerFilterParam param, String[] companyIds) throws BOSException {
        CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        Object acctInfo = null;
        Object companyInfo = null;
        StringBuffer sqlBuf = new StringBuffer(8);
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        GregorianCalendar begincal = new GregorianCalendar(param.getBeginYear(), param.getBeginMonth() - 1, 1);
        GregorianCalendar endcal = new GregorianCalendar(param.getEndYear(), param.getEndMonth(), 0, 23, 59, 59);
        sqlBuf.append("select count(a.fid) as SETTLEMENTAMOUNT, ");
        sqlBuf.append(" sum(isnull(a.FDebitAmount,0)+isnull(a.FCreditAmount,0)) as SETTLEMENTMONEY, ");
        sqlBuf.append("sum (case when fbiztype in (1)  and a.FDebitAmount <>0  then 1 else 0 end ) outterInSettlementAmount,");
        sqlBuf.append("sum (case when fbiztype in (1)  and a.FDebitAmount <>0  then a.FDebitAmount else 0 end ) outterInSettlementMoney,");
        sqlBuf.append("sum (case when fbiztype in (2)  and a.FCreditAmount <>0  then 1 else 0 end ) outeroutSettlementAmount,");
        sqlBuf.append("sum (case when fbiztype in (2)  and a.FCreditAmount <>0  then a.FCreditAmount else 0 end ) outteroutSettlementMoney,");
        sqlBuf.append("sum (case when fbiztype in(3,4) and a.FDebitAmount <>0 then 1 else 0 end ) innerInSettlementAmount,");
        sqlBuf.append("sum (case when fbiztype in(3,4) and  a.FDebitAmount <>0 then a.FDebitAmount else 0 end ) innerInSettlementMoney,");
        sqlBuf.append("sum (case when fbiztype in(3,4) and a.FCreditAmount <>0 then 1 else 0 end ) innerOutSettlementAmount,");
        sqlBuf.append("sum (case when fbiztype in(3,4) and   a.FCreditAmount <>0 then a.FCreditAmount else 0 end ) innerOutSettlementMoney,");
        sqlBuf.append("year(a.FDate) as fyear,month(a.FDate) as fmonth,");
        sqlBuf.append(" b.FName_").append(this.loc).append("  as currencyName, b.fid as currencyId ");
        sqlBuf.append(" from T_FS_SubsidiaryLedger a ");
        sqlBuf.append("INNER JOIN T_BD_Currency AS b  on a.FCurrencyID = b.FID");
        sqlBuf.append("  where 1=1 and ");
        sqlBuf.append(StringUtil.buildIn((String)"FApplyUnitId", (Object[])companyIds));
        sqlBuf.append(" and a.FCompanyId = '").append(chCompany.getId().toString()).append("'");
        sqlBuf.append(" and a.FDate>={");
        sqlBuf.append(FMConstants.FORMAT_DAY.format(begincal.getTime()));
        sqlBuf.append("}");
        sqlBuf.append(" and a.FDate<={");
        sqlBuf.append(FMConstants.FORMAT_DAY.format(endcal.getTime()));
        sqlBuf.append("}");
        if (param.getCurrencyId() != null) {
            sqlBuf.append(" and a.FCurrencyId='");
            sqlBuf.append(param.getCurrencyId());
            sqlBuf.append("'");
        }
        sqlBuf.append(" and a.FInnerAccountId is not null");
        sqlBuf.append(" and  FBizType in (1,2,3,4) ");
        sqlBuf.append(" group by year(a.FDate),month(a.FDate),b.FName_").append(this.loc).append(" ,b.fid  ");
        sqlBuf.append(" order by year(a.FDate),month(a.FDate) ");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sqlBuf.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }

    protected IRowSet getInnerAccRowSet(SettleLedgerFilterParam param, String innerAcct) throws BOSException {
        Object acctInfo = null;
        Object companyInfo = null;
        StringBuffer sqlBuf = new StringBuffer(8);
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        GregorianCalendar begincal = new GregorianCalendar(param.getBeginYear(), param.getBeginMonth() - 1, 1);
        GregorianCalendar endcal = new GregorianCalendar(param.getEndYear(), param.getEndMonth(), 0, 23, 59, 59);
        sqlBuf.append("select count(a.fid) as SETTLEMENTAMOUNT, ");
        sqlBuf.append(" sum(isnull(a.FDebitAmount,0)+isnull(a.FCreditAmount,0)) as SETTLEMENTMONEY, ");
        sqlBuf.append("sum (case fbiztype when 1 then 1 else 0 end ) outterInSettlementAmount,");
        sqlBuf.append("sum (case fbiztype when 1 then a.FDebitAmount else 0 end ) outterInSettlementMoney,");
        sqlBuf.append("sum (case fbiztype when 2 then 1 else 0 end ) outeroutSettlementAmount,");
        sqlBuf.append("sum (case fbiztype when 2 then a.FCreditAmount else 0 end ) outteroutSettlementMoney,");
        sqlBuf.append("sum (case when fbiztype in(3,4) and a.FDebitAmount <>0 then 1 else 0 end ) innerInSettlementAmount,");
        sqlBuf.append("sum (case when fbiztype in(3,4) and  a.FDebitAmount <>0 then a.FDebitAmount else 0 end ) innerInSettlementMoney,");
        sqlBuf.append("sum (case when fbiztype in(3,4) and a.FCreditAmount <>0 then 1 else 0 end ) innerOutSettlementAmount,");
        sqlBuf.append("sum (case when fbiztype in(3,4) and   a.FCreditAmount <>0 then a.FCreditAmount else 0 end ) innerOutSettlementMoney,");
        sqlBuf.append("year(a.FDate) as fyear,month(a.FDate) as fmonth,");
        sqlBuf.append(" b.FName_").append(this.loc).append("  as currencyName, b.fid as currencyId ");
        sqlBuf.append(" from T_FS_SubsidiaryLedger a ");
        sqlBuf.append("INNER JOIN T_BD_Currency AS b  on a.FCurrencyID = b.FID");
        sqlBuf.append("  where FInnerAccountId='");
        sqlBuf.append(innerAcct);
        sqlBuf.append("' and a.FDate>={");
        sqlBuf.append(FMConstants.FORMAT_DAY.format(begincal.getTime()));
        sqlBuf.append("}");
        sqlBuf.append(" and a.FDate<={");
        sqlBuf.append(FMConstants.FORMAT_DAY.format(endcal.getTime()));
        sqlBuf.append("}");
        if (param.getCurrencyId() != null) {
            sqlBuf.append(" and a.FCurrencyId='");
            sqlBuf.append(param.getCurrencyId());
            sqlBuf.append("'");
        }
        sqlBuf.append(" and a.FInnerAccountId is not null ");
        sqlBuf.append(" and  FBizType in (1,2,3,4) ");
        sqlBuf.append(" group by year(a.FDate),month(a.FDate),b.FName_").append(this.loc).append(" ,b.fid  ");
        sqlBuf.append(" order by year(a.FDate),month(a.FDate) ");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sqlBuf.toString());
        IRowSet rs = sqlExe.executeSQL();
        return rs;
    }
}

