/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fpl.client.FpItemClientHelper;
import com.kingdee.eas.fm.fs.BgCtrlSettleHandler;
import com.kingdee.eas.fm.fs.ISettleFacade;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.client.AbstractSettlementBillBaseUI;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettleBitBackUI;
import com.kingdee.eas.fm.fs.client.SettlementBillHandler;
import com.kingdee.eas.fm.fs.client.SettlementBillRecOutUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class SettlementBillBaseUI
extends AbstractSettlementBillBaseUI {
    private static final int ROUND = 4;
    private static final Logger logger = CoreUIObject.getLogger(SettlementBillBaseUI.class);
    private static String resourcePath = "com.kingdee.eas.fm.fs.SettlementBillUI";
    private Map balanceMap = new HashMap();
    private CompanyOrgUnitInfo clearingHouseCompany = FSClientHelper.getClearingHouseCompany();
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private SettlementBillHandler handler = SettlementBillHandler.create();

    public IUIObject getInstance(Map uiContext) {
        SettlementBillInfo info = (SettlementBillInfo)uiContext.get("InitDataObject");
        if (info == null && uiContext.get("DATAOBJECTS") != null) {
            info = (SettlementBillInfo)((Map)uiContext.get("DATAOBJECTS")).get("billInfo");
        }
        if (info == null && uiContext.get("ID") != null) {
            String id = this.getBillId(uiContext);
            info = this.getSettlementBillInfo(id);
        }
        if (info != null) {
            SettBizTypeEnum type = info.getType();
            switch (type.getValue()) {
                case 1: {
                    try {
                        return new SettlementBillRecOutUI();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
        return super.getInstance(uiContext);
    }

    private SettlementBillInfo getSettlementBillInfo(String id) {
        SettlementBillInfo info = null;
        ObjectUuidPK pk = new ObjectUuidPK(id);
        try {
            info = SettlementBillFactory.getRemoteInstance().getSettlementBillInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return info;
    }

    private String getBillId(Map uiContext) {
        String id = null;
        id = uiContext.get("ID") instanceof BOSUuid ? ((BOSUuid)uiContext.get("ID")).toString() : (uiContext.get("ID") instanceof String ? (String)uiContext.get("ID") : uiContext.get("ID").toString());
        return id;
    }

    public void onLoad() throws Exception {
        this.verifyCanIn();
        CurrencyUtil.fillCombCurrency(this.comboCurrency);
        super.onLoad();
        this.initUIProp();
    }

    private void verifyCanIn() throws EASBizException, BOSException {
        if (this.getOprtState().equals("FINDVIEW") || this.getOprtState().equals("VIEW")) {
            return;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"OnlyUnionNoIn"));
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAccept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_accept"));
        this.actionCancelAccept.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelcase"));
        this.actionSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_profitandloss"));
        this.actionUnSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_restore"));
        this.actionBitBack.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.menuTable1.setVisible(false);
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.txtNumber.setEnabled(false);
        }
        SettlementBillInfo info = (SettlementBillInfo)this.getDataObject();
        EntityViewInfo ev = this.getBizTypeFilter(info);
        this.prmtBizType.setEntityViewInfo(ev);
    }

    private EntityViewInfo getBizTypeFilter(SettlementBillInfo info) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(info.getType().getValue())));
        ev.setFilter(filter);
        return ev;
    }

    protected void initUIProp() {
        this.spinAppendix.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 999, 1));
        this.txtBalance1.setRemoveingZeroInDispaly(false);
        this.txtBalance2.setRemoveingZeroInDispaly(false);
        this.txtAmount.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtExchange.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtExchange.setRemoveingZeroInDispaly(false);
        this.txtLocalAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtLocalAmt.setRemoveingZeroInDispaly(false);
        int localPrec = FMClientHelper.getPrecOfCurrency((BOSUuid)this.clearingHouseCompany.getBaseCurrency().getId());
        this.txtLocalAmt.setPrecision(localPrec);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("clearingHouse.*"));
        sic.add(new SelectorItemInfo("applyUnit.*"));
        this.prmtPayerInnerAcct.setSelectorCollection(sic);
        this.prmtPayeeInnerAcct.setSelectorCollection(sic);
        FpItemClientHelper.setOrgView((KDBizPromptBox)this.prmtPayeePlanItem);
        FpItemClientHelper.setOrgView((KDBizPromptBox)this.prmtPayerPlanItem);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SettlementBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        SettlementBillInfo info = new SettlementBillInfo();
        UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        info.setType(this.getSettleBizType());
        info.setCurrency(this.clearingHouseCompany.getBaseCurrency());
        info.setExchange(Constants.ONE);
        info.setAmount(Constants.ZERO);
        info.setLocalAmt(Constants.ZERO);
        info.setAppendix(0);
        try {
            info.setBizDate(FSClientHelper.getClearingHouse().getSettleDate());
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        info.setIsAccepted(false);
        info.setIsTransfer(false);
        info.setFiVouchered(false);
        info.setIsGenPaymentBill(false);
        info.setIsGenReceivingBill(false);
        info.setCompany(this.clearingHouseCompany);
        String companyId = this.clearingHouseCompany.getId().toString();
        FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)companyId);
        info.setCreator(currentUser);
        return info;
    }

    protected SettBizTypeEnum getSettleBizType() {
        return SettBizTypeEnum.RECOUTSIDE;
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkBizDate_dataChanged(e);
    }

    @Override
    protected void prmtPayeeInnerAcct_dataChanged(DataChangeEvent e) throws Exception {
        InnerAccountInfo info = (InnerAccountInfo)this.prmtPayeeInnerAcct.getValue();
        if (info == null) {
            return;
        }
        this.txtPayeeCH.setText(info.getClearingHouse().getName());
        this.txtPayeeFullName.setText(info.getApplyUnit().getName());
    }

    @Override
    protected void prmtPayerInnerAcct_dataChanged(DataChangeEvent e) throws Exception {
        InnerAccountInfo info = (InnerAccountInfo)this.prmtPayerInnerAcct.getValue();
        if (info == null) {
            return;
        }
        this.txtPayerCH.setText(info.getClearingHouse().getName());
        this.txtPayerFullName.setText(info.getApplyUnit().getName());
    }

    @Override
    protected void prmtPayeeBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayeeBankAcct_dataChanged(e);
    }

    @Override
    protected void prmtPayerBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayerBankAcct_dataChanged(e);
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        int precision = currencyInfo.getPrecision();
        this.txtBalance1.setPrecision(precision);
        this.txtBalance2.setPrecision(precision);
        this.txtAmount.setPrecision(precision);
        this.setExchange();
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.setLoaclAmt();
    }

    @Override
    protected void txtExchange_dataChanged(DataChangeEvent e) throws Exception {
        this.setLoaclAmt();
    }

    private void setExchange() throws BOSException, EASBizException {
        CurrencyInfo srcCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        CurrencyInfo destCurrency = this.clearingHouseCompany.getBaseCurrency();
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getId().equals((Object)destCurrency.getId())) {
            this.txtExchange.setEnabled(false);
            this.txtExchange.setPrecision(3);
            this.txtExchange.setValue((Object)Constants.ONE);
            return;
        }
        ExchangeTableInfo baseExchangeTable = this.clearingHouseCompany.getBaseExchangeTable();
        BigDecimal rate = null;
        if (baseExchangeTable != null) {
            int prec = 0;
            ExchangeRateInfo rateInfo = this.handler.getExchangeRate(baseExchangeTable, srcCurrency, destCurrency);
            if (rateInfo != null) {
                rate = rateInfo.getConvertRate();
                prec = rateInfo.getExchangeAux() != null ? rateInfo.getExchangeAux().getPrecision() : rate.scale();
            } else {
                rate = Constants.ZERO;
            }
            this.txtExchange.setPrecision(prec);
            this.txtExchange.setValue((Object)rate);
            this.txtExchange.setEnabled(true);
        }
    }

    private void setLoaclAmt() {
        BigDecimal payeeAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal exchangeRate = this.txtExchange.getBigDecimalValue();
        payeeAmount = payeeAmount == null ? Constants.ZERO : payeeAmount;
        exchangeRate = exchangeRate == null ? Constants.ZERO : exchangeRate;
        int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)this.clearingHouseCompany.getBaseCurrency().getId());
        BigDecimal localAmt = payeeAmount.multiply(exchangeRate).setScale(scale, 4);
        this.txtLocalAmt.setValue((Object)localAmt);
    }

    protected BigDecimal getBalanceValue(CurrencyInfo currencyInfo, InnerAccountInfo innerAcctInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || innerAcctInfo == null) {
            return Constants.ZERO;
        }
        String key = innerAcctInfo.getId().toString() + currencyInfo.getId().toString();
        if (this.balanceMap.containsKey(key)) {
            return (BigDecimal)this.balanceMap.get(key);
        }
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(innerAcctInfo.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        Date unSettleDate = FSClientHelper.getClearingHouse().getSettleDate();
        BigDecimal balance = InAcctFactory.getRemoteInstance().inAcct(chCompany.getNumber(), innerAcctInfo.getNumber(), currencyInfo.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        this.balanceMap.put(key, balance);
        return balance;
    }

    protected BigDecimal getBalanceValue(CurrencyInfo currencyInfo, AccountBankInfo acctBankInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || acctBankInfo == null || acctBankInfo.getCompany() == null) {
            return Constants.ZERO;
        }
        String key = acctBankInfo.getId().toString() + currencyInfo.getId().toString();
        if (this.balanceMap.containsKey(key)) {
            return (BigDecimal)this.balanceMap.get(key);
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getCompany().getId()));
        BigDecimal balance = CashManagementFactory.getRemoteInstance().cash(companyInfo.getNumber(), CashDataSourceEnum.B, null, null, acctBankInfo.getNumber(), currencyInfo.getNumber(), new Date(), new Date(), CashDataTypeEnum.Y, false);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        this.balanceMap.put(key, balance);
        return balance;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionAccept_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        Date settleDate = FSClientHelper.getClearingHouse().getSettleDate();
        if (this.editData.getId() == null) {
            return;
        }
        if (this.editData.getBizDate().after(settleDate)) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"BigDateNoAccepte"));
            SysUtil.abort();
        }
        if (!this.editData.isHasEffected()) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"BillInvalidation"));
            SysUtil.abort();
        }
        this.handler.verifyInfoData((CoreUIObject)this, this.editData);
        ids.add(this.editData.getId().toString());
        this.handler.verifyOverdraft((CoreUIObject)this, "accept", this.editData, this.handler.getInstanceBean(), null);
        ISettleFacade iSettleFacade = SettleFacadeFactory.getRemoteInstance();
        iSettleFacade.accept(ids);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SuccessAccept"));
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
    }

    @Override
    public void actionCancelAccept_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.editData.getId() == null) {
            return;
        }
        if (this.editData.getAcceptedDate().before(FSClientHelper.getClearingHouse().getSettleDate())) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"HasDailySettle"));
            SysUtil.abort();
        }
        if (this.editData.getCashier() != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"HasSettled"));
            SysUtil.abort();
        }
        ids.add(this.editData.getId().toString());
        ISettleFacade iSettleFacade = SettleFacadeFactory.getRemoteInstance();
        iSettleFacade.cancelAccept(ids);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SuccessCancelAccept"));
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
    }

    @Override
    public void actionSettle_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.editData.getId() == null) {
            return;
        }
        if (this.editData.getCashier() != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"HasSettled"));
            SysUtil.abort();
        }
        ids.add(this.editData.getId().toString());
        ISettleFacade iSettleFacade = SettleFacadeFactory.getRemoteInstance();
        iSettleFacade.settle(ids, true);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SuccessSettle"));
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
    }

    @Override
    public void actionUnSettle_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.editData.getId() == null) {
            return;
        }
        if (this.editData.getCashier() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"HasNotSettled"));
            SysUtil.abort();
        }
        ids.add(this.editData.getId().toString());
        ISettleFacade iSettleFacade = SettleFacadeFactory.getRemoteInstance();
        iSettleFacade.unSettle(ids);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SuccessUnSettle"));
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
    }

    @Override
    public void actionBitBack_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        String id = this.editData.getId().toString();
        Set srcbill = FMHelper.getSrcBillIdSet(null, (String)id);
        if (FMHelper.isEmpty((Collection)srcbill)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"114_SettlementBillBaseUI"));
            return;
        }
        String msg = SettleBitBackUI.showDialogWindow((IUIObject)this);
        if (msg == null) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        set.add(id);
        ISettleFacade facade = SettleFacadeFactory.getRemoteInstance();
        facade.bitBack(set, msg);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SuccessBitBack"));
        this.destroyWindow();
        this.idList.remove(id, false);
        if (this.idList.size() > 0) {
            if (this.actionNext.isEnabled()) {
                this.actionNext_actionPerformed(null);
            } else {
                this.actionPre_actionPerformed(null);
            }
        } else {
            this.destroyWindow();
        }
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        BOSUuid id = this.editData.getId();
        SettlementBillInfo info = null;
        ISettlementBill iSettle = (ISettlementBill)this.getBizInterface();
        info = iSettle.exists((IObjectPK)new ObjectUuidPK(id)) ? iSettle.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors()) : this.editData;
        BgCtrlParamCollection paramColl = BgCtrlSettleHandler.getParamColl(info);
        String boName = "com.kingdee.eas.fm.fs.app.SettlementBill";
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)boName, (BgCtrlParamCollection)paramColl, (IObjectValue)info);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateFrom_actionPerformed(e);
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }
}

