/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.DefaultOriginalCurrencyPrecProvider;
import com.kingdee.eas.fm.common.client.DefaultTablePrecisionFormat;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.ITablePrecisionProvider;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.client.AbstractSettlementBillUnitListUI;
import com.kingdee.eas.fm.fs.client.SettlementBillEditUI;
import com.kingdee.eas.fm.fs.client.SettlementBillUnitFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.log4j.Logger;

public class SettlementBillUnitListUI
extends AbstractSettlementBillUnitListUI {
    private static final Logger logger = CoreUIObject.getLogger(SettlementBillUnitListUI.class);
    SettlementBillUnitFilterUI filterUI = null;

    public SettlementBillUnitListUI() throws Exception {
        DefaultTablePrecisionFormat precFmt = new DefaultTablePrecisionFormat();
        DefaultOriginalCurrencyPrecProvider origCurrPrecProvider = new DefaultOriginalCurrencyPrecProvider("currency.id");
        precFmt.setPrecProvider((ITablePrecisionProvider)origCurrPrecProvider);
        precFmt.initFormat(this.tblMain, new String[]{"amount"});
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        String dformat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("acceptedDate").getStyleAttributes().setNumberFormat(dformat);
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = this.getSelectors();
        sic.add(new SelectorItemInfo("payeePlanItem.id"));
        sic.add(new SelectorItemInfo("payeePlanItem.number"));
        sic.add(new SelectorItemInfo("payeePlanItem.name"));
        sic.add(new SelectorItemInfo("acceptor.id"));
        sic.add(new SelectorItemInfo("acceptor.number"));
        sic.add(new SelectorItemInfo("acceptor.name"));
        sic.add(new SelectorItemInfo("payerBankAcct.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.name"));
        sic.add(new SelectorItemInfo("payerBankAcct.number"));
        sic.add(new SelectorItemInfo("payerBankAcct.ctrlStrategy.*"));
        sic.add(new SelectorItemInfo("payerBankAcct.ctrlStrategy.id"));
        sic.add(new SelectorItemInfo("payerBankAcct.ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("payerBankAcct.ctrlStrategy.number"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.id"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.name"));
        sic.add(new SelectorItemInfo("payerInnerAcct.applyUnit.number"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("cheque.id"));
        sic.add(new SelectorItemInfo("cheque.number"));
        sic.add(new SelectorItemInfo("cheque.name"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.type"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("settleType.id"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("payeeArea.id"));
        sic.add(new SelectorItemInfo("payeeArea.number"));
        sic.add(new SelectorItemInfo("payeeArea.name"));
        sic.add(new SelectorItemInfo("reckoningAcct.id"));
        sic.add(new SelectorItemInfo("reckoningAcct.number"));
        sic.add(new SelectorItemInfo("reckoningAcct.name"));
        sic.add(new SelectorItemInfo("srcSettlementBill.id"));
        sic.add(new SelectorItemInfo("srcSettlementBill.number"));
        sic.add(new SelectorItemInfo("srcSettlementBill.name"));
        return sic;
    }

    protected void execQuery() {
        FilterInfo filter = this.getBotpFilter();
        String targetBillType = null;
        Map botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (botpCtx != null) {
            targetBillType = (String)botpCtx.get("TargetBillType");
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
            if (FilterUtility.hasFilterItem((FilterInfo)this.mainQuery.getFilter())) {
                try {
                    String sql = this.mainQuery.getFilter().toSql();
                    if (sql.indexOf("bizDate") == -1) {
                        FilterInfo dateFilter = FilterUtility.createFilterByDate((String)"BIZDATE", (Timestamp)new Timestamp(System.currentTimeMillis()), (DateEnum)DateEnum.RECENTTHREEMONTHS);
                        filter.mergeFilter(dateFilter, "and");
                    }
                    if (targetBillType != null) {
                        String companyId;
                        if (targetBillType.equals("PaymentBill") && sql.indexOf("payerInnerAcct.ApplyUnit.id") == -1) {
                            companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                            filter.getFilterItems().add(new FilterItemInfo("payerInnerAcct.ApplyUnit.id", (Object)companyId));
                        }
                        if (targetBillType.equals("ReceivingBill") && sql.indexOf("payeeInnerAcct.ApplyUnit.id") == -1) {
                            companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                            filter.getFilterItems().add(new FilterItemInfo("payeeInnerAcct.ApplyUnit.id", (Object)companyId));
                        }
                    }
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    SysUtil.abort((Throwable)e);
                }
            } else {
                FilterInfo dateFilter = FilterUtility.createFilterByDate((String)"BIZDATE", (Timestamp)new Timestamp(System.currentTimeMillis()), (DateEnum)DateEnum.RECENTTHREEMONTHS);
                String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                if (targetBillType != null) {
                    if (targetBillType.equals("PaymentBill")) {
                        filter.getFilterItems().add(new FilterItemInfo("payerInnerAcct.ApplyUnit.id", (Object)companyId));
                    } else if (targetBillType.equals("ReceivingBill")) {
                        filter.getFilterItems().add(new FilterItemInfo("payeeInnerAcct.ApplyUnit.id", (Object)companyId));
                    }
                }
                try {
                    filter.mergeFilter(dateFilter, "and");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                this.mainQuery.setFilter(filter);
            }
        }
        this.tblMain.getSelectManager().setSelectMode(2);
        super.execQuery();
    }

    private FilterInfo getBotpFilter() {
        Map botpCtx;
        if (this.getBOTPViewStatus() == 0) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        if (this.getBOTPViewStatus() == 1 && (botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER")) != null) {
            String targetBillType = (String)botpCtx.get("TargetBillType");
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            if (targetBillType != null) {
                if (targetBillType.equals("PaymentBill")) {
                    filter.getFilterItems().add(new FilterItemInfo("isGenPaymentBill", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isDlByPay", (Object)new Integer(1)));
                } else if (targetBillType.equals("ReceivingBill")) {
                    filter.getFilterItems().add(new FilterItemInfo("isGenReceivingBill", (Object)new Integer(0)));
                    filter.getFilterItems().add(new FilterItemInfo("isDlByRec", (Object)new Integer(1)));
                }
                filter.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)new Integer(1)));
                filter.getFilterItems().add(new FilterItemInfo("bizType.isSendDownUnit", (Object)new Integer(1)));
            }
        }
        return filter;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SettlementBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return SettlementBillEditUI.class.getName();
    }
}

