/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.print.IRequestTableData;
import com.kingdee.bos.ctrl.kdf.table.print.MultiPrint;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.AccountPropertyInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.fm.fs.client.AbstractSubsidiaryLedgerHandler;
import com.kingdee.eas.fm.fs.client.AbstractSubsidiaryLedgerUI;
import com.kingdee.eas.fm.fs.client.FSAnalysisHandlerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterUI;
import com.kingdee.eas.fm.fs.client.SubsidiaryPrintSettingUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SubsidiaryLedgerUI
extends AbstractSubsidiaryLedgerUI {
    private SubsidiaryLedgerFilterUI filterUI;
    public static final String DEFAULT_TREE_NODE = "DefaultTreeNode";
    public static final String CURRENCY = "currency";
    private static final String resourcePath1 = "com.kingdee.eas.fm.fs.FSClientResource";
    private String resourcePath = "com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource";
    private static String printDateMsg = "Print_date";
    private static String printPersonMsg = "Print_person";
    private static String printPageCountMsg = "Print_pageCount";
    private boolean isPrintAll;
    private boolean isPaging;
    private MultiPrint multiPrint;
    private KDTable tablePrint = null;
    private String subsidiaryLedgerTempTableName = "";
    private boolean hasQuried = false;
    private static final Logger logger = CoreUIObject.getLogger(SubsidiaryLedgerUI.class);
    private Map balanceMap;
    private BankInfo clearingHouse;
    private boolean refreshTree = false;
    Runnable doPrint = new Runnable(){

        @Override
        public void run() {
            if (SubsidiaryLedgerUI.this.multiPrint != null) {
                SubsidiaryLedgerUI.this.multiPrint.preview();
            }
        }
    };

    public SubsidiaryLedgerUI() throws Exception {
        this.tablePrint = new KDTable();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.treeList.requestFocus();
    }

    protected boolean isDefaultColumnSort() {
        return false;
    }

    protected void execQuery() throws BOSException {
        this.hasQuried = true;
        SubsidiaryLedgerFilterParam param = (SubsidiaryLedgerFilterParam)this.getFilterParam();
        AbstractSubsidiaryLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        String datePeriod = "";
        datePeriod = !param.isByDay() ? param.getBeginYear() + "-" + param.getBeginMonth() + " - " + param.getEndYear() + "-" + param.getEndMonth() : Constants.FORMAT_DAY.format(param.getFromDate()) + " - " + Constants.FORMAT_DAY.format(param.getToDate());
        this.txtPeriodRange.setText(datePeriod);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("date").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        try {
            handler.initTree(this.treeList, param);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort();
        }
        DefaultKingdeeTreeNode node = null;
        node = (DefaultKingdeeTreeNode)this.getUIContext().get(DEFAULT_TREE_NODE);
        if (node != null) {
            this.setSelectionNode(node);
            this.getUIContext().put(DEFAULT_TREE_NODE, null);
        } else {
            FSClientHelper.setFirstInnerAcctNodeSelected(this.treeList);
        }
    }

    private void setSelectionNode(DefaultKingdeeTreeNode node) {
        InnerAccountInfo sumInner = (InnerAccountInfo)node.getUserObject();
        int height = this.treeList.getRowCount();
        for (int i = 1; i < height; ++i) {
            TreePath tp = this.treeList.getPathForRow(i);
            if (tp == null) continue;
            DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            this.setSelectionNode(sumInner.getId().toString(), tn);
        }
    }

    private void setSelectionNode(String srcInnerAcctId, DefaultKingdeeTreeNode node) {
        InnerAccountInfo info;
        Object obj;
        boolean isMatched = false;
        if (node.isLeaf() && (obj = node.getUserObject()) instanceof InnerAccountInfo && srcInnerAcctId.equals((info = (InnerAccountInfo)obj).getId().toString())) {
            this.treeList.setSelectionNode(node);
            isMatched = true;
            return;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount && !isMatched; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.setSelectionNode(srcInnerAcctId, childNode);
        }
    }

    public void parseAcctNumber(DefaultKingdeeTreeNode node, Set acctNumberSet) {
        int childCount = node.getChildCount();
        if (childCount == 0) {
            return;
        }
        for (int j = 0; j < childCount; ++j) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.treeList.getModel().getChild(node, j);
            if (childNode.getUserObject() instanceof InnerAccountInfo) {
                InnerAccountInfo innerAcct = (InnerAccountInfo)childNode.getUserObject();
                acctNumberSet.add(innerAcct.getNumber());
                continue;
            }
            if (childNode.getUserObject() instanceof AccountBankInfo) {
                AccountBankInfo bankAcct = (AccountBankInfo)childNode.getUserObject();
                acctNumberSet.add(bankAcct.getNumber());
                continue;
            }
            for (int k = 0; k < node.getChildCount(); ++k) {
                this.parseAcctNumber((DefaultKingdeeTreeNode)node.getChildAt(k), acctNumberSet);
            }
        }
    }

    public void parseAcctId(DefaultKingdeeTreeNode node, Set acctIdSet) {
        int childCount = node.getChildCount();
        if (childCount == 0) {
            return;
        }
        for (int j = 0; j < childCount; ++j) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.treeList.getModel().getChild(node, j);
            if (childNode.getUserObject() instanceof InnerAccountInfo) {
                InnerAccountInfo innerAcct = (InnerAccountInfo)childNode.getUserObject();
                acctIdSet.add(innerAcct.getId());
                continue;
            }
            if (childNode.getUserObject() instanceof AccountBankInfo) {
                AccountBankInfo bankAcct = (AccountBankInfo)childNode.getUserObject();
                acctIdSet.add(bankAcct.getId());
                continue;
            }
            for (int k = 0; k < node.getChildCount(); ++k) {
                this.parseAcctId((DefaultKingdeeTreeNode)node.getChildAt(k), acctIdSet);
            }
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SubsidiaryLedgerFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        this.hasQuried = true;
        if (this.subsidiaryLedgerTempTableName != null && !this.subsidiaryLedgerTempTableName.equals("")) {
            TableManagerFacadeFactory.getRemoteInstance().releaseTableName(this.subsidiaryLedgerTempTableName);
            this.subsidiaryLedgerTempTableName = null;
        }
        super.treeList_valueChanged(e);
        this.fillTableData();
        this.balanceMap = null;
    }

    public boolean getHasQuried() {
        return this.hasQuried;
    }

    private void fillTableData() throws EASBizException, BOSException, SQLException {
        this.tblMain.removeRows(false);
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        if (obj == null) {
            this.tblMain.removeRows();
            return;
        }
        HashSet<String> acctNumberSet = new HashSet<String>();
        HashSet<BOSUuid> acctIdSet = new HashSet<BOSUuid>();
        if (obj != null && obj instanceof InnerAccountInfo) {
            InnerAccountInfo innerAcct = (InnerAccountInfo)obj;
            acctNumberSet.add(innerAcct.getNumber());
            acctIdSet.add(innerAcct.getId());
        }
        if (obj != null && obj instanceof CompanyOrgUnitInfo) {
            this.parseAcctNumber(node, acctNumberSet);
            this.parseAcctId(node, acctIdSet);
        }
        if (obj != null && obj instanceof AccountBankPropertyEnum) {
            this.parseAcctNumber(node, acctNumberSet);
            this.parseAcctId(node, acctIdSet);
        }
        if (obj != null && obj instanceof AccountPropertyInfo) {
            this.parseAcctNumber(node, acctNumberSet);
            this.parseAcctId(node, acctIdSet);
        }
        if (acctNumberSet.size() == 0) {
            return;
        }
        if (acctIdSet.size() == 0) {
            return;
        }
        this.fillTable(this.tblMain, acctNumberSet, acctIdSet);
    }

    private void fillTable(KDTable table, Set acctNumberSet, Set acctIdSet) throws BOSException, EASBizException, SQLException {
        String acctNumbers = this.TransferSetToString(acctNumberSet);
        CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        BOSUuid currencyId = null;
        EntityViewInfo ev = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filter = ev.getFilter();
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        currencyId = currency.getId();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)acctIdSet, CompareType.INCLUDE));
        SorterItemCollection sorter = ev.getSorter();
        sorter.add(new SorterItemInfo("company.id"));
        sorter.add(new SorterItemInfo("date"));
        sorter.add(new SorterItemInfo("createTime"));
        sorter.add(new SorterItemInfo("seq"));
        sorter.add(new SorterItemInfo("billNumber"));
        sorter.add(new SorterItemInfo("debitAmount"));
        SubsidiaryLedgerFilterParam param = (SubsidiaryLedgerFilterParam)this.getFilterParam();
        AbstractSubsidiaryLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        handler.fillData3(this.mainQueryPK, table, rs, param, chCompany.getNumber(), currencyId, acctNumbers);
    }

    private IRowSet getKdDate(KDTable table, Set acctNumberSet, Set acctIdSet) throws BOSException, EASBizException, SQLException {
        String acctNumbers = this.TransferSetToString(acctNumberSet);
        CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        BOSUuid currencyId = null;
        EntityViewInfo ev = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filter = ev.getFilter();
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        currencyId = currency.getId();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)acctIdSet, CompareType.INCLUDE));
        SorterItemCollection sorter = ev.getSorter();
        sorter.add(new SorterItemInfo("company.id"));
        sorter.add(new SorterItemInfo("date"));
        sorter.add(new SorterItemInfo("createTime"));
        sorter.add(new SorterItemInfo("seq"));
        sorter.add(new SorterItemInfo("billNumber"));
        sorter.add(new SorterItemInfo("debitAmount"));
        SubsidiaryLedgerFilterParam param = (SubsidiaryLedgerFilterParam)this.getFilterParam();
        AbstractSubsidiaryLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    private String TransferSetToString(Set acctNumberSet) {
        String acctNumbers = new String();
        Iterator iter = acctNumberSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String accountNumber = iter.next().toString();
            acctNumbers = i == 0 ? acctNumbers + accountNumber : acctNumbers + "," + accountNumber;
            ++i;
        }
        return acctNumbers.toString();
    }

    private void fillTable(KDTable table, String acctNumbers, InnerAccountCollection innerAcctColl) throws BOSException, EASBizException, SQLException {
        HashSet<String> acctSet = new HashSet<String>();
        if (acctNumbers.indexOf(",") == -1) {
            acctSet.add(acctNumbers);
        } else {
            String[] acctArray = acctNumbers.split(",");
            for (int i = 0; i < acctArray.length; ++i) {
                acctSet.add(acctArray[i]);
            }
        }
        CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        BOSUuid currencyId = null;
        EntityViewInfo ev = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filter = ev.getFilter();
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        currencyId = currency.getId();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("innerAccount.number", acctSet, CompareType.INCLUDE));
        SorterItemCollection sorter = ev.getSorter();
        sorter.add(new SorterItemInfo("company.id"));
        sorter.add(new SorterItemInfo("date"));
        sorter.add(new SorterItemInfo("createTime"));
        sorter.add(new SorterItemInfo("seq"));
        sorter.add(new SorterItemInfo("billNumber"));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        SubsidiaryLedgerFilterParam param = (SubsidiaryLedgerFilterParam)this.getFilterParam();
        AbstractSubsidiaryLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
        if (this.balanceMap == null) {
            this.balanceMap = handler.getBalanceMap(this.mainQueryPK, table, rs, param, chCompany.getNumber(), currencyId, acctNumbers, innerAcctColl);
        }
        handler.fillData3(this.mainQueryPK, table, rs, param, chCompany.getNumber(), currencyId, acctNumbers, innerAcctColl, this.balanceMap);
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.cboCurrency_actionPerformed(e);
        this.treeList_valueChanged(null);
    }

    private void checkClearHourse() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
    }

    public void onLoad() throws Exception {
        BankInfo bankInfo = FSClientHelper.getClearingHouse();
        if (bankInfo.getSettleDate() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath1, (String)"ClearingHouseNotUsed"));
            SysUtil.abort();
        }
        this.treeView.setShowControlPanel(true);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        Object currency = this.getUIContext().get(CURRENCY);
        if (currency != null) {
            this.cboCurrency.setSelectedItem(currency);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        }
        super.onLoad();
        this.btnQuery.setText(this.resHelper.getString("ActionQuery.SHORT_DESCRIPTION"));
        this.btnPrint.setText(this.resHelper.getString("ActionPrint.SHORT_DESCRIPTION"));
        this.btnPrintPre.setText(this.resHelper.getString("ActionPrintPre.SHORT_DESCRIPTION"));
        this.btnRefresh.setText(this.resHelper.getString("ActionRefresh.NAME"));
        Preferences pref = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        this.isPrintAll = pref.getBoolean("isPrintAll", false);
        this.isPaging = pref.getBoolean("isPaging", true);
        this.refreshTree = true;
    }

    public static void showSubsidiaryLedgerUI(IUIObject ui, SubsidiaryLedgerFilterParam param, DefaultKingdeeTreeNode node, CurrencyInfo curInfo) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        uiContext.put((Object)DEFAULT_TREE_NODE, (Object)node);
        uiContext.put((Object)CURRENCY, (Object)curInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SubsidiaryLedgerUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewSettlementBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.actionPrintSetting.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void actionViewSettlementBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        String id = (String)this.tblMain.getRow(i).getCell("id").getValue();
        if (FMHelper.isEmpty((String)id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"SelectValidRecord"));
            return;
        }
        SubsidiaryLedgerInfo info = SubsidiaryLedgerFactory.getRemoteInstance().getSubsidiaryLedgerInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        BOSUuid bosUuid = info.getBillId();
        if (bosUuid == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"SelectValidRecord"));
            return;
        }
        String billId = bosUuid.toString();
        if (billId != null) {
            billId = TransUpDownBillHelper.changeTransBillId(billId);
            FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        }
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node.isRoot()) {
            return;
        }
        Object obj = node.getUserObject();
        if (obj == null) {
            return;
        }
        if (obj != null && obj instanceof CompanyOrgUnitInfo) {
            return;
        }
        if (obj != null && obj instanceof AccountBankPropertyEnum) {
            return;
        }
        String inAcctString = "";
        if (obj != null && obj instanceof InnerAccountInfo) {
            InnerAccountInfo innerAcct = (InnerAccountInfo)obj;
            inAcctString = innerAcct.getNumber() + "-" + innerAcct.getName();
        }
        if (inAcctString == null) {
            return;
        }
        String headString = inAcctString;
        headerModel.addRow(headString, Styles.getDefaultSA());
        super.preparePrintPageHeader(headerModel);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.initMultiPrint();
        DoPrintThreadPre doP = new DoPrintThreadPre(this.multiPrint, true);
        doP.start();
    }

    @Override
    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        this.initMultiPrint();
        DoPrintThreadPre doP = new DoPrintThreadPre(this.multiPrint, false);
        doP.start();
    }

    @Override
    public void actionPrintSetting_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        IUIWindow printSetUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SubsidiaryPrintSettingUI.class.getName(), (Map)uiCtx);
        printSetUI.show();
        SubsidiaryPrintSettingUI printSetUIObj = (SubsidiaryPrintSettingUI)printSetUI.getUIObject();
        if (printSetUIObj.isOK()) {
            this.isPrintAll = printSetUIObj.isPrintAll();
            this.isPaging = printSetUIObj.isPaging();
        }
    }

    protected Page getHeader(boolean isPaging, InnerAccountInfo innerAcctInfo) {
        HeadFootModel header = new HeadFootModel();
        StyleAttributes saMajorTitle = Styles.getDefaultSA();
        saMajorTitle.setFontSize(14);
        saMajorTitle.setBold(true);
        header.addRow(this.getPrintPageTitle(), saMajorTitle);
        header.addRow("");
        StringBuffer headStringOne = new StringBuffer();
        headStringOne.append(this.lblPeriodRange.getBoundLabelText()).append(" ").append(this.txtPeriodRange.getText()).append("&|");
        headStringOne.append(this.lblCurrency.getBoundLabelText()).append(" ").append(this.cboCurrency.getSelectedItem().toString());
        header.addRow(headStringOne.toString());
        StringBuffer headStringTwo = new StringBuffer();
        if (innerAcctInfo != null) {
            innerAcctInfo.setDisplayFormat("$number$-$name$");
            headStringTwo.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource.InnerAccount")).append("   ").append(innerAcctInfo).append("&|");
            headStringTwo.append(" ").append("&|").append(" ");
            header.addRow(headStringTwo.toString());
        }
        Page hPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
        return hPage;
    }

    protected Page getFooter() {
        HeadFootModel footer = new HeadFootModel();
        String dateString = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printDateMsg)) + "&[Date]";
        String personString = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printPersonMsg)) + SysContext.getSysContext().getCurrentUserInfo().getName();
        String pageNumber = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printPageCountMsg)) + "&[Page]/&[PageCount]";
        String footerString = dateString + "&|" + personString + "&|" + pageNumber;
        StyleAttributes sb = Styles.getDefaultSA();
        footer.addRow(footerString, sb);
        Page fPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)footer);
        return fPage;
    }

    protected static InnerAccountCollection getLeafInnerAccounts(TreePath path) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        InnerAccountCollection coll = SubsidiaryLedgerUI.getLeafInnerAccounts(null, node);
        return coll;
    }

    private static InnerAccountCollection getLeafInnerAccounts(InnerAccountCollection coll, DefaultKingdeeTreeNode node) {
        if (coll == null) {
            coll = new InnerAccountCollection();
        }
        if (node.isLeaf() && node.getUserObject() instanceof InnerAccountInfo) {
            coll.add((InnerAccountInfo)node.getUserObject());
        } else {
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultKingdeeTreeNode leafNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
                SubsidiaryLedgerUI.getLeafInnerAccounts(coll, leafNode);
            }
        }
        return coll;
    }

    protected InnerAccountCollection getSelectedInnerAccounts() {
        InnerAccountCollection innerAcctColl = new InnerAccountCollection();
        TreePath[] paths = this.treeList.getSelectionPaths();
        int n = paths.length;
        for (int i = 0; i < n; ++i) {
            innerAcctColl.addCollection(SubsidiaryLedgerUI.getLeafInnerAccounts(paths[i]));
        }
        return innerAcctColl;
    }

    protected InnerAccountCollection getAllInnerAccounts() {
        InnerAccountCollection innerAcctColl = new InnerAccountCollection();
        TreeModel model = this.treeList.getModel();
        int n = model.getChildCount(model.getRoot());
        for (int i = 0; i < n; ++i) {
            Object childNode = model.getChild(model.getRoot(), i);
            innerAcctColl.addCollection(SubsidiaryLedgerUI.getLeafInnerAccounts(null, (DefaultKingdeeTreeNode)childNode));
        }
        return innerAcctColl;
    }

    protected void initMultiPrint() throws FSException {
        InnerAccountCollection innerAcctColl;
        this.multiPrint = new MultiPrint((Component)((Object)this));
        this.multiPrint.getMultiPrintModel().getManager().setParent((Component)((Object)this));
        this.multiPrint.setFrugalPrint(!this.isPaging);
        if (this.isPaging) {
            this.tablePrint.getPrintManager().setBodyTopMargin(360.0f);
        }
        this.multiPrint.setTable(this.tablePrint);
        if (this.isPrintAll) {
            innerAcctColl = this.getAllInnerAccounts();
        } else {
            innerAcctColl = this.getSelectedInnerAccounts();
            if (innerAcctColl.size() <= 0) {
                throw new FSException(FSException.NOTPRINTALLSELECTROW);
            }
        }
        int n = innerAcctColl.size();
        for (int i = 0; i < n; ++i) {
            this.multiPrint.addPrintData(new Integer(i).toString());
        }
        this.multiPrint.setRequestData(new IRequestTableData(){
            private boolean flag = true;

            public void requestTableData(String key) {
                SubsidiaryLedgerUI.this.tablePrint.removeRows();
                SubsidiaryLedgerUI.this.tablePrint.removeColumns();
                SubsidiaryLedgerUI.this.tablePrint.removeHeadRows();
                KDTable tblMainIn = new KDTable();
                int n = SubsidiaryLedgerUI.this.tblMain.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    IColumn oldCol = SubsidiaryLedgerUI.this.tblMain.getColumn(i);
                    tblMainIn.addColumn(i, oldCol);
                }
                IRow headRowIn = tblMainIn.addHeadRow();
                int n2 = SubsidiaryLedgerUI.this.tblMain.getColumnCount();
                for (int i = 0; i < n2; ++i) {
                    IColumn headCol = SubsidiaryLedgerUI.this.tblMain.getColumn(i);
                    String colKey = headCol.getKey();
                    headRowIn.getCell(colKey).setValue(SubsidiaryLedgerUI.this.tblMain.getHeadRow(0).getCell(colKey).getValue());
                }
                tblMainIn.removeRows(false);
                HashSet<String> acctNumberSet = new HashSet<String>();
                HashSet<BOSUuid> acctIdSet = new HashSet<BOSUuid>();
                InnerAccountInfo innerAcct = innerAcctColl.get(Integer.parseInt(key));
                acctNumberSet.add(innerAcct.getNumber());
                acctIdSet.add(innerAcct.getId());
                try {
                    IRowSet rs = SubsidiaryLedgerUI.this.getKdDate(tblMainIn, acctNumberSet, acctIdSet);
                    if (rs == null || rs.size() == 0) {
                        return;
                    }
                    SubsidiaryLedgerFilterParam param = (SubsidiaryLedgerFilterParam)SubsidiaryLedgerUI.this.getFilterParam();
                    AbstractSubsidiaryLedgerHandler handler = FSAnalysisHandlerFactory.getHandler(param);
                    CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                    String acctNumbers = SubsidiaryLedgerUI.this.TransferSetToString(acctNumberSet);
                    CurrencyInfo currency = (CurrencyInfo)SubsidiaryLedgerUI.this.cboCurrency.getSelectedItem();
                    handler.fillData3(SubsidiaryLedgerUI.this.mainQueryPK, tblMainIn, rs, param, chCompany.getNumber(), currency.getId(), acctNumbers);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                int n3 = tblMainIn.getColumnCount();
                for (int i = 0; i < n3; ++i) {
                    IColumn oldCol = tblMainIn.getColumn(i);
                    IColumn newCol = SubsidiaryLedgerUI.this.tablePrint.addColumn();
                    newCol.setWidth(oldCol.getWidth());
                    newCol.setKey(oldCol.getKey());
                    newCol.setStyleAttributes(oldCol.getStyleAttributes());
                }
                IRow headRow = SubsidiaryLedgerUI.this.tablePrint.addHeadRow();
                int n4 = SubsidiaryLedgerUI.this.tablePrint.getColumnCount();
                for (int i = 0; i < n4; ++i) {
                    IColumn headCol = SubsidiaryLedgerUI.this.tablePrint.getColumn(i);
                    String colKey = headCol.getKey();
                    headRow.getCell(colKey).setValue(tblMainIn.getHeadRow(0).getCell(colKey).getValue());
                }
                SubsidiaryLedgerUI.this.tablePrint.getPrintManager().setHeader(SubsidiaryLedgerUI.this.getHeader(SubsidiaryLedgerUI.this.isPaging, innerAcctColl.get(Integer.parseInt(key))));
                if (SubsidiaryLedgerUI.this.tablePrint.getPrintManager().getFooterModel() == null || SubsidiaryLedgerUI.this.tablePrint.getPrintManager().getFooterModel().getRowList().size() == 0 || SubsidiaryLedgerUI.this.tablePrint.getPrintManager().getFooterModel().getRowList().get(0) == null || SubsidiaryLedgerUI.this.tablePrint.getPrintManager().getFooterModel().getRowList().get(0).toString().equals("")) {
                    SubsidiaryLedgerUI.this.tablePrint.getPrintManager().setFooter(SubsidiaryLedgerUI.this.getFooter());
                }
                this.copyData(SubsidiaryLedgerUI.this.tablePrint, tblMainIn);
            }

            private void copyData(KDTable tablePrint, KDTable tblMainIn) {
                for (int i = 0; i < tblMainIn.getRowCount(); ++i) {
                    IRow row = tblMainIn.getRow(i);
                    IRow rowNew = tablePrint.addRow();
                    for (int j = 0; j < tblMainIn.getColumnCount(); ++j) {
                        rowNew.getCell(j).setValue(row.getCell(j).getValue());
                    }
                }
            }
        });
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionViewInnerEReceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> list = new ArrayList<String>();
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        String id = (String)this.tblMain.getRow(i).getCell("id").getValue();
        if (FMHelper.isEmpty((String)id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"SelectValidRecord"));
            return;
        }
        list.add(id);
        if (list.size() > 0) {
            EReceiptInnerClientHelper.viewInnerEreceiptBySubsIdList(list, (Component)((Object)this));
        }
    }

    class DoPrintThreadPre
    extends Thread {
        private MultiPrint multiPrint;
        private boolean doPrint;

        public DoPrintThreadPre(MultiPrint multiPrint, boolean doPrint) {
            this.multiPrint = multiPrint;
            this.doPrint = doPrint;
        }

        @Override
        public void run() {
            if (this.multiPrint != null) {
                if (!this.doPrint) {
                    this.multiPrint.preview();
                } else {
                    this.multiPrint.print();
                }
            }
            SubsidiaryLedgerUI.this.tblMain.setPrintManager(SubsidiaryLedgerUI.this.tablePrint.getPrintManager());
            SubsidiaryLedgerUI.this.printService.savePrintSetting();
        }
    }
}

