/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.noteprint.util.NotePrtRecordUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransDownBillDataProvider
implements BOSQueryDelegate {
    private static IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fm.fs.TransDownBillTDQuery");
    private static Logger logger = Logger.getLogger((String)TransDownBillDataProvider.class.getName());
    private Set ids = null;
    private int printCount = 0;
    private String templatePath = "";
    private IObjectPK currentPK = null;
    private int databaseNumber = 0;
    private int canPrtControl = 3;
    private String billStatus = "10";
    KDNoteHelper currentHelper = null;
    PaymentBillPrintListener listener = new PaymentBillPrintListener();

    public TransDownBillDataProvider(Set id) {
        this.ids = id;
    }

    public TransDownBillDataProvider(List id) {
        this.ids = new HashSet(id);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qpk);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isAutoTranslateBoolean = true;
            exec.option().isMultiLanguage = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            ArrayList param = ds.getParams();
            FMClientHelper.addDataFilter((FilterInfo)filter, (ArrayList)param);
            ev.setFilter(filter);
            exec.setObjectView(ev);
            logger.error((Object)exec.getSQL());
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                NotePrtRecordUtil.setQueryPK((String)"com.kingdee.eas.base.noteprint.app.PrtRecordQuery");
                this.currentPK = new ObjectUuidPK(iRowSet.getString("id"));
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("totalAmt", iRowSet.getBigDecimal("totalAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("confirmedAmt", iRowSet.getBigDecimal("confirmedAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("entrys.amount", iRowSet.getBigDecimal("entrys.amount").setScale(precision, 4));
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return iRowSet;
    }

    public static void main(String[] args) throws BOSException {
        FMClientHelper.printTDMetaDataField((String)qpk.getFullName());
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void setCanPrtControl(int canPrtControl) {
        this.canPrtControl = canPrtControl;
    }

    public void setCurrentHelper(KDNoteHelper currentHelper) {
        this.currentHelper = currentHelper;
    }

    class PaymentBillPrintListener
    implements IPrintActionListener {
        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            try {
                if (NotePrtRecordUtil.isPrintControlEnabled((String)TransDownBillDataProvider.this.templatePath, (IObjectPK)TransDownBillDataProvider.this.currentPK)) {
                    int printedTimes = NotePrtRecordUtil.getPrintedTimes((String)TransDownBillDataProvider.this.templatePath, (IObjectPK)TransDownBillDataProvider.this.currentPK);
                    int prepareTimes = TransDownBillDataProvider.this.currentHelper.getCopies();
                    int maxPrintTimes = NotePrtRecordUtil.getMaxPrt((String)TransDownBillDataProvider.this.templatePath);
                    if (printedTimes >= maxPrintTimes) {
                        MsgBox.showError((String)FMARAPUtil.getStrResource((String)"printCountIsOver"));
                        TransDownBillDataProvider.this.currentHelper.diposePrint();
                    } else if (printedTimes + prepareTimes > maxPrintTimes) {
                        MsgBox.showWarning((String)FMARAPUtil.getStrResource((String)"printCountIsOverRemainCan"));
                        int remain = maxPrintTimes - printedTimes;
                        TransDownBillDataProvider.this.currentHelper.setCopies(remain);
                        NotePrtRecordUtil.updatePrtTimes((String)TransDownBillDataProvider.this.templatePath, (IObjectPK)TransDownBillDataProvider.this.currentPK, (int)remain);
                    } else {
                        TransDownBillDataProvider.this.currentHelper.setCopies(prepareTimes);
                        NotePrtRecordUtil.updatePrtTimes((String)TransDownBillDataProvider.this.templatePath, (IObjectPK)TransDownBillDataProvider.this.currentPK, (int)prepareTimes);
                    }
                } else {
                    int printedTimes = TransDownBillDataProvider.this.currentHelper.getCopies();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        public void closePreview() {
        }
    }
}

