/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.AbstractTransDownBillFilterUI;
import com.kingdee.eas.fm.fs.client.TransDownBillFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import org.apache.log4j.Logger;

public class TransDownBillFilterUI
extends AbstractTransDownBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TransDownBillFilterUI.class);
    private CompanyOrgUnitInfo company = null;

    protected void init() throws Exception {
        if (this.company == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        super.init();
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    protected void setDefaultValue() {
        Date date = new Date();
        this.pkBeginDate.setValue((Object)date);
        this.pkEndDate.setValue((Object)date);
        this.cbxSaved.setSelected(true);
        this.cbxSubmited.setSelected(true);
        this.cbxAudited.setSelected(false);
        this.cbxConfirmed.setSelected(false);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.company.getBaseCurrency());
    }

    public boolean verify() {
        if (this.pkBeginDate.getValue() == null || this.pkEndDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"110_ReceiveAccountFilterUI"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (KDDatePicker)this.pkBeginDate, (KDDatePicker)this.pkEndDate);
        return true;
    }

    public Object getParam() {
        TransDownBillFilterParam param = new TransDownBillFilterParam();
        param.setBeginDate((Date)this.pkBeginDate.getValue());
        param.setEndDate((Date)this.pkEndDate.getValue());
        Object currencyObj = this.comboCurrency.getSelectedItem();
        if (currencyObj.equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)currencyObj).getId().toString());
        }
        boolean[] states = new boolean[]{this.cbxSaved.isSelected(), this.cbxSubmited.isSelected(), this.cbxAudited.isSelected(), this.cbxConfirmed.isSelected()};
        param.setStates(states);
        return param;
    }

    public void setParam(Object param) {
        if (param == null || !(param instanceof TransDownBillFilterParam)) {
            return;
        }
        TransDownBillFilterParam transParam = (TransDownBillFilterParam)((Object)param);
        this.pkBeginDate.setValue((Object)transParam.getBeginDate());
        this.pkEndDate.setValue((Object)transParam.getEndDate());
        if (FMHelper.isEmpty((String)transParam.getCurrencyId())) {
            this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            CurrencyInfo currInfo = new CurrencyInfo();
            currInfo.setId(BOSUuid.read((String)transParam.getCurrencyId()));
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currInfo);
        }
        this.cbxSaved.setSelected(transParam.getStates()[0]);
        this.cbxSubmited.setSelected(transParam.getStates()[1]);
        this.cbxAudited.setSelected(transParam.getStates()[2]);
        this.cbxConfirmed.setSelected(transParam.getStates()[3]);
    }

    protected Class getParamClass() {
        return TransDownBillFilterParam.class;
    }
}

