/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.fpl.client.FpItemClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.EventListener;
import javax.swing.JTextField;

public class FundTransClientHelper {
    public static final String RESOURCE_PATH = "com.kingdee.eas.fm.ft.client.FundTransfer_Resource";

    public static void showMsgAndAbort(CoreUI ui, String msgKey) {
        String msg = EASResource.getString((String)RESOURCE_PATH, (String)msgKey);
        MsgBox.showWarning((Component)ui, (String)msg);
        SysUtil.abort();
    }

    public static void showMsg(CoreUI ui, String msgKey) {
        String msg = EASResource.getString((String)RESOURCE_PATH, (String)msgKey);
        MsgBox.showInfo((Component)ui, (String)msg);
    }

    public static String getFTModualMsg(String msgKey) {
        return EASResource.getString((String)RESOURCE_PATH, (String)msgKey);
    }

    public static boolean isLessEqualThanZero(BigDecimal compareValue) {
        return compareValue.compareTo(Constants.ZERO) <= 0;
    }

    public static void setTableCellEditorByDate(KDTable tblMain, String property) {
        KDDatePicker dpDate = new KDDatePicker();
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor(dpDate));
        tblMain.getColumn(property).getStyleAttributes().setNumberFormat("yyyy-MM-DD");
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property, int precision) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setRoundingMode(4);
        formattedTextField.setMinimumValue((Comparable)Constants.ZERO);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        tblMain.getColumn(property).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void setFpItemDirection(KDBizPromptBox prmtFpItem, String movement_value) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("direction", (Object)movement_value));
        prmtFpItem.setEntityViewInfo(evi);
        FpItemClientHelper.setOrgView((KDBizPromptBox)prmtFpItem);
        prmtFpItem.getQueryAgent().resetRuntimeEntityView();
    }

    public static SelectorItemCollection getSelectForFpItem() {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("fpItem.id");
        select.add("fpItem.name");
        select.add("fpItem.number");
        select.add("currency.id");
        select.add("currency.number");
        select.add("currency.name");
        select.add("company.id");
        select.add("company.name");
        select.add("company.number");
        return select;
    }

    public static void setTableCellEditorByF7(KDTable tblMain, String f7, FilterInfo fi, String property, EventListener[] listeners) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setDisplayFormat("$name$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setQueryInfo(f7);
        if (listeners != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                if (listeners[i] instanceof SelectorListener) {
                    promptBox.addSelectorListener((SelectorListener)listeners[i]);
                    continue;
                }
                if (!(listeners[i] instanceof DataChangeListener)) continue;
                promptBox.addDataChangeListener((DataChangeListener)listeners[i]);
            }
        }
        if (fi != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            promptBox.setEntityViewInfo(evi);
        }
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public static boolean isControlledByFpItem_FundTransferBill() throws Exception {
        return FundTransClientHelper.isControlledByFpItem("FT002");
    }

    public static boolean isControlledByFpItem_FundTransferRepayBill() throws Exception {
        return FundTransClientHelper.isControlledByFpItem("FT003");
    }

    public static boolean isControlledByFpItem_FundTransferInterestBill() throws Exception {
        return FundTransClientHelper.isControlledByFpItem("FT004");
    }

    public static boolean isControlledByFpItem(String sysParam) throws Exception {
        IContextHelper iContextHelper = ContextHelperFactory.getRemoteInstance();
        CompanyOrgUnitInfo CURRENT_COMPANY = iContextHelper.getCurrentCompany();
        boolean isFpItemControl = iContextHelper.getBooleanParam(sysParam, (IObjectPK)new ObjectUuidPK(CURRENT_COMPANY.getId()));
        return true;
    }
}

