/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.IvtModuleResourceReader;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ft.client.AbstractFundTransRateAdjustBilFilterUI;
import com.kingdee.eas.fm.ft.client.FundTransRateAdjustBilFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;

public class FundTransRateAdjustBilFilterUI
extends AbstractFundTransRateAdjustBilFilterUI {
    public Object getParam() {
        Object relations;
        FundTransRateAdjustBilFilterParam cbfp = new FundTransRateAdjustBilFilterParam();
        cbfp.setCompanyIDSet(this.getCompanyIdSet());
        if (null != this.dpStartDate.getValue()) {
            cbfp.setStartDate(DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())));
        }
        if (null != this.dpEndDate.getValue()) {
            cbfp.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())));
        }
        if (!((relations = this.cboRelation.getSelectedItem()) instanceof FMSysDefinedEnum)) {
            cbfp.setRelations((RelationshipWithLoanCompanyEnum)relations);
        } else {
            cbfp.setRelations(null);
        }
        if (relations instanceof RelationshipWithLoanCompanyEnum) {
            cbfp.setRelations((RelationshipWithLoanCompanyEnum)relations);
            if (relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                this.contTransCompany.setVisible(true);
                this.contCustomer.setVisible(false);
                if (this.prmtTransComapny.getValue() != null) {
                    cbfp.setLoanCompanys(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtTransComapny));
                }
            } else {
                this.contTransCompany.setVisible(false);
                this.contCustomer.setVisible(true);
                if (this.prmtCustomer.getValue() != null) {
                    cbfp.setCustomers(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCustomer));
                }
            }
        } else {
            this.contTransCompany.setVisible(false);
            this.contCustomer.setVisible(false);
            cbfp.setCustomers(null);
            cbfp.setLoanCompanys(null);
        }
        cbfp.setBOTP(false);
        return cbfp;
    }

    public void setParam(Object param) {
        FundTransRateAdjustBilFilterParam filterParam = (FundTransRateAdjustBilFilterParam)param;
        this.dpStartDate.setValue((Object)filterParam.getStartDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        if (filterParam.getRelations() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboRelation, (Object)filterParam.getRelations());
        } else {
            this.cboRelation.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        if (filterParam.getRelations() == RelationshipWithLoanCompanyEnum.INTERIOR) {
            this.prmtCustomer.setValue(null);
            this.setBizPromtValues(filterParam.getLoanCompanys(), 3);
            this.contTransCompany.setVisible(true);
            this.contCustomer.setVisible(false);
        } else if (filterParam.getRelations() == RelationshipWithLoanCompanyEnum.EXTERIOR) {
            this.prmtTransComapny.setValue(null);
            this.setBizPromtValues(filterParam.getCustomers(), 2);
            this.contTransCompany.setVisible(false);
            this.contCustomer.setVisible(true);
        } else {
            this.prmtTransComapny.setValue(null);
            this.prmtCustomer.setValue(null);
        }
    }

    private void setBizPromtValues(String[] ids, int paraType) {
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (ids != null && ids.length > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])ids), CompareType.INCLUDE));
        }
        ev.setFilter(filter);
        try {
            switch (paraType) {
                case 2: {
                    this.setCustomer(ev);
                    break;
                }
                case 3: {
                    this.setLoanCompany(ev);
                    break;
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setCustomer(EntityViewInfo ev) throws BOSException {
        CustomerCollection customCol = CustomerFactory.getRemoteInstance().getCustomerCollection(ev);
        this.prmtCustomer.setValue((Object)customCol.toArray());
    }

    private void setLoanCompany(EntityViewInfo ev) throws BOSException {
        CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
        this.prmtTransComapny.setValue((Object)companyCol.toArray());
    }

    protected void init() throws Exception {
        super.init();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
    }

    private void customInit() {
        this.initDate();
        this.initRelations();
        this.prmtCustomer.setValue(null);
        this.prmtCustomer.setEnabledMultiSelection(true);
        this.prmtCustomer.setDisplayFormat("$name$");
        this.prmtCustomer.setCommitFormat("$number$");
        this.prmtCustomer.setEditFormat("$name$");
        FMClientHelper.setCustomerF7(null, (KDBizPromptBox)this.prmtCustomer, (boolean)true, null);
        this.prmtTransComapny.setValue(null);
        this.prmtTransComapny.setEnabledMultiSelection(true);
        this.prmtTransComapny.setDisplayFormat("$name$");
        this.prmtTransComapny.setCommitFormat("$number$");
        this.prmtTransComapny.setEditFormat("$name$");
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.prmtTransComapny, (boolean)true);
    }

    private void initRelations() {
        this.cboRelation.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboRelation.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.initDate();
        this.cboRelation.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.prmtCustomer.setValue(null);
        this.prmtTransComapny.setValue(null);
    }

    private void initDate() {
        Date now = new Date();
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public boolean verify() {
        if (((Date)this.dpStartDate.getValue()).after((Date)this.dpEndDate.getValue())) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"dateError"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    @Override
    protected void cboRelation_itemStateChanged(ItemEvent e) throws Exception {
        IvtModualUtils.cboRelationsItemStateChanged((KDComboBox)this.cboRelation, (KDLabelContainer)this.contCustomer, (KDBizPromptBox)this.prmtCustomer, (KDLabelContainer)this.contTransCompany, (KDBizPromptBox)this.prmtTransComapny);
    }

    protected Class getParamClass() {
        return FundTransRateAdjustBilFilterParam.class;
    }
}

