/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ft.FundTransferExtBillFactory;
import com.kingdee.eas.fm.ft.FundTransferExtBillInfo;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferExtBillListUI;
import com.kingdee.eas.fm.ft.client.FTListPropress;
import com.kingdee.eas.fm.ft.client.FundTransferExtBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTransferExtBillFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FundTransferExtBillListUI
extends AbstractFundTransferExtBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferExtBillListUI.class);
    private FundTransferExtBillFilterUI filterUI;
    FillListener fillListener = new FillListener();
    public static final String FUNDTRANSFEREXTBILL_FILENAME = "/FM/INVEST/FT/FUNDTRANSFEREXTBILL";

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FundTransferExtBillFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new FTListPropress();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        return sic;
    }

    protected String getEditUIName() {
        return FundTransferExtBillEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompanyCommon);
        super.onLoad();
        this.actionCreateTo.setEnabled(false);
        this.actionCreateTo.setVisible(false);
        this.actionDelVoucher.setEnabled(true);
        this.actionDelVoucher.setVisible(true);
        this.actionVoucher.setEnabled(true);
        this.actionVoucher.setVisible(true);
        this.actionPCVoucher.setEnabled(true);
        this.actionPCVoucher.setVisible(true);
        this.actionDelPCVoucher.setEnabled(true);
        this.actionDelPCVoucher.setVisible(true);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanRemove();
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanEdit() throws Exception {
        this.checkSelected();
        FundTransferExtBillInfo extInfo = this.getSelectedObject();
        if (extInfo.isFivouchered()) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"bill_vouchered"));
        }
        this.checkSeq(extInfo, 1);
    }

    private void checkCanRemove() throws Exception {
        this.checkSelected();
        FundTransferExtBillInfo extInfo = this.getSelectedObject();
        if (extInfo.isFivouchered()) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"bill_vouchered"));
        }
        this.checkSeq(extInfo, 2);
    }

    private FundTransferExtBillInfo getSelectedObject() throws EASBizException, BOSException {
        return FundTransferExtBillFactory.getRemoteInstance().getFundTransferExtBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getCustomerSelectors());
    }

    public SelectorItemCollection getCustomerSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("loan.extTimes"));
        return sic;
    }

    private void checkSeq(FundTransferExtBillInfo extInfo, int type) throws Exception {
        int maxSeq = extInfo.getLoan().getExtTimes();
        if (extInfo.getExtendSeq() != maxSeq) {
            if (type == 1) {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"edit_error1"));
                SysUtil.abort();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getBizModelResourceMsg((String)"delete_error1"));
                SysUtil.abort();
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransferExtBillFactory.getRemoteInstance();
    }

    protected void execQuery() {
        if (this.isBotp()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isGenLoanExt", null, CompareType.IS));
            filter.getFilterItems().add(new FilterItemInfo("isGenLoanExt", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("loan.isGenLoan", (Object)Boolean.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("transCompany.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
            filter.setMaskString("( #0 or #1 ) and #2 and #3 ");
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        super.execQuery();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            filter.getFilterItems().add(new FilterItemInfo("isGenLoanExt", null, CompareType.IS));
            filter.getFilterItems().add(new FilterItemInfo("isGenLoanExt", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("loan.isGenLoan", (Object)Boolean.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("transCompany.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
            filter.setMaskString("( #0 or #1 ) and #2 and #3 ");
            return filter;
        }
        return filter;
    }

    private boolean isBotp() {
        int status;
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        if (this.getUIContext().get("BOTPFilter") != null) {
            return false;
        }
        return this.getUIContext().get("BOTPViewStatus") instanceof Integer && (status = ((Integer)this.getUIContext().get("BOTPViewStatus")).intValue()) == 1;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 5;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.fundTransferExtBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.fundTransferExtBillTDPrint(true);
    }

    private void fundTransferExtBillTDPrint(boolean isPreview) {
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferExtBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(FMHelper.list2Set((List)idList), headPK);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSFEREXTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSFEREXTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(FundTransferExtBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                this.formatRow(tblMain, i);
            }
        }

        private void formatRow(KDTable tblMain, int i) {
            IRow row = tblMain.getRow(i);
            Integer precesion = (Integer)row.getCell("currency.precision").getValue();
            this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
            String format = FMClientHelper.getNumberFtm((int)FundTransferExtBillListUI.this.getBaseCurrencyPrecision());
            this.setNumberFormat(row, "loanBalanceLocal", format);
            this.setNumberFormat(row, "exchangeRate", format, false);
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "loanBalance", format);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            this.setNumberFormat(row, columnKey, format, true);
        }

        private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            if (doFormat) {
                styleAttributes.setNumberFormat(format);
            } else {
                String formatRate = FMClientHelper.getNumberFtm((int)5);
                styleAttributes.setNumberFormat(formatRate);
            }
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

