/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMBudgetFacadeFactory;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferInterestBillEditUI;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundTransferInterestBillEditUI
extends AbstractFundTransferInterestBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferInterestBillEditUI.class);
    private FundTransferRepayBillInfo repayBillInfo;
    private Map map;
    private boolean successFlag = false;
    IObjectPK pk1;
    public static final String FUNDTRANSFERINTERESTBILL_FILENAME = "/FM/IM/FUNDTRANSFERINTERESTBILL";

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        this.editData.setFivouchered(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransferInterestBillFactory.getRemoteInstance();
    }

    public void initDataStatus() {
        super.initDataStatus();
        FundTransferInterestBillInfo intInfo = (FundTransferInterestBillInfo)this.getDataObject();
        if (intInfo.getTransBill() != null) {
            if (intInfo.getTransBill().getRelationWithCmp() == RelationshipWithLoanCompanyEnum.EXTERIOR) {
                this.contTransCompany.setVisible(false);
                this.prmtTransCompany.setVisible(false);
                this.prmtCustomer.setVisible(true);
                this.contCustomer.setVisible(true);
            } else {
                this.contTransCompany.setVisible(true);
                this.prmtTransCompany.setVisible(true);
                this.prmtCustomer.setVisible(false);
                this.contCustomer.setVisible(false);
            }
        }
        this.prmtTransBill.setEnabled(false);
        this.prmtTransCompany.setEnabled(false);
        this.prmtCustomer.setEnabled(false);
        this.setEnable(false);
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.actionPre.setEnabled(false);
            this.actionPre.setVisible(false);
            this.actionNext.setEnabled(false);
            this.actionNext.setVisible(false);
            this.actionFirst.setEnabled(false);
            this.actionFirst.setVisible(false);
            this.actionLast.setEnabled(false);
            this.actionLast.setVisible(false);
            this.actionTraceDown.setEnabled(false);
            this.actionTraceDown.setVisible(false);
            this.actionTraceUp.setEnabled(false);
            this.actionTraceUp.setVisible(false);
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionTDPrint.setEnabled(true);
            this.actionTDPrintPreview.setEnabled(true);
            this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
            this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        }
    }

    private void setEnable(boolean isEnabled) {
        this.actionSave.setEnabled(isEnabled);
        this.actionSave.setVisible(isEnabled);
        this.actionPrint.setEnabled(isEnabled);
        this.actionPrint.setVisible(isEnabled);
        this.actionEdit.setEnabled(isEnabled);
        this.actionEdit.setVisible(isEnabled);
        this.actionRemove.setEnabled(isEnabled);
        this.actionRemove.setVisible(isEnabled);
        this.actionPrintPreview.setEnabled(isEnabled);
        this.actionPrintPreview.setVisible(isEnabled);
        this.actionCopy.setEnabled(isEnabled);
        this.actionCopy.setVisible(isEnabled);
        this.actionCopyFrom.setVisible(isEnabled);
        this.actionCopyFrom.setVisible(isEnabled);
        this.kdtEntries.setEditable(isEnabled);
        this.kdtEntries.setEnabled(isEnabled);
        this.menuItemAddNew.setVisible(isEnabled);
        this.menuItemAddNew.setEnabled(isEnabled);
        this.actionAddNew.setEnabled(isEnabled);
        this.actionAddNew.setVisible(isEnabled);
        this.actionAddLine.setEnabled(isEnabled);
        this.actionAddLine.setVisible(isEnabled);
        this.actionRemoveLine.setEnabled(isEnabled);
        this.actionRemoveLine.setVisible(isEnabled);
        this.actionInsertLine.setEnabled(isEnabled);
        this.actionInsertLine.setVisible(isEnabled);
    }

    @Override
    public void loadFields() {
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        }
        if (this.isSetPrecisionAuto()) {
            try {
                this.setPrecision();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e.getCause());
            }
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        }
        this.formatTable(this.editData.getCurrency().getPrecision());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void formatTable(int precision) {
        IRow row = null;
        String rateFormat = "";
        int rowCount = this.kdtEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtEntries.getRow(i);
            this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precision));
            IntRateTypeExpressionEnum exp = (IntRateTypeExpressionEnum)row.getCell("intRateExpression").getValue();
            String enu = exp.getValue();
            rateFormat = "year".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
            row.getCell("rate").getStyleAttributes().setNumberFormat(rateFormat);
            row.getCell("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            PenAccrualTypeEnum exp1 = (PenAccrualTypeEnum)row.getCell("penaRateType").getValue();
            enu = exp1.getValue();
            rateFormat = "addPercent".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
            row.getCell("penaRate").getStyleAttributes().setNumberFormat(rateFormat);
            row.getCell("penaRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("intervalDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("overdueDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private void setAmtCellNumberFormat(IRow row, String format) {
        this.setNumberFormat(row, "amount", format);
        this.setNumberFormat(row, "yingjiamt", format);
        this.setNumberFormat(row, "yingjiPenaAmt", format);
    }

    private void setNumberFormat(IRow row, String columnKey, String format) {
        this.setNumberFormat(row, columnKey, format, true);
    }

    private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
        StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
        if (doFormat) {
            styleAttributes.setNumberFormat(format);
        } else {
            String formatRate = FMClientHelper.getNumberFtm((int)5);
            styleAttributes.setNumberFormat(formatRate);
        }
        styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.kdtEntries.checkParsed();
        this.pkBizDate.setSupportedEmpty(false);
        this.repayBillInfo = (FundTransferRepayBillInfo)this.getUIContext().get("REPAY_ID");
        com.kingdee.eas.fm.cl.modelutils.ClientUtils.initControlsBeforeOnLoad((KDComboBox)this.comboCurrency, null, null);
        super.onLoad();
        KDPromptSelector opseelect = F7SelectorFactory.getAccountF7((IUIObject)this, (String)this.currentCompany.getId().toString());
        this.prmtRecAcctView.setSelector(opseelect);
        this.restoreData();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        if (this.getBOTPViewStatus() != 1 && this.getOprtState().equals(OprtState.ADDNEW)) {
            this.prmtProject.setData((Object)(this.repayBillInfo == null ? this.getSourceLoanProjectInfo() : this.repayBillInfo.getProject()));
        }
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
    }

    private ProjectInfo getSourceLoanProjectInfo() throws EASBizException, BOSException {
        if (!EmptyUtil.isEmpty((Object)this.prmtTransBill.getData())) {
            BOSUuid id = ((FundTransferBillInfo)this.prmtTransBill.getData()).getId();
            return FundTransferBillFactory.getRemoteInstance().getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(id), this.getLoanProjectSelector()).getProject();
        }
        return null;
    }

    private SelectorItemCollection getLoanProjectSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("project.*"));
        return sic;
    }

    private void restoreData() {
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.comboCurrency.getSelectedItem();
    }

    protected void resetPrecisionForOtherComponent() {
        this.txtRate.setPrecision(5);
        this.txtPenaRate.setPrecision(5);
    }

    protected IObjectValue createNewData() {
        FundTransferInterestBillInfo intInfo = null;
        try {
            this.map = FundTransferInterestBillFactory.getRemoteInstance().repayIntForRateAdjust(this.getStartDate(), this.getEndDate(), this.repayBillInfo);
            intInfo = (FundTransferInterestBillInfo)this.map.get("fundTransferInterestBillInfo");
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return intInfo;
    }

    private Date getEndDate() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.repayBillInfo.getRepayDate());
        c.add(6, -1);
        return c.getTime();
    }

    private Date getStartDate() {
        Date loanStartDate = this.repayBillInfo.getLoan().getStartDate();
        Date lastIntDate = this.repayBillInfo.getLoan().getLastSettleDate();
        if (lastIntDate == null) {
            return loanStartDate;
        }
        return this.maxDate(loanStartDate, lastIntDate);
    }

    private Date maxDate(Date date1, Date date2) {
        int i = date1.compareTo(date2);
        switch (i) {
            case 1: {
                return date1;
            }
            case -1: {
                return date2;
            }
            case 0: {
                return date1;
            }
        }
        return date1;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add("fundFlowItem.*");
        sic.add("transRepay.id");
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.doBizVerify();
    }

    private void doBizVerify() {
    }

    protected void comboRateExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboRateExpression.getSelectedItem();
        IntRateTypeInfo rateType = this.editData.getTransBill().getRateType();
        com.kingdee.eas.fm.cl.modelutils.ClientUtils.calYearDays((IntRateTypeExpressionEnum)intRateTypeExpressionEnum, (IntRateTypeInfo)rateType, null, (KDLabelContainer)this.contRate);
    }

    protected void comboPenaAccrualType_actionPerformed(ActionEvent e) throws Exception {
        PenAccrualTypeEnum penAccrualType = (PenAccrualTypeEnum)this.comboPenaAccrualType.getShowSelectedItem();
        com.kingdee.eas.fm.cl.modelutils.ClientUtils.setPenaRateText((PenAccrualTypeEnum)penAccrualType, (KDLabelContainer)this.contPenaRate);
    }

    public boolean getSuccessFlag() {
        return this.successFlag;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.pk1 = null;
        if (this.repayBillInfo != null) {
            this.editData.setBizDate((Date)this.pkBizDate.getValue());
            this.editData.setDescription(this.txtDescription.getText());
            this.editData.setTransRepay(this.repayBillInfo);
            this.editData.setIntCalType(IntCalTypeEnum.REPAY_INT);
            this.editData.setNumber(this.txtNumber.getText());
            this.editData.setShijiIntAmt(this.txtShijiIntAmt.getBigDecimalValue());
            this.editData.setShijiPenaAmt(this.txtShijiPenaAmt.getBigDecimalValue());
            this.editData.setAcctBank((AccountBankInfo)this.prmtAcctBank.getValue());
            this.editData.setRecAcctView((AccountViewInfo)this.prmtRecAcctView.getValue());
            this.editData.setProject((ProjectInfo)this.prmtProject.getData());
            this.map.put("fundTransferInterestBillInfo", this.editData);
            FundTransferInterestBillFactory.getRemoteInstance().submitForRateAdjust(this.map);
            this.disposeUIWindow();
        } else if (this.map != null) {
            FundTransferInterestBillInfo intInfo = (FundTransferInterestBillInfo)this.map.get("fundTransferInterestBillInfo");
            intInfo.setNumber(this.txtNumber.getText());
            intInfo.setShijiIntAmt(this.txtShijiIntAmt.getBigDecimalValue());
            intInfo.setShijiPenaAmt(this.txtShijiPenaAmt.getBigDecimalValue());
            intInfo.setAcctBank((AccountBankInfo)this.prmtAcctBank.getValue());
            this.map.put("fundTransferInterestBillInfo", intInfo);
            FundTransferInterestBillFactory.getRemoteInstance().submitForRateAdjust(this.map);
        } else {
            super.actionSubmit_actionPerformed(e);
        }
        if (this.pk1 != null) {
            String billId = this.pk1.toString();
            String Msg = FMBudgetFacadeFactory.getRemoteInstance().getMsgFromID(billId);
            if (Msg != null && !"".equals(Msg)) {
                MsgBox.showConfirm2((String)Msg);
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.pk1 = super.runSubmit();
        return this.pk1;
    }

    public static int showIntReceiveEditUI(CoreUIObject ui, FundTransferRepayBillInfo repayInfo) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"REPAY_ID", (Object)repayInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FundTransferInterestBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            FundTransferInterestBillInfo intBillInfo = (FundTransferInterestBillInfo)((FundTransferInterestBillEditUI)uiWindow.getUIObject()).getDataObject();
            if (EmptyUtil.isEmpty((Object)intBillInfo.getYingjiIntAmt()) || !EmptyUtil.isEmpty((Object)intBillInfo.getYingjiIntAmt()) && intBillInfo.getYingjiIntAmt().compareTo(Constants.ZERO) <= 0) {
                uiWindow.close();
                return 1;
            }
            uiWindow.show();
            boolean success = ((FundTransferInterestBillEditUI)uiWindow.getUIObject()).getSuccessFlag();
            if (success) {
                uiWindow.close();
            }
            return 2;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort((Throwable)e);
            return 0;
        }
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.ft.app.FundTransferInterestBill", null, (IObjectValue)this.editData);
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    @Override
    protected void prmtAcctBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo accBank = (AccountBankInfo)this.prmtAcctBank.getValue();
        if (accBank != null) {
            accBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBank.getId()), this.getCustomSelector());
            this.prmtRecAcctView.setValue((Object)accBank.getAccount());
        }
    }

    private void setprmtDistributeAcctBankFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        String currencyID = ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyID));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtAcctBank.setEntityViewInfo(evi);
        this.prmtAcctBank.getQueryAgent().resetRuntimeEntityView();
    }

    private SelectorItemCollection getCustomSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        return sic;
    }

    @Override
    protected void prmtAcctBank_willCommit(CommitEvent e) throws Exception {
        this.setprmtDistributeAcctBankFilter();
    }

    @Override
    protected void prmtAcctBank_willShow(SelectorEvent e) throws Exception {
        this.setprmtDistributeAcctBankFilter();
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferInterestBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferInterestBillTDPrint(true);
    }

    private void fundTransferInterestBillTDPrint(boolean isPreview) {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        idSet.add(this.editData.getId());
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferInterestBillHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "FundTransferInterestBillHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "FundTransferInterestBillEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferInterestBillEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "transferInterest.id");
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSFERINTERESTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSFERINTERESTBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }
}

