/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.cl.AllEnum;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferInterestBillFilterUI;
import com.kingdee.eas.fm.ft.client.FundTransferInterestBillParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class FundTransferInterestBillFilterUI
extends AbstractFundTransferInterestBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferInterestBillFilterUI.class);

    protected void init() throws Exception {
        super.init();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.prmtLoanCompany, (boolean)true);
        FMClientHelper.setCustomerFilterF7(null, (KDBizPromptBox)this.prmtCustomer, (boolean)true, null);
    }

    private void customInit() {
        this.initDate();
        this.initRelations();
        this.initLoanCompany();
        this.initReations();
        this.initCurrency();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initReations() {
        this.comboRelations.removeAllItems();
        this.comboRelations.addItem((Object)RelationshipWithLoanCompanyEnum.INTERIOR);
        this.comboRelations.addItem((Object)RelationshipWithLoanCompanyEnum.EXTERIOR);
        this.comboRelations.addItem((Object)AllEnum.ALL);
        this.comboRelations.setSelectedItem((Object)RelationshipWithLoanCompanyEnum.INTERIOR);
    }

    public boolean verify() {
        if (DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())))) {
            MsgBox.showInfo((String)ResourceFactory.getBizModelResourceMsg((String)"enddate_error"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    private void initLoanCompany() {
        RelationshipWithLoanCompanyEnum reations = (RelationshipWithLoanCompanyEnum)this.comboRelations.getSelectedItem();
        if (reations == RelationshipWithLoanCompanyEnum.INTERIOR) {
            this.contLoanCompany.setVisible(true);
            this.contCustomer.setVisible(false);
        } else {
            this.contLoanCompany.setVisible(false);
            this.contCustomer.setVisible(true);
        }
        this.prmtLoanCompany.setValue(null);
        this.prmtCustomer.setValue(null);
    }

    private void initRelations() {
        this.comboRelations.setSelectedItem((Object)RelationshipWithLoanCompanyEnum.INTERIOR);
    }

    private void initDate() {
        Date now = new Date();
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public Object getParam() {
        Object obj;
        FundTransferInterestBillParam crbf = new FundTransferInterestBillParam();
        if (null != this.dpStartDate.getValue()) {
            crbf.setStartDate(DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())));
        }
        if (null != this.dpEndDate.getValue()) {
            crbf.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())));
        }
        if (null != this.comboRelations.getSelectedItem() && (obj = this.comboRelations.getSelectedItem()) instanceof RelationshipWithLoanCompanyEnum) {
            RelationshipWithLoanCompanyEnum relations = (RelationshipWithLoanCompanyEnum)this.comboRelations.getSelectedItem();
            crbf.setRations(relations);
            if (relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                if (null != this.prmtLoanCompany.getValue()) {
                    crbf.setLoanCompanyIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoanCompany));
                }
            } else if (null != this.prmtCustomer.getValue()) {
                crbf.setCustomerIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCustomer));
            }
        }
        crbf.setBOTP(false);
        if (this.bySave.isSelected()) {
            crbf.setStatus(StateEnum.SAVE);
        } else if (this.bySubmit.isSelected()) {
            crbf.setStatus(StateEnum.SUBMISSION);
        } else if (this.byAudit.isSelected()) {
            crbf.setStatus(StateEnum.EAA);
        } else {
            crbf.setStatus(null);
        }
        if (null != this.cboCurrency.getSelectedItem()) {
            obj = this.cboCurrency.getSelectedItem();
            if (obj instanceof CurrencyInfo) {
                crbf.setCurrencyInfo((CurrencyInfo)this.cboCurrency.getSelectedItem());
            } else {
                crbf.setCurrencyInfo(null);
            }
        }
        return crbf;
    }

    public void setParam(Object param) {
        if (null == param || !(param instanceof FundTransferInterestBillParam)) {
            return;
        }
        FundTransferInterestBillParam filterParam = (FundTransferInterestBillParam)param;
        this.dpStartDate.setValue((Object)filterParam.getStartDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        if (filterParam.getRations() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboRelations, (Object)filterParam.getRations());
        } else {
            this.comboRelations.setSelectedItem((Object)AllEnum.ALL);
        }
        this.prmtLoanCompany.setValue(null);
        this.prmtCustomer.setValue(null);
        if (filterParam.getRations() instanceof RelationshipWithLoanCompanyEnum) {
            if (filterParam.getRations() == RelationshipWithLoanCompanyEnum.INTERIOR) {
                this.setLoanCompany(filterParam);
            } else {
                this.setCustomer(filterParam);
            }
        }
        if (filterParam.getStatus() == null) {
            this.byAll.setSelected(true);
        } else if (filterParam.getStatus().getValue() == 0) {
            this.bySave.setSelected(true);
        } else if (filterParam.getStatus().getValue() == 1) {
            this.bySubmit.setSelected(true);
        } else if (filterParam.getStatus().getValue() == 2) {
            this.byAudit.setSelected(true);
        }
        if (filterParam.getCurrencyInfo() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)filterParam.getCurrencyInfo());
        } else {
            this.cboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
    }

    private void setCustomer(FundTransferInterestBillParam filterParam) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String[] customer = filterParam.getCustomerIDs();
        if (customer != null && customer.length > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])customer), CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                CustomerCollection customerCol = CustomerFactory.getRemoteInstance().getCustomerCollection(ev);
                this.prmtCustomer.setValue((Object)customerCol.toArray());
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
    }

    private void setLoanCompany(FundTransferInterestBillParam filterParam) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String[] loanCompany = filterParam.getLoanCompanyIDs();
        if (loanCompany != null && loanCompany.length > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])loanCompany), CompareType.INCLUDE));
            ev.setFilter(filter);
            try {
                CompanyOrgUnitCollection com = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
                this.prmtLoanCompany.setValue((Object)com.toArray());
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
    }

    @Override
    protected void comboRelations_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.comboRelations.getSelectedItem();
        if (obj instanceof RelationshipWithLoanCompanyEnum) {
            RelationshipWithLoanCompanyEnum relations = (RelationshipWithLoanCompanyEnum)this.comboRelations.getSelectedItem();
            if (relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                this.contLoanCompany.setVisible(true);
                this.contCustomer.setVisible(false);
                this.prmtCustomer.setValue(null);
            } else {
                this.contLoanCompany.setVisible(false);
                this.contCustomer.setVisible(true);
                this.prmtLoanCompany.setValue(null);
            }
        } else {
            this.contLoanCompany.setVisible(false);
            this.contCustomer.setVisible(false);
        }
    }

    @Override
    protected void prmtCustomer_dataChanged(DataChangeEvent e) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpEndDate.setSupportedEmpty(false);
        this.dpStartDate.setSupportedEmpty(false);
    }

    protected Class getParamClass() {
        return FundTransferInterestBillParam.class;
    }
}

