/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.LoanBaseBillInfo;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.RepayBaseBillInfo;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMBudgetFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.FundTransferInterestBillCollection;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferRepayBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTransferInterestBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundTransferRepayBillEditUI
extends AbstractFundTransferRepayBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferRepayBillEditUI.class);
    private boolean successFlag;
    private FundTransferBillInfo ftInfo;
    IObjectPK pk1;
    public static final String FUNDTRANSFERREPAYBILL_FILENAME = "/FM/INVEST/FT/FUNDTRANSFERREPAYBILL";

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (FMHelper.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "ft_repay_02addnew";
        }
        return "ft_repay_01view";
    }

    @Override
    public void loadFields() {
        CompanyOrgUnitInfo company;
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        } else {
            company = SysContext.getSysContext().getCurrentFIUnit();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)company.getBaseCurrency());
        }
        if (this.isSetPrecisionAuto()) {
            try {
                this.setPrecision();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e.getCause());
            }
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        } else {
            company = SysContext.getSysContext().getCurrentFIUnit();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)company.getBaseCurrency());
        }
        if (this.ftInfo != null) {
            this.pkMaturityDate.setValue((Object)this.ftInfo.getMaturityDate());
            this.pkEffectiveDate.setValue((Object)this.ftInfo.getEffectiveDate());
            this.prmtFinancingProduct.setValue((Object)this.ftInfo.getFinacingProduct());
        } else if (this.editData.getLoan() != null) {
            this.pkMaturityDate.setValue((Object)this.editData.getLoan().getMaturityDate());
            this.pkEffectiveDate.setValue((Object)this.editData.getLoan().getEffectiveDate());
            this.prmtFinancingProduct.setValue((Object)this.editData.getLoan().getFinacingProduct());
        }
        if (this.editData.getExchangeRate() != null) {
            this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        }
        this.txtRepayAmt.setValue((Object)this.editData.getRepayAmt());
        this.setChkIsPenaAccrua();
        this.restoreData();
    }

    private boolean chekcHasIntRelated(String id) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("transRepay.id", (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        FundTransferInterestBillCollection intBillCol = FundTransferInterestBillFactory.getRemoteInstance().getFundTransferInterestBillCollection(evi);
        return intBillCol != null && intBillCol.size() > 0;
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        if (this.getBOTPViewStatus() != 1) {
            this.ftInfo = this.getSourceLoanInfo();
        } else {
            FundTransferRepayBillInfo ftRepay = (FundTransferRepayBillInfo)this.getUIContext().get("InitDataObject");
            try {
                SelectorItemCollection ssic = new SelectorItemCollection();
                ssic.add(new SelectorItemInfo("*"));
                ssic.add(new SelectorItemInfo("transCompany.id"));
                ssic.add(new SelectorItemInfo("transCompany.name"));
                ssic.add(new SelectorItemInfo("transCompany.number"));
                ssic.add(new SelectorItemInfo("customer.id"));
                ssic.add(new SelectorItemInfo("customer.number"));
                ssic.add(new SelectorItemInfo("customer.name"));
                ssic.add(new SelectorItemInfo("finacingProduct.id"));
                ssic.add(new SelectorItemInfo("finacingProduct.number"));
                ssic.add(new SelectorItemInfo("finacingProduct.name"));
                ssic.add(new SelectorItemInfo("project.id"));
                ssic.add(new SelectorItemInfo("project.number"));
                ssic.add(new SelectorItemInfo("project.name"));
                ssic.add(new SelectorItemInfo("fpItem.number"));
                ssic.add(new SelectorItemInfo("fpItem.name"));
                ssic.add(new SelectorItemInfo("fpItem.id"));
                ssic.add(new SelectorItemInfo("distributeAcctBank.number"));
                ssic.add(new SelectorItemInfo("distributeAcctBank.name"));
                ssic.add(new SelectorItemInfo("distributeAcctBank.id"));
                ssic.add(new SelectorItemInfo("settleAcctView.number"));
                ssic.add(new SelectorItemInfo("settleAcctView.name"));
                ssic.add(new SelectorItemInfo("settleAcctView.id"));
                ssic.add(new SelectorItemInfo("company.id"));
                ssic.add(new SelectorItemInfo("company.name"));
                ssic.add(new SelectorItemInfo("fundFlowItem.*"));
                this.ftInfo = FundTransferBillFactory.getRemoteInstance().getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(ftRepay.getLoan().getId()), ssic);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        super.onLoad();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            RepayBaseBillInfo rbi = new RepayBaseBillInfo();
            rbi.setLoanAmt(this.editData.getLoanAmt());
            rbi.setRepayTotalAmt(this.editData.getRepayTotalAmt().subtract(this.editData.getRepayAmt()));
            rbi.setLoanBalance(this.editData.getLoanBalance().add(this.editData.getRepayAmt()));
            rbi.setLastRepayDate(this.editData.getLastRepayDate());
            rbi.setRepaySeq(this.editData.getRepaySeq());
            this.editData.setLastRepayInfo(rbi);
            this.txtRepayAmt.setEnabled(false);
            this.chkIsRepayWithAccrual.setEnabled(false);
            this.chkIsPenaAccrual.setEnabled(false);
            if (this.chekcHasIntRelated(this.editData.getId().toString())) {
                this.pkBizDate.setEnabled(false);
                this.pkRepayDate.setEnabled(false);
            }
        }
        this.contCustomer.setVisible(false);
        if (this.editData != null) {
            if (this.editData.getLoan() != null) {
                if (this.editData.getLoan().getRelationWithCmp() == RelationshipWithLoanCompanyEnum.INTERIOR) {
                    this.contTransCompany.setVisible(true);
                    this.contCustomer.setVisible(false);
                    this.prmtTransCompany.setEnabled(false);
                } else {
                    this.contTransCompany.setVisible(false);
                    this.contCustomer.setVisible(true);
                    this.prmtCustomer.setEnabled(false);
                }
            } else {
                this.contTransCompany.setVisible(true);
                this.contCustomer.setVisible(false);
                this.prmtTransCompany.setEnabled(false);
            }
        }
        KDPromptSelector opseelect = F7SelectorFactory.getAccountF7((IUIObject)this, (String)this.currentCompany.getId().toString());
        this.prmtReceAcctView.setSelector(opseelect);
        this.txtDescription.setMaxLength(80);
        this.txtNumber.setMaxLength(40);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        if (this.getBOTPViewStatus() != 1 && this.getOprtState().equals(OprtState.ADDNEW) && !EmptyUtil.isEmpty((String)((String)this.getUIContext().get("TransferBill"))) && "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory".equals((String)this.getUIContext().get("openType"))) {
            this.prmtProject.setData((Object)this.getSourceLoanProjectInfo());
        }
    }

    public FundTransferBillInfo getSourceLoanInfo() throws Exception {
        String id = (String)this.getUIContext().get("TransferBill");
        if (null == id) {
            return null;
        }
        return FundTransferBillFactory.getRemoteInstance().getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(id), this.getLoanSelector());
    }

    private ProjectInfo getSourceLoanProjectInfo() throws Exception {
        String id = (String)this.getUIContext().get("TransferBill");
        return FundTransferBillFactory.getRemoteInstance().getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(id), this.getLoanProjectSelector()).getProject();
    }

    protected LoanBaseBillInfo getLoanInfo() {
        return this.ftInfo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loan.*"));
        sic.add(new SelectorItemInfo("loan.transCompany.id"));
        sic.add(new SelectorItemInfo("loan.transCompany.name"));
        sic.add(new SelectorItemInfo("loan.transCompany.number"));
        sic.add(new SelectorItemInfo("loan.customer.id"));
        sic.add(new SelectorItemInfo("loan.customer.number"));
        sic.add(new SelectorItemInfo("loan.customer.name"));
        sic.add(new SelectorItemInfo("loan.finacingProduct.id"));
        sic.add(new SelectorItemInfo("loan.finacingProduct.number"));
        sic.add(new SelectorItemInfo("loan.finacingProduct.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("accountant.id"));
        sic.add(new SelectorItemInfo("accountant.number"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("receAcctBank.id"));
        sic.add(new SelectorItemInfo("receAcctBank.number"));
        sic.add(new SelectorItemInfo("receAcctBank.name"));
        sic.add(new SelectorItemInfo("receCompany.id"));
        sic.add(new SelectorItemInfo("receCompany.number"));
        sic.add(new SelectorItemInfo("receCompany.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add("fundFlowItem.*");
        return sic;
    }

    protected IObjectValue createNewData() {
        FundTransferRepayBillInfo ftRepayInfoNewData = new FundTransferRepayBillInfo();
        this.copyValues(ftRepayInfoNewData);
        return ftRepayInfoNewData;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getBOTPViewStatus() == 1) {
            FundTransferRepayBillInfo repayInfo = (FundTransferRepayBillInfo)dataObject;
            Date NOW = DateTimeUtils.truncateDate((Date)DateUtil.getDayBegin());
            if (repayInfo.getRepayAmt() == null) {
                repayInfo.setRepayAmt(this.ftInfo.getLoanBalanceAmt());
                this.txtRepayAmt.setMaximumValue((Comparable)this.ftInfo.getLoanBalanceAmt());
            }
            repayInfo.setLoanAmt(this.ftInfo.getLoanAmt());
            repayInfo.setLoan(this.ftInfo);
            repayInfo.setTransCompany(this.ftInfo.getTransCompany());
            repayInfo.setCustomer(this.ftInfo.getCustomer());
            repayInfo.setCurrency(this.ftInfo.getCurrency());
            repayInfo.setBizDate(NOW);
            if (repayInfo.getRepayDate() == null) {
                if (this.ftInfo.getLastRepayDate() != null) {
                    repayInfo.setRepayDate(this.ftInfo.getLastRepayDate());
                } else {
                    repayInfo.setRepayDate(NOW);
                }
            }
            repayInfo.setRepaySeq(this.ftInfo.getRepayTimes() + 1);
            repayInfo.setRepayTotalAmt(this.ftInfo.getLoanAmt().subtract(this.ftInfo.getLoanBalanceAmt()).add(repayInfo.getRepayAmt()));
            repayInfo.setLoanBalance(repayInfo.getLoanAmt().subtract(repayInfo.getRepayTotalAmt()));
            repayInfo.setAccrual(Constants.ZERO);
            repayInfo.setPenaAccrual(Constants.ZERO);
            repayInfo.setReceAcctBank(this.ftInfo.getDistributeAcctBank());
            repayInfo.setCompany(this.ftInfo.getCompany());
            repayInfo.setExchangeRate(this.ftInfo.getExchangeRate());
            repayInfo.setRepayAmtLocal(FMHelper.multiply((BigDecimal)repayInfo.getExchangeRate(), (BigDecimal)repayInfo.getRepayAmt()));
            repayInfo.setReceAcctView(this.ftInfo.getSettleAcctView());
            repayInfo.setReceCompany(this.ftInfo.getCompany());
            String description = EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"36_FundTransferRepayBillEditUI");
            description = MessageFormat.format(description, this.ftInfo.getNumber(), repayInfo.getRepaySeq());
            repayInfo.setDescription(description);
            repayInfo.setHasInterestBill(false);
            repayInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        }
    }

    private void copyValues(FundTransferRepayBillInfo infoNewData) {
        FundTransferBillInfo loaninfo = null;
        try {
            loaninfo = this.getSourceLoanInfo();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e.getCause());
        }
        Date NOW = DateTimeUtils.truncateDate((Date)DateUtil.getDayBegin());
        infoNewData.setBizDate(NOW);
        infoNewData.setRepayDate(NOW);
        infoNewData.setCompany(this.currentCompany);
        if (loaninfo != null) {
            infoNewData.setRepayAmt(loaninfo.getLoanBalanceAmt());
            infoNewData.setLoanAmt(loaninfo.getLoanAmt());
            infoNewData.setLoan(loaninfo);
            infoNewData.setTransCompany(loaninfo.getTransCompany());
            infoNewData.setCustomer(loaninfo.getCustomer());
            infoNewData.setCurrency(loaninfo.getCurrency());
            infoNewData.setRepaySeq(loaninfo.getRepayTimes() + 1);
            infoNewData.setRepayTotalAmt(loaninfo.getLoanAmt().subtract(loaninfo.getLoanBalanceAmt()).add(infoNewData.getRepayAmt()));
            infoNewData.setLoanBalance(infoNewData.getLoanAmt().subtract(infoNewData.getRepayTotalAmt()));
            infoNewData.setAccrual(Constants.ZERO);
            infoNewData.setPenaAccrual(Constants.ZERO);
            infoNewData.setCreator(loaninfo.getCreator());
            infoNewData.setReceAcctBank(loaninfo.getDistributeAcctBank());
            infoNewData.setExchangeRate(loaninfo.getExchangeRate());
            infoNewData.setRepayAmtLocal(FMHelper.multiply((BigDecimal)infoNewData.getExchangeRate(), (BigDecimal)infoNewData.getRepayAmt()));
            infoNewData.setIsRepayWithAccrual(true);
            infoNewData.setReceAcctView(this.ftInfo.getSettleAcctView());
            infoNewData.setReceCompany(this.ftInfo.getCompany());
            String description = EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"36_FundTransferRepayBillEditUI");
            description = MessageFormat.format(description, this.ftInfo.getNumber(), infoNewData.getRepaySeq());
            infoNewData.setDescription(description);
            infoNewData.setHasInterestBill(false);
        }
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    private SelectorItemCollection getLoanSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("transCompany.id"));
        sic.add(new SelectorItemInfo("transCompany.number"));
        sic.add(new SelectorItemInfo("transCompany.name"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("distributeAcctBank.id"));
        sic.add(new SelectorItemInfo("distributeAcctBank.number"));
        sic.add(new SelectorItemInfo("distributeAcctBank.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("finacingProduct.id"));
        sic.add(new SelectorItemInfo("finacingProduct.number"));
        sic.add(new SelectorItemInfo("finacingProduct.name"));
        sic.add(new SelectorItemInfo("settleAcctView.id"));
        sic.add(new SelectorItemInfo("settleAcctView.number"));
        sic.add(new SelectorItemInfo("settleAcctView.name"));
        return sic;
    }

    private SelectorItemCollection getLoanProjectSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("project.*"));
        return sic;
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        this.editData.setFivouchered(false);
    }

    @Override
    protected void chkIsRepayWithAccrual_itemStateChanged(ItemEvent e) throws Exception {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return;
        }
        if (this.chkIsRepayWithAccrual.isSelected()) {
            this.setChkIsPenaAccrua();
        } else {
            this.chkIsPenaAccrual.setSelected(false);
            this.chkIsPenaAccrual.setEnabled(false);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setIsModifyOper(false);
        } else {
            this.editData.setIsModifyOper(true);
        }
        this.pk1 = null;
        this.editData.setLoan(this.ftInfo);
        this.editData.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
        this.verify(e);
        if (!this.editData.getIsModifyOper() && this.editData.isIsRepayWithAccrual()) {
            if (this.editData.getRepayDate().compareTo(this.editData.getLoan().getEffectiveDate()) == 0) {
                this.repayWithoutAccrual(e);
            } else {
                this.repayWithAccrual(e);
            }
        } else {
            this.repayWithoutAccrual(e);
        }
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkBizDate});
        if (this.pk1 != null) {
            String billId = this.pk1.toString();
            String Msg = FMBudgetFacadeFactory.getRemoteInstance().getMsgFromID(billId);
            if (Msg != null && !"".equals(Msg)) {
                MsgBox.showConfirm2((String)Msg);
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.pk1 = super.runSubmit();
        return this.pk1;
    }

    private void repayWithoutAccrual(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.getUIContext().put("BOTPViewStatus", new Integer(0));
        Boolean isAddNew = (Boolean)this.getUIContext().get("IS_ADDNEW");
        if (isAddNew == null || !isAddNew.booleanValue()) {
            this.successFlag = true;
            this.setDataObject(this.createNewData());
            this.loadFields();
            this.disposeUIWindow();
        } else {
            this.successFlag = true;
            this.getUIContext().remove("TransferBill");
            this.getUIContext().put("BOTPViewStatus", new Integer(-1));
            this.setDataObject(this.createNewData());
            this.loadFields();
        }
    }

    private void repayWithAccrual(ActionEvent e) throws BOSException, EASBizException, Exception {
        FundTransferRepayBillFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)this.editData);
        int result = FundTransferInterestBillEditUI.showIntReceiveEditUI((CoreUIObject)this, this.editData);
        if (result == 2) {
            this.restoreData();
            this.successFlag = true;
            this.getUIContext().remove("TransferBill");
            this.getUIContext().put("BOTPViewStatus", new Integer(-1));
            this.setDataObject(this.createNewData());
            this.loadFields();
        } else if (result == 1) {
            super.actionSubmit_actionPerformed(e);
            this.getUIContext().remove("TransferBill");
            this.getUIContext().put("BOTPViewStatus", new Integer(-1));
            this.setDataObject(this.createNewData());
            this.loadFields();
            this.successFlag = true;
            if (this.successFlag) {
                this.disposeUIWindow();
            }
        }
        if (this.successFlag) {
            this.disposeUIWindow();
        }
    }

    private void restoreData() {
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public static void showRepayWindow(CoreUIObject ui, String id) throws EASBizException, UIException {
        if (id == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"TransferBill", (Object)id);
        uiContext.put((Object)"openType", (Object)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FundTransferRepayBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((FundTransferRepayBillEditUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }

    private boolean getSuccessFlag() {
        return this.successFlag;
    }

    public void initDataStatus() {
        super.initDataStatus();
        FundTransferRepayBillInfo repayInfo = (FundTransferRepayBillInfo)this.getDataObject();
        if (repayInfo.getCurrency() != null && this.currentCompany.getBaseCurrency().getId().toString().equals(repayInfo.getCurrency().getId().toString())) {
            this.txtExchangeRate.setEditable(false);
            this.txtExchangeRate.setEnabled(false);
        } else {
            this.txtExchangeRate.setEditable(true);
            this.txtExchangeRate.setEnabled(true);
        }
        if (repayInfo != null) {
            if (repayInfo.getLoan() != null) {
                if (repayInfo.getLoan().getRelationWithCmp() == RelationshipWithLoanCompanyEnum.INTERIOR) {
                    this.contTransCompany.setVisible(true);
                    this.contCustomer.setVisible(false);
                    this.prmtTransCompany.setEnabled(false);
                } else {
                    this.contTransCompany.setVisible(false);
                    this.contCustomer.setVisible(true);
                    this.prmtCustomer.setEnabled(false);
                }
            } else {
                this.contTransCompany.setVisible(true);
                this.contCustomer.setVisible(false);
                this.prmtTransCompany.setEnabled(false);
            }
        }
        boolean actCreFromEnabled = true;
        if (this.getUIContext().get("openType") != null && this.getUIContext().get("openType").toString().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            actCreFromEnabled = false;
        }
        boolean actCreFromEnabled1 = !this.getOprtState().equals(OprtState.VIEW);
        boolean isEnabled = actCreFromEnabled && actCreFromEnabled1;
        this.actionCreateFrom.setVisible(isEnabled);
        this.actionCreateFrom.setEnabled(isEnabled);
        this.btnCreateFrom.setVisible(isEnabled);
        this.btnCreateFrom.setEnabled(isEnabled);
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.actionPre.setEnabled(false);
            this.actionPre.setVisible(false);
            this.actionNext.setEnabled(false);
            this.actionNext.setVisible(false);
            this.actionFirst.setEnabled(false);
            this.actionFirst.setVisible(false);
            this.actionLast.setEnabled(false);
            this.actionLast.setVisible(false);
        }
        this.txtAccrual.setEnabled(true);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.pkRepayDate.setSupportedEmpty(false);
        this.txtAccrual.setEnabled(false);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.txtRepayAmt.setEnabled(false);
            this.chkIsRepayWithAccrual.setEnabled(false);
            this.chkIsPenaAccrual.setEnabled(false);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtLoan.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)ResourceFactory.getModelResourceMsg((String)"shouldcreatefrom_fundtrans_repay"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        super.verifyInput(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransferRepayBillFactory.getRemoteInstance();
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("DefaultQueryFilter", this.getFilter());
        ctx.put("fundTransfer", "fundTransfer");
        ctx.put("CURRENTCOMPANY", this.currentCompany.getId().toString());
        this.getBillEdit().createFrom(null, ctx);
        this.btnCreateFrom.setEnabled(true);
    }

    private FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)Constants.ZERO, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
        return filterInfo;
    }

    @Override
    protected void prmtReceAcctBank_willCommit(CommitEvent e) throws Exception {
        this.setAccountBankFilter();
    }

    @Override
    protected void prmtReceAcctBank_willShow(SelectorEvent e) throws Exception {
        this.setAccountBankFilter();
    }

    @Override
    protected void prmtReceAcctBank_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo accBank = (AccountBankInfo)this.prmtReceAcctBank.getValue();
        if (accBank != null) {
            accBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBank.getId()), this.getCustomSelector());
            this.prmtReceAcctView.setValue((Object)accBank.getAccount());
        }
    }

    private SelectorItemCollection getCustomSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("classificatio.id"));
        return sic;
    }

    private void setAccountBankFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtReceAcctBank.setEntityViewInfo(evi);
        this.prmtReceAcctBank.getQueryAgent().resetRuntimeEntityView();
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(company);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        this.editData.setCurrency(currencyInfo);
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.ft.app.FundTransferRepayBill", null, (IObjectValue)this.editData);
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    private boolean isPenaAccrualable() {
        boolean isPenaAccrualEnable = false;
        if (this.editData.getLoan() != null) {
            if (this.editData.getRepayDate().compareTo(this.editData.getLoan().getMaturityDate()) > 0) {
                isPenaAccrualEnable = true;
            }
        } else if (this.pkRepayDate.getValue() != null && this.pkMaturityDate.getValue() != null && this.pkRepayDate.getSqlDate().compareTo(this.pkMaturityDate.getSqlDate()) > 0) {
            isPenaAccrualEnable = true;
        }
        return isPenaAccrualEnable && this.chkIsRepayWithAccrual.isSelected();
    }

    private void setChkIsPenaAccrua() {
        this.chkIsPenaAccrual.setEnabled(this.isPenaAccrualable());
        this.chkIsPenaAccrual.setSelected(this.chkIsPenaAccrual.isEnabled());
    }

    @Override
    protected void pkRepayDate_dataChanged(DataChangeEvent e) throws Exception {
        this.editData.setRepayDate((Date)this.pkRepayDate.getValue());
        this.setChkIsPenaAccrua();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferRepayBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.fundTransferRepayBillTDPrint(true);
    }

    private void fundTransferRepayBillTDPrint(boolean isPreview) {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        idSet.add(this.editData.getId());
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferRepayBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSFERREPAYBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSFERREPAYBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "repayDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

