/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.cl.StateEnum;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFacadeFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ft.IFundTransferRepayBill;
import com.kingdee.eas.fm.ft.IFundTransferRepayBillFacade;
import com.kingdee.eas.fm.ft.client.AbstractFundTransferRepayBillListUI;
import com.kingdee.eas.fm.ft.client.FTRepayListPropress;
import com.kingdee.eas.fm.ft.client.FundTransClientHelper;
import com.kingdee.eas.fm.ft.client.FundTransferRepayBillEditUI;
import com.kingdee.eas.fm.ft.client.FundTransferRepayBillFilterParam;
import com.kingdee.eas.fm.ft.client.FundTransferRepayBillFilterUI;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundTransferRepayBillListUI
extends AbstractFundTransferRepayBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FundTransferRepayBillListUI.class);
    private FundTransferRepayBillFilterUI filterUI;
    private IContextHelper iContextHelper;
    FillListener fillListener = new FillListener();
    public static final String FUNDTRANSFERREPAYBILL_FILENAME = "/FM/INVEST/FT/FUNDTRANSFERREPAYBILL";

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FundTransferRepayBillFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return FundTransferRepayBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundTransferRepayBillFactory.getRemoteInstance();
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new FTRepayListPropress();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkModfify();
        super.actionRemove_actionPerformed(e);
    }

    private void checkModfify() throws Exception {
        FundTransferRepayBillInfo repayInfo = this.getSelectedInfo();
        if (StateEnum.EAA.equals((Object)repayInfo.getState())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"89_ConsignmentApplicationEditUI"));
            this.abort();
        }
        this.checkRepaySeq(repayInfo);
    }

    private void checkRepaySeq(FundTransferRepayBillInfo repayInfo) {
        if (repayInfo.getRepaySeq() != repayInfo.getLoan().getRepayTimes()) {
            FundTransClientHelper.showMsgAndAbort((CoreUI)this, "repay_seq_error");
        }
    }

    private FundTransferRepayBillInfo getSelectedInfo() throws Exception {
        this.checkSelected();
        return ((IFundTransferRepayBill)this.getBillInterface()).getFundTransferRepayBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getCustomerSelectors());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        return sic;
    }

    private SelectorItemCollection getCustomerSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("loan.repayTimes"));
        return sic;
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompanyCommon);
        this.iContextHelper = ContextHelperFactory.getRemoteInstance();
        super.onLoad();
        this.actionViewDoProccess.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
        this.actionAntiBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        int bookType = this.iContextHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId()));
        if (bookType != 0) {
            this.actionBook.setVisible(false);
            this.actionAntiBook.setVisible(false);
            this.actionBook.setEnabled(false);
            this.actionAntiBook.setEnabled(false);
        } else {
            this.actionBook.setVisible(true);
            this.actionAntiBook.setVisible(true);
            this.actionBook.setEnabled(true);
            this.actionAntiBook.setEnabled(true);
        }
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 2;
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    protected boolean isFootVisible() {
        return true;
    }

    public void execQuery() {
        if (this.isBotp() && this.getUIContext().get("BTPEDITPARAMETER") != null && "ReceivingBill".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("cashier.name", null));
            if (this.mainQuery.getFilter() != null) {
                try {
                    filter.mergeFilter(this.mainQuery.getFilter(), "AND");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.formatFootRow();
    }

    private boolean isBotp() {
        int status;
        if (this.getUIContext().get("BOTPViewStatus") == null) {
            return false;
        }
        return this.getUIContext().get("BOTPViewStatus") instanceof Integer && (status = ((Integer)this.getUIContext().get("BOTPViewStatus")).intValue()) == 1;
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            FundTransferRepayBillFilterParam param = (FundTransferRepayBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyInfo() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyInfo());
            String[] columns = new SumFiledsInfo(SumBillEnum.FtLoanRepay).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.getSelectedKeyValues() != null && this.getSelectedIdValues().size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"23_FundTransferBillListUI"));
            SysUtil.abort();
        }
        String selectId = this.getSelectedKeyValue();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("state"));
        FundTransferRepayBillInfo billInfo = FundTransferRepayBillFactory.getRemoteInstance().getFundTransferRepayBillInfo((IObjectPK)new ObjectUuidPK(selectId), selector);
        if (!StateEnum.EAA.equals((Object)billInfo.getState())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"93_ConsignmentApplicationListUI"));
            this.abort();
        }
        super.actionCreateTo_actionPerformed(e);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && "fromRepayment".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("fromRepayment"))) {
            filter.getFilterItems().add(new FilterItemInfo("isCreateLoanRepayBill", null, CompareType.IS));
            filter.getFilterItems().add(new FilterItemInfo("isCreateLoanRepayBill", (Object)"0"));
            filter.getFilterItems().add(new FilterItemInfo("loan.isGenLoan", (Object)"1"));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)2));
            Map botpParams = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            filter.getFilterItems().add(new FilterItemInfo("transCompany.id", botpParams.get("CURRENTCOMPANY")));
            filter.getFilterItems().add(new FilterItemInfo("cashier.name", null));
            filter.setMaskString("( #0 or #1 ) and #2 and #3 and #4 and #5");
            return filter;
        }
        return filter;
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        StringBuffer sbList = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            HashSet idSet = new HashSet();
            for (int i = 0; i < idList.size(); ++i) {
                idSet.add(idList.get(i));
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(fi);
            BillBaseCollection coll = FundTransferRepayBillFactory.getRemoteInstance().getBillBaseCollection(view);
            for (FundTransferRepayBillInfo info : coll) {
                if (info.getCashier() == null || info.getCashier().getId() == null) continue;
                if (sbList.length() > 0) {
                    sbList.append("," + info.getNumber());
                    continue;
                }
                sbList.append(info.getNumber());
            }
        }
        if (sbList.length() > 0) {
            String msg = sbList + EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"hasBookBill");
            MsgBox.showInfo((String)msg);
            this.abort();
        }
        IFundTransferRepayBillFacade facade = FundTransferRepayBillFacadeFactory.getRemoteInstance();
        facade.book(idList);
        this.showMsg(e);
    }

    @Override
    public void actionAntiBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        Object cashier = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            cashier = row.getCell("cashier.name").getValue();
            if (cashier == null) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"28_FundTransferBillListUI"));
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            IFundTransferRepayBillFacade facade = FundTransferRepayBillFacadeFactory.getRemoteInstance();
            facade.antiBook(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"29_FundTransferBillListUI"))) == 0) {
            IFundTransferRepayBillFacade facade = FundTransferRepayBillFacadeFactory.getRemoteInstance();
            facade.antiBook(ids);
            this.showMsg(e);
        }
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.fundTransferRepayBillTDPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.fundTransferRepayBillTDPrint(true);
    }

    private void fundTransferRepayBillTDPrint(boolean isPreview) {
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ft.app.FundTransferRepayBillTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(FMHelper.list2Set((List)idList), headPK);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(FUNDTRANSFERREPAYBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(FUNDTRANSFERREPAYBILL_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        if (destBosTypeList == null || destBosTypeList.size() == 0) {
            return null;
        }
        FundTransferRepayBillInfo info = null;
        try {
            info = this.getSelectedInfo();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (info != null && info.getCashier() != null) {
            destBosTypeList.remove(new ReceivingBillInfo().getBOSType().toString());
        }
        destBosTypeList.remove("18180D81");
        return destBosTypeList;
    }

    private boolean chekcHasRepaymentBillRelated(String id) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createFrom", (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        RepaymentCollection intBillCol = RepaymentFactory.getRemoteInstance().getRepaymentCollection(evi);
        return intBillCol != null && intBillCol.size() > 0;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        FundTransferRepayBillInfo info = FundTransferRepayBillFactory.getRemoteInstance().getFundTransferRepayBillInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (StateEnum.EAA.equals((Object)info.getState())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"372_RepaymentListUI"));
            this.abort();
        }
        if (this.chekcHasRepaymentBillRelated(keyValue)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"687_Repayment_edit"));
            this.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        HashSet idSet = new HashSet(ids);
        if (EmptyUtil.isEmpty((Collection)ids)) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)ids);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        FundTransferRepayBillFactory.getRemoteInstance().audit(idSet);
        this.refresh(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        HashSet idSet = new HashSet(ids);
        FundTransferRepayBillFactory.getRemoteInstance().unAudit(idSet);
        this.refresh(e);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "repayDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionSubmit", "actionUnAudit"};
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(FundTransferRepayBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                Integer precesion = (Integer)row.getCell("currency.precision").getValue();
                this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
                String format = FMClientHelper.getNumberFtm((int)FundTransferRepayBillListUI.this.getBaseCurrencyPrecision());
                this.setNumberFormat(row, "repayAmtLocal", format);
                String rateFormat = "";
                BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("loan.intRateExpression").getValue();
                Object enu = exp.getValue();
                rateFormat = "year".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
                row.getCell("loan.rate").getStyleAttributes().setNumberFormat(rateFormat);
                row.getCell("loan.rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                exp = (BizEnumValueInfo)row.getCell("loan.penAccrualType").getValue();
                enu = exp.getValue();
                rateFormat = "addPercent".equals(enu.toString()) ? "#,##0.00000\\%" : "#,##0.00000\\\u2030";
                row.getCell("loan.penaRate").getStyleAttributes().setNumberFormat(rateFormat);
                row.getCell("loan.penaRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "repayAmt", format);
            this.setNumberFormat(row, "loanBalance", format);
            this.setNumberFormat(row, "repayTotalAmt", format);
            this.setNumberFormat(row, "accrual", format);
            this.setNumberFormat(row, "penaAccrual", format);
            this.setNumberFormat(row, "exchangeRate", format, false);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            this.setNumberFormat(row, columnKey, format, true);
        }

        private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            if (doFormat) {
                styleAttributes.setNumberFormat(format);
            } else {
                String formatRate = FMClientHelper.getNumberFtm((int)5);
                styleAttributes.setNumberFormat(formatRate);
            }
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

