/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.cl.AllEnum;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.IvtModuleResourceReader;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillCollection;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillFactory;
import com.kingdee.eas.fm.ft.FundTransRateAdjustBillInfo;
import com.kingdee.eas.fm.ft.FundTransferBillCollection;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ft.client.AbstractFundTrasnferBillChooseUI;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FundTrasnferBillChooseUI
extends AbstractFundTrasnferBillChooseUI {
    private Set createdIntReceivedID;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.prmtTransBill.setDisplayFormat("$number$");
        FundTransferBillCollection fundTransferBillCollection = (FundTransferBillCollection)((Object)this.getUIContext().get("fundTrans"));
        if (fundTransferBillCollection != null && !fundTransferBillCollection.isEmpty()) {
            this.prmtTransBill.setData((Object)fundTransferBillCollection.toArray());
        }
    }

    @Override
    protected void cboRelations_itemStateChanged(ItemEvent e) throws Exception {
        IvtModualUtils.cboRelationsItemStateChanged((KDComboBox)this.cboRelations, (KDLabelContainer)this.contCustomer, (KDBizPromptBox)this.prmtCustomer, (KDLabelContainer)this.contTransCompany, (KDBizPromptBox)this.prmtTransCompany);
    }

    private void initComboRelations() {
        this.cboRelations.addItem((Object)AllEnum.ALL);
        this.cboRelations.setSelectedItem((Object)RelationshipWithLoanCompanyEnum.INTERIOR);
    }

    private void init() {
        this.initCurrecny();
        this.initDate();
        this.initRateExpression();
        this.initPenaType();
        this.initNumberFormat();
        this.initNumberValue();
        this.initComboRelations();
        this.prmtTransBill.setEnabledMultiSelection(true);
        this.prmtCustomer.setValue(null);
        this.prmtCustomer.setEnabledMultiSelection(true);
        this.prmtCustomer.setDisplayFormat("$name$");
        this.prmtCustomer.setCommitFormat("$number$");
        this.prmtCustomer.setEditFormat("$name$");
        FMClientHelper.setCustomerF7(null, (KDBizPromptBox)this.prmtCustomer, (boolean)true, null);
        this.prmtTransCompany.setValue(null);
        this.prmtTransCompany.setEnabledMultiSelection(true);
        this.prmtTransCompany.setDisplayFormat("$name$");
        this.prmtTransCompany.setCommitFormat("$number$");
        this.prmtTransCompany.setEditFormat("$name$");
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.prmtTransCompany, (boolean)true);
    }

    private void initCurrecny() {
        IvtModualUtils.fillCboCurrency((KDComboBox)this.cboCurrency);
    }

    private void initDate() {
        this.dpAdjDate.setSupportedEmpty(false);
        this.dpAdjDate.setValue((Object)DateUtil.getDayBegin());
    }

    private void initRateExpression() {
        this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
    }

    private void initPenaType() {
        this.comboPenaType.setSelectedItem((Object)PenAccrualTypeEnum.ADD_PERCENT);
    }

    private void initNumberValue() {
        this.txtRate.setValue((Object)Constants.ZERO);
        this.txtPenaRate.setValue((Object)Constants.ZERO);
        this.txtYearDays.setValue((Object)IvtModualUtils.VALUE_360);
    }

    private void initNumberFormat() {
        this.txtRate.setPrecision(5);
        this.txtRate.setHorizontalAlignment(4);
        this.txtRate.setRemoveingZeroInDispaly(false);
        this.txtRate.setMaximumValue((Comparable)Constants.ZERO);
        this.txtRate.setMaximumValue((Comparable)Constants.ONE_HUNDRED);
        this.txtPenaRate.setPrecision(5);
        this.txtPenaRate.setHorizontalAlignment(4);
        this.txtPenaRate.setRemoveingZeroInDispaly(false);
        this.txtYearDays.setHorizontalAlignment(4);
        this.txtRate.setSupportedEmpty(false);
        this.txtPenaRate.setSupportedEmpty(false);
        this.txtYearDays.setSupportedEmpty(false);
    }

    @Override
    protected void prmtTransBill_willCommit(CommitEvent e) throws Exception {
        this.filterTransBill();
    }

    @Override
    protected void prmtTransBill_willShow(SelectorEvent e) throws Exception {
        this.filterTransBill();
    }

    private void filterTransBill() {
        this.prmtTransBill.getQueryAgent().resetRuntimeEntityView();
        this.prmtTransBill.setEntityViewInfo(this.setAllLoanView());
        this.prmtTransBill.setSelectorCollection(this.getCustomSelectors());
    }

    private EntityViewInfo setAllLoanView() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItmes(filter);
        evi.setFilter(filter);
        return evi;
    }

    private void setFilterItmes(FilterInfo filter) {
        this.setCurrencyFilterItem(filter);
        this.setTransCompanyFilterItem(filter);
        this.setBalanceFilterItem(filter);
        this.setStatusFilter(filter);
        this.setRateTypeFilterItem(filter);
    }

    private void setStatusFilter(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3), CompareType.EQUALS));
    }

    private void setBalanceFilterItem(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("loanBalanceAmt", (Object)Constants.ZERO, CompareType.GREATER));
    }

    private void setRateTypeFilterItem(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("rateType.id", (Object)ResourceFactory.getConsultativeRate()));
    }

    private void setTransCompanyFilterItem(FilterInfo filter) {
        Object rswc = this.cboRelations.getSelectedItem();
        if (rswc instanceof RelationshipWithLoanCompanyEnum) {
            if (rswc == RelationshipWithLoanCompanyEnum.EXTERIOR) {
                String[] customerIDs = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCustomer);
                if (customerIDs != null && customerIDs.length > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)FMHelper.asSet((String[])customerIDs), CompareType.INCLUDE));
                }
                filter.getFilterItems().add(new FilterItemInfo("transCompany.id", null, CompareType.EQUALS));
            } else {
                String[] loanCompanyIDs = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtTransCompany);
                if (loanCompanyIDs != null && loanCompanyIDs.length > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("transCompany.id", (Object)FMHelper.asSet((String[])loanCompanyIDs), CompareType.INCLUDE));
                }
                filter.getFilterItems().add(new FilterItemInfo("customer.id", null, CompareType.EQUALS));
            }
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
    }

    private void setCurrencyFilterItem(FilterInfo filter) {
        Object obj = this.cboCurrency.getSelectedItem();
        if (obj instanceof CurrencyInfo) {
            CurrencyInfo info = (CurrencyInfo)obj;
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getId().toString()));
        }
    }

    private SelectorItemCollection getCustomSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public boolean verify() {
        String[] loanids = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtTransBill);
        if (loanids == null || loanids.length <= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"choose_loan"));
            SysUtil.abort();
        }
        if (this.txtYearDays.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"yearday_error"));
            SysUtil.abort();
        }
        if (this.txtPenaRate.getBigDecimalValue().compareTo(Constants.ZERO) < 0 || this.txtPenaRate.getBigDecimalValue().compareTo(Constants.ONE_HUNDRED) >= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"penarate_error"));
            SysUtil.abort();
        }
        return true;
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.createdIntReceivedID = new HashSet();
        this.createdIntReceivedID.clear();
        FundTransRateAdjustBillCollection col = this.createRateAdjustBillCollection();
        this.createdIntReceivedID = FundTransRateAdjustBillFactory.getRemoteInstance().batchAdjustRate(col);
        if (this.createdIntReceivedID == null || this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"no_adjust_rate_bill_created"));
            SysUtil.abort();
        } else {
            this.disposeUIWindow();
        }
    }

    private FundTransRateAdjustBillCollection createRateAdjustBillCollection() throws BOSException {
        FundTransferBillCollection loanCol = null;
        if (this.prmtTransBill.getValue() == null) {
            loanCol = FundTransferBillFactory.getRemoteInstance().getFundTransferBillCollection(this.setAllLoanView());
        } else {
            Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtTransBill));
            loanCol = FundTransferBillFactory.getRemoteInstance().getFundTransferBillCollection(this.setSelectLoanView(ids));
        }
        return this.createCLRateAdjustBills(loanCol);
    }

    private FundTransRateAdjustBillCollection createCLRateAdjustBills(FundTransferBillCollection loanCol) {
        FundTransRateAdjustBillCollection col = new FundTransRateAdjustBillCollection();
        int size = loanCol.size();
        for (int i = 0; i < size; ++i) {
            FundTransferBillInfo loanInfo = loanCol.get(i);
            col.add(this.createNewData(loanInfo));
        }
        return col;
    }

    private FundTransRateAdjustBillInfo createNewData(FundTransferBillInfo loanInfo) {
        FundTransRateAdjustBillInfo rateAdjustInfo = new FundTransRateAdjustBillInfo();
        this.setValues(rateAdjustInfo, loanInfo);
        return rateAdjustInfo;
    }

    private void setValues(FundTransRateAdjustBillInfo rateAdjustInfo, FundTransferBillInfo loanInfo) {
        this.copyValueFromLoanInfo(rateAdjustInfo, loanInfo);
        this.copyValueFromUI(rateAdjustInfo);
        this.copyValueFromOther(rateAdjustInfo);
    }

    private void copyValueFromLoanInfo(FundTransRateAdjustBillInfo rateAdjustInfo, FundTransferBillInfo loanInfo) {
        rateAdjustInfo.setLoan(loanInfo);
        rateAdjustInfo.setAdjustSeq(loanInfo.getAdjustRateTimes() + 1);
        rateAdjustInfo.setLastAdjustDate(loanInfo.getLastAdjustDate());
        rateAdjustInfo.setCurrency(loanInfo.getCurrency());
    }

    private void copyValueFromOther(FundTransRateAdjustBillInfo rateAdjustInfo) {
        IContextHelper iContextHelp = ContextHelperFactory.getRemoteInstance();
        rateAdjustInfo.setCompany(iContextHelp.getCurrentCompany());
        rateAdjustInfo.setCU(iContextHelp.getCurrentCtrlUnit());
        rateAdjustInfo.setCreator(iContextHelp.getCurrentUser());
    }

    private EntityViewInfo setSelectLoanView(Set ids) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        evi.setFilter(filter);
        return evi;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public static Set show(CoreUI ui) {
        Set returnValue = new HashSet();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"fundTrans", ui.getUIContext().get("ids"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FundTrasnferBillChooseUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((FundTrasnferBillChooseUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    private Set getReturnValue() {
        return this.createdIntReceivedID;
    }

    protected void clearPrmtValue() {
        this.prmtTransBill.setValue(null);
    }
}

