/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.ft.RptFundTransferConstants;
import com.kingdee.eas.fm.ft.client.AbstractRptFundTransferBillDetailFilterUI;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;

public class RptFundTransferBillDetailFilterUI
extends AbstractRptFundTransferBillDetailFilterUI {
    public void onLoad() throws Exception {
        super.onLoad();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        if (this.dpStartDate.getValue() == null) {
            this.dpStartDate.setValue((Object)DateUtil.getDayBegin());
        }
    }

    protected void init() throws Exception {
        super.init();
        this.dpEndDate.setSupportedEmpty(false);
        this.dpEndDate.setValue((Object)new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.dpEndDate.getValue());
        calendar.set(5, 1);
        this.dpStartDate.setValue((Object)calendar.getTime());
        this.customInit();
        this.prmtTransCompany.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
        this.cboRelations.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum").toArray());
        this.cboRelations.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboRelations.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboUnit.setSelectedItem((Object)LoanStatisticalUnitEnum.TEN_THOUSAND);
        FMClientHelper.setCustomerFilterF7(null, (KDBizPromptBox)this.prmtCustomer, (boolean)true, null, (boolean)true);
        FinClientHelper.initFinProduct((KDBizPromptBox)this.prmtFinPro);
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    private void customInit() {
        this.initDate();
        this.initCurrency();
        this.byTransCompany.setSelected(true);
        this.prmtTransCompany.setValue(null);
        this.chkCludeZero.setSelected(false);
        this.prmtCustomer.setValue(null);
        this.cboUnit.setSelectedItem((Object)LoanStatisticalUnitEnum.TEN_THOUSAND);
        this.cboRelations.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.prmtFinPro.setValue(null);
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
    }

    @Override
    protected void cboRelations_itemStateChanged(ItemEvent e) throws Exception {
        Object obj = this.cboRelations.getSelectedItem();
        if (obj instanceof RelationshipWithLoanCompanyEnum) {
            RelationshipWithLoanCompanyEnum relations = (RelationshipWithLoanCompanyEnum)this.cboRelations.getSelectedItem();
            if (relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                this.contTransCompany.setVisible(true);
                this.contCustomer.setVisible(false);
                this.prmtCustomer.setValue(null);
                this.byTransCompany.setText(RptFundTransferConstants.REOURCE_READER.getKeyValue("transCompany"));
            } else {
                this.contCustomer.setVisible(true);
                this.contTransCompany.setVisible(false);
                this.prmtTransCompany.setValue(null);
                this.byTransCompany.setText(RptFundTransferConstants.REOURCE_READER.getKeyValue("customer"));
            }
        } else {
            this.contTransCompany.setVisible(false);
            this.contCustomer.setVisible(false);
            this.prmtTransCompany.setValue(null);
            this.prmtCustomer.setValue(null);
            this.byTransCompany.setText(RptFundTransferConstants.REOURCE_READER.getKeyValue("transCompany"));
        }
    }

    private void initDate() {
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
    }

    public Object getParam() {
        RptFundTransferDetailFilterParam filterParam = new RptFundTransferDetailFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        filterParam.setStartDate(this.dpStartDate.getSqlDate());
        filterParam.setEndDate(this.dpEndDate.getSqlDate());
        filterParam.setCurrencyInfo(this.getCurrency());
        filterParam.setCustomerIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCustomer));
        filterParam.setTransCompanyIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtTransCompany));
        filterParam.setFinProIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtFinPro));
        filterParam.setUnit((LoanStatisticalUnitEnum)this.cboUnit.getSelectedItem());
        Object relationsSelected = this.cboRelations.getSelectedItem();
        if (relationsSelected instanceof RelationshipWithLoanCompanyEnum) {
            filterParam.setRelations((RelationshipWithLoanCompanyEnum)relationsSelected);
        } else {
            filterParam.setRelations(null);
        }
        filterParam.setIncludeZero(this.chkCludeZero.isSelected());
        if (filterParam.getRelations() != null) {
            if (this.byTransCompany.isSelected()) {
                filterParam.setQueryType("byTransCompany");
            } else if (this.byCompany.isSelected()) {
                filterParam.setQueryType("byCompany");
            } else if (this.byFinPro.isSelected()) {
                filterParam.setQueryType("byFinPro");
            }
        } else if (this.byFinPro.isSelected()) {
            filterParam.setQueryType("byFinPro");
        } else if (this.byCompany.isSelected()) {
            filterParam.setQueryType("byCompany");
        } else {
            filterParam.setQueryType("byTransCompany");
        }
        return filterParam;
    }

    private CurrencyInfo getCurrency() {
        return (CurrencyInfo)this.cboCurrency.getSelectedItem();
    }

    public void setParam(Object param) {
        RptFundTransferDetailFilterParam filterParam = (RptFundTransferDetailFilterParam)((Object)param);
        if (filterParam != null) {
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            this.dpStartDate.setValue((Object)filterParam.getStartDate());
            this.dpEndDate.setValue((Object)filterParam.getEndDate());
            try {
                this.prmtTransCompany.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getTransCompanyIDs())));
                FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)filterParam.getCurrencyInfo());
                this.prmtCustomer.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getCustomerIDs())));
                this.prmtFinPro.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getFinProIDs())));
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            this.chkCludeZero.setSelected(filterParam.isIncludeZero());
            if (filterParam.getRelations() != null) {
                FMClientHelper.setSelectObject((KDComboBox)this.cboRelations, (Object)filterParam.getRelations());
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.cboRelations, (Object)FMSysDefinedEnum.ALL_ITEMS);
            }
            FMClientHelper.setSelectObject((KDComboBox)this.cboUnit, (Object)filterParam.getUnit());
            if ("byTransCompany".equals(filterParam.getQueryType())) {
                this.byTransCompany.setSelected(true);
            } else if ("byCompany".equals(filterParam.getQueryType())) {
                this.byCompany.setSelected(true);
            } else if ("byFinPro".equals(filterParam.getQueryType())) {
                this.byFinPro.setSelected(true);
            }
        }
    }

    private CurrencyInfo getCurrencyInfo(String currencyID) throws EASBizException, BOSException {
        return CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
    }

    public boolean verify() {
        super.verify();
        Date startDate = DateTimeUtils.truncateDate((Date)this.dpStartDate.getSqlDate());
        Date endDate = DateTimeUtils.truncateDate((Date)this.dpEndDate.getSqlDate());
        if (startDate.after(endDate)) {
            MsgBox.showWarning((String)RptFundTransferConstants.REOURCE_READER.getKeyValue("enddate_error"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    protected boolean isCheckCompanyNullWhenOnlyUnion() {
        return true;
    }

    protected Class getParamClass() {
        return RptFundTransferDetailFilterParam.class;
    }
}

