/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ft.client.AbstractRptFundTransferBillDetailMainUI;
import com.kingdee.eas.fm.ft.client.RptFundTransferBillDetailFilterUI;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailFilterParam;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailHandler;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailHandler_ByCompany;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailHandler_ByCustomer;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailHandler_ByFinPro;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailHandler_ByFix;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailHandler_ByTransCompany;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class RptFundTransferBillDetailMainUI
extends AbstractRptFundTransferBillDetailMainUI {
    private FMFilterBaseUI filterUI;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptFundTransferBillDetailFilterUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        this.tblMain.checkParsed();
        RptFundTransferDetailFilterParam filterParam = (RptFundTransferDetailFilterParam)this.getFilterParam();
        this.showHead(filterParam);
        int groupType = filterParam.getBizHandler();
        FMDetailRptBaseHandler handler = this.getBizHander(filterParam, groupType);
        handler.execute();
    }

    private FMDetailRptBaseHandler getBizHander(RptFundTransferDetailFilterParam filterParam, int groupType) {
        RptFundTransferDetailHandler handler = null;
        switch (groupType) {
            case 1: {
                handler = new RptFundTransferDetailHandler_ByCompany(this, filterParam.getFilter(), filterParam);
                break;
            }
            case 2: {
                handler = new RptFundTransferDetailHandler_ByFinPro(this, filterParam.getFilter(), filterParam);
                break;
            }
            case 3: {
                handler = new RptFundTransferDetailHandler_ByTransCompany(this, filterParam.getFilter(), filterParam);
                break;
            }
            case 4: {
                handler = new RptFundTransferDetailHandler_ByCustomer(this, filterParam.getFilter(), filterParam);
                break;
            }
            case 5: {
                handler = new RptFundTransferDetailHandler_ByFix(this, filterParam.getFilter(), filterParam);
                break;
            }
            default: {
                handler = new RptFundTransferDetailHandler_ByTransCompany(this, filterParam.getFilter(), filterParam);
            }
        }
        return handler;
    }

    private void showHead(RptFundTransferDetailFilterParam filterParam) {
        if (filterParam.getStartDate() == null) {
            this.txtDate.setText(DateUtil.formatDate2((Date)filterParam.getEndDate()));
        } else {
            this.txtDate.setText(DateUtil.formatDate2((Date)filterParam.getStartDate()) + " ~ " + DateUtil.formatDate2((Date)filterParam.getEndDate()));
        }
        this.cboUnit.setSelectedItem((Object)filterParam.getUnit());
        this.cboCurrency.setSelectedItem((Object)filterParam.getCurrencyInfo());
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("id").getValue();
        if (id == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        RptFundTransferDetailFilterParam filterParam = (RptFundTransferDetailFilterParam)this.getFilterParam();
        this.showHead(filterParam);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSequenceCheck.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    public static void showSequenceCheckWindow(IUIObject owner, RptFundTransferDetailFilterParam param) throws UIException {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        uiContext.put((Object)"Owner", (Object)owner);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptFundTransferBillDetailMainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.contDate.getBoundLabelText()).append("&[EndDate]&|").append(this.contCurrency.getBoundLabelText()).append("&[currency]&| ").append(this.contUnit.getBoundLabelText()).append("&[Unit]&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Unit", ((LoanStatisticalUnitEnum)this.cboUnit.getSelectedItem()).getAlias());
        map.put("EndDate", this.txtDate.getText());
        map.put("currency", ((CurrencyInfo)this.cboCurrency.getSelectedItem()).getName());
        return map;
    }
}

