/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ft.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.cl.RelationshipWithLoanCompanyEnum;
import com.kingdee.eas.fm.cl.ReturnWayEnum;
import com.kingdee.eas.fm.common.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMRptBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.ft.RptFundTransferConstants;
import com.kingdee.eas.fm.ft.client.RptFundTransferDetailFilterParam;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class RptFundTransferDetailHandler
extends FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    private static final Logger logger = CoreUIObject.getLogger(RptFundTransferDetailHandler.class);
    private static final String EXCHANGERATE = "exchangerate";
    private static final String GUARANTEE_AMT = "guaranteeAmt";
    private static final String BALANCE = "balance";
    private static final String REPAY_AMT = "repayAmt";
    private static final String DISTRIBUTE_ACCT_BANK = "distributeAcctBank";
    private static final String NUMBER = "number";
    private static final String LOAN_AMT = "loanAmt";
    private static final String BALANCE_LOCAL = "balanceLocal";
    private static final String REPAY_AMT_LOCAL = "repayAmtLocal";
    private static final String LOAN_AMT_LOCAL = "loanAmtLocal";
    private CompanyOrgUnitInfo currentCompany;
    private Date endDate;
    private Date startDate;
    private LoanStatisticalUnitEnum amountUnit;
    private String currencyID;
    private String[] transCompanyIDs;
    private String[] customerIDs;
    private String[] finProIDs;
    private String loc;
    private boolean includeZero;
    private RptFundTransferDetailFilterParam params;
    private String unit = "1";
    private String orderByColumn;
    private String orderByFromSumMainUI;
    private int precisionLocalCurrency = 2;
    private int precisionCurrency = 2;
    private String localCurrencyNumber;
    private RelationshipWithLoanCompanyEnum relations;
    private Set companyIDs;

    public RptFundTransferDetailHandler(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt) {
        super(filterInfo, sorter, kdt);
    }

    public RptFundTransferDetailHandler(FilterInfo filterInfo, KDTable kdt) {
        super(filterInfo, kdt);
    }

    public RptFundTransferDetailHandler(KDTable tblMain, FilterInfo filter) {
        super(filter, tblMain);
    }

    public RptFundTransferDetailHandler(FMRptBaseUI fmRptUI, FilterInfo filter, RptFundTransferDetailFilterParam filterParam) {
        super(filter, fmRptUI);
        this.setChloanDetailFilterParam(filterParam);
        this.prepare();
    }

    private void setLocalString() {
        this.loc = "_l2";
    }

    protected void prepare() {
        this.setLocalString();
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            this.precisionLocalCurrency = baseCurrency.getPrecision();
            this.localCurrencyNumber = baseCurrency.getNumber();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.precisionCurrency = this.params.getCurrencyInfo().getPrecision();
        this.orderByColumn = this.getOrderName();
        this.startDate = this.params.getStartDate();
        if (this.startDate != null) {
            this.startDate = new Date(DateTimeUtils.truncateDate((java.util.Date)new Date(this.startDate.getTime())).getTime());
        }
        this.endDate = this.params.getEndDate();
        if (this.endDate != null) {
            this.endDate = new Date(DateTimeUtils.truncateDate((java.util.Date)new Date(this.endDate.getTime())).getTime());
        }
        this.amountUnit = this.params.getUnit();
        this.currencyID = this.params.getCurrencyInfo().getId().toString();
        this.customerIDs = this.params.getCustomerIDs();
        this.includeZero = this.params.isIncludeZero();
        this.relations = this.params.getRelations();
        this.companyIDs = this.params.getCompanyIdSet();
        this.finProIDs = this.params.getFinProIDs();
        this.transCompanyIDs = this.params.getTransCompanyIDs();
        this.orderByFromSumMainUI = this.params.getOrderByFromSumMainUI();
        if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.THOUSAND)) {
            this.unit = "1000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.TEN_THOUSAND)) {
            this.unit = "10000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.MILLION)) {
            this.unit = "1000000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.HUNDRED_THOUSAND)) {
            this.unit = "10000000";
        } else if (this.amountUnit.equals((Object)LoanStatisticalUnitEnum.HUNDRED_MILLION)) {
            this.unit = "100000000";
        }
    }

    protected abstract String getOrderName();

    protected abstract String getStatColumn();

    public void setChloanDetailFilterParam(RptFundTransferDetailFilterParam rptChloanDetailFilterParam) {
        this.params = rptChloanDetailFilterParam;
    }

    protected String getQueryPath() {
        return "";
    }

    public void setTableStateRow() {
        int i;
        this.kdt.getColumn(this.getStatColumn()).setStat(true);
        IRow rowLongTime = this.kdt.getGroupManager().getStatRowTemplate(0);
        rowLongTime.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"38_RptFundTransferDetailHandler"));
        rowLongTime.getCell(0).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        rowLongTime.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        rowLongTime.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"38_RptFundTransferDetailHandler"));
        rowLongTime.getCell(0).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        rowLongTime.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        IRow rowLongTime0 = this.kdt.getGroupManager().getStatRowTemplate(-1);
        String[] statisColomn_initCurrency = new String[]{LOAN_AMT, REPAY_AMT, BALANCE, GUARANTEE_AMT};
        String[] statisColomn_localCurrency = new String[]{LOAN_AMT_LOCAL, REPAY_AMT_LOCAL, BALANCE_LOCAL};
        for (i = 0; i < statisColomn_initCurrency.length; ++i) {
            rowLongTime.getCell(statisColomn_initCurrency[i]).setExpressions("SUM");
            rowLongTime.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowLongTime.getCell(statisColomn_initCurrency[i]).getStyleAttributes().setBackground(new Color(0xF6F6B6));
            this.initDecimalCol(rowLongTime.getCell(statisColomn_initCurrency[i]), this.precisionCurrency);
            rowLongTime0.getCell(statisColomn_initCurrency[i]).setExpressions("SUM");
            this.initDecimalCol(rowLongTime0.getCell(statisColomn_initCurrency[i]), this.precisionCurrency);
        }
        for (i = 0; i < statisColomn_localCurrency.length; ++i) {
            rowLongTime.getCell(statisColomn_localCurrency[i]).setExpressions("SUM");
            rowLongTime.getStyleAttributes().setBackground(new Color(0xF6F6B6));
            rowLongTime.getCell(statisColomn_localCurrency[i]).getStyleAttributes().setBackground(new Color(0xF6F6B6));
            this.initDecimalCol(rowLongTime.getCell(statisColomn_localCurrency[i]), this.precisionLocalCurrency);
            rowLongTime0.getCell(statisColomn_localCurrency[i]).setExpressions("SUM");
            this.initDecimalCol(rowLongTime0.getCell(statisColomn_localCurrency[i]), this.precisionLocalCurrency);
        }
        rowLongTime0.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"39_RptFundTransferDetailHandler"));
        rowLongTime0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
    }

    private String getValues(String[] currencyIDs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < currencyIDs.length; ++i) {
            sb.append("'").append(currencyIDs[i]).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ") \n";
    }

    protected String getResString(String key) {
        return RptFundTransferConstants.REOURCE_READER.getKeyValue(key);
    }

    public void initHeader() {
        super.initHeader();
        this.initTable();
    }

    protected void initTable() {
        this.kdt.getGroupManager().setTotalize(true);
        this.initCustomHeader();
        this.initCommonColumn();
        IRow row = this.formatCommonHeadRow();
        this.formatCustomerHeadRow(row);
        IRow rowH = this.kdt.addHeadRow();
        this.kdt.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.kdt.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        this.kdt.getHeadMergeManager().mergeBlock(0, 2, 1, 2);
        this.kdt.getHeadMergeManager().mergeBlock(0, 3, 1, 3);
        this.kdt.getHeadMergeManager().mergeBlock(0, 4, 1, 4);
        this.kdt.getHeadMergeManager().mergeBlock(0, 5, 1, 5);
        rowH.getCell(LOAN_AMT).setValue((Object)this.getResString("rpt_detail_header_amt_title"));
        rowH.getCell(LOAN_AMT_LOCAL).setValue((Object)this.getResString("rpt_detail_header_localamt_title"));
        rowH.getCell(REPAY_AMT).setValue((Object)this.getResString("rpt_detail_header_amt_title"));
        rowH.getCell(REPAY_AMT_LOCAL).setValue((Object)this.getResString("rpt_detail_header_localamt_title"));
        rowH.getCell(BALANCE).setValue((Object)this.getResString("rpt_detail_header_amt_title"));
        rowH.getCell(BALANCE_LOCAL).setValue((Object)this.getResString("rpt_detail_header_localamt_title"));
        this.kdt.getHeadMergeManager().mergeBlock(0, 6, 0, 7);
        this.kdt.getHeadMergeManager().mergeBlock(0, 8, 0, 9);
        this.kdt.getHeadMergeManager().mergeBlock(0, 10, 0, 11);
        for (int i = 12; i <= 39; ++i) {
            this.kdt.getHeadMergeManager().mergeBlock(0, i, 1, i);
        }
        this.kdt.getColumn(0).setGroup(true);
        this.kdt.getColumn(1).setGroup(true);
        this.kdt.getColumn(2).setGroup(true);
        this.kdt.getColumn(0).setMergeable(true);
        this.kdt.getColumn(1).setMergeable(true);
        this.kdt.getColumn(2).setMergeable(true);
        if (this.currencyEqual()) {
            rowH.setHeight(0);
        }
    }

    public boolean currencyEqual() {
        return this.params.getCurrencyInfo().getNumber().equals(this.localCurrencyNumber);
    }

    protected void initCustomHeader() {
    }

    protected void formatCustomerHeadRow(IRow row) {
    }

    protected IRow formatCommonHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell(NUMBER).setValue((Object)this.getResString("rpt_detail_header_number"));
        headRow.getCell(DISTRIBUTE_ACCT_BANK).setValue((Object)this.getResString("rpt_detail_header_distributeAcctBank"));
        headRow.getCell(EXCHANGERATE).setValue((Object)this.getResString("rpt_detail_header_exchangerate"));
        headRow.getCell(LOAN_AMT).setValue((Object)this.getResString("rpt_detail_header_loanamt__title"));
        if (!this.currencyEqual()) {
            headRow.getCell(LOAN_AMT_LOCAL).setValue((Object)this.getResString("rpt_detail_header_loanamt__title"));
            headRow.getCell(REPAY_AMT_LOCAL).setValue((Object)this.getResString("rpt_detail_header_repayamt__title"));
            headRow.getCell(BALANCE_LOCAL).setValue((Object)this.getResString("rpt_detail_header_balanceamt__title"));
        }
        headRow.getCell(REPAY_AMT).setValue((Object)this.getResString("rpt_detail_header_repayamt__title"));
        headRow.getCell(BALANCE).setValue((Object)this.getResString("rpt_detail_header_balanceamt__title"));
        headRow.getCell("rateType").setValue((Object)this.getResString("rpt_detail_header_ratetype"));
        headRow.getCell("rateexpression").setValue((Object)this.getResString("rpt_detail_header_rateexpression"));
        headRow.getCell("yearType").setValue((Object)this.getResString("rpt_detail_header_yearrate"));
        headRow.getCell("startDate").setValue((Object)this.getResString("rpt_detail_header_startdate"));
        headRow.getCell("endDate").setValue((Object)this.getResString("rpt_detail_header_enddate"));
        headRow.getCell("repayseq").setValue((Object)this.getResString("rpt_detail_header_repayseq"));
        headRow.getCell("penatype").setValue((Object)this.getResString("rpt_detail_header_penatype"));
        headRow.getCell("penarate").setValue((Object)this.getResString("rpt_detail_header_penarate"));
        headRow.getCell("repayway").setValue((Object)this.getResString("rpt_detail_header_repayType"));
        headRow.getCell("repaydate").setValue((Object)this.getResString("rpt_detail_header_repaydate"));
        headRow.getCell("repayamt").setValue((Object)this.getResString("rpt_detail_header_repayamtFromrepay"));
        headRow.getCell("guaranteeType").setValue((Object)this.getResString("rpt_detail_header_guarteetype"));
        headRow.getCell(GUARANTEE_AMT).setValue((Object)this.getResString("rpt_detail_header_guarteeamt"));
        headRow.getCell("isHisBill").setValue((Object)this.getResString("rpt_detail_header_ishistory"));
        headRow.getCell("creatorname").setValue((Object)this.getResString("rpt_detail_header_creator"));
        headRow.getCell("project").setValue((Object)this.getResString("rpt_detail_header_project"));
        return headRow;
    }

    public void endDataFill() {
        super.endDataFill();
        this.kdt.getSelectManager().setSelectMode(2);
        this.reCalcuAndMerColumn();
        if (this.currencyEqual()) {
            this.kdt.getColumn(LOAN_AMT).getStyleAttributes().setHided(true);
            this.kdt.getColumn(REPAY_AMT).getStyleAttributes().setHided(true);
            this.kdt.getColumn(BALANCE).getStyleAttributes().setHided(true);
        }
    }

    private void reCalcuAndMerColumn() {
        BigDecimal loanAmtLocal = Constants.ZERO;
        BigDecimal repayAmtLocal = Constants.ZERO;
        BigDecimal balanceLocal = Constants.ZERO;
        BigDecimal loanAmtLocal_xiaoji = Constants.ZERO;
        BigDecimal repayAmtLocal_xiaoji = Constants.ZERO;
        BigDecimal balanceLocal_xiaoji = Constants.ZERO;
        BigDecimal loanAmt = Constants.ZERO;
        BigDecimal repayAmt = Constants.ZERO;
        BigDecimal balance = Constants.ZERO;
        BigDecimal loanAmt_xiaoji = Constants.ZERO;
        BigDecimal repayAmt_xiaoji = Constants.ZERO;
        BigDecimal balance_xiaoji = Constants.ZERO;
        BigDecimal guaranteeAmt = Constants.ZERO;
        BigDecimal guaranteeAmt_xiaoji = Constants.ZERO;
        HashSet<String> idSet = new HashSet<String>();
        HashMap index2id = new HashMap();
        String idCompareLast = "";
        int size = this.kdt.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdt.getRow(i);
            if (row.getCell("id").getValue() != null) {
                String id = row.getCell("id").getValue().toString();
                if (!idSet.contains(id)) {
                    if (row.getCell(LOAN_AMT_LOCAL).getValue() != null) {
                        loanAmtLocal = loanAmtLocal.add((BigDecimal)row.getCell(LOAN_AMT_LOCAL).getValue());
                        repayAmtLocal = repayAmtLocal.add((BigDecimal)row.getCell(REPAY_AMT_LOCAL).getValue());
                        balanceLocal = balanceLocal.add((BigDecimal)row.getCell(BALANCE_LOCAL).getValue());
                        loanAmt = loanAmt.add((BigDecimal)row.getCell(LOAN_AMT).getValue());
                        repayAmt = repayAmt.add((BigDecimal)row.getCell(REPAY_AMT).getValue());
                        balance = balance.add((BigDecimal)row.getCell(BALANCE).getValue());
                        guaranteeAmt = guaranteeAmt.add(row.getCell(GUARANTEE_AMT).getValue() == null ? BigDecimal.ZERO : (BigDecimal)row.getCell(GUARANTEE_AMT).getValue());
                        loanAmtLocal_xiaoji = loanAmtLocal_xiaoji.add((BigDecimal)row.getCell(LOAN_AMT_LOCAL).getValue());
                        repayAmtLocal_xiaoji = repayAmtLocal_xiaoji.add((BigDecimal)row.getCell(REPAY_AMT_LOCAL).getValue());
                        balanceLocal_xiaoji = balanceLocal_xiaoji.add((BigDecimal)row.getCell(BALANCE_LOCAL).getValue());
                        loanAmt_xiaoji = loanAmt_xiaoji.add((BigDecimal)row.getCell(LOAN_AMT).getValue());
                        repayAmt_xiaoji = repayAmt_xiaoji.add((BigDecimal)row.getCell(REPAY_AMT).getValue());
                        balance_xiaoji = balance_xiaoji.add((BigDecimal)row.getCell(BALANCE).getValue());
                        guaranteeAmt_xiaoji = guaranteeAmt_xiaoji.add(row.getCell(GUARANTEE_AMT).getValue() == null ? BigDecimal.ZERO : (BigDecimal)row.getCell(GUARANTEE_AMT).getValue());
                    }
                    idSet.add(id);
                }
                if (idCompareLast.equals(id)) {
                    ((Set)index2id.get(idCompareLast)).add(new Integer(i));
                    if (i == 0) continue;
                    ((Set)index2id.get(idCompareLast)).add(new Integer(i - 1));
                    continue;
                }
                idCompareLast = id;
                HashSet tobeMerList = new HashSet();
                index2id.put(idCompareLast, tobeMerList);
                continue;
            }
            row.getCell(LOAN_AMT_LOCAL).setValue((Object)loanAmtLocal_xiaoji);
            row.getCell(REPAY_AMT_LOCAL).setValue((Object)repayAmtLocal_xiaoji);
            row.getCell(BALANCE_LOCAL).setValue((Object)balanceLocal_xiaoji);
            if (!this.currencyEqual()) {
                row.getCell(LOAN_AMT).setValue((Object)loanAmt_xiaoji);
                row.getCell(REPAY_AMT).setValue((Object)repayAmt_xiaoji);
                row.getCell(BALANCE).setValue((Object)balance_xiaoji);
            }
            row.getCell(GUARANTEE_AMT).setValue((Object)guaranteeAmt_xiaoji);
            loanAmtLocal_xiaoji = Constants.ZERO;
            repayAmtLocal_xiaoji = Constants.ZERO;
            balanceLocal_xiaoji = Constants.ZERO;
            guaranteeAmt_xiaoji = Constants.ZERO;
            loanAmt_xiaoji = Constants.ZERO;
            repayAmt_xiaoji = Constants.ZERO;
            balance_xiaoji = Constants.ZERO;
        }
        IRow row = this.kdt.getRow(this.kdt.getRowCount() - 1);
        if (row != null) {
            row.getCell(LOAN_AMT_LOCAL).setValue((Object)loanAmtLocal);
            row.getCell(REPAY_AMT_LOCAL).setValue((Object)repayAmtLocal);
            row.getCell(BALANCE_LOCAL).setValue((Object)balanceLocal);
            if (!this.currencyEqual()) {
                row.getCell(LOAN_AMT).setValue((Object)loanAmt);
                row.getCell(REPAY_AMT).setValue((Object)repayAmt);
                row.getCell(BALANCE).setValue((Object)balance);
            }
            row.getCell(GUARANTEE_AMT).setValue((Object)guaranteeAmt);
        }
        Iterator it = index2id.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Set setMer = (Set)index2id.get(key);
            if (setMer == null || setMer.size() <= 0) continue;
            Object[] merIndex = setMer.toArray(new Integer[setMer.size()]);
            Arrays.sort(merIndex);
            for (int i = 1; i < merIndex.length; ++i) {
                Object bottom = merIndex[i];
                for (int j = 1; j < 25; ++j) {
                    this.kdt.getMergeManager().mergeBlock(((Integer)merIndex[0]).intValue(), j, ((Integer)bottom).intValue(), j);
                }
            }
        }
    }

    private String getCommonFilterToLoan() {
        StringBuffer sb = new StringBuffer();
        this.commonBegin(sb);
        this.commonConditions(sb);
        this.commonEnd(sb);
        return sb.toString();
    }

    private void commonConditions(StringBuffer sb) {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            sb.append("\tand chloan.fcompanyid = '").append(this.currentCompany.getId().toString()).append("' ");
        } else if (this.companyIDs != null && this.companyIDs.size() != 0) {
            sb.append(" and chloan.fcompanyid in ").append(this.getValues(this.companyIDs.toArray(new String[this.companyIDs.size()])));
        } else {
            sb.append(" and chloan.fcompanyid in ('') ");
        }
        if (this.currencyID != null && this.currencyID.trim().length() > 0) {
            sb.append(" and chloan.fcurrencyid = '").append(this.currencyID).append("' ");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.endDate != null) {
            String strEndDate = sdf.format(this.endDate);
            sb.append("and chloan.FEffectiveDate <={").append(strEndDate).append("} ");
        }
        if (this.startDate != null) {
            String strStartDate = sdf.format(this.startDate);
            sb.append("and chloan.FEffectiveDate >={").append(strStartDate).append("} ");
        }
        if (this.finProIDs != null) {
            sb.append(" and chloan.ffinacingproductid in ").append(this.getValues(this.finProIDs));
        }
        if (this.relations instanceof RelationshipWithLoanCompanyEnum) {
            if (this.relations == RelationshipWithLoanCompanyEnum.INTERIOR) {
                if (this.transCompanyIDs != null && this.transCompanyIDs.length > 0) {
                    sb.append(" and chloan.FTransCompanyID in ").append(this.getValues(this.transCompanyIDs));
                }
                sb.append(" and chloan.fcustomerid is null \n");
            } else {
                if (this.customerIDs != null && this.customerIDs.length > 0) {
                    sb.append(" and chloan.FCustomerID in ").append(this.getValues(this.customerIDs));
                }
                sb.append(" and chloan.FTransCompanyID is null \n");
            }
        }
    }

    private void commonEnd(StringBuffer sb) {
        sb.append(")");
    }

    private void commonBegin(StringBuffer sb) {
        sb.append("( chloan.FStatus <>0 \n");
    }

    protected void initCommonColumn() {
        String[] columnKeys = new String[]{NUMBER, DISTRIBUTE_ACCT_BANK, EXCHANGERATE, LOAN_AMT, LOAN_AMT_LOCAL, REPAY_AMT, REPAY_AMT_LOCAL, BALANCE, BALANCE_LOCAL, "startDate", "endDate", "rateType", "rateexpression", "yearType", "penatype", "penarate", "repayway", "guaranteeType", GUARANTEE_AMT, "project", "isHisBill", "creatorname", "repayseq", "repaydate", "repayamt", "id", "currencyprecision", "relations"};
        String[] hideColKeys = new String[]{"id", "currencyprecision", "relations"};
        HashSet<String> hideColSet = new HashSet<String>(Arrays.asList(hideColKeys));
        for (int i = 0; i < columnKeys.length; ++i) {
            IColumn col = this.kdt.addColumn();
            col.setKey(columnKeys[i]);
            if (!hideColSet.contains(columnKeys[i])) continue;
            col.getStyleAttributes().setHided(true);
        }
    }

    protected void setContentToCommonColumn(IRow row, IRowSet rs) throws SQLException {
        row.getCell("currencyprecision").setValue(rs.getObject("fcurrencyprecision"));
        int precision = Integer.parseInt(row.getCell("currencyprecision").getValue().toString());
        row.getCell(NUMBER).setValue(rs.getObject("fnumber"));
        row.getCell(DISTRIBUTE_ACCT_BANK).setValue(rs.getObject("FDistributeAcctBank"));
        row.getCell(EXCHANGERATE).setValue(rs.getObject(EXCHANGERATE));
        this.initDecimalCol(row.getCell(EXCHANGERATE), "%r{#,##0.0000}f");
        row.getCell(LOAN_AMT).setValue(rs.getObject("loanamttotal"));
        this.initDecimalCol(row.getCell(LOAN_AMT), precision);
        row.getCell(LOAN_AMT_LOCAL).setValue(rs.getObject("loanamtlocal"));
        this.initDecimalCol(row.getCell(LOAN_AMT_LOCAL), this.precisionLocalCurrency);
        row.getCell(REPAY_AMT).setValue(rs.getObject("repaytotalamt"));
        this.initDecimalCol(row.getCell(REPAY_AMT), precision);
        row.getCell(REPAY_AMT_LOCAL).setValue(rs.getObject("repaytotalamtlocal"));
        this.initDecimalCol(row.getCell(REPAY_AMT_LOCAL), this.precisionLocalCurrency);
        row.getCell(BALANCE).setValue(rs.getObject(BALANCE));
        this.initDecimalCol(row.getCell(BALANCE), precision);
        row.getCell(BALANCE_LOCAL).setValue(rs.getObject("balancelocal"));
        this.initDecimalCol(row.getCell(BALANCE_LOCAL), this.precisionLocalCurrency);
        row.getCell("rateType").setValue(rs.getObject("ratetypename"));
        row.getCell("rateexpression").setValue(rs.getObject("intratetypeexpression"));
        row.getCell("yearType").setValue(rs.getObject("yearrate"));
        String exp = row.getCell("rateexpression").getValue().toString();
        if (exp.equals(IntRateTypeExpressionEnum.YEAR.getAlias())) {
            row.getCell("yearType").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
        } else {
            row.getCell("yearType").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
        }
        row.getCell("yearType").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("startDate").setValue((Object)rs.getDate("startdate"));
        row.getCell("endDate").setValue((Object)rs.getDate("enddate"));
        row.getCell("id").setValue(rs.getObject("fid"));
        PenAccrualTypeEnum penatype = null;
        if (rs.getObject("FPenAccrualType") != null) {
            penatype = PenAccrualTypeEnum.getEnum((String)rs.getObject("FPenAccrualType").toString());
        }
        row.getCell("penatype").setValue(penatype);
        row.getCell("penarate").setValue(rs.getObject("FPenaRate"));
        if (penatype != null) {
            if (penatype == PenAccrualTypeEnum.ADD_PERCENT) {
                row.getCell("penarate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
            } else {
                row.getCell("penarate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
            }
        }
        row.getCell("penarate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        ReturnWayEnum returnway = null;
        if (rs.getObject("FReturnWay") != null) {
            returnway = ReturnWayEnum.getEnum((String)rs.getObject("FReturnWay").toString());
        }
        row.getCell("repayway").setValue(returnway);
        if (rs.getInt("repaySeq") == 9999) {
            row.getCell("repayseq").setValue(null);
            row.getCell("repaydate").setValue(null);
            row.getCell("repayamt").setValue(null);
        } else {
            row.getCell("repayseq").setValue(rs.getObject("repaySeq"));
            row.getCell("repaydate").setValue((Object)rs.getDate("repaydate"));
            row.getCell("repayamt").setValue(rs.getObject("repayamt"));
            this.initDecimalCol(row.getCell("repayamt"), this.precisionCurrency);
        }
        row.getCell("guaranteeType").setValue(rs.getObject("guaranteeTypeName"));
        row.getCell(GUARANTEE_AMT).setValue(rs.getObject("FGuaranteeAmt"));
        this.initDecimalCol(row.getCell(GUARANTEE_AMT), this.precisionCurrency);
        row.getCell("isHisBill").setValue((Object)rs.getBoolean("isHisBill"));
        row.getCell("creatorname").setValue(rs.getObject("creatorname"));
        row.getCell("project").setValue(rs.getObject("projectname"));
    }

    private void initDecimalCol(ICell cell, int precision) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    private void initDecimalCol(ICell cell, String format) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(format);
    }

    public IRowSet getRowSet() throws BOSException {
        String sql = this.getDetailSQLExt();
        return SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
    }

    private String getDetailSQLExt() {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" select * from \n");
        sbSQL.append(" (  \n");
        sbSQL.append(this.getLoanWithRepayDetail("detailtbl1"));
        sbSQL.append(" )  \n");
        sbSQL.append(" as t  \n");
        if (!this.includeZero) {
            sbSQL.append("  where balance>0 order by ").append(this.orderByColumn).append(" ,fnumber,repaySeq");
        } else {
            sbSQL.append("   order by ").append(this.orderByColumn).append(" ,fnumber,repaySeq");
        }
        logger.info((Object)sbSQL.toString());
        return sbSQL.toString();
    }

    private StringBuffer getLoanWithInterestDetail(String tableAlias) {
        StringBuffer getLoanWithInterestDetail = new StringBuffer(1024);
        getLoanWithInterestDetail.append(" select " + tableAlias + ".*, (loanamttotal-repaytotalamt) as balance,\n");
        getLoanWithInterestDetail.append("             (loanAmtLocal-repaytotalamtLocal) as balanceLocal from \n");
        getLoanWithInterestDetail.append("   ( \n");
        this.getCommonSelector(getLoanWithInterestDetail);
        getLoanWithInterestDetail.append(" null  as repaySeq,\n");
        getLoanWithInterestDetail.append(" null as repayDate,\n");
        getLoanWithInterestDetail.append(" null as repayamt \n");
        getLoanWithInterestDetail.append(" from T_FT_FundTransferBill chloan \n");
        this.getCommonLeftJoin(getLoanWithInterestDetail);
        getLoanWithInterestDetail.append(" left outer join  T_FT_FundTransferRepayBill repay on  chloan.fid =    repay.FLoanID   \n");
        getLoanWithInterestDetail.append(" left outer join T_FT_FundTransferInterestBill as intbill on repay.fid = intbill.FTransBillID \n");
        getLoanWithInterestDetail.append("    where ( " + this.getCommonFilterToLoanWithInterest() + " )  ) as " + tableAlias + " \n");
        return getLoanWithInterestDetail;
    }

    private StringBuffer getCommonFilterToLoanWithInterest() {
        StringBuffer sb = new StringBuffer();
        this.commonBegin(sb);
        this.commonConditions(sb);
        this.WithInterestCondition(sb);
        this.commonEnd(sb);
        return sb;
    }

    private void WithInterestCondition(StringBuffer sb) {
        sb.append(" and intbill.FTransRepayID is null ");
    }

    private StringBuffer getLoanWithRepayDetail(String tableAlias) {
        StringBuffer sbWithRepay = new StringBuffer(1024);
        sbWithRepay.append(" select " + tableAlias + ".*, (loanamttotal-balance) as repaytotalamt, \n");
        sbWithRepay.append(" (loanAmtLocal-balanceLocal) as repaytotalamtLocal from  \n");
        sbWithRepay.append("   ( ");
        this.getCommonSelector(sbWithRepay);
        sbWithRepay.append(" repay.FRepaySeq as repaySeq, \n");
        sbWithRepay.append(" repay.FRepayDate as repayDate,    \n");
        sbWithRepay.append(" repay.FRepayAmt/").append(this.unit).append(" as repayamt \n");
        sbWithRepay.append(" from T_FT_FundTransferBill chloan \n");
        this.getCommonLeftJoin(sbWithRepay);
        sbWithRepay.append(" left outer join  T_FT_FundTransferRepayBill repay on  chloan.fid =    repay.FLoanID   \n");
        sbWithRepay.append(" left outer join T_FT_FundTransferInterestBill as intbill on repay.fid = intbill.FTransRepayID \n");
        sbWithRepay.append("    where ( " + this.getCommonFilterToLoanWithRepay() + " ) ) as " + tableAlias + "\n");
        return sbWithRepay;
    }

    private String getCommonFilterToLoanWithRepay() {
        return this.getCommonFilterToLoan();
    }

    private void getCommonLeftJoin(StringBuffer sbWithRepay) {
        sbWithRepay.append(" left outer join  t_org_company com on com.fid = chloan.fcompanyid \n");
        sbWithRepay.append(" left outer join  t_bd_customer customer on customer.fid = chloan.fcustomerid  \n");
        sbWithRepay.append(" left outer join  t_bd_currency cur on cur.fid = chloan.fcurrencyid \n");
        sbWithRepay.append(" left outer join  t_fin_financingproducts finpro on finpro.fid = chloan.ffinacingproductid \n");
        sbWithRepay.append(" left outer join  t_int_intratetype ratetype on ratetype.fid = chloan.fratetypeid \n");
        sbWithRepay.append(" left outer join  T_BD_AccountBanks accountBanks on accountBanks.fid = chloan.FDistributeAcctBankID \n");
        sbWithRepay.append(" left outer join  T_FIN_GuaranteeType guaranteeType on guaranteeType.fid = chloan.FGuaranteeTypeID \n");
        sbWithRepay.append(" left outer join t_pm_user as creator on chloan.fcreatorid = creator.fid \n");
        sbWithRepay.append(" left outer join  t_org_company as transCom on transCom.fid = chloan.FTransCompanyID \n");
        sbWithRepay.append(" left outer join  T_BD_Project as project on project.fid = chloan.FProjectID \n");
    }

    private void getCommonSelector(StringBuffer sbWithRepay) {
        sbWithRepay.append("     select cur.fprecision as fcurrencyprecision,chloan.FFinacingProductID as ffinacingproductid,chloan.fcurrencyid as fcurrencyid, \n");
        sbWithRepay.append("          chloan.FTransCompanyID as FTransCompanyID,  chloan.FCompanyID as FCompanyID, accountBanks.FBankAccountNumber as FDistributeAcctBank, \n");
        sbWithRepay.append("   chloan.FCustomerID as FCustomerID,isnull(fratetypeid,'10001') as fratetypeid,\n");
        sbWithRepay.append("          finpro.fname").append(this.loc).append(" as finproName,cur.fname").append(this.loc).append(" as fcurrencyName, project.fname").append(this.loc).append(" as projectName, \n");
        sbWithRepay.append("          transCom.fname").append(this.loc).append(" as transCompanyName, com.fname").append(this.loc).append(" as CompanyName, chloan.FRelationWithCmp as relations,   \n");
        sbWithRepay.append("          customer.fname").append(this.loc).append(" as customername, isnull(rateType.Fname").append(this.loc).append(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"40_RptFundTransferDetailHandler"));
        sbWithRepay.append("          chloan.fnumber as fnumber, chloan.fid as fid, \n");
        sbWithRepay.append(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"41_RptFundTransferDetailHandler"));
        sbWithRepay.append(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"42_RptFundTransferDetailHandler"));
        sbWithRepay.append("               end \n");
        sbWithRepay.append("          ) as fhorizon, \n");
        sbWithRepay.append("     (case when chloan.fhorizon<=12 or fhorizon is null then '[shorthorizon]' \n");
        sbWithRepay.append("           else '[longhorizon]' \n");
        sbWithRepay.append("           end \n");
        sbWithRepay.append("      ) as fhorizonStr, \n");
        sbWithRepay.append("      chloan.FEffectiveDate as startdate,chloan.FMaturityDate as enddate, \n");
        sbWithRepay.append("       chloan.fdescription as diggest, \n");
        sbWithRepay.append("     chloan.FLoanAmt/").append(this.unit).append(" as loanamttotal, \n");
        sbWithRepay.append("     chloan.FLoanBalanceAmt/").append(this.unit).append(" as balance, \n");
        sbWithRepay.append("       chloan.FLoanAmt*chloan.fexchangerate/").append(this.unit).append(" as loanAmtLocal, \n");
        sbWithRepay.append("       chloan.FLoanBalanceAmt*chloan.fexchangerate/").append(this.unit).append(" as balanceLocal, \n");
        sbWithRepay.append("        chloan.fexchangerate as exchangerate, \n");
        sbWithRepay.append("        (case chloan.FIntRateExpression \n");
        sbWithRepay.append(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"43_RptFundTransferDetailHandler"));
        sbWithRepay.append(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"44_RptFundTransferDetailHandler"));
        sbWithRepay.append(EASResource.getString((String)"com.kingdee.eas.fm.ft.FTAutoGenerateResource", (String)"45_RptFundTransferDetailHandler"));
        sbWithRepay.append("        \t\t\t end  \n");
        sbWithRepay.append("        \t)  as  intratetypeexpression ,  chloan.FRate as  yearrate, \n");
        sbWithRepay.append("   chloan.FPenAccrualType as FPenAccrualType,  chloan.FPenaRate as FPenaRate,  \n");
        sbWithRepay.append("  chloan.FReturnWay  as  FReturnWay, \n");
        sbWithRepay.append("   isnull(chloan.ftranscompanyid,chloan.fcustomerid) as fixid, \n");
        sbWithRepay.append("   isnull(transCom.fname").append(this.loc).append(" ,customer.fname").append(this.loc).append(" ) as fixname, \n");
        sbWithRepay.append(" intbill.FIntCalType as type,  \n");
        sbWithRepay.append(" intbill.Fnumber as intnumber, \n");
        sbWithRepay.append(" intbill.FStartDate as intstartdate,  \n");
        sbWithRepay.append(" intbill.FendDate as intenddate,\n");
        sbWithRepay.append(" intbill.FIntervalDays as intdays, \n");
        sbWithRepay.append(" intbill.FAmount/").append(this.unit).append(" as intamt, \n");
        sbWithRepay.append(" intbill.FYingjiIntAmt/").append(this.unit).append(" as yingjiamt,\n");
        sbWithRepay.append(" intbill.FShijiIntAmt/").append(this.unit).append(" as shijiamt, \n");
        sbWithRepay.append(" intbill.FYingjiPenaAmt/").append(this.unit).append(" as yingjipenaamt, \n");
        sbWithRepay.append(" intbill.FShijiPenaAmt/").append(this.unit).append(" as shijipenaamt, \n");
        sbWithRepay.append(" guaranteeType.fname_l2 as guaranteeTypeName, \n");
        sbWithRepay.append(" chloan.FGuaranteeAmt/").append(this.unit).append(" as FGuaranteeAmt,    \n");
        sbWithRepay.append(" chloan.FIsHistoryBill as isHisBill,  \n");
        sbWithRepay.append(" creator.fname_l2 as creatorname, \n");
    }
}

