/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowItemCollection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.client.FundFlowItemPromptBox;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.fm.liquid.LiquidBaseHelper;
import com.kingdee.eas.fm.liquid.client.AbstractJournalFlowItemsFilterUI;
import com.kingdee.eas.fm.liquid.client.JournalFlowItemsParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class JournalFlowItemsFilterUI
extends AbstractJournalFlowItemsFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(JournalFlowItemsFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public String getPermissionItem() {
        return "JournalFlowItem_query";
    }

    public void setCompany() throws EASBizException, BOSException {
        this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)"JournalFlowItem_query");
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo info = coll.get(i);
            if (!this.currentCompany.getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public void init() throws Exception {
        super.init();
        this.setCompany();
        this.prmtCompany.setEnabledMultiSelection(false);
        if (!LiquidBaseHelper.isCompanyUnion(this.currentCompany)) {
            this.prmtCompany.setValue((Object)this.currentCompany);
        }
        this.prmtFlowItems.setQueryInfo("com.kingdee.eas.fi.cas.F7FundFlowItemQuery");
        FundFlowItemPromptBox selectorFundFlowItem = new FundFlowItemPromptBox((IUIObject)this, null);
        selectorFundFlowItem.setMultiSelect(true);
        this.prmtFlowItems.setSelector((KDPromptSelector)selectorFundFlowItem);
        this.prmtFlowItems.setEnabledMultiSelection(true);
        this.prmtFlowItems.setEditFormat("$number$");
        this.prmtFlowItems.setDisplayFormat("$name$");
        this.prmtFlowItems.setCommitFormat("$number$;$name$");
        this.pkDateFrom.setValue((Object)DateUtil.getDayBegin());
        this.pkDateTo.setValue((Object)DateUtil.getDayEnd());
        this.pkDateFrom.setValue((Object)DateUtil.getDayBegin());
        this.pkDateTo.setValue((Object)DateUtil.getDayEnd());
        this.txtAmountFrom.setSupportedEmpty(true);
        this.txtAmountFrom.setNegatived(true);
        this.txtAmountFrom.setPrecision(2);
        this.txtAmountFrom.setRemoveingZeroInDispaly(false);
        this.txtAmountFrom.setMaximumValue((Comparable)new BigDecimal("10000000000000"));
        this.txtAmountFrom.setMinimumValue((Comparable)new BigDecimal("-10000000000000"));
        this.txtAmountFrom.setHorizontalAlignment(4);
        this.txtAmountTo.setSupportedEmpty(true);
        this.txtAmountTo.setNegatived(true);
        this.txtAmountTo.setPrecision(2);
        this.txtAmountTo.setRemoveingZeroInDispaly(false);
        this.txtAmountTo.setMaximumValue((Comparable)new BigDecimal("10000000000000"));
        this.txtAmountTo.setMinimumValue((Comparable)new BigDecimal("-10000000000000"));
        this.txtAmountTo.setHorizontalAlignment(4);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        try {
            this.setCompany();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getParam() {
        JournalFlowItemsParam param = new JournalFlowItemsParam();
        if (!FMHelper.isEmpty((Object)this.prmtCompany.getValue())) {
            String companyId = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
            param.setCompanyid(companyId);
        }
        param.setDateFrom((Date)this.pkDateFrom.getValue());
        param.setDateTo((Date)this.pkDateTo.getValue());
        if (!FMHelper.isEmpty((Object)this.prmtAccountBank.getValue())) {
            Set accountIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtAccountBank));
            param.setAccountIdSet(accountIdSet);
        }
        if (!FMHelper.isEmpty((Object)this.prmtCurrency.getValue())) {
            Set currencyIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency));
            param.setCurrencyIdSet(currencyIdSet);
        }
        if (!FMHelper.isEmpty((Object)this.prmtFlowItems.getValue())) {
            Set flowItemsIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtFlowItems));
            param.setFlowItemsIdSet(flowItemsIdSet);
        }
        if (!FMHelper.isEmpty((Object)this.txtAmountFrom)) {
            param.setAmountFrom(this.txtAmountFrom.getBigDecimalValue());
        }
        if (!FMHelper.isEmpty((Object)this.txtAmountTo)) {
            param.setAmountTo(this.txtAmountTo.getBigDecimalValue());
        }
        return param;
    }

    public void setParam(Object param) {
        CoreBaseInfo[] c;
        JournalFlowItemsParam para = (JournalFlowItemsParam)param;
        if (para == null) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = FMClientHelper.getCompany((String)para.getCompanyid());
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        this.prmtCompany.setValue((Object)companyInfo);
        this.pkDateFrom.setValue((Object)para.getDateFrom());
        this.pkDateTo.setValue((Object)para.getDateTo());
        if (!FMHelper.isEmpty((Collection)para.getAccountIdSet())) {
            c = null;
            try {
                c = RptFmClientUtil.getBaseInfoFromIdSet((Set)para.getAccountIdSet());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.prmtAccountBank.setData((Object)c);
        }
        if (!FMHelper.isEmpty((Collection)para.getCurrencyIdSet())) {
            c = null;
            try {
                c = RptFmClientUtil.getBaseInfoFromIdSet((Set)para.getCurrencyIdSet());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.prmtCurrency.setData((Object)c);
        }
        if (!FMHelper.isEmpty((Collection)para.getFlowItemsIdSet())) {
            c = null;
            try {
                c = RptFmClientUtil.getBaseInfoFromIdSet((Set)para.getFlowItemsIdSet());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.prmtFlowItems.setData((Object)c);
        }
        if (!FMHelper.isEmpty((Object)para.getAmountFrom())) {
            this.txtAmountFrom.setValue((Object)para.getAmountFrom());
        }
        if (!FMHelper.isEmpty((Object)para.getAmountTo())) {
            this.txtAmountTo.setValue((Object)para.getAmountTo());
        }
    }

    protected Class getParamClass() {
        return JournalFlowItemsParam.class;
    }

    @Override
    protected void prmtAccountBank_willShow(SelectorEvent e) throws Exception {
        String companyid;
        super.prmtAccountBank_willShow(e);
        FilterInfo filter = new FilterInfo();
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyIsNull"));
            SysUtil.abort();
        }
        if (this.prmtCompany.getValue() != null && (companyid = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtAccountBank.setEntityViewInfo(evi);
        this.prmtAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    public boolean verify() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"companyNotNull"));
            SysUtil.abort();
        }
        Date startDate = (Date)this.pkDateFrom.getValue();
        Date endDate = (Date)this.pkDateTo.getValue();
        if (startDate != null && endDate != null) {
            if (startDate.after(endDate)) {
                MsgBox.showWarning(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"dateVerify"));
                SysUtil.abort();
            }
            GregorianCalendar grc = new GregorianCalendar();
            grc.setTime(startDate);
            grc.add(2, 3);
            Date afterThreeMonth = grc.getTime();
            if (endDate.after(afterThreeMonth)) {
                MsgBox.showWarning(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"lessThanThreeMonth"));
                SysUtil.abort();
            }
        }
        BigDecimal amountFrom = this.txtAmountFrom.getBigDecimalValue();
        BigDecimal amountTo = this.txtAmountTo.getBigDecimalValue();
        if (amountFrom != null && amountTo != null && amountFrom.compareTo(amountTo) > 0) {
            MsgBox.showWarning(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.liquid.LiquidResource", (String)"amountVerify"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
        if (e.getNewValue() != null && e.getOldValue() != null && !e.getNewValue().equals(e.getOldValue()) || e.getOldValue() == null && e.getNewValue() != null || e.getNewValue() == null) {
            this.prmtAccountBank.setValue(null);
        }
    }

    @Override
    protected void prmtFlowItems_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtFlowItems.getData() != null && AccessHelper.getF7Ids((KDBizPromptBox)this.prmtFlowItems) != null && AccessHelper.getF7Ids((KDBizPromptBox)this.prmtFlowItems).length > 0) {
            Set flowItemsIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtFlowItems));
            Set<String> allIdSet = this.getWithAllChildren(flowItemsIdSet);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", allIdSet, CompareType.INCLUDE));
            FundFlowItemCollection datas = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(viewInfo);
            if (datas != null && datas.size() > 0) {
                CoreBaseInfo[] infoArray = new CoreBaseInfo[datas.size()];
                for (int i = 0; i < datas.size(); ++i) {
                    infoArray[i] = datas.get(i);
                }
                EventListener[] listeners = this.prmtFlowItems.getListeners(DataChangeListener.class);
                DataChangeListener dcl = (DataChangeListener)listeners[0];
                this.prmtFlowItems.removeDataChangeListener(dcl);
                this.prmtFlowItems.setData((Object)infoArray);
                this.prmtFlowItems.addDataChangeListener(dcl);
            }
        }
    }

    protected Set<String> getWithAllChildren(Set<String> selectIdSet) {
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", selectIdSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        view.setFilter(filter);
        view.setSelector(selector);
        try {
            TreeBaseCollection resultColl = FundFlowItemFactory.getRemoteInstance().getTreeBaseCollection(view);
            TreeBaseInfo info = null;
            for (int i = 0; i < resultColl.size(); ++i) {
                info = resultColl.get(i);
                idSet.add(info.getId().toString());
                if (info.isIsLeaf()) continue;
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter(new FilterInfo());
                ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
                TreeBaseCollection col = FundFlowItemFactory.getRemoteInstance().getTreeBaseCollection(ev);
                for (int j = 0; j < col.size(); ++j) {
                    idSet.add(col.get(j).getId().toString());
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return idSet;
    }
}

