/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common.schedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RefreshDCContextListJob
implements Job {
    private static Logger logger = Logger.getLogger(RefreshDCContextListJob.class);

    public void execute(JobExecutionContext jobExecCtx) throws JobExecutionException {
        logger.info((Object)"eas_fm---RefreshDCContextListJob trigger begin.");
        try {
            ArrayList newDCList = DCManager.getInstance().getDCList();
            Vector oldDCContextList = (Vector)this.getDataMap(jobExecCtx).get((Object)"DC_CONTEXT_LIST_KEY");
            this.refreshContextList(newDCList, oldDCContextList);
        }
        catch (Exception e) {
            logger.error((Object)"eas.fm---RefreshDCContextListJob error!", (Throwable)e);
        }
    }

    private JobDataMap getDataMap(JobExecutionContext jobExecCtx) {
        return jobExecCtx.getJobDetail().getJobDataMap();
    }

    private void refreshContextList(List<DCInfo> newDCList, Vector<Context> oldDCContextList) throws BOSException {
        this.addContext(newDCList, oldDCContextList);
        this.removeContext(newDCList, oldDCContextList);
    }

    private void addContext(List<DCInfo> newDCList, Vector<Context> oldDCContextList) throws BOSException {
        for (DCInfo dcInfo : newDCList) {
            if (this.isFound(oldDCContextList, dcInfo)) continue;
            Context ctx = this.createContext(dcInfo);
            oldDCContextList.add(ctx);
        }
    }

    private void removeContext(List<DCInfo> newDCList, Vector<Context> oldDCContextList) {
        Iterator<Context> it = oldDCContextList.iterator();
        while (it.hasNext()) {
            Context context = it.next();
            if (this.isFound(newDCList, context)) continue;
            it.remove();
        }
    }

    private boolean isFound(Vector<Context> dcContextList, DCInfo dcInfo) {
        for (Context context : dcContextList) {
            if (!dcInfo.getNumber().equals(context.getAIS())) continue;
            return true;
        }
        return false;
    }

    private boolean isFound(List<DCInfo> dcList, Context context) {
        for (DCInfo dcInfo : dcList) {
            if (!context.getAIS().equals(dcInfo.getNumber())) continue;
            return true;
        }
        return false;
    }

    private Context createContext(DCInfo dcInfo) {
        Context ctx = new Context(null, dcInfo.getSolutionName(), dcInfo.getNumber(), null);
        ctx.setUserName(dcInfo.getUserName());
        ctx.put((Object)"dbType", (Object)this.getDBType(dcInfo.getDBType()));
        return ctx;
    }

    private String getDBType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2";
            }
            case 2: {
                return "Oracle";
            }
        }
        return "NONE";
    }
}

