/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import com.kingdee.eas.fm.mobile.util.AccountCurrencyComponentParseException;
import org.apache.log4j.Logger;

public class AccountCurrencyComponentUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.mobile.util.AccountCurrencyComponentUtil");
    public static final String ACCOUNT_CURRENCY_ID_SPLITOR = "$ACCOUNT_CURRENCY_ID_SPLITOR$";
    private static final String ACCOUNT_CURRENCY_ID_SPLITOR_REGEX = "\\$ACCOUNT_CURRENCY_ID_SPLITOR\\$";
    private String accountCurrencyComponentID;
    private String accountID;
    private String currencyID;
    private boolean isRight;

    public AccountCurrencyComponentUtil(String accountCurrencyComponentID) {
        this.accountCurrencyComponentID = accountCurrencyComponentID;
        try {
            this.parseAccountCurrencyComponentID(accountCurrencyComponentID);
            this.isRight = true;
        }
        catch (AccountCurrencyComponentParseException e) {
            this.isRight = false;
        }
    }

    private void parseAccountCurrencyComponentID(String accountCurrencyComponentID) throws AccountCurrencyComponentParseException {
        String[] split;
        if (accountCurrencyComponentID.contains(ACCOUNT_CURRENCY_ID_SPLITOR) && (split = accountCurrencyComponentID.split(ACCOUNT_CURRENCY_ID_SPLITOR_REGEX)).length == 2) {
            this.accountID = split[0];
            this.currencyID = split[1];
            return;
        }
        throw new AccountCurrencyComponentParseException(String.format("\u3010%s\u3011\u4e0d\u662f\u3010\u8d26\u6237+\u5e01\u522b\u3011\u7684\u7ec4\u5408ID", accountCurrencyComponentID));
    }

    public String getAccountCurrencyComponentID() {
        return this.accountCurrencyComponentID;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getCurrencyID() {
        return this.currencyID;
    }

    public boolean isRight() {
        return this.isRight;
    }
}

