/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util.period;

import com.kingdee.eas.fm.mobile.util.DateUtils;
import com.kingdee.eas.fm.mobile.util.period.PeriodFilter;
import java.util.Date;

public class HarfAYearPeriodFilter
implements PeriodFilter {
    private final int year;
    private final String yearType;
    private int currentYear;
    private String currentYearType;

    public HarfAYearPeriodFilter(Date date) {
        this.year = DateUtils.getYear(date);
        this.yearType = DateUtils.getYearType(date);
        this.currentYear = this.year;
        this.currentYearType = this.yearType;
    }

    @Override
    public String getText() {
        return String.format("%d\u5e74%s", this.currentYear, this.currentYearType.equals("FIRST_HALF_YEAR") ? "\u4e0a\u534a\u5e74" : "\u4e0b\u534a\u5e74");
    }

    @Override
    public boolean hasNext() {
        return this.currentYear != this.year || !this.yearType.equals(this.currentYearType);
    }

    @Override
    public void previous() {
        if (this.currentYearType.equals("FIRST_HALF_YEAR")) {
            --this.currentYear;
            this.currentYearType = "SECOND_HALF";
        } else {
            this.currentYearType = "FIRST_HALF_YEAR";
        }
    }

    @Override
    public void next() {
        if (this.currentYearType.equals("FIRST_HALF_YEAR")) {
            this.currentYearType = "SECOND_HALF";
        } else {
            ++this.currentYear;
            this.currentYearType = "FIRST_HALF_YEAR";
        }
    }

    @Override
    public String getURLParameters() {
        return null;
    }
}

