/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewCompanyProfitF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.recon.FmSettleResultCollection;
import com.kingdee.eas.fm.recon.FmSettleResultFactory;
import com.kingdee.eas.fm.recon.FmSettleResultInfo;
import com.kingdee.eas.fm.recon.SettleStatusEnum;
import com.kingdee.eas.fm.recon.client.AbstractFMSettleInitUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;

public class FMSettleInitUI
extends AbstractFMSettleInitUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmSettleResource";
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.actionEndInit.setEnabled(true);
        this.actionEndInit.setVisible(true);
        this.actionUnInit.setEnabled(true);
        this.actionUnInit.setVisible(true);
        this.actionEndInit.putValue("SmallIcon", com.kingdee.eas.util.client.EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.actionUnInit.putValue("SmallIcon", com.kingdee.eas.util.client.EASResource.getIcon((String)"imgTbtn_finitialize"));
        if (!this.currentCompany.isIsCU()) {
            this.prmtOrg.setEditable(false);
            this.prmtOrg.setEnabled(false);
            this.prmtOrg.setValue((Object)this.currentCompany);
        } else {
            this.prmtOrg.setEditable(true);
            NewCompanyProfitF7 orgF7 = new NewCompanyProfitF7((IUIObject)this);
            orgF7.setPermissionItem("FMINIT_01VIEW");
            this.prmtOrg.setDisplayFormat("$name$");
            this.prmtOrg.setEditFormat("$name$");
            this.prmtOrg.setSelector((KDPromptSelector)orgF7);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtOrg.setEntityViewInfo(evi);
            this.prmtOrg.setValue((Object)this.getInitCompany());
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getKeyFieldName() {
        return "module";
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void prmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrg_dataChanged(e);
        if (!(this.prmtOrg.getData() instanceof CompanyOrgUnitInfo)) {
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtOrg.getData();
        if (company != null) {
            this.currentCompany = company;
            this.prmtOrg.setData((Object)company);
        }
        this.loadData();
    }

    public void loadData() {
        this.tblMain.removeRows();
        try {
            SystemStatusCtrolCollection statusCtrolColls = this.getSystemStatusCtrolCollectionByCompany(this.currentCompany);
            for (int i = 0; i < statusCtrolColls.size(); ++i) {
                SystemStatusCtrolInfo statusCtrolInfo = statusCtrolColls.get(i);
                IRow row = this.tblMain.addRow();
                row.getCell("module").setValue((Object)statusCtrolInfo.getSystemStatus().getName());
                if (statusCtrolInfo.getStartPeriod() != null) {
                    row.getCell("enablePeriod").setValue((Object)statusCtrolInfo.getStartPeriod().getDescription());
                }
                KDCheckBox prmt = new KDCheckBox();
                KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JCheckBox)prmt);
                row.getCell("select").setEditor((ICellEditor)editor);
                row.getCell("select").getStyleAttributes().setLocked(false);
                if (statusCtrolInfo.isIsStart()) {
                    row.getCell("enable").setValue((Object)true);
                } else {
                    row.getCell("enable").setValue((Object)false);
                }
                row.getCell("select").setValue((Object)false);
                row.getCell("id").setValue((Object)statusCtrolInfo.getId());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private SystemStatusCtrolCollection getSystemStatusCtrolCollectionByCompany(CompanyOrgUnitInfo company) throws BOSException {
        EntityViewInfo entity = new EntityViewInfo();
        entity.getSelector().add(new SelectorItemInfo("id"));
        entity.getSelector().add(new SelectorItemInfo("systemStatus.name"));
        entity.getSelector().add(new SelectorItemInfo("isStart"));
        entity.getSelector().add(new SelectorItemInfo("startPeriod.description"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)28, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)29, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)30, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)31, CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2 or #3 or #4)");
        entity.setFilter(filter);
        SystemStatusCtrolCollection systemStatusCtrolColl = SystemStatusCtrolFactory.getRemoteInstance().getSystemStatusCtrolCollection(entity);
        return systemStatusCtrolColl;
    }

    private SystemStatusCtrolCollection getSystemStatusCtrolCollectionByIdList(List<String> idList) throws BOSException {
        EntityViewInfo entity = new EntityViewInfo();
        entity.getSelector().add(new SelectorItemInfo("id"));
        entity.getSelector().add(new SelectorItemInfo("systemStatus.name"));
        entity.getSelector().add(new SelectorItemInfo("isStart"));
        entity.getSelector().add(new SelectorItemInfo("startPeriod.description"));
        entity.getSelector().add(new SelectorItemInfo("isRelatedAccount"));
        entity.getSelector().add(new SelectorItemInfo("relatedPeriod"));
        entity.getSelector().add(new SelectorItemInfo("currentPeriod"));
        entity.getSelector().add(new SelectorItemInfo("company"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(idList), CompareType.INCLUDE));
        entity.setFilter(filter);
        SystemStatusCtrolCollection systemStatusCtrolColl = SystemStatusCtrolFactory.getRemoteInstance().getSystemStatusCtrolCollection(entity);
        return systemStatusCtrolColl;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionEndInit_actionPerformed(ActionEvent e) throws Exception {
        List<String> idList;
        if (!(this.prmtOrg.getData() instanceof CompanyOrgUnitInfo)) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"5_SELECT_ORG"));
            SysUtil.abort();
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtOrg.getData();
        boolean isPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.currentUser.getId()), (IObjectPK)new ObjectUuidPK(company.getId()), "FMINIT_02ENDINIT");
        if (!isPermission) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"6_NO_ENDINT_PERM"));
            SysUtil.abort();
        }
        if ((idList = this.getSelectIds()).size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"7_SELECT_INIT_MODULE"));
            SysUtil.abort();
        }
        SystemStatusCtrolCollection colls = this.getSystemStatusCtrolCollectionByIdList(idList);
        List<String> msgList = this.verifyForEndInit(colls);
        this.doEndInit(colls);
        if (msgList.size() > 0) {
            StringBuffer detail = new StringBuffer();
            for (int i = 0; i < msgList.size(); ++i) {
                detail.append(msgList.get(i) + "\r\n");
            }
            String title = com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE_PATH, (String)"33_INIT_DETAIL", (Object[])new Object[]{colls.size(), msgList.size()});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)detail.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"8_ENDINIT_SUCC"));
        }
        this.loadData();
    }

    @Override
    public void actionUnInit_actionPerformed(ActionEvent e) throws Exception {
        if (!(this.prmtOrg.getData() instanceof CompanyOrgUnitInfo)) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"5_SELECT_ORG"));
            SysUtil.abort();
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtOrg.getData();
        boolean isPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.currentUser.getId()), (IObjectPK)new ObjectUuidPK(company.getId()), "FMINIT_03UNINIT");
        if (!isPermission) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"9_NO_UNINIT_PERM"));
            SysUtil.abort();
        }
        super.actionUnInit_actionPerformed(e);
        List<String> idList = this.getSelectIds();
        if (idList.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"10_SELECT_UNINIT_MODULE"));
            SysUtil.abort();
        }
        SystemStatusCtrolCollection colls = this.getSystemStatusCtrolCollectionByIdList(idList);
        List<String> msgList = this.verifyForUnInit(colls);
        this.doUninit(colls);
        if (msgList.size() > 0) {
            StringBuffer detail = new StringBuffer();
            for (int i = 0; i < msgList.size(); ++i) {
                detail.append(msgList.get(i) + "\r\n");
            }
            String title = com.kingdee.eas.util.client.EASResource.getString((String)RESOURCE_PATH, (String)"32_UNINIT_DETAIL", (Object[])new Object[]{colls.size(), msgList.size()});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)detail.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"11_UNINIT_SUCC"));
        }
        this.loadData();
    }

    public List<String> verifyForEndInit(SystemStatusCtrolCollection colls) throws BOSException {
        ArrayList<String> msgList = new ArrayList<String>();
        for (int i = colls.size() - 1; i >= 0; --i) {
            SystemStatusCtrolInfo info = colls.get(i);
            if (info.isIsStart()) {
                msgList.add(info.getSystemStatus().getName() + EASResource.getString((String)RESOURCE_PATH, (String)"12_HAS_ENABLED"));
                colls.remove(info);
                continue;
            }
            if (info.getStartPeriod() != null) continue;
            msgList.add(info.getSystemStatus().getName() + EASResource.getString((String)RESOURCE_PATH, (String)"13_ENABLE_PERIOD_NULL"));
            colls.remove(info);
        }
        return msgList;
    }

    private void doEndInit(SystemStatusCtrolCollection colls) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isStart"));
        sic.add(new SelectorItemInfo("currentPeriod"));
        for (int i = 0; i < colls.size(); ++i) {
            SystemStatusCtrolInfo info = colls.get(i);
            info.setIsStart(true);
            info.setCurrentPeriod(info.getStartPeriod());
            SystemStatusCtrolFactory.getRemoteInstance().updatePartial((CoreBaseInfo)info, sic);
            FmSettleResultInfo settleResult = new FmSettleResultInfo();
            settleResult.setCompany(this.currentCompany);
            settleResult.setPeriod(info.getCurrentPeriod());
            settleResult.setSystemStatus(info.getSystemStatus());
            settleResult.setSettleStatus(SettleStatusEnum.unSettle);
            FmSettleResultFactory.getRemoteInstance().save((CoreBaseInfo)settleResult);
        }
    }

    private void doUninit(SystemStatusCtrolCollection colls) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isStart"));
        sic.add(new SelectorItemInfo("currentPeriod"));
        for (int i = 0; i < colls.size(); ++i) {
            SystemStatusCtrolInfo info = colls.get(i);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)info.getCurrentPeriod().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("systemStatus", (Object)info.getSystemStatus().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("settleStatus", (Object)0, CompareType.EQUALS));
            FmSettleResultFactory.getRemoteInstance().delete(filter);
            info.setIsStart(false);
            info.setCurrentPeriod(null);
            SystemStatusCtrolFactory.getRemoteInstance().updatePartial((CoreBaseInfo)info, sic);
        }
    }

    public List<String> verifyForUnInit(SystemStatusCtrolCollection colls) throws BOSException {
        ArrayList<String> msgList = new ArrayList<String>();
        for (int i = colls.size() - 1; i >= 0; --i) {
            SystemStatusCtrolInfo info = colls.get(i);
            if (!info.isIsStart()) {
                msgList.add(info.getSystemStatus().getName() + EASResource.getString((String)RESOURCE_PATH, (String)"14_NOT_ENABLED"));
                colls.remove(info);
                continue;
            }
            if (!info.getStartPeriod().getId().toString().equals(info.getCurrentPeriod().getId().toString())) {
                msgList.add(info.getSystemStatus().getName() + EASResource.getString((String)RESOURCE_PATH, (String)"15_CUR_PERIOD_NOTEQUALS_ENABLE"));
                colls.remove(info);
                continue;
            }
            if (info.isIsRelatedAccount() && info.getCurrentPeriod().getId().toString().equals(info.getRelatedPeriod().getId().toString())) {
                msgList.add(info.getSystemStatus().getName() + EASResource.getString((String)RESOURCE_PATH, (String)"16_RATED_GL"));
                colls.remove(info);
                continue;
            }
            EntityViewInfo entity = new EntityViewInfo();
            entity.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)info.getCurrentPeriod().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("systemStatus", (Object)info.getSystemStatus().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("settleStatus", (Object)SettleStatusEnum.settle, CompareType.EQUALS));
            entity.setFilter(filter);
            FmSettleResultCollection settleResultColls = FmSettleResultFactory.getRemoteInstance().getFmSettleResultCollection(entity);
            if (settleResultColls.size() <= 0) continue;
            msgList.add(info.getSystemStatus().getName() + EASResource.getString((String)RESOURCE_PATH, (String)"17_CUR_HAS_SETTLED"));
            colls.remove(info);
        }
        return msgList;
    }

    public List<String> getSelectIds() {
        ArrayList<String> idList = new ArrayList<String>();
        List rowList = this.tblMain.getBody().getRows();
        for (int i = 0; i < rowList.size(); ++i) {
            KDTRow row = (KDTRow)rowList.get(i);
            Boolean isSelected = (Boolean)row.getCell(3).getValue();
            if (!isSelected.booleanValue()) continue;
            String id = row.getCell(4).getValue().toString();
            idList.add(id);
        }
        return idList;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.loadData();
    }

    private CompanyOrgUnitInfo getInitCompany() {
        try {
            IPermission permission = PermissionFactory.getRemoteInstance();
            FullOrgUnitCollection orgColls = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(this.currentUser.getId()), OrgType.Company, null, "FMINIT_01VIEW");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < orgColls.size(); ++i) {
                if (this.currentCompany.getId().toString().equals(orgColls.get(i).getId().toString()) && this.currentCompany.isIsBizUnit()) {
                    return this.currentCompany;
                }
                idSet.add(orgColls.get(i).getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filter1.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE));
            view.setFilter(filter1);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("longNumber"));
            view.setSorter(sorter);
            CompanyOrgUnitCollection fiOrgColls = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            return fiOrgColls.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

