/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IO_Period;
import com.kingdee.eas.basedata.assistant.IPeriodType;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.O_PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewCompanyProfitF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.PeriodHelper;
import com.kingdee.eas.fm.recon.SettleStatusEnum;
import com.kingdee.eas.fm.recon.client.AbstractFmSettlementFilterUI;
import com.kingdee.eas.fm.recon.client.FMSettleCenterFilterParam;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FmSettlementFilterUI
extends AbstractFmSettlementFilterUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmSettleResource";
    private static final Logger logger = CoreUIObject.getLogger(FmSettlementFilterUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private UserInfo currentUser;
    private FMSettleCenterFilterParam param = new FMSettleCenterFilterParam();

    public FmSettlementFilterUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public boolean verify() {
        if (EmptyUtil.isEmpty((Object)this.prmtCompany.getValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE_PATH, (String)"5_SELECT_ORG"));
            return false;
        }
        if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiEndYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth)) {
            this.spiBeginYear.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"18_ENDPERIOD_LESS_BEGINPERIOD"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        return ((FMSettleCenterFilterParam)((Object)this.getParam())).getFilter();
    }

    protected Class getParamClass() {
        return FMSettleCenterFilterParam.class;
    }

    public Object getParam() {
        if (this.cmbModule.getSelectedItem() instanceof SystemEnum) {
            SystemEnum selectedValue = (SystemEnum)this.cmbModule.getSelectedItem();
            switch (selectedValue.getValue()) {
                case 28: {
                    this.param.setSystemStatus("xsH6i+JRQSGKJg+gLlACogKlUUw=");
                    break;
                }
                case 29: {
                    this.param.setSystemStatus("NOxD8DLoShmvHOvurKhSyQKlUUw=");
                    break;
                }
                case 30: {
                    this.param.setSystemStatus("4Mt/QEgISTGmHtXJOUP9fwKlUUw=");
                    break;
                }
                case 31: {
                    this.param.setSystemStatus("cFLZpTZCQAW4MBR0Pfu+FgKlUUw=");
                }
            }
        } else {
            this.param.setSystemStatus(null);
        }
        if (this.cmbSettleStatus.getSelectedItem() instanceof SettleStatusEnum) {
            SettleStatusEnum settleStatus = (SettleStatusEnum)((Object)this.cmbSettleStatus.getSelectedItem());
            this.param.setSettleState(settleStatus.getValue());
        } else {
            this.param.setSettleState(null);
        }
        this.param.setCompanyIdSet(this.getOrgsIdSet());
        this.param.setBeginYear(Integer.valueOf(this.spiBeginYear.getValue().toString()));
        this.param.setEndYear(Integer.valueOf(this.spiEndYear.getValue().toString()));
        this.param.setBeginMonth(Integer.valueOf(this.spiBeginMonth.getValue().toString()));
        this.param.setEndMonth(Integer.valueOf(this.spiEndMonth.getValue().toString()));
        return this.param;
    }

    public void setParam(Object param) {
        FMSettleCenterFilterParam filterParam = (FMSettleCenterFilterParam)((Object)param);
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        if (filterParam.getSettleState() == null) {
            this.cmbSettleStatus.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            this.cmbSettleStatus.setSelectedItem((Object)SettleStatusEnum.getEnum(filterParam.getSettleState()));
        }
        if (filterParam.getSystemStatus() == null) {
            this.cmbModule.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        } else if (filterParam.getSystemStatus().equals("xsH6i+JRQSGKJg+gLlACogKlUUw=")) {
            this.cmbModule.setSelectedItem((Object)SystemEnum.NT_MANAGEMENT);
        } else if (filterParam.getSystemStatus().equals("NOxD8DLoShmvHOvurKhSyQKlUUw=")) {
            this.cmbModule.setSelectedItem((Object)SystemEnum.FIN_MANAGE);
        } else if (filterParam.getSystemStatus().equals("4Mt/QEgISTGmHtXJOUP9fwKlUUw=")) {
            this.cmbModule.setSelectedItem((Object)SystemEnum.IVT_MANAGE);
        } else if (filterParam.getSystemStatus().equals("cFLZpTZCQAW4MBR0Pfu+FgKlUUw=")) {
            this.cmbModule.setSelectedItem((Object)SystemEnum.CTL_MANAGE);
        } else {
            this.cmbModule.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (!EmptyUtil.isEmpty((Collection)filterParam.getCompanyIdSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterParam.getCompanyIdSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmtCompany.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
    }

    protected void initComponents() throws Exception {
        this.btnCompanySelect.setEnabled(false);
        this.btnCompanySelect.setVisible(false);
        this.chkIA.setEnabled(false);
        this.chkIA.setVisible(false);
        NewCompanyProfitF7 orgF7 = new NewCompanyProfitF7((IUIObject)this);
        orgF7.setMultiSelect(true);
        orgF7.setPermissionItem("FMSETTLE_01VIEW");
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setEditFormat("$name$");
        this.prmtCompany.setSelector((KDPromptSelector)orgF7);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(evi);
        this.prmtCompany.setValue((Object)this.getInitCompany());
        if (this.currentCompany.isIsBizUnit()) {
            this.prmtCompany.setEnabled(false);
        }
        Date now = new Date();
        this.spiBeginYear.setValue((Object)DateTimeUtils.getYear((Date)now));
        this.spiEndYear.setValue((Object)DateTimeUtils.getYear((Date)now));
        this.spiBeginMonth.setValue((Object)DateTimeUtils.getMonth((Date)now));
        this.spiEndMonth.setValue((Object)DateTimeUtils.getMonth((Date)now));
        this.cmbSettleStatus.removeItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbModule.removeItem((Object)SystemEnum.NT_MANAGEMENT);
        this.cmbModule.removeItem((Object)SystemEnum.FIN_MANAGE);
        this.cmbModule.removeItem((Object)SystemEnum.IVT_MANAGE);
        this.cmbModule.removeItem((Object)SystemEnum.CTL_MANAGE);
        this.cmbModule.removeItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbSettleStatus.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbSettleStatus.setSelectedIndex(2);
        this.cmbModule.addItem((Object)SystemEnum.NT_MANAGEMENT);
        this.cmbModule.addItem((Object)SystemEnum.FIN_MANAGE);
        this.cmbModule.addItem((Object)SystemEnum.IVT_MANAGE);
        this.cmbModule.addItem((Object)SystemEnum.CTL_MANAGE);
        this.cmbModule.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbModule.setSelectedIndex(4);
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndMonth);
    }

    protected void init() throws Exception {
        this.initComponents();
        this.initPeriod();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initPeriod() throws EASBizException, BOSException {
        if (this.currentCompany != null && this.currentCompany.isIsBizUnit()) {
            ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getRemoteInstance();
            if (!(ictrol.isStart(30, this.currentCompany.getId().toString()) || ictrol.isStart(31, this.currentCompany.getId().toString()) || ictrol.isStart(29, this.currentCompany.getId().toString()) || ictrol.isStart(28, this.currentCompany.getId().toString()))) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"StartPeriod_NullMsg"));
                SysUtil.abort();
            }
            if (this.currentCompany != null && this.currentCompany.isIsBizUnit()) {
                PeriodHelper.setPeriodNum((CompanyOrgUnitInfo)this.currentCompany, (KDSpinner)this.spiBeginMonth, (Integer)((Integer)this.spiBeginYear.getValue()), (SystemEnum)PeriodHelper.getBeginDateSysEnumOf4((String)this.currentCompany.getId().toString()));
                PeriodHelper.setPeriodNum((CompanyOrgUnitInfo)this.currentCompany, (KDSpinner)this.spiEndMonth, (Integer)((Integer)this.spiEndYear.getValue()), (SystemEnum)PeriodHelper.getEndDateSysEnumOf4((String)this.currentCompany.getId().toString()));
            }
        }
    }

    private int[] getYears() throws Exception {
        String cbType = null;
        String cbTypeid = null;
        IO_Period iO_Period = null;
        IPeriodType iPeriodType = null;
        if (iO_Period == null) {
            iO_Period = O_PeriodFactory.getRemoteInstance();
        }
        if (iPeriodType == null) {
            iPeriodType = PeriodTypeFactory.getRemoteInstance();
            PeriodTypeCollection periodTypeCollection = iPeriodType.getPeriodTypeCollection();
            for (int i = 0; i < periodTypeCollection.size(); ++i) {
                PeriodTypeInfo info = periodTypeCollection.get(i);
                cbType = info.getName() + " - " + info.getNumber();
                cbTypeid = info.getId().toString();
            }
        }
        if (cbType.equals("")) {
            int[] para = new int[]{};
            return para;
        }
        return iO_Period.getAllPeriodYear(cbTypeid);
    }

    public FMSettleCenterFilterParam getFilterParam() {
        return this.param;
    }

    private Set<String> getOrgsIdSet() {
        HashSet<String> idSet = new HashSet<String>();
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            idSet.add(companyInfo.getId().toString());
        } else if (this.prmtCompany.getValue() instanceof Object[]) {
            Object[] arrays = (Object[])this.prmtCompany.getValue();
            for (int i = 0; i < arrays.length; ++i) {
                CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)arrays[i];
                idSet.add(info.getId().toString());
            }
        } else {
            OrgUnitInfo[] companyInfos = (OrgUnitInfo[])this.prmtCompany.getValue();
            for (int i = 0; i < companyInfos.length; ++i) {
                idSet.add(companyInfos[i].getId().toString());
            }
        }
        return idSet;
    }

    private CompanyOrgUnitInfo getInitCompany() {
        try {
            IPermission permission = PermissionFactory.getRemoteInstance();
            FullOrgUnitCollection orgColls = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(this.currentUser.getId()), OrgType.Company, null, "FMSETTLE_01VIEW");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < orgColls.size(); ++i) {
                if (this.currentCompany.getId().toString().equals(orgColls.get(i).getId().toString()) && this.currentCompany.isIsBizUnit()) {
                    return this.currentCompany;
                }
                idSet.add(orgColls.get(i).getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filter1.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE));
            view.setFilter(filter1);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("longNumber"));
            view.setSorter(sorter);
            CompanyOrgUnitCollection fiOrgColls = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            return fiOrgColls.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

