/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpt.liquid.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.FundStockFacadeFactory;
import com.kingdee.eas.fm.liquid.IFundStockFacade;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.rpt.common.RptHelper;
import com.kingdee.eas.fm.rpt.liquid.dataset.LiquidBaseDataSet;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiquidStockDetailDataSet
extends LiquidBaseDataSet {
    @Override
    protected Map<String, Object> getFilterParamMap() {
        String showParams;
        Map<String, Object> paramMap = super.getFilterParamMap();
        paramMap.put("beginDate", this.getFilterParamValue("beginDate"));
        paramMap.put("endDate", this.getFilterParamValue("endDate"));
        String bankIds = this.getFilterParamValue("bank");
        if (!EmptyUtil.isEmpty((String)bankIds)) {
            paramMap.put("bankIdSet", LiquidHelper.ids2Set((String)bankIds));
            paramMap.put("isIncludeCash", "false");
        }
        boolean isIncludeInnerBank = (showParams = this.getFilterParamValue("showParams")).indexOf("4") == -1;
        paramMap.put("isIncludeInnerBank", String.valueOf(isIncludeInnerBank));
        boolean isIncludeSealCompany = showParams.indexOf("5") != -1;
        paramMap.put("isIncludeSealCompany", String.valueOf(isIncludeSealCompany));
        return paramMap;
    }

    private IRowSet executeSigleTask(IFundStockFacade iFundStockFacade, Map<String, Object> filterParamMap) throws EASBizException, BOSException {
        System.out.println("Thread(" + Thread.currentThread().getName() + ") : " + filterParamMap.get("beginDate") + " - " + filterParamMap.get("beginDate") + " is runninng ");
        return iFundStockFacade.getStockStructure(filterParamMap);
    }

    private BlockingQueue<Map<String, Object>> getFilterMapQueue(Map<String, Object> filterParamMap) throws EASBizException, InterruptedException {
        Date beginDate = DateUtil.stringToDate((String)((String)filterParamMap.get("beginDate")));
        Date endDate = DateUtil.stringToDate((String)((String)filterParamMap.get("endDate")));
        int queryCycle = Integer.parseInt((String)filterParamMap.get("queryCycle"));
        BgPeriodCollection bgPeriodCol = LiquidHelper.getBeginAndEndDates(null, (Date)beginDate, (Date)endDate, (int)queryCycle);
        int count = bgPeriodCol.size();
        ArrayBlockingQueue<Map<String, Object>> filterMapQueue = new ArrayBlockingQueue<Map<String, Object>>(count);
        Object value = null;
        for (int i = 0; i < count; ++i) {
            BgPeriodInfo bgPeriodInfo = bgPeriodCol.get(i);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (String key : filterParamMap.keySet()) {
                value = key.equals("beginDate") ? DateUtil.DateToString((Date)bgPeriodInfo.getBeginDate()) : (key.equals("endDate") ? DateUtil.DateToString((Date)bgPeriodInfo.getEndDate()) : filterParamMap.get(key));
                paramMap.put(key, (String)value);
            }
            filterMapQueue.put(paramMap);
        }
        return filterMapQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicRowSet executeWithMultiThread(Map<String, Object> filterParamMap) throws EASBizException, InterruptedException, BOSException, ExecutionException {
        int THREAD_COUNT = 8;
        final BlockingQueue<Map<String, Object>> filterMapQueue = this.getFilterMapQueue(filterParamMap);
        int size = filterMapQueue.size();
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        try {
            ExecutorCompletionService<IRowSet> completionService = new ExecutorCompletionService<IRowSet>(executorService);
            final IFundStockFacade iFundStockFacade = FundStockFacadeFactory.getRemoteInstance();
            for (int i = 0; i < size; ++i) {
                completionService.submit(new Callable<IRowSet>(){

                    @Override
                    public IRowSet call() throws Exception {
                        return LiquidStockDetailDataSet.this.executeSigleTask(iFundStockFacade, (Map)filterMapQueue.take());
                    }
                });
            }
            DynamicRowSet resultRs = null;
            for (int i = 0; i < size; ++i) {
                IRowSet rowSet = (IRowSet)completionService.take().get();
                if (resultRs == null) {
                    resultRs = (DynamicRowSet)rowSet;
                    continue;
                }
                resultRs.merge((DynamicRowSet)rowSet);
            }
            DynamicRowSet dynamicRowSet = resultRs;
            return dynamicRowSet;
        }
        finally {
            if (!executorService.isShutdown()) {
                executorService.shutdown();
            }
        }
    }

    @Override
    protected IRowSet getQueryRowSet(Map<String, Object> filterParamMap) throws Exception {
        IRowSet rowSet = null;
        try {
            long startTime = System.currentTimeMillis();
            rowSet = FundStockFacadeFactory.getRemoteInstance().getStockStructure(filterParamMap);
            long endTime = System.currentTimeMillis();
            System.out.println("call server getStockStructure spent time : " + (endTime - startTime));
        }
        catch (EASBizException e) {
            RptHelper.handleException(e);
            throw e;
        }
        return rowSet;
    }
}

