/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpt.liquid.param;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.liquid.common.LiquidCompanyHelper;
import com.kingdee.eas.fm.rpt.FmRptFacadeFactory;
import com.kingdee.eas.fm.rpt.common.RptHelper;
import com.kingdee.eas.fm.rpt.liquid.param.LiquidCompanyUnionF7;
import com.kingdee.eas.fm.rpt.liquid.param.LiquidParamRelationHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.rpts.ctrlsqldesign.param.AbstractParamRelation;
import com.kingdee.eas.rpts.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.eas.util.SysUtil;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class LiquidBaseParamRelation
extends AbstractParamRelation {
    protected CompanyOrgUnitInfo currentCompany;
    protected CurrencyInfo baseCurrency;
    protected DefaultArgInput filterUI = null;
    protected LiquidParamRelationHelper paramRelationHelper = new LiquidParamRelationHelper();

    public LiquidBaseParamRelation() {
        this.initDefaultProp();
    }

    public void setFilterUI(DefaultArgInput filter) {
        super.setFilterUI(filter);
        this.filterUI = filter;
    }

    protected boolean isOneStyle() {
        return true;
    }

    protected boolean isOrgUnion() {
        return false;
    }

    protected Object getComponent(String paramName) {
        return this.objectComponents.get(paramName);
    }

    protected void setF7IsEnabled(String paramName, boolean isEnabled) {
        KDPromptBox prmt = (KDPromptBox)this.getComponent(paramName);
        if (prmt != null) {
            prmt.setEnabled(isEnabled);
        }
    }

    protected void setSpinnerIsEnabled(String paramName, boolean isEnabled) {
        KDSpinner kdSpinner = (KDSpinner)this.getComponent(paramName);
        if (kdSpinner != null) {
            kdSpinner.setEnabled(isEnabled);
        }
    }

    protected void resetSpinnerMaxLevel(String paramName, int maxLevel, boolean isRested) {
        KDSpinner kdSpinner = (KDSpinner)this.getComponent(paramName);
        if (kdSpinner != null) {
            double level = (Double)kdSpinner.getValue();
            if (isRested) {
                level = 1.0;
            }
            kdSpinner.setValue((Object)level, false);
            kdSpinner.repaint();
            kdSpinner.setModel((SpinnerModel)new SpinnerNumberModel(level, 1.0, (double)maxLevel, 1.0));
        }
    }

    protected void setComponentReqired(String paramName, boolean isReqired, boolean isEnabled) {
        Object currentObj = this.getComponent(paramName);
        if (currentObj == null) {
            return;
        }
        if (currentObj instanceof KDTextField) {
            ((KDTextField)currentObj).setRequired(isReqired);
            if (!isReqired && !isEnabled) {
                ((KDTextField)currentObj).setText(null, false);
            }
        } else if (currentObj instanceof KDBizPromptBox) {
            ((KDBizPromptBox)currentObj).setRequired(isReqired);
            if (!isReqired && !isEnabled) {
                ((KDBizPromptBox)currentObj).setDataNoNotify(null);
            }
        } else if (currentObj instanceof KDComboBox) {
            ((KDComboBox)currentObj).setRequired(isReqired);
            if (!isReqired && !isEnabled) {
                ((KDComboBox)currentObj).setSelectedIndex(-1, false);
            }
        } else if (currentObj instanceof KDCheckBox) {
            ((KDCheckBox)currentObj).setRequired(isReqired);
        } else if (currentObj instanceof KDSpinner) {
            ((KDSpinner)currentObj).setRequired(isReqired);
        } else if (currentObj instanceof KDDatePicker) {
            ((KDDatePicker)currentObj).setRequired(isReqired);
        } else if (currentObj instanceof KDTimePicker) {
            ((KDTimePicker)currentObj).setRequired(isReqired);
        }
        if (isReqired) {
            ((JComponent)currentObj).setEnabled(true);
        } else {
            ((JComponent)currentObj).setEnabled(isEnabled);
        }
    }

    private void initDefaultProp() {
        try {
            this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("baseCurrency.*");
            this.currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), selector);
            this.baseCurrency = this.currentCompany.getBaseCurrency();
        }
        catch (Exception e) {
            RptHelper.handleException(e);
            SysUtil.abort();
        }
    }

    public void loadSolutionAfter() throws Exception {
        super.loadSolutionAfter();
        if (this.isOneStyle()) {
            this.filterUI.createParametersUILayout();
        }
        this.initComponentParams();
    }

    private void initCompanyOrgF7() throws Exception {
        KDBizPromptBox companyF7 = (KDBizPromptBox)this.getComponent("company");
        companyF7.setDisplayFormat("$number$-$name$");
        if (companyF7.getData() == null) {
            companyF7.setData((Object)this.currentCompany);
        } else {
            String companyId = this.getComponentValue("company");
            companyF7.setData((Object)LiquidCompanyHelper.getCompanyOrgUnitInfo(null, (String)companyId));
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)companyF7.getData();
        int maxLevel = FmRptFacadeFactory.getRemoteInstance().getSubCompanyMaxLevel((CoreBaseInfo)companyInfo);
        this.resetSpinnerMaxLevel("companyLevel", maxLevel, false);
        if (this.currentCompany.isIsBizUnit()) {
            companyF7.setEnabled(false);
            this.setSpinnerIsEnabled("companyLevel", false);
        }
    }

    protected void initCompanyUnionF7() throws Exception {
        KDBizPromptBox companyUnionF7 = (KDBizPromptBox)this.getComponent("companyUnion");
        companyUnionF7.setDisplayFormat("$number$-$name$");
        if (companyUnionF7.getData() == null) {
            this.orgUnionTreeOnChange();
        } else {
            String companyId = this.getComponentValue("companyUnion");
            companyUnionF7.setData((Object)LiquidCompanyHelper.getOrgUnitInfo(null, (String)companyId));
        }
        CoreBaseInfo companyInfo = (CoreBaseInfo)companyUnionF7.getData();
        int maxLevel = FmRptFacadeFactory.getRemoteInstance().getSubCompanyMaxLevel(companyInfo);
        this.resetSpinnerMaxLevel("companyLevel", maxLevel, false);
        if (this.currentCompany.isIsBizUnit()) {
            companyUnionF7.setEnabled(false);
            this.setSpinnerIsEnabled("companyLevel", false);
        }
    }

    protected void initCompanyF7() throws Exception {
        if (!this.isOrgUnion()) {
            this.initCompanyOrgF7();
        } else {
            this.initCompanyUnionF7();
        }
    }

    protected void initCurrencyF7() throws Exception {
        KDBizPromptBox currencyF7 = (KDBizPromptBox)this.getComponent("currency");
        currencyF7.setDisplayFormat("$number$-$name$");
        currencyF7.setEditFormat("$number$");
        currencyF7.setCommitFormat("$number$;$name$");
        currencyF7.setEditable(true);
        this.setComponentValue("baseCurrency", this.baseCurrency.getName(), true);
    }

    protected void initOrgUnionTree() throws Exception {
        KDComboBox cboOrgTree = (KDComboBox)this.getComponent("orgUnionTree");
        if (cboOrgTree == null || !cboOrgTree.isVisible()) {
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        OrgTreeCollection orgTrees = LiquidCompanyHelper.getAllUnionTrees(null, (String)userId, null);
        int size = orgTrees.size();
        for (int i = 0; i < size; ++i) {
            OrgTreeInfo treeInfo = orgTrees.get(i);
            DefObj defObj = new DefObj();
            defObj.setName(treeInfo.getId().toString());
            defObj.setAlias(treeInfo.getName());
            cboOrgTree.addItem((Object)defObj);
        }
        if (cboOrgTree.getItemCount() > 0) {
            cboOrgTree.setSelectedIndex(0);
        }
    }

    protected void initComponentParams() throws Exception {
        this.initOrgUnionTree();
        this.initCompanyF7();
        this.initCurrencyF7();
    }

    private void orgUnionTreeOnChange() {
        KDComboBox cboOrgTree = (KDComboBox)this.getComponent("orgUnionTree");
        DefObj treeInfo = (DefObj)cboOrgTree.getSelectedItem();
        KDBizPromptBox prmtCompanyUnion = (KDBizPromptBox)this.getComponent("companyUnion");
        LiquidCompanyUnionF7 companyUnionF7 = (LiquidCompanyUnionF7)prmtCompanyUnion.getSelector();
        companyUnionF7.setTreeID(treeInfo.getName());
        companyUnionF7.refresh();
        prmtCompanyUnion.setDataNoNotify(null);
    }

    protected void companyOnChange() throws BOSException, Exception {
        KDBizPromptBox companyF7 = (KDBizPromptBox)this.getComponent("company");
        CompanyOrgUnitInfo companyInfo = null;
        Object companyValue = companyF7.getValue();
        if (companyValue instanceof DefObj[]) {
            String companyId = ((DefObj[])companyValue)[0].getName();
            companyInfo = LiquidCompanyHelper.getCompanyOrgUnitInfo(null, (String)companyId);
        } else if (companyValue instanceof CompanyOrgUnitInfo) {
            companyInfo = (CompanyOrgUnitInfo)companyF7.getValue();
        } else {
            return;
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)companyInfo)) {
            this.setSpinnerIsEnabled("companyLevel", false);
        } else {
            this.setSpinnerIsEnabled("companyLevel", !companyInfo.isIsBizUnit());
            int maxLevel = FmRptFacadeFactory.getRemoteInstance().getSubCompanyMaxLevel((CoreBaseInfo)companyInfo);
            this.resetSpinnerMaxLevel("companyLevel", maxLevel, true);
        }
    }

    protected void companyUnionOnChange() throws BOSException, Exception {
        KDBizPromptBox companyUnionF7 = (KDBizPromptBox)this.getComponent("companyUnion");
        OrgUnitInfo companyInfo = null;
        Object companyValue = companyUnionF7.getValue();
        if (companyValue instanceof DefObj[]) {
            String companyId = ((DefObj[])companyValue)[0].getName();
            companyInfo = (OrgUnitInfo)LiquidCompanyHelper.getOrgUnitInfo(null, (String)companyId);
        } else if (companyValue instanceof OrgUnitInfo) {
            companyInfo = (OrgUnitInfo)companyUnionF7.getValue();
        } else {
            return;
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)companyInfo)) {
            this.setSpinnerIsEnabled("companyLevel", false);
        } else {
            this.setSpinnerIsEnabled("companyLevel", !companyInfo.isIsLeaf());
            int maxLevel = FmRptFacadeFactory.getRemoteInstance().getSubCompanyMaxLevel((CoreBaseInfo)companyInfo);
            this.resetSpinnerMaxLevel("companyLevel", maxLevel, true);
        }
    }

    public void dataChange(String paramName) throws Exception {
        super.dataChange(paramName);
        if (paramName.equals("orgUnionTree")) {
            this.orgUnionTreeOnChange();
        } else if (paramName.equals("company")) {
            this.companyOnChange();
        } else if (paramName.equals("companyUnion")) {
            this.companyUnionOnChange();
        }
    }

    protected boolean checkBeginAndEndDate() {
        KDDatePicker dpkBeginDate = (KDDatePicker)this.getComponent("beginDate");
        KDDatePicker dpkEndDate = (KDDatePicker)this.getComponent("endDate");
        return this.paramRelationHelper.checkBeginAndEndDate(dpkBeginDate, dpkEndDate);
    }

    protected void deleteEmptyItem(String paramName) {
        KDComboBox cboComboBox = (KDComboBox)this.getComponent(paramName);
        DefObj defObj = (DefObj)cboComboBox.getItemAt(0);
        if (EmptyUtil.isEmpty((String)defObj.getName())) {
            cboComboBox.removeItemAt(0);
        }
    }

    protected void setIsDiffYearParam() throws Exception {
        KDCheckBox chkDiffYear = (KDCheckBox)this.getComponent("isDiffYear");
        if (chkDiffYear != null) {
            Date beginDate = DateUtil.stringToDate((String)this.getComponentValue("beginDate"));
            Date endDate = DateUtil.stringToDate((String)this.getComponentValue("endDate"));
            boolean isDiffYear = !DateUtil.getFirstYearDate((Date)beginDate).equals(DateUtil.getFirstYearDate((Date)endDate));
            chkDiffYear.setSelected(isDiffYear, false);
        }
    }
}

