/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpt.liquid.param;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.FundFlowItemPromptBox;
import com.kingdee.eas.fm.liquid.LiquidException;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.rpt.common.RptHelper;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Calendar;

public class LiquidParamRelationHelper {
    public void setBeginAndEndDate(String paramName, KDDatePicker dpkBeginDate, KDDatePicker dpkEndDate, int queryCycle) throws LiquidException, BOSException {
        Date date = null;
        date = paramName.equals("endDate") ? dpkEndDate.getSqlDate() : dpkBeginDate.getSqlDate();
        BgPeriodInfo bgPeriodInfo = LiquidHelper.getBgPeriodInfoByDateAndCycle(null, (java.util.Date)date, (int)queryCycle);
        if (bgPeriodInfo == null) {
            throw new LiquidException(LiquidException.NOTEXISTPGPERIOD, new Object[]{BgPeriodEnum.getEnum((int)queryCycle).getAlias(), DateUtil.DateToString((java.util.Date)date)});
        }
        if (paramName.equals("queryCycle")) {
            dpkBeginDate.setValue((Object)bgPeriodInfo.getBeginDate(), false);
            dpkEndDate.setValue((Object)bgPeriodInfo.getEndDate(), false);
        } else if (paramName.equals("beginDate")) {
            dpkBeginDate.setValue((Object)bgPeriodInfo.getBeginDate(), false);
        } else if (paramName.equals("endDate")) {
            dpkEndDate.setValue((Object)bgPeriodInfo.getEndDate(), false);
        }
    }

    public final boolean checkBeginAndEndDate(KDDatePicker dpkBeginDate, KDDatePicker dpkEndDate) {
        if (dpkBeginDate.getSqlDate().after(dpkEndDate.getSqlDate())) {
            MsgBox.showInfo((String)RptHelper.getRptResource(null, "VerifyBeginLessThanEndDate"));
            dpkEndDate.requestFocus();
            return false;
        }
        return true;
    }

    public void checkCurrencyHasExchangeRate(CompanyOrgUnitInfo currentCompany, CurrencyInfo baseCurrency, KDBizPromptBox currencyF7) throws BOSException, EASBizException {
        ExchangeTableInfo baseExchangeTable = currentCompany.getBaseExchangeTable();
        if (baseExchangeTable == null) {
            return;
        }
        StringBuilder currencyNames = new StringBuilder();
        Object currencyObj = currencyF7.getData();
        if (!EmptyUtil.isEmpty((Object)currencyObj)) {
            IExchangeRate iExchangeRate = ExchangeRateFactory.getRemoteInstance();
            Object[] currencys = (Object[])currencyObj;
            int length = currencys.length;
            for (int i = 0; i < length; ++i) {
                ExchangeRateInfo exRateInfo;
                CurrencyInfo currency = (CurrencyInfo)currencys[i];
                if (currency.getId().equals((Object)baseCurrency.getId()) || (exRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(baseExchangeTable.getId()), (IObjectPK)new ObjectUuidPK(currency.getId()), (IObjectPK)new ObjectUuidPK(baseCurrency.getId()), null)) != null) continue;
                if (currencyNames.length() > 0) {
                    currencyNames.append(",");
                }
                currencyNames.append(currency.getName());
            }
        }
        if (currencyNames.length() > 0) {
            String info = MessageFormat.format(RptHelper.getRptResource(null, "VerifyNotExchangeRate"), currencyNames.toString());
            RptHelper.handleException(new Exception(info));
        }
    }

    public boolean checkDateRange(KDDatePicker dpkBeginDate, KDDatePicker dpkEndDate) {
        Calendar calBeginDate = Calendar.getInstance();
        calBeginDate.setTime(dpkBeginDate.getSqlDate());
        calBeginDate.add(1, 1);
        if (dpkEndDate.getSqlDate().after(calBeginDate.getTime())) {
            String warnInfo = RptHelper.getRptResource(null, "VerifyWarnDateRange");
            RptHelper.handleException(new Exception(warnInfo));
            return false;
        }
        return true;
    }

    public boolean checkMaxPeriodCount(int queryCycle, java.util.Date beginDate, java.util.Date endDate, int maxPeriodCount) throws EASBizException {
        int count = 0;
        count = queryCycle == 7 ? DateUtil.getDiffDays((java.util.Date)beginDate, (java.util.Date)endDate) : LiquidHelper.getBeginAndEndDates(null, (java.util.Date)beginDate, (java.util.Date)endDate, (int)queryCycle).size();
        if (count > maxPeriodCount) {
            String info = MessageFormat.format(RptHelper.getRptResource(null, "VerifyMaxPeriod"), new Integer(maxPeriodCount));
            MsgBox.showInfo((String)info);
            return false;
        }
        return true;
    }

    public boolean checkMaxPeriodRange(int queryCycle, java.util.Date beginDate, java.util.Date endDate) throws EASBizException {
        int maxPeriodCount;
        switch (queryCycle) {
            case 1: {
                maxPeriodCount = 3;
                break;
            }
            case 2: {
                maxPeriodCount = 6;
                break;
            }
            case 3: {
                maxPeriodCount = 12;
                break;
            }
            case 4: {
                maxPeriodCount = 24;
                break;
            }
            case 9: {
                maxPeriodCount = 36;
                break;
            }
            case 6: {
                maxPeriodCount = 60;
                break;
            }
            case 5: {
                maxPeriodCount = 53;
                break;
            }
            case 7: {
                maxPeriodCount = 90;
                break;
            }
            default: {
                maxPeriodCount = 31;
            }
        }
        return this.checkMaxPeriodCount(queryCycle, beginDate, endDate, maxPeriodCount);
    }

    public void addSelfCustomItem(KDComboBox cboQueryCycle) {
        DefObj defObj = (DefObj)cboQueryCycle.getItemAt(0);
        if (EmptyUtil.isEmpty((String)defObj.getName())) {
            defObj.setAlias(RptHelper.getRptResource(null, "TitleCustom"));
            defObj.setName("-1");
        }
    }

    public void initFundFlowItemF7(KDBizPromptBox f7FundFlowItem, boolean isMultiSelect, FundFlowDirection direction) {
        FundFlowItemPromptBox selectorFundFlowItem = direction != null ? new FundFlowItemPromptBox(null, direction) : new FundFlowItemPromptBox();
        selectorFundFlowItem.setMultiSelect(isMultiSelect);
        f7FundFlowItem.setSelector((KDPromptSelector)selectorFundFlowItem);
        f7FundFlowItem.setEnabledMultiSelection(isMultiSelect);
        f7FundFlowItem.setEditFormat("$number$");
        f7FundFlowItem.setDisplayFormat("$number$-$name$");
        f7FundFlowItem.setCommitFormat("$number$;$name$");
        f7FundFlowItem.setEditable(true);
    }
}

