/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.fm.common.util.AccrualResultInfo;
import com.kingdee.eas.fm.im.IIntRateBase;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class AccrualCalculatorPropertyUtil {
    private static final Logger logger = CoreUIObject.getLogger(AccrualCalculatorPropertyUtil.class);

    public static void copyPropertiesValue(Context ctx, AccrualCalculatorElementNeededInfo aceni, CoreBaseInfo info, IntReceivedBillTypeEnum intReceiveType) {
        if (info instanceof TimeDepositBillInfo) {
            aceni.setIntReceivedBillTypeEnum(intReceiveType);
            AccrualCalculatorPropertyUtil.copyPropertiesValueFromTimeDepositInfo(ctx, aceni, (TimeDepositBillInfo)info);
        } else if (info instanceof UnTimeDepositBillInfo) {
            aceni.setIntReceivedBillTypeEnum(intReceiveType);
            if (intReceiveType == IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT) {
                AccrualCalculatorPropertyUtil.copyPropertiesValueFromUnTimeDepositInfo(ctx, aceni, (UnTimeDepositBillInfo)info);
            }
        }
    }

    private static void copyPropertiesValueFromUnTimeDepositInfo(Context ctx, AccrualCalculatorElementNeededInfo aceni, UnTimeDepositBillInfo info) {
        TimeDepositBillInfo timeDepositBill = info.getTimeDepositBill();
        aceni.setUnDepositAmt(info.getUnDepositAmt());
        aceni.setUnDepositDate(info.getBizDate());
        aceni.setUnDepositTypeEnum(info.getUnDepositType());
        aceni.setIntRateTypeExpressionEnum(timeDepositBill.getIntRateTypeExpression());
        Date lastUndepositTime = timeDepositBill.getLastUnDepositDate();
        Date timeDepositEffectiveDate = timeDepositBill.getEffectiveDate();
        if (lastUndepositTime == null) {
            aceni.setEffectedDate(timeDepositBill.getEffectiveDate());
        } else if (lastUndepositTime.compareTo(timeDepositEffectiveDate) > 0) {
            aceni.setEffectedDate(lastUndepositTime);
        } else {
            aceni.setEffectedDate(timeDepositEffectiveDate);
        }
        aceni.setIntTerm(timeDepositBill.getIntTerm());
        if (info.getUnDepositType() == UnDepositTypeEnum.MATURE_UNDEPOSIT) {
            aceni.setMaturityDate(DateUtil.getBeforeDay((Date)timeDepositBill.getMaturityDay()));
        } else {
            aceni.setMaturityDate(DateUtil.getBeforeDay((Date)info.getBizDate()));
        }
        aceni.setCurYearRate(info.getYearRate());
        aceni.setYearDays(new BigDecimal(String.valueOf(timeDepositBill.getYearDays())));
        aceni.setYearRate(AccrualCalculatorPropertyUtil.getYearRate(ctx, timeDepositBill, aceni));
        aceni.setCurrency(timeDepositBill.getCurrency());
    }

    private static void copyPropertiesValueFromTimeDepositInfo(Context ctx, AccrualCalculatorElementNeededInfo aceni, TimeDepositBillInfo info) {
        aceni.setFloorAmt(info.getFloorAmt());
        aceni.setIntRateType(info.getIntRateTable());
        aceni.setIntRateTypeExpressionEnum(info.getIntRateTypeExpression());
        aceni.setEffectedDate(info.getEffectiveDate());
        aceni.setMaturityDate(info.getMaturityDay());
        aceni.setTimeDepositType(info.getTimeDepositType());
        aceni.setFloatting(info.getFloating());
        aceni.setCurrency(info.getCurrency());
        aceni.setBizDate(info.getBizDate());
        aceni.setIntRateTypeExpressionEnum(info.getIntRateTypeExpression());
        aceni.setYearDays(new BigDecimal(String.valueOf(info.getYearDays())));
        if (aceni.getIntReceivedBillTypeEnum() == IntReceivedBillTypeEnum.INTBILL_REDEPOSIT) {
            aceni.setDepositBalance(info.getBalance());
        } else if (aceni.getIntReceivedBillTypeEnum() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            aceni.setDepositBalance(info.getBalance());
            aceni.setLastPreDate(info.getLastRecvIntDay());
        }
        aceni.setYearRate(AccrualCalculatorPropertyUtil.getYearRate(ctx, info, aceni));
        aceni.setIntTerm(info.getIntTerm());
    }

    private static BigDecimal getYearRate(Context ctx, TimeDepositBillInfo info, AccrualCalculatorElementNeededInfo aceni) {
        BigDecimal yearRate = Constants.ZERO;
        yearRate = info.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || info.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER ? info.getYearRate() : AccrualCalculatorPropertyUtil.calcYearRate(ctx, info.getIntRateTable(), info.getFloating(), info.getCurrency(), info.getBizDate());
        return yearRate;
    }

    private static BigDecimal calcYearRate(Context ctx, IntRateTypeInfo intType, BigDecimal floating, CurrencyInfo currency, Date date) {
        if (floating == null || intType == null) {
            return null;
        }
        IntRateBaseInfo intratebase = null;
        try {
            IIntRateBase iir = null;
            iir = ctx == null ? IntRateBaseFactory.getRemoteInstance() : IntRateBaseFactory.getLocalInstance((Context)ctx);
            intratebase = iir.getCurRateByCond(intType.getId().toString(), currency.getId().toString(), date);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        if (intratebase == null) {
            return Constants.ZERO;
        }
        return intratebase.getYearRate().add(floating.divide(Constants.ONE_HUNDRED, 5, 4));
    }

    public static void copyResultToIntBillInfo(CoreBaseInfo info, AccrualResultInfo accrualResultInfo) {
        if (accrualResultInfo != null && info instanceof IntReceivedBillInfo) {
            AccrualCalculatorPropertyUtil.copyResultToIntReceiveInfo_Bank(accrualResultInfo, (IntReceivedBillInfo)info);
        }
    }

    private static void copyResultToIntReceiveInfo_Bank(AccrualResultInfo accrualResultInfo, IntReceivedBillInfo objectValue) {
        objectValue.setDeInterest(accrualResultInfo.getPeriodicalAccrual());
        objectValue.setCreInterest(accrualResultInfo.getCurrentAccrual());
        objectValue.setYingjiAmt(accrualResultInfo.getYingJiAccrual());
        objectValue.setShijiAmt(accrualResultInfo.getShiJiAccrual());
        objectValue.setWeixiaoheAmt(accrualResultInfo.getUnVerifyAmt());
        objectValue.setYichongxiaoAmt(accrualResultInfo.getStrikedAmt());
        objectValue.setIntervalDays(accrualResultInfo.getDays().intValue());
    }
}

