/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculator;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.fm.common.util.AccrualResultInfo;
import com.kingdee.eas.fm.td.AccrualCalculatorPropertyUtil;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.IntReceivedStatusEnum;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class IntReceiveHelper {
    private static IntReceiveHelper intReceiveHelper;
    private Date selectedDateInScopeUI;
    private TimeDepositHelper helper;

    public IntReceivedBillInfo createIntReceiveBillToBeSaved(Context ctx, IntReceivedBillInfo objectValue, TimeDepositBillInfo timeDepositBillInfo, Date date) throws EASBizException, BOSException {
        this.selectedDateInScopeUI = date;
        this.initIntReceiveBill(ctx, objectValue, timeDepositBillInfo, date);
        return objectValue;
    }

    private void initIntReceiveBill(Context ctx, IntReceivedBillInfo objectValue, TimeDepositBillInfo timeDepositBillInfo, Date endDate) throws EASBizException, BOSException {
        objectValue.setCompany(timeDepositBillInfo.getDepositCompany());
        objectValue.setCreator(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
        objectValue.setSrcBillID(timeDepositBillInfo.getId().toString());
        objectValue.setHasEffected(false);
        objectValue.setEffectedStatus(IntReceivedStatusEnum.TEMPSTORE);
        objectValue.setIsAddedByReceive(false);
        objectValue.setComInterstBillID(null);
        objectValue.setBizDate(DateUtil.getDayBegin());
        objectValue.setCorpCurAcct(timeDepositBillInfo.getBankCurAcct());
        objectValue.setCreYearRate(timeDepositBillInfo.getCurYearRate());
        objectValue.setTimeDepositBillID(timeDepositBillInfo);
        objectValue.setSrcBillID(timeDepositBillInfo.getId().toString());
        objectValue.setEffectiveDate(this.calcuEffectiveDate(timeDepositBillInfo));
        objectValue.setEndDate(this.calcuMarturity(timeDepositBillInfo));
        if (objectValue.getEffectiveDate().compareTo(objectValue.getEndDate()) > 0) {
            throw new TDException(TDException.INT_PRE_ERROR, new String[]{timeDepositBillInfo.getNumber()});
        }
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.PRE_DRAWING);
        objectValue.setBank(timeDepositBillInfo.getDepositBank());
        objectValue.setCurrency(timeDepositBillInfo.getCurrency());
        BigDecimal floorAmt = timeDepositBillInfo.getFloorAmt() == null ? Constants.ZERO : timeDepositBillInfo.getFloorAmt();
        objectValue.setDepositAmt(timeDepositBillInfo.getBalance().subtract(floorAmt));
        IContextHelper contextHelper = null;
        contextHelper = ctx == null ? ContextHelperFactory.getRemoteInstance() : ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo currencyCompany = contextHelper.getCurrentCompany();
        boolean param_FT001 = contextHelper.getBooleanParam("TD001", (IObjectPK)new ObjectUuidPK(currencyCompany.getId()));
        objectValue.setDepYearRate(this.calcuYearRate_Redeposit(ctx, timeDepositBillInfo, objectValue.getEndDate()));
        objectValue.setIsChongzhang(false);
        objectValue.setDigest(timeDepositBillInfo.getNumber() + " " + objectValue.getIntReceiveType().getAlias());
        objectValue.setYearDays(timeDepositBillInfo.getYearDays());
        objectValue.setIntRateTypeExpression(timeDepositBillInfo.getIntRateTypeExpression());
        objectValue.setLastIntDate(timeDepositBillInfo.getLastRecvIntDay());
        AccrualCalculatorElementNeededInfo aceni = new AccrualCalculatorElementNeededInfo();
        aceni.setCustomerEndDate(endDate);
        AccrualCalculatorPropertyUtil.copyPropertiesValue(ctx, aceni, (CoreBaseInfo)timeDepositBillInfo, objectValue.getIntReceiveType());
        aceni.setFloorAmt(timeDepositBillInfo.getFloorAmt());
        aceni.setBizDate(objectValue.getEndDate());
        aceni.setCurrency(objectValue.getCurrency());
        try {
            AccrualResultInfo info = AccrualCalculator.getInstance((AccrualCalculatorElementNeededInfo)aceni).doCalculate(ctx, (CoreBaseInfo)objectValue);
            AccrualCalculatorPropertyUtil.copyResultToIntBillInfo((CoreBaseInfo)objectValue, info);
        }
        catch (FMException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    private Date calcuMarturity(TimeDepositBillInfo info) {
        Date endDate = this.selectedDateInScopeUI;
        if (null != info.getMaturityDay() && info.getMaturityDay().before(this.selectedDateInScopeUI)) {
            endDate = info.getMaturityDay();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        c.add(5, -1);
        return DateTimeUtils.truncateDate((Date)c.getTime());
    }

    private Date calcuEffectiveDate(TimeDepositBillInfo info) {
        Date returnDate = info.getEffectiveDate();
        if (null != info.getLastRecvIntDay() && info.getEffectiveDate().before(info.getLastRecvIntDay())) {
            returnDate = info.getLastRecvIntDay();
        }
        return DateTimeUtils.truncateDate((Date)returnDate);
    }

    private BigDecimal calcuYearRate_Redeposit(Context ctx, TimeDepositBillInfo info, Date date) {
        BigDecimal returnValue = Constants.ZERO;
        if (info.getTimeDepositType().getValue().equals("timedeposit") || info.getTimeDepositType().getValue().equals("timedeposit_outer")) {
            returnValue = info.getYearRate();
        } else if (info.getTimeDepositType().getValue().equals("calldeposit") || info.getTimeDepositType().getValue().equals("calldeposit_outer")) {
            try {
                IntReceiveHelper intReceiveHelper = this;
                returnValue = intReceiveHelper.helper.getInstance().calcYearRate(ctx, info.getIntRateTable(), info.getCurrency(), date);
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e.getCause());
            }
        }
        return returnValue;
    }

    public static IntReceiveHelper getInstance() {
        if (intReceiveHelper == null) {
            intReceiveHelper = new IntReceiveHelper();
        }
        return intReceiveHelper;
    }
}

