/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.fm.im.TermTypeEnum;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.client.DepositBillWarnUI;
import com.kingdee.eas.fm.td.client.IntReceivedBillEditUI;
import com.kingdee.eas.fm.td.client.TimeDepositBillEditUI;
import com.kingdee.eas.fm.td.client.TimeDepositBillListUI;
import com.kingdee.eas.fm.td.client.UnTimeDepositBillEditUI;
import com.kingdee.eas.fm.td.client.UnTimeDepositBillListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TimeDepositHelper {
    private static String RESOURCE_PATH = "com.kingdee.eas.fm.td.client.TdResource";
    private static final Logger logger = CoreUIObject.getLogger(TimeDepositHelper.class);
    private static TimeDepositHelper instance;
    private static final int SCALE = 5;
    private final BigDecimal HUNDRED = new BigDecimal(String.valueOf(100));
    private static String BILL_OPR_TYPE_RTD;

    private TimeDepositHelper() {
    }

    public static TimeDepositHelper getInstance() {
        if (instance == null) {
            instance = new TimeDepositHelper();
        }
        return instance;
    }

    public String getResourcePath() {
        return RESOURCE_PATH;
    }

    public String getDateMsg() {
        return "endDateMustGreateThanStartDate";
    }

    public String getBillOprType(int type) {
        if (1 == type) {
            return "RTD";
        }
        return "ISHIS";
    }

    public BigDecimal calcMatureIntAmt(BigDecimal depositAmt, BigDecimal yearrate, IntTermInfo intterm, IntRateTypeInfo intType) {
        if (intterm == null || depositAmt == null || yearrate == null) {
            return new BigDecimal(String.valueOf(0));
        }
        int factor = 360;
        if (intType != null) {
            factor = intType.getFactorDay();
        }
        if (intterm.getType() == TermTypeEnum.MONTH) {
            factor = 12;
        } else if (intterm.getType() == TermTypeEnum.YEAR) {
            factor = 1;
        }
        return depositAmt.multiply(yearrate).multiply(new BigDecimal(String.valueOf(intterm.getTerm()))).divide(new BigDecimal(String.valueOf(factor)), 5, 4);
    }

    public Date calcMaturityDay(Date startday, IntTermInfo intterm) {
        if (intterm == null || startday == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        Calendar b = Calendar.getInstance();
        c.setTime(startday);
        b.setTime(startday);
        if (intterm.getType() == TermTypeEnum.DAY) {
            c.add(5, intterm.getTerm());
        } else if (intterm.getType() == TermTypeEnum.YEAR) {
            c.add(1, intterm.getTerm());
        } else {
            c.add(2, intterm.getTerm());
        }
        return DateTimeUtils.truncateDate((Date)c.getTime());
    }

    public BigDecimal calcYearRate(Context ctx, IntRateTypeInfo intType, CurrencyInfo currency, Date date) throws Exception {
        if (intType == null) {
            return null;
        }
        BigDecimal yearRate = this.getYearRateFromRateTable(ctx, date, currency.getId().toString(), intType.getId().toString());
        return yearRate;
    }

    private BigDecimal getYearRateFromRateTable(Context ctx, Date endDate, String currencyID, String typeID) throws BOSException, SQLException {
        BigDecimal yearRate = Constants.ZERO;
        String dateStr = FMConstants.FORMAT_TIME.format(endDate);
        String billState = IntRateStateEnum.AUDITED.getValue();
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 a.fid, a.fyearRate, a.ftypeid, b.ffactor ");
        sql.append("from t_int_IntRateBase as a left outer join t_int_intRateType as b on a.fTypeId = b.fid ");
        sql.append("where a.feffectiveDate <= {" + dateStr + "} and a.fcurrencyid = '" + currencyID + "' and a.ftypeid = '" + typeID + "' and a.fbillState = '" + billState + "' and FIntTermID  is null ");
        sql.append("order by a.feffectiveDate desc");
        IRowSet rs = null;
        rs = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL() : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
        if (rs.next()) {
            yearRate = rs.getBigDecimal(2);
        }
        return yearRate;
    }

    public int getExRatePrec(String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        if (srcCurrId == null || date == null) {
            return 0;
        }
        ExchangeRateInfo exRateInfo = this.getExRateInfo(srcCurrId, destCurrId, company, date);
        if (exRateInfo != null) {
            return exRateInfo.getPrecision();
        }
        return 0;
    }

    public int calcuIntervalDays(Date endDate, Date effectiveDate) {
        long days = DateUtil.dateDiff((String)"d", (Date)effectiveDate, (Date)endDate);
        return new Long(days).intValue();
    }

    public ExchangeRateInfo getExRateInfo(String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        ExchangeTableInfo baseExchangeTable;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (destCurrId == null) {
            destCurrId = company.getBaseCurrency().getId().toString();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        ExchangeRateInfo exRateInfo = null;
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getRemoteInstance();
            exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return exRateInfo;
    }

    private BigDecimal getExchangeRate(ExchangeTableInfo baseExchangeTable, CurrencyInfo sourceCur, CurrencyInfo desCur, Date date) throws Exception {
        if (baseExchangeTable == null || sourceCur == null || desCur == null || date == null) {
            return Constants.ONE;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCur.getId());
        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (erInfo != null) {
            if (erInfo.getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                return erInfo.getConvertRate();
            }
            return Constants.ONE.divide(erInfo.getConvertRate(), erInfo.getPrecision());
        }
        return Constants.ONE;
    }

    public boolean isLocalCurrency(CurrencyInfo currency, CompanyOrgUnitInfo company) {
        boolean isLocCurrency = false;
        if (currency == null) {
            return isLocCurrency;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        CurrencyInfo localCurrency = company.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId())) {
            isLocCurrency = true;
        }
        return isLocCurrency;
    }

    public BigDecimal getExchangeRate(CurrencyInfo srcCurr, CompanyOrgUnitInfo company, Date date) throws Exception {
        if (srcCurr == null || date == null) {
            return null;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (this.isLocalCurrency(srcCurr, company)) {
            return Constants.ONE;
        }
        ExchangeRateInfo exRateInfo = this.getExRateInfo(srcCurr, null, company, date = DateTimeUtils.truncateDate((Date)date));
        if (exRateInfo == null) {
            return Constants.ONE;
        }
        return exRateInfo.getConvertRate();
    }

    public ExchangeRateInfo getExRateInfo(CurrencyInfo srcCurr, CurrencyInfo destCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        ExchangeTableInfo baseExchangeTable;
        if (srcCurr == null || date == null) {
            return null;
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (destCurr == null) {
            destCurr = company.getBaseCurrency();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((Date)date);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurr.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurr.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return exRateInfo;
    }

    public void showReDeopsitWindow(CoreUIObject ui, String selectedValue, int type) throws UIException, EASBizException {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"ID", (Object)selectedValue);
            uiContext.put((Object)"hisOrRtd", (Object)this.getBillOprType(type));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(TimeDepositBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    public Map showIntReceiveEditUI(CoreUIObject ui, Object info, String intbill_redeposit_value, String sourceBillID) {
        if (info instanceof TimeDepositBillInfo) {
            return this.showIntReceiveEditUI_Redepost(ui, (TimeDepositBillInfo)info, intbill_redeposit_value, sourceBillID);
        }
        if (info instanceof UnTimeDepositBillInfo) {
            return this.showIntReceiveEditUI_UnDeposit(ui, (UnTimeDepositBillInfo)info, intbill_redeposit_value, sourceBillID);
        }
        return new HashMap();
    }

    private Map showIntReceiveEditUI_UnDeposit(CoreUIObject ui, UnTimeDepositBillInfo info, String intbill_redeposit_value, String sourceBillID) {
        Map successhm = null;
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"sourceTimeBillID", (Object)sourceBillID);
            uiContext.put((Object)"UnDipositID", (Object)info);
            uiContext.put((Object)"intType", (Object)intbill_redeposit_value);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IntReceivedBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            successhm = ((IntReceivedBillEditUI)uiWindow.getUIObject()).getSubmitStatus();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort();
        }
        return successhm;
    }

    private Map showIntReceiveEditUI_Redepost(CoreUIObject ui, TimeDepositBillInfo info, String intbill_redeposit_value, String sourceBillID) {
        Map successStatus = null;
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"sourceTimeBillID", (Object)sourceBillID);
            uiContext.put((Object)"ObjectInfo_ID", (Object)info);
            uiContext.put((Object)"intType", (Object)intbill_redeposit_value);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IntReceivedBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            successStatus = ((IntReceivedBillEditUI)uiWindow.getUIObject()).getSubmitStatus();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        return successStatus;
    }

    public void showUnDeopsitHisWindow(UnTimeDepositBillListUI ui, String selectedKeyValue, int i) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"isHisUnDeposit", (Object)"1");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UnTimeDepositBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    public void showWarnningWindow(TimeDepositBillListUI ui, IRowSet data) {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"data", (Object)data);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DepositBillWarnUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public BigDecimal calcMatureIntAmt(BigDecimal depositAmt, BigDecimal yearrate, BigDecimal yearDays, BigDecimal intervalDays, BigDecimal base) {
        BigDecimal tmp1 = depositAmt.multiply(yearrate).multiply(intervalDays);
        BigDecimal tmp2 = yearDays.multiply(base);
        return tmp1.divide(tmp2, 5, 4);
    }

    public boolean value_TD001(CompanyOrgUnitInfo currencyCompany) {
        IContextHelper iContextHelper = ContextHelperFactory.getRemoteInstance();
        boolean param_TD001 = iContextHelper.getBooleanParam("TD001", (IObjectPK)new ObjectUuidPK(currencyCompany.getId()));
        return param_TD001;
    }

    public boolean value_TD001_server(Context ctx, CompanyOrgUnitInfo currencyCompany) {
        IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean param_TD001 = iContextHelper.getBooleanParam("TD001", (IObjectPK)new ObjectUuidPK(currencyCompany.getId()));
        return param_TD001;
    }

    public Date getMaxDate(List li) {
        Date beginDate = null;
        Date tmp = null;
        try {
            beginDate = DateTimeUtils.parseDate((String)"1900-01-01");
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        for (int i = 0; i < li.size(); ++i) {
            tmp = (Date)li.get(i);
            if (tmp == null || tmp.compareTo(beginDate) < 0) continue;
            beginDate = tmp;
        }
        return beginDate;
    }

    public Date getMinDate(List li) {
        Date beginDate = null;
        Date tmp = null;
        try {
            beginDate = DateTimeUtils.parseDate((String)"2999-01-01");
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        for (int i = 0; i < li.size(); ++i) {
            tmp = (Date)li.get(i);
            if (tmp == null || tmp.compareTo(beginDate) > 0) continue;
            beginDate = tmp;
        }
        return beginDate;
    }

    public String parseValue(Set setIDs) {
        StringBuffer returnSb = new StringBuffer();
        Object[] ids = setIDs.toArray();
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                returnSb.append(ids[i].toString());
                continue;
            }
            returnSb.append(ids[i].toString()).append(",");
        }
        return returnSb.toString();
    }

    static {
        BILL_OPR_TYPE_RTD = "RTD";
    }
}

