/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMTDBOSQueryDelegate;
import com.kingdee.eas.fm.common.util.TDUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class IntReceiveDataProvider
extends FMTDBOSQueryDelegate {
    private static final Logger logger = CoreUIObject.getLogger(IntReceiveDataProvider.class);
    private KDTable tblMain;

    public IntReceiveDataProvider(List idList, KDTable tblMain) {
        this.tblMain = tblMain;
    }

    public IMetaDataPK getQueryPK() {
        return null;
    }

    public EntityViewInfo getEntityViewInfo(BOSQueryDataSource ds) {
        return null;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        if (this.tblMain != null) {
            try {
                TDUtils t = new TDUtils();
                IRowSet iRowSet = t.kdTableSelectRow2RowSet(this.tblMain, null);
                while (iRowSet.next()) {
                    this.dealRowSet(iRowSet);
                }
                iRowSet.beforeFirst();
                return iRowSet;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SysUtil.abort((Throwable)e);
            }
        } else {
            return super.execute(ds);
        }
        return null;
    }

    protected void dealRowSet(IRowSet rowSet) throws SQLException {
        String currencyID = rowSet.getString("currency.id");
        int precision = 2;
        try {
            precision = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID)).getPrecision();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        rowSet.updateString("amt", this.setPrecision(rowSet.getString("amt"), precision));
        rowSet.updateString("deInterest", this.setPrecision(rowSet.getString("deInterest"), precision));
        rowSet.updateString("creInterest", this.setPrecision(rowSet.getString("creInterest"), precision));
        rowSet.updateString("yingjiAmt", this.setPrecision(rowSet.getString("yingjiAmt"), precision));
        rowSet.updateString("shijiAmt", this.setPrecision(rowSet.getString("shijiAmt"), precision));
    }

    private String setPrecision(String value, int precision) {
        BigDecimal b = FMHelper.parseBigDecimal((String)value);
        b = b.setScale(precision, 4);
        return b.toString();
    }
}

