/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.fm.td.client.AbstractRptTimeDepositBalanceFilterUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class RptTimeDepositBalanceFilterUI
extends AbstractRptTimeDepositBalanceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositBalanceFilterUI.class);
    private CurrencyInfo baseCurrency;

    public RptTimeDepositBalanceFilterUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    }

    protected void init() throws Exception {
        super.init();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
    }

    public void clear() {
        super.clear();
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        this.comboUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
        this.prmtBank.setValue(null);
    }

    private void customInit() {
        this.initCurrency();
        this.initDate();
        this.initBillType();
        this.initStatisticalUnit();
        this.intQueryType();
        this.initAmt();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboCurrency.setSelectedItem((Object)this.baseCurrency);
    }

    public boolean verify() {
        if (this.comboUnit.getSelectedItem() == null) {
            this.comboUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
        }
        this.checkAmtValid();
        return super.verify();
    }

    private void checkAmtValid() {
        if (this.kdftAmtFrom.getBigDecimalValue().compareTo(this.kdftAmtTo.getBigDecimalValue()) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"23_RptTimeDepositBalanceFilterUI"));
            SysUtil.abort();
        }
    }

    private void initDate() {
        this.dpEndDate.setSupportedEmpty(false);
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
    }

    private void initBillType() {
        this.cboType.removeAllItems();
        this.cboType.addItems(TimeDepositTypeEnum.getEnumList().toArray());
        this.cboType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboType.setSelectedItem((Object)TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
    }

    private void initStatisticalUnit() {
        this.comboUnit.removeAllItems();
        this.comboUnit.addItems(StatisticalUnitEnum.getEnumList().toArray());
        this.comboUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
    }

    private void intQueryType() {
        this.rdByBank.setSelected(true);
    }

    private void initAmt() {
        this.kdftAmtFrom.setPrecision(2);
        this.kdftAmtTo.setPrecision(2);
        this.kdftAmtFrom.setSupportedEmpty(false);
        this.kdftAmtTo.setSupportedEmpty(false);
        this.kdftAmtFrom.setMinimumValue((Comparable)Constants.ZERO);
        this.kdftAmtTo.setMinimumValue((Comparable)Constants.ZERO);
        this.kdftAmtFrom.setValue((Object)Constants.ZERO);
        this.kdftAmtTo.setValue((Object)Constants.ZERO);
    }

    public Object getParam() {
        RptTimeDepositBalanceFilterParam filterParam = new RptTimeDepositBalanceFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        filterParam.setEndDate(this.dpEndDate.getSqlDate());
        filterParam.setCurrencyIDs(this.getCurrencyParam());
        Object obj = this.cboType.getSelectedItem();
        if (obj instanceof TimeDepositTypeEnum) {
            filterParam.setTimeDepositType((TimeDepositTypeEnum)obj);
        } else {
            filterParam.setTimeDepositType(null);
        }
        filterParam.setBankIDs(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBank));
        filterParam.setStatisticalUnit((StatisticalUnitEnum)((Object)this.comboUnit.getSelectedItem()));
        filterParam.setAmtFrom(this.kdftAmtFrom.getBigDecimalValue());
        filterParam.setAmtTo(this.kdftAmtTo.getBigDecimalValue());
        if (this.rdByBank.isSelected()) {
            filterParam.setQueryType("By_Bank");
        } else if (this.rdByCompany.isSelected()) {
            filterParam.setQueryType("By_Company");
        } else if (this.rdByCurrency.isSelected()) {
            filterParam.setQueryType("By_Currency");
        }
        filterParam.setRateCurrencyInfo((CurrencyInfo)this.prmtCurrency.getData());
        return filterParam;
    }

    private String[] getCurrencyParam() {
        String[] currencyIds = null;
        Object currencySelected = this.comboCurrency.getSelectedItem();
        if (currencySelected instanceof CurrencyInfo) {
            CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            currencyIds = new String[]{info.getId().toString()};
        } else {
            currencyIds = null;
        }
        return currencyIds;
    }

    protected Class getParamClass() {
        return RptTimeDepositBalanceFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        RptTimeDepositBalanceFilterParam filterParam = (RptTimeDepositBalanceFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        try {
            if (filterParam.getCurrencyIDs() != null && filterParam.getCurrencyIDs()[0] != null) {
                String selectedId = filterParam.getCurrencyIDs()[0];
                this.comboCurrency.setSelectedItem((Object)this.getSelectCurrency(selectedId));
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
            this.prmtBank.setValue((Object)this.getBaseInfoFromIdSet(FMHelper.asSet((String[])filterParam.getBankIDs())));
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
        if (filterParam.getTimeDepositType() != null) {
            this.cboType.setSelectedItem((Object)filterParam.getTimeDepositType());
        } else {
            this.cboType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.comboUnit.setSelectedItem((Object)filterParam.getStatisticalUnit());
        this.kdftAmtFrom.setValue((Object)filterParam.getAmtFrom());
        this.kdftAmtTo.setValue((Object)filterParam.getAmtTo());
        if ("By_Bank".equals(filterParam.getQueryType())) {
            this.rdByBank.setSelected(true);
        } else if ("By_Company".equals(filterParam.getQueryType())) {
            this.rdByCompany.setSelected(true);
        } else if ("By_Currency".equals(filterParam.getQueryType())) {
            this.rdByCurrency.setSelected(true);
        }
    }

    private CurrencyInfo getSelectCurrency(String selectedId) {
        CurrencyInfo currencyInfo = null;
        try {
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(selectedId));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ExceptionHandler.handle((Throwable)e.getCause());
        }
        return currencyInfo;
    }

    @Override
    protected void kdtHistory_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kdtHistory.isSelected()) {
            this.prmtCurrency.setEnabled(false);
            this.prmtCurrency.setData(null);
        }
    }

    @Override
    protected void kdtCurrent_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kdtCurrent.isSelected()) {
            this.prmtCurrency.setEnabled(true);
            BOSUuid id = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency().getId();
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
            this.prmtCurrency.setData((Object)currency);
        }
    }
}

