/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.td.client.AbstractRptTimeDepositBalanceUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceByBankHandler;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceByComoanyHandler;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceByCurrencyHandler;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceFilterParam;
import com.kingdee.eas.fm.td.client.RptTimeDepositBalanceFilterUI;
import com.kingdee.eas.fm.td.client.RptTimeDepositHandlerAdapter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RptTimeDepositBalanceUI
extends AbstractRptTimeDepositBalanceUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositBalanceUI.class);
    private FMFilterBaseUI filterUI;

    public void onLoad() throws Exception {
        super.onLoad();
        this.pkEndDate.setEnabled(false);
        this.txtUnit.setEnabled(false);
        this.tblMain.setColumnMoveable(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("id").getValue();
        if (id == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptTimeDepositBalanceFilterUI();
        }
        return this.filterUI;
    }

    protected void execQuery() throws BOSException {
        this.tblMain.checkParsed();
        RptTimeDepositBalanceFilterParam filterParam = (RptTimeDepositBalanceFilterParam)this.getFilterParam();
        this.showHead(filterParam);
        int groupType = filterParam.getType();
        IFMDetailRptHandler handler = this.getBizHander(filterParam, groupType);
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        handler.endDataFill();
        this.tblMain.setColumnMoveable(false);
        CurrencyInfo rateCurrencyInfo = filterParam.getRateCurrencyInfo();
        if (rateCurrencyInfo != null) {
            this.kDLabel1.setVisible(true);
            this.kDLabel2.setVisible(true);
            this.kDLabel2.setText(rateCurrencyInfo.getName());
            int headRowCount = this.tblMain.getHeadRowCount();
            int columnCount = this.tblMain.getColumnCount();
            for (int i = 0; i < headRowCount; ++i) {
                IRow headRow = this.tblMain.getHeadRow(i);
                for (int j = 0; j < columnCount; ++j) {
                    Object headValue = headRow.getCell(j).getValue();
                    if (headValue == null || headValue.toString().indexOf("\u6298\u672c\u4f4d\u5e01") < 0) continue;
                    String replace = headValue.toString().replace("\u6298\u672c\u4f4d\u5e01", "\u6298\u67e5\u8be2\u5e01\u522b");
                    headRow.getCell(j).setValue((Object)replace);
                }
            }
        } else {
            this.kDLabel1.setVisible(false);
            this.kDLabel2.setVisible(false);
        }
    }

    private IFMDetailRptHandler getBizHander(RptTimeDepositBalanceFilterParam filterParam, int groupType) {
        RptTimeDepositHandlerAdapter handler = null;
        switch (groupType) {
            case 0: {
                handler = new RptTimeDepositBalanceByBankHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            case 1: {
                handler = new RptTimeDepositBalanceByComoanyHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            case 2: {
                handler = new RptTimeDepositBalanceByCurrencyHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            default: {
                handler = new RptTimeDepositBalanceByBankHandler(this.tblMain, filterParam.getFilter(), filterParam);
            }
        }
        return handler;
    }

    private void showHead(RptTimeDepositBalanceFilterParam filterParam) {
        this.pkEndDate.setValue((Object)filterParam.getEndDate());
        this.txtUnit.setText(filterParam.getStatisticalUnit().getAlias());
    }
}

