/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.fm.td.TimeDepositTypeEnum;
import com.kingdee.eas.fm.td.client.AbstractRptTimeDepositSumFilterUI;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Container;
import java.sql.Date;
import org.apache.log4j.Logger;

public class RptTimeDepositSumFilterUI
extends AbstractRptTimeDepositSumFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositSumFilterUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.setProperty("companyIdSet", (Object)this.companyIdSet);
        rm.setProperty("startDate", (Object)this.dpStartDate.getSqlDate());
        rm.setProperty("endDate", (Object)this.dpEndDate.getSqlDate());
        rm.setProperty("currency", this.cboCurrency.getSelectedItem());
        rm.setProperty("depositType", this.cboType.getSelectedItem());
        rm.setProperty("bankIDS", (Object)AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBank));
        rm.setProperty("amountUnit", this.jtAmountUnit.getSelectedItem());
        rm.setProperty("companyIDS", (Object)this.companyIdSet);
        if (this.rdByBank.isSelected()) {
            rm.setProperty("queryType", (Object)"byBank");
        } else if (this.rbCompany.isSelected()) {
            rm.setProperty("queryType", (Object)"byCompany");
        } else {
            rm.setProperty("queryType", (Object)"byCurrency");
        }
        rm.recordAllStatus((Container)((Object)this));
        return rm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rm = new RptConditionManager(params);
        rm.restoreAllStatus((Container)((Object)this));
        super.setCustomCondition(params);
    }

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.initCustomed();
    }

    private void initCustomed() {
        this.initCurrency();
        this.initBillType();
        this.initDate();
        this.initStatisticalUnit();
        this.intQueryType();
        this.prmtBank.setValue(null);
    }

    public void clear() {
        super.clear();
        this.initCustomed();
    }

    private void intQueryType() {
        this.rdByBank.setSelected(true);
    }

    private void initStatisticalUnit() {
        this.jtAmountUnit.removeAllItems();
        this.jtAmountUnit.addItems(StatisticalUnitEnum.getEnumList().toArray());
        this.jtAmountUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
    }

    public void initDate() {
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.dpStartDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpEndDate.setValue((Object)new java.util.Date());
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.cboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboCurrency.setSelectedItem((Object)this.baseCurrency);
    }

    private void initBillType() {
        this.cboType.removeAllItems();
        this.cboType.addItems(TimeDepositTypeEnum.getEnumList().toArray());
        this.cboType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.cboType.setSelectedItem((Object)TimeDepositTypeEnum.TIMEDEPOSIT_INNER);
    }

    public boolean verify() {
        Date kdDateTo;
        Date kdDateFrom = this.dpStartDate.getSqlDate();
        if (kdDateFrom.compareTo(kdDateTo = this.dpEndDate.getSqlDate()) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"32_RptTimeDepositSumFilterUI"));
            SysUtil.abort();
        }
        if (this.jtAmountUnit.getSelectedItem() == null) {
            this.jtAmountUnit.setSelectedItem((Object)StatisticalUnitEnum.TEN_THOUSAND);
        }
        return super.verify();
    }
}

