/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.im.IntTermFactory;
import com.kingdee.eas.fm.im.IntTermInfo;
import com.kingdee.eas.fm.im.TermTypeEnum;
import com.kingdee.eas.fm.td.ITimeDepositBill;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillFilterParam;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.client.AbstractTimeDepositBillListUI;
import com.kingdee.eas.fm.td.client.ChooseCompDepositUI;
import com.kingdee.eas.fm.td.client.TDBillDataProvider;
import com.kingdee.eas.fm.td.client.TimeDepositBillEditUI;
import com.kingdee.eas.fm.td.client.TimeDepositBillFilterUI;
import com.kingdee.eas.fm.td.client.UnTimeDepositBillEditUI;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TimeDepositBillListUI
extends AbstractTimeDepositBillListUI {
    private CompanyOrgUnitInfo companyInfo;
    private static final Logger logger = CoreUIObject.getLogger(TimeDepositBillListUI.class);
    private static final String MATURITY_ACCURAL = "maturityAccural";
    private static final String BALANCE = "balance";
    private static final String DEPOSIT_AMT_LOCAL = "depositAmtLocal";
    private static final String FLOOR_AMT = "floorAmt";
    private static final String DEPOSIT_AMT = "depositAmt";
    public static final String OPER_COPY = "COPY";
    FillListener fillListener = new FillListener();
    private Boolean effectiveCanBeModify = new Boolean(false);
    private static TimeDepositBillFilterUI filterUI = null;
    private static final String TIMEDEPOSITBILL_FILENAME = "/FM/INVEST/TD/TIMEDEPOSIT";

    public TimeDepositBillListUI() throws Exception {
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionViewDoProccess.setEnabled(false);
        this.actionModifyCertificateNo.setEnabled(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionReDeposit.setEnabled(true);
        this.actionReDeposit.setVisible(true);
        this.actionCopy.setVisible(true);
        this.actionCopy.setEnabled(true);
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
        if (this.companyInfo == null || !this.companyInfo.isIsBizUnit()) {
            this.actionAddNew.setEnabled(false);
            this.actionAddHis.setEnabled(false);
            this.actionReceiveFromComp.setEnabled(false);
            this.actionCopy.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionAttachment.setEnabled(false);
            this.actionCreateTo.setEnabled(false);
            this.actionCopyTo.setEnabled(false);
            this.actionAccepted.setEnabled(false);
            this.actionVoucher.setEnabled(false);
            this.actionSignature.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionModifyCertificateNo.setEnabled(false);
            this.actionUnDeposit.setEnabled(false);
            this.actionReDeposit.setEnabled(false);
            this.actionBook.setEnabled(false);
            this.actionChgRec.setEnabled(false);
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionVoucher.setEnabled(false);
            this.btnDelVoucher.setEnabled(false);
        }
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionUnDeposit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
        this.actionReDeposit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_repeatcheck"));
        this.actionReceiveFromComp.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inceptreport"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionAddHis.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_new"));
        this.actionCopy.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
    }

    @Override
    public void actionUnDeposit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeUnDeposited();
        UnTimeDepositBillEditUI.showUnDeopsitWindow((CoreUIObject)this, this.getSelectedKeyValue());
        this.refresh(e);
    }

    @Override
    public void actionReDeposit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeRedeposit();
        ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
        try {
            this.setOprtState("userCustomerStatus");
            this.pubFireVOChangeListener(pk.toString());
            TimeDepositBillEditUI.showReDeopsitWindow((CoreUIObject)this, this.getSelectedKeyValue(), 1);
            this.setOprtState("RELEASEALL");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        this.refresh(e);
    }

    protected void checkCanBeRedeposit() throws Exception {
        TimeDepositBillInfo timeDepositBillInfo = this.getSelectObject();
        if (timeDepositBillInfo.getEffectedStatus() == EffectedStatusEnum.TEMPSTORE) {
            throw new TDException(TDException.NOT_REDEPOSIT_REASON1);
        }
        if (!timeDepositBillInfo.getTimeDepositType().getValue().equals("timedeposit") && !timeDepositBillInfo.getTimeDepositType().getValue().equals("timedeposit_outer")) {
            throw new TDException(TDException.NOT_REDEPOSIT_REASON4);
        }
        if (timeDepositBillInfo.getBalance().compareTo(Constants.ZERO) <= 0) {
            throw new TDException(TDException.NOT_REDEPOSIT_REASON3);
        }
        if (timeDepositBillInfo.isIsAddedByReceive()) {
            throw new TDException(TDException.NOT_REDEPOSIT_REASON5);
        }
    }

    @Override
    public void actionAddHis_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        TimeDepositBillInfo info = this.getSelectObject();
        if (info.isIsAddedByReceive()) {
            throw new TDException(TDException.BANK_RECEIVED_ERROR);
        }
        this.effectiveCanBeModify = new Boolean(this.hasBeenOperated(info.getId().toString()));
        if (this.effectiveCanBeModify.booleanValue() || info.getBalance().compareTo(Constants.ZERO) == 0) {
            throw new TDException(TDException.EDIT_ERROR);
        }
        super.actionEdit_actionPerformed(e);
    }

    protected boolean hasBeenOperated(String selectedValue) throws BOSException, SQLException {
        String sql = "select fid from t_td_intreceivedbill where FTimeDepositBillIDID = '" + selectedValue + "'";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        boolean hasInt = rs.next();
        if (hasInt) {
            return hasInt;
        }
        String sqlUndeposit = "select fid from T_TD_UnTimeDepositBill where FTimeDepositBillID = '" + selectedValue + "'";
        rs = SQLExecutorFactory.getRemoteInstance((String)sqlUndeposit).executeSQL();
        boolean hasBeenUndeposited = rs.next();
        return hasInt || hasBeenUndeposited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        TimeDepositBillInfo info = this.getSelectObject();
        if (info.getEffectedStatus() == EffectedStatusEnum.TEMPSTORE) {
            throw new TDException(TDException.CREATE_VOUCHER_EXC2);
        }
        if (info.isFivouchered()) {
            throw new TDException(TDException.CREATE_VOUCHER_EXC3);
        }
        if (info.isIsHistoryBill()) {
            throw new TDException(TDException.CREATE_VOUCHER_EXC4);
        }
        boolean requestSuccess = true;
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        try {
            requestSuccess = iMC.requestObjIDForUpdate(info.getId().toString());
            if (requestSuccess) {
                super.actionVoucher_actionPerformed(e);
            } else {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"lockInfo"));
            }
        }
        finally {
            if (requestSuccess) {
                iMC.releaseObjIDForUpdate(info.getId().toString());
            }
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    protected TimeDepositBillInfo getSelectObject() throws Exception {
        this.checkSelected();
        TimeDepositBillInfo info = ((ITimeDepositBill)this.getBizInterface()).getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        return info;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        TimeDepositBillInfo info = this.getSelectObject();
        if (info.isIsHistoryBill()) {
            boolean isRedepsited = info.isIsReDeposited();
            boolean isPreDrawed = info.isIsPreDraw();
            boolean isUnDeposited = info.isIsUnDeposit();
            if (isRedepsited || isPreDrawed || isUnDeposited) {
                throw new TDException(TDException.DELETE_EXC1);
            }
        } else if (info.isFivouchered()) {
            throw new TDException(TDException.DELETE_EXC2);
        }
        super.actionRemove_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionEdit)) {
            uiContext.put((Object)"effectedDateCanBeEdited", (Object)this.effectiveCanBeModify);
        }
        if (action.equals((Object)this.actionAddHis)) {
            uiContext.put((Object)"ISHIS", (Object)Boolean.TRUE);
        } else {
            uiContext.put((Object)"ISHIS", (Object)Boolean.FALSE);
        }
    }

    protected void checkCanBeUnDeposited() throws Exception {
        TimeDepositBillInfo timeDepositBillInfo = this.getSelectObject();
        if (timeDepositBillInfo.getEffectedStatus() == EffectedStatusEnum.TEMPSTORE) {
            throw new TDException(TDException.NOT_UNDEPOSIT_REASON1);
        }
        if (timeDepositBillInfo.getBalance().compareTo(Constants.ZERO) <= 0) {
            throw new TDException(TDException.NOT_UNDEPOSIT_REASON2);
        }
        if (timeDepositBillInfo.isIsAddedByReceive()) {
            throw new TDException(TDException.NOT_UNDEPOSIT_REASON3);
        }
    }

    private void checkMaxActiveTimes(TimeDepositBillInfo timeDepositBillInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ctrlStrategy.lowestBalance");
        sic.add("ctrlStrategy.maxActiveTimes");
        AccountBankInfo info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getBankDepAcct().getId()), sic);
        if (info.getCtrlStrategy() != null) {
            int maxActiveTimes = info.getCtrlStrategy().getMaxActiveTimes();
            if (maxActiveTimes == 0) {
                return;
            }
            int maxUndeNo = this.getMaxUnDepositSeqNo(timeDepositBillInfo.getId().toString());
            if (maxUndeNo == maxActiveTimes) {
                throw new TDException(TDException.UNDE_ERROR4);
            }
        }
    }

    private int getMaxUnDepositSeqNo(String id) throws BOSException {
        Map hm = UnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(id));
        Integer maxUndepositSeq = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
        return maxUndepositSeq;
    }

    @Override
    protected String getEditUIName() {
        return TimeDepositBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TimeDepositBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (filterUI == null) {
            filterUI = new TimeDepositBillFilterUI();
        }
        return filterUI;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTDPrint_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        TDBillDataProvider data = new TDBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(TIMEDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTDPrint_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        TDBillDataProvider data = new TDBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(TIMEDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private ArrayList filterList(ArrayList idList) throws Exception {
        ArrayList<String> li = new ArrayList<String>();
        TimeDepositBillInfo info = ((ITimeDepositBill)this.getBizInterface()).getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(idList.get(0).toString()));
        StringBuffer sb = new StringBuffer("select fid from t_td_timedepositbill where 1=1 and  ");
        sb.append(FMHelper.buildIn((String)"fid", (Object[])idList.toArray()));
        sb.append("and  FTimeDepositType='").append(info.getTimeDepositType().getValue()).append("'");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        while (rs.next()) {
            li.add(rs.getString(1));
        }
        return li;
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }

    private FilterInfo getUnTimeDepositFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(BALANCE, (Object)Constants.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("depositCompany.name", (Object)this.currentCompanyCommon.getName(), CompareType.EQUALS));
        return filter;
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return super.getDefaultFilterForQuery();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("accountant.id"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add("comDepositBillID");
        return sic;
    }

    @Override
    public void actionReceiveFromComp_actionPerformed(ActionEvent e) throws Exception {
        Map hm = ChooseCompDepositUI.showChooseCompDepositUI((CoreUI)this);
        if (hm == null) {
            SysUtil.abort();
        } else {
            Set setIDs = (Set)hm.get("receivedBillId");
            if (setIDs != null) {
                String includeValue = TimeDepositHelper.getInstance().parseValue(setIDs);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
                this.mainQuery.setFilter(filter);
                this.refresh(e);
            }
        }
    }

    public FilterInfo getFilterInfo() {
        if (this.getUIContext().get("BTPEDITPARAMETER") == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(BALANCE, (Object)Constants.ZERO, CompareType.GREATER));
        Map btpMap = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (btpMap != null && btpMap.get("FROME") != null) {
            if (btpMap.get("FROME").equals("UnTimeDepositApplyBill")) {
                filter.getFilterItems().add(new FilterItemInfo("depositCompany.id", btpMap.get("COMPANYID"), CompareType.EQUALS));
            }
        } else if (btpMap != null && btpMap.get("TargetBillType") != null && btpMap.get("TargetBillType").equals("TimeDeposit")) {
            filter.getFilterItems().add(new FilterItemInfo("depositCompany.id", (Object)this.companyInfo.getId(), CompareType.EQUALS));
        }
        return filter;
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.companyInfo)) {
            super.actionTraceDown_actionPerformed(e);
            return;
        }
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList<String> list = new ArrayList<String>();
        String id = (String)idList.get(0);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)id, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("destObjectID");
        evi.setFilter(filter);
        evi.setSelector(sic);
        BOTRelationCollection botRelaCollection = BOTRelationFactory.getRemoteInstance().getCollection(evi);
        int size = botRelaCollection.size();
        for (int index = 0; index < size; ++index) {
            list.add(botRelaCollection.get(index).getDestObjectID().toString());
        }
        if (list == null || list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"64_TimeDepositBillListUI"));
            SysUtil.abort();
        }
        String[] billIds = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            billIds[i] = ((String)list.get(i)).toString();
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String[])billIds, (CompanyOrgUnitInfo)this.companyInfo);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            if (this.mainQuery.getFilter() != null) {
                FilterItemCollection filterItems = this.mainQuery.getFilter().getFilterItems();
                for (int i = 0; i < filterItems.size(); ++i) {
                    FilterItemInfo filterItem = filterItems.get(i);
                    if (!filterItem.getPropertyName().equalsIgnoreCase("timeDepositType")) continue;
                    String timeDepositType = filterItem.getCompareValue().toString();
                    if ("timedeposit".equals(timeDepositType) || "timedeposit_outer".equals(timeDepositType)) {
                        System.out.println(1);
                        this.tblMain.getColumn("depositType").getStyleAttributes().setHided(true);
                        this.tblMain.getColumn("intTerm").getStyleAttributes().setHided(false);
                    }
                    if (!"calldeposit".equals(timeDepositType) && !"calldeposit_outer".equals(timeDepositType)) continue;
                    System.out.println(2);
                    this.tblMain.getColumn("intTerm").getStyleAttributes().setHided(true);
                    this.tblMain.getColumn("depositType").getStyleAttributes().setHided(false);
                }
            }
            TimeDepositBillFilterParam param = (TimeDepositBillFilterParam)((Object)this.getFilterUI().getParam());
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrency());
            String[] columns = new SumFiledsInfo(SumBillEnum.TimeDep).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionModifyCertificateNo_actionPerformed(ActionEvent e) throws Exception {
        TimeDepositBillEditUI.showModifyCertificateNoWindow((CoreUIObject)this, this.getSelectedKeyValue());
        this.refresh(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        int rowIndex = e.getRowIndex();
        if (rowIndex != -1) {
            IRow row = this.tblMain.getRow(rowIndex);
            if (((Boolean)row.getCell("isUnDeposit").getValue()).booleanValue() && "2".equals(((BizEnumValueDTO)row.getCell("status").getValue()).getString())) {
                this.btnModifyCertificateNo.setEnabled(true);
            } else {
                this.btnModifyCertificateNo.setEnabled(false);
            }
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)OPER_COPY, (Object)OPER_COPY);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "effectiveDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove"};
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(TimeDepositBillListUI.this.tblMain, e);
            TimeDepositBillListUI.this.formatFootRow();
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                BizEnumValueInfo exp;
                row = tblMain.getRow(i);
                currencyId = (String)row.getCell("currency.id").getValue();
                this.calcMaturityAccrual(row);
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)TimeDepositBillListUI.DEPOSIT_AMT, (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)TimeDepositBillListUI.FLOOR_AMT, (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)TimeDepositBillListUI.DEPOSIT_AMT_LOCAL, (String)TimeDepositBillListUI.this.companyInfo.getBaseCurrency().getId().toString());
                    FMClientHelper.setNumberFormat((IRow)row, (String)TimeDepositBillListUI.BALANCE, (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)TimeDepositBillListUI.MATURITY_ACCURAL, (String)currencyId);
                }
                if (!FMHelper.isEmpty((Object)(exp = (BizEnumValueInfo)row.getCell("rateExpression").getValue()))) {
                    Object enu = exp.getValue();
                    if ("year".equalsIgnoreCase(enu.toString())) {
                        row.getCell("baseRate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                        row.getCell("yearRate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                        row.getCell("currYearRate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                    } else {
                        row.getCell("baseRate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
                        row.getCell("yearRate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
                        row.getCell("currYearRate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
                    }
                }
                row.getCell("yearRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("currYearRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("exchangeRate").getStyleAttributes().setNumberFormat("%r-[]0.4n");
                row.getCell("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }

        private void calcMaturityAccrual(IRow row) {
            BizEnumValueInfo depositType;
            Boolean isAddByRe = (Boolean)row.getCell("isAddedByReDeposit").getValue();
            if (isAddByRe.booleanValue() && ((depositType = (BizEnumValueInfo)row.getCell("depositType").getValue()).getValue().equals("timedeposit") || depositType.getValue().equals("timedeposit_outer"))) {
                Integer yearDays = (Integer)row.getCell("yearDays").getValue();
                BizEnumValueInfo rateExpression = (BizEnumValueInfo)row.getCell("rateExpression").getValue();
                BigDecimal base = Constants.ZERO;
                base = rateExpression.getValue().equals("year") ? Constants.ONE_HUNDRED : Constants.ONE_THOUSAND;
                BigDecimal depositAmt = (BigDecimal)row.getCell(TimeDepositBillListUI.DEPOSIT_AMT).getValue();
                Date startDate = (Date)row.getCell("startDate").getValue();
                Date endDate = (Date)row.getCell("endDate").getValue();
                BigDecimal yearValue = (BigDecimal)row.getCell("yearRate").getValue();
                int intervalDays = TimeDepositHelper.getInstance().calcuIntervalDays(endDate, startDate);
                if (TimeDepositHelper.getInstance().value_TD001(TimeDepositBillListUI.this.companyInfo) && !EmptyUtil.isEmpty((Object)row.getCell("intTerm")) && !EmptyUtil.isEmpty((Object)row.getCell("intTerm").getValue())) {
                    String termName = row.getCell("intTerm").getValue().toString();
                    String oql = "select id,type,term where name = '" + termName + "'";
                    IntTermInfo termInfo = null;
                    try {
                        termInfo = IntTermFactory.getRemoteInstance().getIntTermInfo(oql);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (termInfo != null && termInfo.getType() == TermTypeEnum.MONTH) {
                        intervalDays = termInfo.getTerm() * 30;
                    } else if (termInfo != null && termInfo.getType() == TermTypeEnum.YEAR) {
                        intervalDays = termInfo.getTerm() * 360;
                    }
                }
                BigDecimal intAmt = TimeDepositHelper.getInstance().calcMatureIntAmt(depositAmt, yearValue, new BigDecimal(String.valueOf(yearDays)), new BigDecimal(String.valueOf(intervalDays)), base);
                row.getCell(TimeDepositBillListUI.MATURITY_ACCURAL).setValue((Object)intAmt);
            }
        }

        private void setNumberFormat(IRow row, String columnKey) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            styleAttributes.setNumberFormat("%r-[ ]0.2n");
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }

        private void setAmtCellNumberFormat(IRow row) {
            this.setNumberFormat(row, TimeDepositBillListUI.DEPOSIT_AMT);
            this.setNumberFormat(row, TimeDepositBillListUI.FLOOR_AMT);
            this.setNumberFormat(row, TimeDepositBillListUI.DEPOSIT_AMT_LOCAL);
            this.setNumberFormat(row, TimeDepositBillListUI.BALANCE);
            this.setNumberFormat(row, TimeDepositBillListUI.MATURITY_ACCURAL);
        }
    }
}

