/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositBillCollection;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.fm.td.TimeDepositHelper;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillInfo;
import com.kingdee.eas.fm.td.UnTimeDepositBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositBillInfo;
import com.kingdee.eas.fm.td.client.AbstractUnTimeDepositBillEditUI;
import com.kingdee.eas.fm.td.client.IntReceivedBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnTimeDepositBillEditUI
extends AbstractUnTimeDepositBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(UnTimeDepositBillEditUI.class);
    protected TimeDepositBillInfo timeDepositBillInfo;
    private CompanyOrgUnitInfo companyInfo;
    private Map successHm;
    private BigDecimal depositBalance = Constants.ZERO;
    private BigDecimal hasUndeAmtOfHisBill = Constants.ZERO;
    private Date maxBizDate = null;
    private boolean isSubmit = false;

    public UnTimeDepositBillEditUI() throws Exception {
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (FMHelper.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "fm_un_02add";
        }
        return "fm_un_01view";
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("handler.name"));
        return sic;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.timeDepositBillInfo == null && this.editData.getTimeDepositBill() != null) {
            try {
                this.timeDepositBillInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getTimeDepositBill().getId()));
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        if (this.timeDepositBillInfo != null) {
            this.pkEndDate.setValue((Object)this.timeDepositBillInfo.getMaturityDay());
            this.txtDepositAmt.setValue((Object)this.timeDepositBillInfo.getDepositAmt());
            this.txtRemAmt.setValue((Object)this.timeDepositBillInfo.getDepositAmt().subtract(this.editData.getUnDepositAmt()));
            this.txtlocalAmt.setValue((Object)this.editData.getExchangeRate().multiply(this.editData.getUnDepositAmt()));
            this.txtAccumulativeUnTimeDepostAmt.setValue((Object)this.timeDepositBillInfo.getDepositAmt().subtract(this.timeDepositBillInfo.getBalance()));
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.editData.getCurrency());
            this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
            IntRateTypeExpressionEnum intRateTypeExpressionEnum = this.timeDepositBillInfo.getIntRateTypeExpression();
            if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
                String msgStr = EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"60_UnTimeIntRateTypeExpression");
                this.contYearRate.setBoundLabelText(msgStr);
            } else {
                String msgStr = EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"61_UnTimeIntRateTypeExpression");
                this.contYearRate.setBoundLabelText(msgStr);
            }
            if (this.getOprtState().equals("ADDNEW")) {
                if (this.editData.getUnTimeDepositSeqNo() == 1) {
                    this.hasUndeAmtOfHisBill = FMHelper.subtract((BigDecimal)this.timeDepositBillInfo.getDepositAmt(), (BigDecimal)this.timeDepositBillInfo.getInitBalanceOfHistoryBill());
                    this.editData.setHasUndeAmtOfHistBill(this.hasUndeAmtOfHisBill);
                    this.editData.setAccumulativeUnTimeDepostAmt(this.timeDepositBillInfo.getDepositAmt());
                } else {
                    this.hasUndeAmtOfHisBill = FMHelper.subtract((BigDecimal)this.timeDepositBillInfo.getDepositAmt(), (BigDecimal)this.timeDepositBillInfo.getBalance());
                    this.editData.setHasUndeAmtOfHistBill(this.hasUndeAmtOfHisBill);
                    this.editData.setAccumulativeUnTimeDepostAmt(this.timeDepositBillInfo.getDepositAmt());
                }
            } else {
                this.hasUndeAmtOfHisBill = this.editData.getAccumulativeUnTimeDepostAmt();
            }
        }
        if (this.editData.getCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        }
        this.comboUnDepositType.setSelectedItem((Object)this.editData.getUnDepositType());
        this.txtUnTimeDepositSeqNo.setValue((Object)new Integer(this.editData.getUnTimeDepositSeqNo()));
        this.txtUnDepositAmt.setMaximumValue((Comparable)this.editData.getUnDepositAmt());
        this.txtUnDepositAmt.setValue((Object)this.editData.getUnDepositAmt());
        this.txtAccumulativeUnTimeDepostAmt.setValue((Object)this.editData.getAccumulativeUnTimeDepostAmt());
        this.txtRemAmt.setValue((Object)FMHelper.subtract((BigDecimal)this.txtDepositAmt.getBigDecimalValue(), (BigDecimal)this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue()));
        this.chkIsCalInt.setSelected(this.editData.isIsCalInt());
        try {
            this.chkIsCalInt_itemStateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.chkIsYearRate.setSelected(this.editData.isIsAppointRate());
        this.txtYearRate.setValue((Object)this.editData.getYearRate());
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) {
            this.calcUnDepositAmtTotal();
        }
        ActionListener[] al = (ActionListener[])this.comboUnDepositType.getListeners(ActionListener.class);
        this.comboUnDepositType.removeActionListener(al[0]);
        this.comboUnDepositType.setSelectedItem((Object)this.editData.getUnDepositType());
        this.comboUnDepositType.addActionListener(al[0]);
        this.txtYearRate.setValue((Object)this.editData.getYearRate());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setTimeDepositBill((TimeDepositBillInfo)this.prmtTimeDepositBill.getValue());
        this.editData.setBank((BankInfo)this.prmtBank.getValue());
        this.editData.setCompany((CompanyOrgUnitInfo)this.prmtCompany.getValue());
        this.editData.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
        this.editData.setUnTimeDepositSeqNo(this.txtUnTimeDepositSeqNo.getIntegerValue());
        this.editData.setAccumulativeUnTimeDepostAmt(this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue());
        this.editData.setUnDepositAmt(this.txtUnDepositAmt.getBigDecimalValue());
        this.editData.setPayeeBankAccount((AccountBankInfo)this.prmtPayeeBankAccount.getValue());
        this.editData.setHandler(FMClientHelper.getUserByF7Person((CoreUI)this, (KDBizPromptBox)this.prmtHandler));
        this.editData.setBizDate(DateTimeUtils.truncateDate((Date)this.editData.getBizDate()));
        this.editData.setFivouchered(false);
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.companyInfo);
        this.initController();
        super.onLoad();
        if (!this.getOprtState().equals(OprtState.VIEW) && this.timeDepositBillInfo != null) {
            if (this.timeDepositBillInfo.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.timeDepositBillInfo.getTimeDepositType() == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER) {
                this.comboUnDepositType.removeAllItems();
                this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT);
                this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
                this.comboUnDepositType.setSelectedItem((Object)this.editData.getUnDepositType());
            } else {
                this.comboUnDepositType.removeAllItems();
                this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
                this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT);
                this.comboUnDepositType.setSelectedItem((Object)this.editData.getUnDepositType());
            }
        }
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.prmtHandler.setEnabled(true);
            this.prmtPayeeBankAccount.setEnabled(true);
            if (this.editData.getCurrency() != null) {
                if (!this.companyInfo.getBaseCurrency().getId().toString().equals(this.editData.getCurrency().getId().toString())) {
                    this.txtExchangeRate.setEnabled(true);
                } else {
                    this.txtExchangeRate.setEnabled(false);
                }
            }
        }
        this.txtUnDepositAmt.setMaximumValue((Comparable)this.txtUnDepositAmt.getBigDecimalValue());
        if (this.getUIContext().get("infoid") != null) {
            this.actionCreateFrom.setEnabled(false);
            this.actionAddNew.setVisible(false);
        } else {
            this.actionCreateFrom.setEnabled(true);
            this.actionAddNew.setVisible(true);
        }
        this.txtNumber.setMaxLength(80);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtAccountant);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtCreator);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtHandler);
        this.actionAuditResult.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.comboUnDepositType});
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected void resetPrecisionForOtherComponent() {
        this.txtExchangeRate.setPrecision(5);
        this.txtYearRate.setPrecision(5);
        this.txtUnTimeDepositSeqNo.setPrecision(0);
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.cboCurrency.getSelectedItem();
    }

    protected void resetPrecisionForLocalAmt() {
        this.txtlocalAmt.setPrecision(this.getBaseCurrencyPrecision());
    }

    private void initController() {
        CashHelper.initCombCurrency((KDComboBox)this.cboCurrency, (boolean)false);
        this.prmtHandler.setEnabled(false);
        this.prmtHandler.setDisplayFormat("$name$");
        this.prmtPayeeBankAccount.setCommitFormat("$number$");
        this.prmtPayeeBankAccount.setEnabled(false);
        this.prmtCreator.setEnabled(false);
        this.txtUnDepositAmt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtUnDepositAmt.setMaximumValue((Comparable)Constants.MAX_VALUE);
    }

    protected IObjectValue createNewData() {
        UnTimeDepositBillInfo objectValue = new UnTimeDepositBillInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setBizDate(DateUtil.getDayBegin());
        objectValue.setIsHis(false);
        objectValue.setIsAddedByReceive(false);
        objectValue.setComUnDepositBillID(null);
        objectValue.setMyBizDate(DateUtil.getDayBegin());
        this.copyValueToNewData_undeposit(objectValue);
        return objectValue;
    }

    protected void copyValueToNewData_undeposit(UnTimeDepositBillInfo objectValue) {
        String id = (String)this.getUIContext().get("infoid");
        if (id != null) {
            try {
                this.timeDepositBillInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(id), this.getTimedepositSelectors());
                this.depositBalance = this.timeDepositBillInfo.getBalance();
            }
            catch (Exception e) {
                this.handUIException(e.getCause());
            }
            objectValue.setUnDepositType(UnDepositTypeEnum.MATURE_UNDEPOSIT);
            objectValue.setTimeDepositBill(this.timeDepositBillInfo);
            objectValue.setCompany(this.timeDepositBillInfo.getDepositCompany());
            objectValue.setCurrency(this.timeDepositBillInfo.getCurrency());
            objectValue.setExchangeRate(this.timeDepositBillInfo.getExchangeRate());
            objectValue.setUnDepositAmt(this.timeDepositBillInfo.getBalance());
            objectValue.setHandler(this.timeDepositBillInfo.getHandler());
            objectValue.setPayeeBankAccount(this.timeDepositBillInfo.getBankCurAcct());
            objectValue.setCertificateNo(this.timeDepositBillInfo.getCertificateNo());
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"59_UnTimeDepositBillEditUI"), this.timeDepositBillInfo.getNumber());
            objectValue.setDescription(msgStr);
            objectValue.setBank(this.timeDepositBillInfo.getDepositBank());
            try {
                Map hm = UnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getId().toString()));
                Integer maxseq = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
                objectValue.setUnTimeDepositSeqNo(maxseq + 1);
                this.maxBizDate = (Date)hm.get("maxBizDate");
            }
            catch (BOSException e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort((Throwable)e);
            }
            this.setBizDate(objectValue);
            objectValue.setIsAppointRate(false);
            objectValue.setIsCalInt(true);
            objectValue.setIntDeAmt(Constants.ZERO);
            objectValue.setIntCurAmt(Constants.ZERO);
            objectValue.setIntSum(Constants.ZERO);
            objectValue.setMyBizDate(DateUtil.getDayBegin());
            objectValue.setYearRate(this.timeDepositBillInfo.getCurYearRate());
        }
    }

    protected void setBizDate(UnTimeDepositBillInfo objectValue) {
    }

    private SelectorItemCollection getTimedepositSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("handler.*"));
        sic.add(new SelectorItemInfo("bankCurAcct.*"));
        sic.add(new SelectorItemInfo("depositBank.*"));
        sic.add(new SelectorItemInfo("depositCompany.*"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            UnTimeDepositBillInfo unTimeDepositBillInfo = (UnTimeDepositBillInfo)dataObject;
            this.timeDepositBillInfo = unTimeDepositBillInfo.getTimeDepositBill();
            String sourceID = (String)this.getUIContext().get("srcBillID");
            if (sourceID != null) {
                unTimeDepositBillInfo.setSourceBillId(sourceID);
                if (FMHelper.isInstanceof((String)sourceID, UnTimeDepositApplyBillInfo.class)) {
                    this.setDataObjectFromUnTimeDepositApply(unTimeDepositBillInfo, sourceID);
                } else {
                    try {
                        this.timeDepositBillInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(sourceID), this.getTimedepositSelectors());
                    }
                    catch (Exception e) {
                        this.handUIException(e.getCause());
                    }
                    if (this.timeDepositBillInfo != null) {
                        try {
                            this.timeDepositBillInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getId()), this.getTimedepositSelectors());
                            unTimeDepositBillInfo.setTimeDepositBill(this.timeDepositBillInfo);
                        }
                        catch (Exception e) {
                            this.handUIExceptionAndAbort(e);
                        }
                        unTimeDepositBillInfo.setExchangeRate(this.timeDepositBillInfo.getExchangeRate());
                        this.setexChangeRate(unTimeDepositBillInfo);
                        this.depositBalance = this.timeDepositBillInfo.getBalance();
                        unTimeDepositBillInfo.setHandler(this.timeDepositBillInfo.getHandler());
                        unTimeDepositBillInfo.setCurrency(this.timeDepositBillInfo.getCurrency());
                        unTimeDepositBillInfo.setUnDepositAmt(this.timeDepositBillInfo.getBalance());
                        unTimeDepositBillInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
                        unTimeDepositBillInfo.setPayeeBankAccount(this.timeDepositBillInfo.getBankCurAcct());
                        try {
                            Map hm = UnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getId().toString()));
                            Integer maxseq = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
                            unTimeDepositBillInfo.setUnTimeDepositSeqNo(maxseq + 1);
                            this.maxBizDate = (Date)hm.get("maxBizDate");
                            BigDecimal accuUnDeAmt = (BigDecimal)hm.get("UNDEPOSIT_ACCUMULATE_AMT");
                            BigDecimal bigDecimal = unTimeDepositBillInfo.getUnDepositAmt();
                        }
                        catch (BOSException e) {
                            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                            SysUtil.abort((Throwable)e);
                        }
                        unTimeDepositBillInfo.setUnDepositType(UnDepositTypeEnum.MATURE_UNDEPOSIT);
                        unTimeDepositBillInfo.setIsAppointRate(true);
                        unTimeDepositBillInfo.setIsCalInt(true);
                        unTimeDepositBillInfo.setIntDeAmt(Constants.ZERO);
                        unTimeDepositBillInfo.setIntCurAmt(Constants.ZERO);
                        unTimeDepositBillInfo.setIntSum(Constants.ZERO);
                        unTimeDepositBillInfo.setMyBizDate(DateUtil.getDayBegin());
                        unTimeDepositBillInfo.setYearRate(this.timeDepositBillInfo.getCurYearRate());
                    }
                }
            }
        }
    }

    private void emptyCtrl() {
        this.txtNumber.setText("");
        this.prmtBank.setValue(null);
        this.prmtTimeDepositBill.setValue(null);
        this.txtUnTimeDepositSeqNo.setValue((Object)Constants.ZERO);
        this.prmtCompany.setValue(null);
        this.prmtHandler.setValue(null);
        this.prmtPayeeBankAccount.setValue(null);
        this.pkEndDate.setValue(null);
        this.txtDepositAmt.setValue(null);
        this.txtAccumulativeUnTimeDepostAmt.setValue(null);
        this.txtRemAmt.setValue(null);
        this.txtExchangeRate.setValue(null);
        this.txtUnDepositAmt.setValue(null);
        this.txtlocalAmt.setValue(null);
        this.txtDiggest.setText("");
    }

    private void verifyTimeDepositBalance(TimeDepositBillInfo info) {
        BigDecimal balance;
        if (this.getOprtState() == OprtState.ADDNEW && this.isFromUnTimeDepositApply() && !FMHelper.isEmpty((CoreBaseInfo)info) && !FMHelper.isEmpty((Object)(balance = info.getBalance())) && balance.compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"54_UnTimeDepositBillEditUI"));
            this.emptyCtrl();
            SysUtil.abort();
        }
    }

    private boolean isFromUnTimeDepositApply() {
        String sourceID = (String)this.getUIContext().get("srcBillID");
        return !FMHelper.isEmpty((String)sourceID) && FMHelper.isInstanceof((String)sourceID, UnTimeDepositApplyBillInfo.class);
    }

    private void setDataObjectFromUnTimeDepositApply(UnTimeDepositBillInfo unTimeDepositBillInfo, String sourceID) {
        try {
            UnTimeDepositApplyBillInfo applyInfo = UnTimeDepositApplyBillFactory.getRemoteInstance().getUnTimeDepositApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceID), this.getUnTimedepositSelectors());
            unTimeDepositBillInfo.setPayeeBankAccount(applyInfo.getPayeeAccount());
            unTimeDepositBillInfo.setUnDepositType(applyInfo.getUnDepositType());
            unTimeDepositBillInfo.setBizDate(applyInfo.getUnDepositDate());
            if (!FMHelper.isEmpty((CoreBaseInfo)applyInfo)) {
                String srcApplyId = applyInfo.getSourceBillId();
                if (!FMHelper.isEmpty((String)srcApplyId) && FMHelper.isInstanceof((String)srcApplyId, TimeDepositBillInfo.class)) {
                    this.timeDepositBillInfo = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(srcApplyId), this.getTimedepositSelectors());
                } else if (!FMHelper.isEmpty((String)srcApplyId) && FMHelper.isInstanceof((String)srcApplyId, CompDepositAccountBillInfo.class)) {
                    this.timeDepositBillInfo = this.getTimeDepositBillInfoByCompDepositBill(srcApplyId);
                    unTimeDepositBillInfo.setTimeDepositBill(this.timeDepositBillInfo);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e.getCause());
        }
        unTimeDepositBillInfo.setTimeDepositBill(this.timeDepositBillInfo);
        if (this.timeDepositBillInfo != null) {
            unTimeDepositBillInfo.setCompany(this.timeDepositBillInfo.getCompany());
            unTimeDepositBillInfo.setBank(this.timeDepositBillInfo.getDepositBank());
            unTimeDepositBillInfo.setExchangeRate(this.timeDepositBillInfo.getExchangeRate());
            this.depositBalance = this.timeDepositBillInfo.getBalance();
            unTimeDepositBillInfo.setHandler(this.timeDepositBillInfo.getHandler());
            unTimeDepositBillInfo.setCurrency(this.timeDepositBillInfo.getCurrency());
            unTimeDepositBillInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
            try {
                Map hm = UnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getId().toString()));
                Integer maxseq = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
                unTimeDepositBillInfo.setUnTimeDepositSeqNo(maxseq + 1);
                this.maxBizDate = (Date)hm.get("maxBizDate");
            }
            catch (BOSException e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort((Throwable)e);
            }
            unTimeDepositBillInfo.setIsAppointRate(true);
            unTimeDepositBillInfo.setIsCalInt(true);
            unTimeDepositBillInfo.setIntDeAmt(Constants.ZERO);
            unTimeDepositBillInfo.setIntCurAmt(Constants.ZERO);
            unTimeDepositBillInfo.setIntSum(Constants.ZERO);
            unTimeDepositBillInfo.setMyBizDate(DateUtil.getDayBegin());
            unTimeDepositBillInfo.setYearRate(this.timeDepositBillInfo.getCurYearRate());
        }
    }

    private TimeDepositBillInfo getTimeDepositBillInfoByCompDepositBill(String srcApplyId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("comDepositBillID", (Object)srcApplyId));
        view.setFilter(filter);
        TimeDepositBillInfo info = null;
        try {
            TimeDepositBillCollection colls = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillCollection(view);
            TimeDepositBillInfo timeDepositBillInfo = info = colls == null ? null : colls.get(0);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info)) {
                info = TimeDepositBillFactory.getRemoteInstance().getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), this.getTimedepositSelectors());
            }
        }
        catch (Exception e) {
            this.handUIException(e.getCause());
        }
        return info;
    }

    private SelectorItemCollection getUnTimedepositSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payeeAccount.*"));
        return sic;
    }

    protected void setexChangeRate(UnTimeDepositBillInfo unTimeDepositBillInfo) {
    }

    private void setBillHandler(IObjectValue dataObject) {
        UserInfo handler = null;
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            handler = ((UnTimeDepositBillInfo)dataObject).getTimeDepositBill().getHandler();
        }
        if (handler == null && this.getUIContext().get("BOTPViewStatus") != null) {
            handler = ((UnTimeDepositBillInfo)this.getUIContext().get("CURRENT.VO")).getTimeDepositBill().getHandler();
        }
        ((UnTimeDepositBillInfo)dataObject).setHandler(handler);
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    protected void txtUnDepositAmt_dataChanged(DataChangeEvent e) throws Exception {
        if (null == this.timeDepositBillInfo) {
            return;
        }
        this.calcUnDepositAmtTotal();
        this.setLocalAmt();
    }

    private void calcUnDepositAmtTotal() {
        if (this.txtDepositAmt.getBigDecimalValue() == null) {
            return;
        }
        this.txtAccumulativeUnTimeDepostAmt.setValue((Object)this.txtUnDepositAmt.getBigDecimalValue().add(this.hasUndeAmtOfHisBill));
        this.txtRemAmt.setValue((Object)this.txtDepositAmt.getBigDecimalValue().subtract(this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue()));
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.setLocalAmt();
    }

    private void setLocalAmt() {
        if (null != this.txtExchangeRate.getBigDecimalValue() && null != this.txtUnDepositAmt.getBigDecimalValue()) {
            this.txtlocalAmt.setValue((Object)this.txtExchangeRate.getBigDecimalValue().multiply(this.txtUnDepositAmt.getBigDecimalValue()));
        }
    }

    @Override
    protected void prmtTimeDepositBill_dataChanged(DataChangeEvent e) throws Exception {
    }

    private UserInfo getHandler(BOSUuid id) {
        UserInfo handler = null;
        try {
            handler = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return handler;
    }

    private void setMaxSeqAmtRem(TimeDepositBillInfo info) throws BOSException {
        Map hm = UnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        this.setMaxUnDeposit((Integer)hm.get("UNDEPOSIT_MAX_SEQ"));
    }

    private void calcRate(Date date) throws Exception {
        if (date != null) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
            if (currencyInfo == null) {
                return;
            }
            int prec = RecPayHandler.getExRatePrec((String)currencyInfo.getId().toString(), null, null, (Date)date);
            prec = prec == 0 ? 5 : prec;
            this.txtExchangeRate.setPrecision(prec);
            this.txtExchangeRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)currencyInfo, null, (Date)date));
        }
    }

    @Override
    protected void pkBillDate_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        this.setPrecision();
        if (currencyInfo == null) {
            return;
        }
        int baseCurrPre = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)currencyInfo.getId().toString()));
        this.calcRate((Date)this.pkBillDate.getValue());
    }

    private void setPre(int baseCurrPre) {
        this.txtExchangeRate.setPrecision(4);
        this.txtUnDepositAmt.setPrecision(2);
        this.txtlocalAmt.setPrecision(2);
        this.txtDepositAmt.setPrecision(2);
        this.txtAccumulativeUnTimeDepostAmt.setPrecision(2);
        this.txtRemAmt.setPrecision(2);
    }

    private void setRemAmt(TimeDepositBillInfo info) {
        BigDecimal accumulativeUnTimeDepostAmt = this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue() == null ? Constants.ZERO : this.txtAccumulativeUnTimeDepostAmt.getBigDecimalValue();
        this.txtRemAmt.setValue((Object)info.getDepositAmt().subtract(accumulativeUnTimeDepostAmt));
    }

    private void setUnDepositAccumulateAmt(BigDecimal accudecimal) {
        this.txtAccumulativeUnTimeDepostAmt.setValue((Object)Constants.ZERO);
        BigDecimal unDepositAmt = Constants.ZERO;
        if (this.txtUnDepositAmt.getBigDecimalValue() != null) {
            unDepositAmt = this.txtUnDepositAmt.getBigDecimalValue();
        }
        this.txtAccumulativeUnTimeDepostAmt.setValue((Object)unDepositAmt.add(accudecimal));
    }

    private void setMaxUnDeposit(Integer maxSeq) {
        this.txtUnTimeDepositSeqNo.setValue((Object)new Integer(maxSeq + 1));
    }

    private void setUnDepostType(TimeDepositBillInfo timeDepositBillInfo) {
        if (null == timeDepositBillInfo) {
            return;
        }
        if (timeDepositBillInfo.getTimeDepositType().getValue().equals("timedeposit") || timeDepositBillInfo.getTimeDepositType().getValue().equals("timedeposit_outer")) {
            this.comboUnDepositType.removeAllItems();
            this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.AHEAD_UNDEPOSIT);
            this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
            this.comboUnDepositType.setSelectedItem((Object)UnDepositTypeEnum.MATURE_UNDEPOSIT);
        } else if (timeDepositBillInfo.getTimeDepositType().getValue().equals("calldeposit") || timeDepositBillInfo.getTimeDepositType().getValue().equals("calldeposit_outer")) {
            this.comboUnDepositType.removeAllItems();
            this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
            this.comboUnDepositType.addItem((Object)UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT);
            this.comboUnDepositType.setSelectedItem((Object)UnDepositTypeEnum.CONSULT_UNDEPOSIT);
        }
    }

    private void setValueAccordToSelectedBill(TimeDepositBillInfo timeDepositBillInfo) throws EASBizException, BOSException {
        if (null == timeDepositBillInfo) {
            return;
        }
        this.prmtBank.setValue((Object)BankFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getDepositBank().getId().toString())));
        this.prmtCompany.setValue((Object)CompanyOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCompany().getId().toString())));
        this.cboCurrency.setSelectedItem((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getCurrency().getId().toString())));
        this.pkEndDate.setValue((Object)timeDepositBillInfo.getMaturityDay());
        this.txtDepositAmt.setValue((Object)timeDepositBillInfo.getDepositAmt());
        this.txtUnDepositAmt.setMaximumValue((Comparable)timeDepositBillInfo.getDepositAmt());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.verifyInputValid();
        this.checkUndepositDate();
        this.checkUnDepositAmt();
        if (this.timeDepositBillInfo != null) {
            // empty if block
        }
    }

    private void checkMaxActiveTimes(TimeDepositBillInfo timeDepositBillInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ctrlStrategy.lowestBalance");
        sic.add("ctrlStrategy.maxActiveTimes");
        AccountBankInfo info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(timeDepositBillInfo.getBankDepAcct().getId()), sic);
        if (info.getCtrlStrategy() != null) {
            int maxActiveTimes = info.getCtrlStrategy().getMaxActiveTimes();
            if (maxActiveTimes == 0) {
                return;
            }
            int maxUndeNo = this.getMaxUnDepositSeqNo(timeDepositBillInfo.getId().toString());
            if (maxUndeNo == maxActiveTimes) {
                throw new TDException(TDException.UNDE_ERROR4);
            }
        }
    }

    private int getMaxUnDepositSeqNo(String id) throws BOSException {
        Map hm = UnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(id));
        Integer maxUndepositSeq = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
        return maxUndepositSeq;
    }

    private void verifyInputValid() throws TDException {
        if (this.prmtTimeDepositBill.getValue() == null) {
            throw new TDException(TDException.UNDEPOSIT_ERROR1);
        }
        if (this.txtNumber.isEditable()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBillDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtUnDepositAmt);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayeeBankAccount);
        if (!FMClientHelper.verifyIsPlus((String)this.txtUnDepositAmt.getBigDecimalValue().toString())) {
            this.txtUnDepositAmt.requestFocus(true);
            throw new TDException(TDException.UNDEPOSIT_NEGATIVE_EXC);
        }
    }

    protected void checkUnDepositAmt() throws EASBizException, BOSException, TDException {
        BigDecimal unDepositAmt = this.txtUnDepositAmt.getBigDecimalValue();
        if (unDepositAmt.compareTo(this.timeDepositBillInfo.getBalance()) != 0) {
            if (!this.condition2(unDepositAmt)) {
                throw new TDException(TDException.UNDEPOSITAMT_EXC1);
            }
            if (!this.condition1(unDepositAmt)) {
                throw new TDException(TDException.UNDEPOSITAMT_EXC2);
            }
        }
    }

    private boolean condition1(BigDecimal unDepositAmt) throws EASBizException, BOSException, TDException {
        BigDecimal lowestBalance;
        boolean isValid = true;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ctrlStrategy.lowestDrawAmt");
        AccountBankInfo info = (AccountBankInfo)AccountBankFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.timeDepositBillInfo.getBankDepAcct().getId()));
        if (info.getCtrlStrategy() != null && (lowestBalance = info.getCtrlStrategy().getLowestBalance()) != null && unDepositAmt.compareTo(lowestBalance.multiply(Constants.TEN_THOUSAND)) > 0) {
            isValid = false;
        }
        return isValid;
    }

    private boolean condition2(BigDecimal unDepositAmt) {
        return unDepositAmt.compareTo(this.timeDepositBillInfo.getBalance().subtract(this.timeDepositBillInfo.getFloorAmt())) <= 0 || unDepositAmt.compareTo(Constants.ZERO) <= 0;
    }

    private void checkUndepositDate() throws TDException {
        Date lastUnDepositDate = this.timeDepositBillInfo.getLastUnDepositDate();
        Date effectiveDate = this.timeDepositBillInfo.getEffectiveDate();
        Date maturityDate = this.timeDepositBillInfo.getMaturityDay();
        Date unDepoistDate = (Date)this.pkBillDate.getValue();
        UnDepositTypeEnum unDepositTypeEnum = (UnDepositTypeEnum)this.comboUnDepositType.getSelectedItem();
        if (unDepoistDate.compareTo(this.getMinDate(lastUnDepositDate, effectiveDate)) < 0) {
            throw new TDException(TDException.UNDEPOSITDATE_EXC1);
        }
        if (unDepositTypeEnum.getValue().equals("matureUnDeposit")) {
            if (unDepoistDate.compareTo(maturityDate) < 0) {
                this.pkBillDate.requestFocus();
                throw new TDException(TDException.UNDEPOSITDATE_EXC2);
            }
        } else if (unDepositTypeEnum.getValue().equals("aheadUnDeposit") && unDepoistDate.compareTo(maturityDate) >= 0) {
            this.pkBillDate.requestFocus();
            throw new TDException(TDException.UNDEPOSITDATE_EXC3);
        }
    }

    @Override
    public void comboUnDepositType_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            UnDepositTypeEnum unDepositType = (UnDepositTypeEnum)this.comboUnDepositType.getSelectedItem();
            if (unDepositType == UnDepositTypeEnum.MATURE_UNDEPOSIT) {
                this.txtUnDepositAmt.setEnabled(false);
                if (this.txtRemAmt.getBigDecimalValue() != null && this.txtUnDepositAmt.getBigDecimalValue() != null && !this.getOprtState().equals(OprtState.VIEW)) {
                    this.txtUnDepositAmt.setValue((Object)this.txtRemAmt.getBigDecimalValue().add(this.txtUnDepositAmt.getBigDecimalValue()));
                    this.calcUnDepositAmtTotal();
                }
            } else if (!this.isFromUnTimeDepositApply()) {
                this.txtUnDepositAmt.setEnabled(true);
            }
            if (unDepositType == UnDepositTypeEnum.CONSULT_UNDEPOSIT) {
                this.chkIsCalInt.setSelected(true);
                this.chkIsYearRate.setSelected(true);
                if (this.editData.getTimeDepositBill() != null) {
                    this.txtYearRate.setValue((Object)this.editData.getTimeDepositBill().getCurYearRate());
                }
            } else if (unDepositType == UnDepositTypeEnum.UN_CONSULT_UNDEPOSIT) {
                this.chkIsCalInt.setSelected(true);
                this.chkIsYearRate.setSelected(true);
                if (this.editData.getTimeDepositBill() != null) {
                    this.txtYearRate.setValue((Object)this.editData.getTimeDepositBill().getCurYearRate());
                }
            } else if (this.editData.getTimeDepositBill() != null) {
                this.txtYearRate.setValue((Object)this.editData.getTimeDepositBill().getCurYearRate());
            }
        }
    }

    private Date getMinDate(Date lastUnDepositDate, final Date effectiveDate) {
        ArrayList li = new ArrayList(){
            {
                this.add(UnTimeDepositBillEditUI.this.maxBizDate);
                this.add(effectiveDate);
            }
        };
        return TimeDepositHelper.getInstance().getMaxDate(li);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UnTimeDepositBillFactory.getRemoteInstance();
    }

    public Map getSuccessHm() {
        return this.successHm;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    private Date calcEndDate(Date billDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(billDate);
        c.add(5, -1);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyTimeDepositBalance(this.timeDepositBillInfo);
        this.verify(e);
        Date intEndDate = DateTimeUtils.truncateDate((Date)this.calcEndDate((Date)this.pkBillDate.getValue()));
        Date intStartDate = DateTimeUtils.truncateDate((Date)this.timeDepositBillInfo.getEffectiveDate());
        if (intEndDate.compareTo(intStartDate) < 0) {
            super.actionSubmit_actionPerformed(e);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.td.TDAutoGenerateResource", (String)"42_UnTimeDepositBillEditUI"));
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            if (this.getUIWindow() instanceof Dialog) {
                this.uiWindow.close();
            } else {
                this.txtNumber.setText("");
                this.prmtBank.setValue(null);
                this.prmtTimeDepositBill.setValue(null);
                this.txtUnTimeDepositSeqNo.setValue((Object)Constants.ZERO);
                this.prmtCompany.setValue(null);
                this.prmtHandler.setValue(null);
                this.prmtPayeeBankAccount.setValue(null);
                this.pkEndDate.setValue(null);
                this.txtDepositAmt.setValue(null);
                this.txtAccumulativeUnTimeDepostAmt.setValue(null);
                this.txtRemAmt.setValue(null);
                this.txtExchangeRate.setValue(null);
                this.txtUnDepositAmt.setValue(null);
                this.txtlocalAmt.setValue(null);
                this.txtDiggest.setText("");
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
            }
        } else {
            this.editData.setCU(ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit());
            UnTimeDepositBillFactory.getRemoteInstance().checkNumberDup(null, (CoreBillBaseInfo)this.editData);
            UnTimeDepositBillInfo rInfo = this.editData;
            if (rInfo.getId() == null) {
                this.editData.setId(BOSUuid.create((BOSObjectType)rInfo.getBOSType()));
            }
            if (!this.isSubmit) {
                try {
                    if (this.editData.isIsCalInt()) {
                        this.isSubmit = true;
                        this.successHm = IntReceivedBillEditUI.showIntReceiveEditUI((CoreUIObject)this, (CoreBaseInfo)this.editData, "1", (String)this.getUIContext().get("infoid"));
                    } else {
                        super.actionSubmit_actionPerformed(e);
                        this.successHm = new HashMap();
                        this.successHm.put("successFlag", Boolean.TRUE);
                    }
                }
                finally {
                    this.isSubmit = false;
                }
            }
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            if (this.getUIWindow() instanceof Dialog) {
                Boolean succ;
                if (this.successHm != null && (succ = (Boolean)this.successHm.get("successFlag")) != null && succ.booleanValue()) {
                    this.uiWindow.close();
                }
            } else {
                this.txtNumber.setText("");
                this.prmtBank.setValue(null);
                this.prmtTimeDepositBill.setValue(null);
                this.txtUnTimeDepositSeqNo.setValue((Object)Constants.ZERO);
                this.prmtCompany.setValue(null);
                this.prmtHandler.setValue(null);
                this.prmtPayeeBankAccount.setValue(null);
                this.pkEndDate.setValue(null);
                this.txtDepositAmt.setValue(null);
                this.txtAccumulativeUnTimeDepostAmt.setValue(null);
                this.txtRemAmt.setValue(null);
                this.txtExchangeRate.setValue(null);
                this.txtUnDepositAmt.setValue(null);
                this.txtlocalAmt.setValue(null);
                this.txtDiggest.setText("");
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
            }
        }
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.comboUnDepositType});
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("TargetBillType", "TimeDeposit");
        this.getBillEdit().createFrom(null, ctx);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        UnTimeDepositBillInfo unTimeInfo = (UnTimeDepositBillInfo)this.getDataObject();
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionViewSubmitProccess.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionAddNew.setEnabled(false);
            this.actionAddNew.setVisible(false);
        } else if (this.getBOTPViewStatus() == 1) {
            this.actionAddNew.setEnabled(false);
            this.actionAddNew.setVisible(false);
        } else {
            this.actionAddNew.setEnabled(true);
            this.actionAddNew.setVisible(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionCreateFrom.setEnabled(false);
            this.actionCreateFrom.setVisible(false);
        } else {
            this.actionCreateFrom.setEnabled(true);
            this.actionCreateFrom.setVisible(true);
        }
        this.txtYearRate.setEnabled(unTimeInfo.isIsAppointRate());
        this.chkIsYearRate.setVisible(unTimeInfo.isIsCalInt());
        if (unTimeInfo.isIsCalInt()) {
            this.contYearRate.setVisible(unTimeInfo.isIsAppointRate());
        } else {
            this.contYearRate.setVisible(false);
        }
        if (this.isFromUnTimeDepositApply()) {
            this.comboUnDepositType.setEnabled(false);
            this.txtUnDepositAmt.setEnabled(false);
        }
    }

    public static void showUnDeopsitWindow(CoreUIObject ui, String selectedValue) throws UIException, EASBizException {
        try {
            Boolean succ;
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"infoid", (Object)selectedValue);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UnTimeDepositBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            Map successHm = ((UnTimeDepositBillEditUI)uiWindow.getUIObject()).getSuccessHm();
            if (successHm != null && (succ = (Boolean)successHm.get("successFlag")) != null && succ.booleanValue()) {
                uiWindow.close();
            }
        }
        catch (BOSException e) {
            MsgBox.showError((String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    public void prmtPayeeBankAccount_willShow(SelectorEvent e) {
        this.setPrmtPayeeBankAccountFilter();
    }

    private void setPrmtPayeeBankAccountFilter() {
        this.prmtPayeeBankAccount.setEntityViewInfo(this.getBankAccountFilter());
        this.prmtPayeeBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public void prmtPayeeBankAccount_willCommit(CommitEvent e) {
        this.setPrmtPayeeBankAccountFilter();
    }

    private EntityViewInfo getBankAccountFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    protected void chkIsCalInt_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsCalInt_itemStateChanged(e);
        this.chkIsYearRate.setVisible(this.chkIsCalInt.isSelected());
        this.chkIsYearRate.setSelected(false);
    }

    @Override
    protected void chkIsYearRate_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsYearRate_itemStateChanged(e);
        this.contYearRate.setEnabled(this.chkIsYearRate.isSelected());
        this.contYearRate.setVisible(this.contYearRate.isEnabled());
        if (this.contYearRate.isVisible() && this.editData.getTimeDepositBill() != null) {
            this.txtYearRate.setValue((Object)this.editData.getTimeDepositBill().getCurYearRate());
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

