/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.hr.client.f7.IF7ParamFromUI;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillFactory;
import com.kingdee.eas.hr.affair.client.AbstractEmpEnrollBillReviseUI;
import com.kingdee.eas.hr.base.F7ConfigCollection;
import com.kingdee.eas.hr.base.F7ConfigDetailCollection;
import com.kingdee.eas.hr.base.F7ConfigDetailInfo;
import com.kingdee.eas.hr.base.F7ConfigFactory;
import com.kingdee.eas.hr.base.F7ScopeEnum;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.PositionRelatedInfo;
import com.kingdee.eas.hr.base.RelatedInfoGetFacadeFactory;
import com.kingdee.eas.hr.base.client.f7.DefaultF7PramFromUI;
import com.kingdee.eas.hr.base.client.util.HRBizDefineClientUtils;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.apache.log4j.Logger;

public class EmpEnrollBillReviseUI
extends AbstractEmpEnrollBillReviseUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpEnrollBillReviseUI.class);
    private boolean isIDCardVerify = true;
    private boolean hasLoadFields = false;
    private String oldCUid = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.editData.getPerson() == null) {
            logger.error((Object)"Cannot be revised");
        }
        this.isIDCardVerify = this.isIDcardVerify();
        this.initEditor();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        this.hasLoadFields = false;
        super.loadFields();
        this.hasLoadFields = true;
    }

    private void initEditor() throws EASBizException, BOSException {
        this.menuBar.setVisible(false);
        if (this.editData.getHrBizDefine() == null) {
            MsgBox.showError((String)"cannot edit");
            SysUtil.abort();
        }
        HRBizDefineInfo defineInfo = this.getHrBizDefineInfo(this.editData.getHrBizDefine().getId().toString());
        HRBizDefineClientUtils.setOutEmpTypeEditor((HRBizDefineInfo)defineInfo, (KDComboBox)this.cbEmpType);
        this.cbEmpType.setSelectedItem((Object)this.editData.getEmpType());
        HRBizDefineClientUtils.setAffairActionEditor((HRBizDefineInfo)defineInfo, (KDComboBox)this.cbAffairReason);
        this.cbAffairReason.setSelectedItem((Object)this.editData.getAffairActionReason());
        ((AbstractDocument)this.txtIDCardNo.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet attr) throws BadLocationException {
                fb.insertString(offset, str.toUpperCase(), attr);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                fb.replace(offset, length, text.toUpperCase(), attrs);
            }
        });
        if (this.isIDCardVerify) {
            this.addIDCardNOListener();
        } else {
            this.addTryIDCardNOListener();
        }
        PositionPromptBox2 position = new PositionPromptBox2();
        position.setSealUp("false");
        this.prmtPosition.setSelector((KDPromptSelector)position);
        boolean canEditPosition = this.canEditPosition();
        this.prmtJobGrade.setReadOnly(!canEditPosition);
        if (canEditPosition) {
            String oql = "select id,seq,f7.id,f7.number,ui.id,ui.name,detail.* where f7.number = '" + PositionPromptBox2.class.getName() + "' and ui.name = 'com.kingdee.eas.hr.affair.client.EmpEnrollBizBillEditUI' ";
            F7ConfigCollection cc = F7ConfigFactory.getRemoteInstance().getF7ConfigCollection(oql);
            if (cc != null && cc.size() > 0) {
                F7ConfigDetailCollection dc = cc.get(0).getDetail();
                F7ConfigDetailInfo dInfo = null;
                if (dc != null) {
                    int size = dc.size();
                    for (int i = 0; i < size; ++i) {
                        dInfo = dc.get(i);
                        if (!"SCOPE".equals(dInfo.getProperty())) continue;
                        position.setScope(F7ScopeEnum.getEnum((String)dInfo.getValue()), (IF7ParamFromUI)new DefaultF7PramFromUI((CoreUIObject)this, this.getMainOrgContext(), OrgType.HRO, false));
                    }
                }
            }
        }
        boolean canEditJobGrade = this.canEditJobGrade();
        this.prmtJobGrade.setQueryInfo("com.kingdee.eas.hr.org.app.JobGradeListQuery");
        this.prmtJobGrade.setDisplayFormat("$name$");
        this.prmtJobGrade.setEditFormat("$number$");
        this.prmtJobGrade.setCommitFormat("$number$");
        if (this.prmtJobGrade.getSelector() == null) {
            this.prmtJobGrade.setSelector((KDPromptSelector)new JobGradePromptBox());
        }
        this.prmtJobGrade.setReadOnly(!canEditJobGrade);
        if (canEditJobGrade) {
            PositionInfo positionInfo = (PositionInfo)this.prmtPosition.getValue();
            this.setJobGradeEditor(positionInfo);
        }
        this.prmtAdminOrg.setReadOnly(true);
        this.prmtJob.setReadOnly(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("empType.isOnTheStrength"));
        sic.add(new SelectorItemInfo("empType.name"));
        sic.add(new SelectorItemInfo("empType.id"));
        sic.add(new SelectorItemInfo("affairActionReason.id"));
        sic.add(new SelectorItemInfo("affairActionReason.name"));
        sic.add(new SelectorItemInfo("bill.hrOrgUnit"));
        sic.add(new SelectorItemInfo("bill.billState"));
        return sic;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmpEnrollBizBillEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private HRBizDefineInfo getHrBizDefineInfo(String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("outEmpTypes.empType.id"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.name"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.number"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.isOnTheStrength"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.inService"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.workRelation"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.id"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.name"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.number"));
        return HRBizDefineFactory.getRemoteInstance().getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    private boolean canEditJobGrade() {
        return true;
    }

    private boolean canEditPosition() {
        return true;
    }

    @Override
    protected void prmtPosition_stateChanged(ChangeEvent e) throws Exception {
        PositionInfo positionInfo = (PositionInfo)this.prmtPosition.getValue();
        this.setJobGradeEditor(positionInfo);
        if (!this.hasLoadFields) {
            return;
        }
        if (positionInfo != null) {
            this.prmtAdminOrg.setValue((Object)positionInfo.getAdminOrgUnit());
            this.prmtJob.setValue((Object)positionInfo.getJob());
        } else {
            this.prmtAdminOrg.setValue(null);
            this.prmtJob.setValue(null);
        }
    }

    private void setJobGradeEditor(PositionInfo positionInfo) throws EASBizException, BOSException {
        if (positionInfo == null) {
            this.prmtJobGrade.setValue(null);
            this.prmtJobGrade.setEnabled(false);
            return;
        }
        if (positionInfo != null) {
            this.prmtJobGrade.setEnabled(true);
            String positionId = positionInfo.getId().toString();
            PositionRelatedInfo pRelatedInfo = null;
            pRelatedInfo = RelatedInfoGetFacadeFactory.getRemoteInstance().getPositionRelatedInfo(positionId);
            CtrlUnitInfo ctrlInfo = pRelatedInfo.getCu();
            HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
            cuSet.add(ctrlInfo);
            JobGradePromptBox selector = (JobGradePromptBox)this.prmtJobGrade.getSelector();
            if (selector == null) {
                selector = new JobGradePromptBox();
                this.prmtJobGrade.setSelector((KDPromptSelector)selector);
            }
            selector.changeContextByCUSet(cuSet);
            String cuid = ctrlInfo.getId().toString();
            if (this.oldCUid == null) {
                this.oldCUid = cuid;
            }
            if (!this.oldCUid.equals(cuid)) {
                this.prmtJobGrade.setValue(null);
            }
            this.oldCUid = cuid;
        }
    }

    public IObjectPK runSubmit() throws Exception {
        EmpEnrollBizBillFactory.getRemoteInstance().reviseEmpEnroll(this.editData);
        return new ObjectUuidPK(this.editData.getId());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtEmpNumber.isEnabled() && StringUtils.isEmpty((String)this.txtEmpNumber.getText())) {
            this.txtEmpNumber.requestFocusInWindow();
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getEmpName())) {
            this.txtEmpName.requestFocusInWindow();
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        if (this.cbEmpType.getSelectedItem() == null) {
            throw new EmployeeException(EmployeeException.EMPTYPECONVERT_TOTYPE_CANNOTEMPTY);
        }
        String strCardNo = this.txtIDCardNo.getText();
        String strPassportNo = this.txtPassportNo.getText();
        if (StringUtils.isEmpty((String)strCardNo) && StringUtils.isEmpty((String)strPassportNo)) {
            this.txtIDCardNo.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.PM_POSITION_MUST_NOT_NULL);
        }
        if (this.prmtPosition.getData() == null) {
            this.prmtPosition.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMP_PERSONDEP_NULL);
        }
        if (StringUtils.isEmpty((String)this.txtReviseReason.getText())) {
            this.txtReviseReason.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.REVISE_NOT_NULL);
        }
    }

    @Override
    protected void pkEnrollDate_dataChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        if (newValue != null) {
            Date newEnrollDate = (Date)newValue;
            int tryMonths = 0;
            if (this.txtProbation.getIntegerValue() != null) {
                tryMonths = this.txtProbation.getIntegerValue();
            }
            Date formalDate = DateTimeUtils.addMonth((Date)newEnrollDate, (int)tryMonths);
            this.pkFormalDate.setValue((Object)formalDate);
        }
    }

    @Override
    protected void txtProbation_dataChanged(DataChangeEvent e) throws Exception {
        Date newEnrollDate = (Date)this.pkEnrollDate.getValue();
        int tryMonths = 0;
        if (this.txtProbation.getIntegerValue() != null) {
            tryMonths = this.txtProbation.getIntegerValue();
        }
        Date formalDate = DateTimeUtils.addMonth((Date)newEnrollDate, (int)tryMonths);
        this.pkFormalDate.setValue((Object)formalDate);
    }

    public boolean isIDcardVerify() throws Exception {
        String paramNum = "IS_IDCARD_VERIFY";
        String hrOrgId = null;
        if (this.editData.getBill().getHrOrgUnit() != null) {
            hrOrgId = this.editData.getBill().getHrOrgUnit().getId().toString();
        }
        this.isIDCardVerify = HRParamUtil.getParamOfHR(null, (String)paramNum, hrOrgId);
        return this.isIDCardVerify;
    }

    public void addIDCardNOListener() {
        this.txtIDCardNo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                EmpEnrollBillReviseUI.this.setBirtDayAndSexByIDCaridNO();
            }
        });
    }

    public void addTryIDCardNOListener() {
        this.txtIDCardNo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                EmpEnrollBillReviseUI.this.trySetBirtDayAndSexByIDCaridNO();
            }
        });
    }

    private void setBirtDayAndSexByIDCaridNO() {
        String idCardNO = this.txtIDCardNo.getText();
        if (idCardNO == null || "".equals(idCardNO)) {
            return;
        }
        int intIdCaridNO = idCardNO.length();
        if (intIdCaridNO == 15 || intIdCaridNO == 18) {
            try {
                this.setDateBirthdayByIDCradNO(idCardNO, intIdCaridNO);
                this.setSexByIDCardNO(idCardNO, intIdCaridNO);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
            }
        }
    }

    private void setDateBirthdayByIDCradNO(String strIDCardNO, int cardType) throws Exception {
        String birthday;
        IDCardCommonUtil iDCardCommonUtil = new IDCardCommonUtil(strIDCardNO, this.isIDCardVerify);
        boolean isModify = true;
        String newBirthday = iDCardCommonUtil.getBirthday();
        if (this.pkBirthday.getValue() != null && !(birthday = DateTimeUtils.format((Date)((Date)this.pkBirthday.getValue()), (String)"yyyy-MM-dd")).equals(newBirthday)) {
            int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"BIRTHDAY_AUTO"));
            isModify = MsgBox.isYes((int)result);
        }
        if (isModify) {
            this.pkBirthday.setValue((Object)new SimpleDateFormat("yyyy-MM-dd").parse(newBirthday));
        }
    }

    private void setSexByIDCardNO(String strIDCardNO, int cardType) throws Exception {
        String lastNum = "";
        if (cardType == 15) {
            lastNum = strIDCardNO.substring(14);
        } else if (cardType == 18) {
            lastNum = strIDCardNO.substring(16, 17);
        }
        int sexNum = 0;
        try {
            sexNum = Integer.parseInt(lastNum) % 2;
        }
        catch (Exception ex) {
            throw new EmployeeException(EmployeeException.EMP_IDCARDINO_ERROR);
        }
        if (sexNum == 1) {
            this.comboGender.setSelectedItem((Object)Genders.Male);
        } else if (sexNum == 0) {
            this.comboGender.setSelectedItem((Object)Genders.Female);
        }
    }

    private void trySetBirtDayAndSexByIDCaridNO() {
        String idCardNO = this.txtIDCardNo.getText();
        if (StringUtils.isEmpty((String)idCardNO)) {
            return;
        }
        int intIdCaridNO = idCardNO.length();
        if (intIdCaridNO == 15 || intIdCaridNO == 18) {
            idCardNO = idCardNO.substring(6);
            idCardNO = intIdCaridNO == 15 ? "19" + idCardNO : idCardNO;
            String birthStr = "";
            String year = idCardNO.substring(0, 4);
            String month = idCardNO.substring(4, 6);
            String date = idCardNO.substring(6, 8);
            birthStr = year + "-" + month + "-" + date;
            try {
                String birthday;
                boolean isModify = true;
                if (this.pkBirthday.getValue() != null && !(birthday = DateTimeUtils.format((Date)((Date)this.pkBirthday.getValue()), (String)"yyyy-MM-dd")).equals(birthStr)) {
                    int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"BIRTHDAY_AUTO"));
                    isModify = MsgBox.isYes((int)result);
                }
                if (isModify) {
                    this.pkBirthday.setValue((Object)new SimpleDateFormat("yyyy-MM-dd").parse(birthStr));
                    this.editData.setBirthday(new SimpleDateFormat("yyyy-MM-dd").parse(birthStr));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setSexByIDCardNO(this.pkBirthday.getText(), intIdCaridNO);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

