/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.IEmpEnrollFromOtherSys;
import com.kingdee.eas.hr.affair.client.AbstractEmpEnrollBizBillEditUI;
import com.kingdee.eas.hr.affair.client.EmpEnrollBizBillEditUIBiz;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.affair.util.AffairForCmpUtil;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.PersonCheckException;
import com.kingdee.eas.hr.base.client.EditUIUtil;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpEnrollBizBillEditUI
extends AbstractEmpEnrollBizBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpEnrollBizBillEditUI.class);
    public static final String ENROLL_FROM_OTHERSYS = "ENROLL_FROM_OTHERSYS";
    private IEmpEnrollFromOtherSys enrollFromOthers = null;
    private final String IDCARDNUMBER = "IDCardNo";
    private final String PASSPORTNUMBER = "passportNo";

    @Override
    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        IDetailPanelListener addListener = ((EmpEnrollBizBillEditUIBiz)this.biz).getAddLineListener();
        this.kdtEntrys_detailPanel.addAddListener(addListener);
        this.kdtEntrys_detailPanel.addInsertListener(addListener);
        if (!(this.editData == null || StringUtils.isEmpty((String)this.editData.getEnrollFromOthers()) && this.editData.isIsMultiEntry())) {
            this.kdtEntrys_detailPanel.getAddNewLineButton().setEnabled(false);
            this.kdtEntrys_detailPanel.getInsertLineButton().setEnabled(false);
            this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(false);
            this.kdtEntrys_detailPanel.getAddNewLineButton().setVisible(false);
            this.kdtEntrys_detailPanel.getInsertLineButton().setVisible(false);
            this.kdtEntrys_detailPanel.getRemoveLinesButton().setVisible(false);
        }
        EditUIUtil.getDescriptionLabel((DetailPanel)this.kdtEntrys_detailPanel).setText(EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"51_EmpEnrollBizBillEditUI"));
        this.setIsParPersonAttributes();
    }

    @Override
    public String getTitle() {
        return EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"50_EmpEnrollBizBillEditUI");
    }

    @Override
    public void initLayout() {
        super.initLayout();
        this.kdtEntrys.getColumn("isParPerson").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("isParPerson").getStyleAttributes().setBackground(HRAffairClientUtils.DISABLE_FIELD_COLOR);
    }

    private void setIsParPersonAttributes() {
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("enrollFromOthers"));
        return selector;
    }

    @Override
    protected DetailPanel getIgnoredDetailPanel() {
        return null;
    }

    @Override
    protected void beforeOnLoad() throws Exception {
        Object otherSys = this.getUIContext().get(ENROLL_FROM_OTHERSYS);
        if (otherSys != null && otherSys instanceof IEmpEnrollFromOtherSys) {
            this.enrollFromOthers = (IEmpEnrollFromOtherSys)otherSys;
        }
        super.beforeOnLoad();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EmpEnrollBizBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        EmpEnrollBizBillEntryInfo entry = new EmpEnrollBizBillEntryInfo();
        return entry;
    }

    @Override
    protected IObjectValue createNewData() {
        EmpEnrollBizBillInfo objectValue = null;
        if (this.enrollFromOthers != null) {
            try {
                objectValue = this.enrollFromOthers.getEmpEnrollBizBillInfo();
                objectValue.setEnrollFromOthers(this.enrollFromOthers.getClass().getName());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.enrollFromOthers = null;
        } else {
            objectValue = new EmpEnrollBizBillInfo();
            UserInfo info = SysContext.getSysContext().getCurrentUserInfo();
            objectValue.setBillState(HRBillStateEnum.SAVED);
            objectValue.setApplier(info.getPerson());
        }
        objectValue.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return objectValue;
    }

    protected void loadData() throws Exception {
        super.loadData();
    }

    @Override
    public void loadFields() {
        ((EmpEnrollBizBillEditUIBiz)this.biz).beforeLoadData();
        super.loadFields();
    }

    @Override
    protected IHRBillEditUIBiz getBillBiz() {
        return new EmpEnrollBizBillEditUIBiz();
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        ((EmpEnrollBizBillEditUIBiz)this.biz).entryEditStopped(e);
    }

    @Override
    protected void kdtEntrys_editStopping(KDTEditEvent e) throws Exception {
        ((EmpEnrollBizBillEditUIBiz)this.biz).entryEditStopping(e);
    }

    @Override
    public void actionColumnCopyAll_actionPerformed(ActionEvent e) throws Exception {
        ((EmpEnrollBizBillEditUIBiz)this.biz).copyColumn(this.kdtEntrys, false);
    }

    @Override
    public void actionColumnCopySelect_actionPerformed(ActionEvent e) throws Exception {
        ((EmpEnrollBizBillEditUIBiz)this.biz).copyColumn(this.kdtEntrys, true);
    }

    protected boolean isShowMenuTable() {
        return true;
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.kdtEntrys_detailPanel.getAddNewLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(false);
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.EmpEnrollBizBillEditUIFunction";
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        IRow row = null;
        String personNum = null;
        boolean enrollAgain = false;
        String enrollAgainPersonID = null;
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtEntrys.getRow(i);
            personNum = (String)row.getCell("empNumber").getValue();
            enrollAgain = row.getCell("enrollAgain").getValue() != null ? (Boolean)row.getCell("enrollAgain").getValue() : false;
            enrollAgainPersonID = row.getCell("existPersonID").getValue() != null ? row.getCell("existPersonID").getValue().toString() : null;
            this.checkEmpNumber(personNum, enrollAgain, enrollAgainPersonID);
            if (row.getCell("xinDian").getStyleAttributes().isHided() || row.getCell("xinDian").getValue() == null) continue;
            SalariatHiberPropsInfo pointInfo = (SalariatHiberPropsInfo)row.getCell("xinDian").getValue();
            pointInfo.put("pointInfo", null);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void checkEmpNumber(String number, boolean enrollAgain, String enrollAgainPersonID) throws BOSException, EASBizException {
        ISQLExecutor iSQL;
        IRowSet rowSet;
        StringBuffer oql = new StringBuffer("select fempnumber,fbillId from T_HR_EmpEnrollBizBillEntry where fempnumber ='" + number + "'");
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            oql.append(" and fbillid <>'").append(this.editData.getId()).append("'");
        }
        if ((rowSet = (iSQL = SQLExecutorFactory.getRemoteInstance((String)oql.toString())).executeSQL()).size() <= 0) {
            return;
        }
        if (!enrollAgain) {
            throw new PersonCheckException(PersonCheckException.PERSONNUMBEREXIST, new Object[]{number});
        }
        boolean isCanIn = this.checkExistsPersonCanAgainIn(enrollAgainPersonID, number);
        if (!isCanIn) {
            throw new PersonCheckException(PersonCheckException.PERSONNUMBEREXIST, new Object[]{number});
        }
    }

    private boolean checkExistsPersonCanAgainIn(String personID, String empNumber) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)personID)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("number");
            selector.add("employeeType.inService");
            PersonInfo perInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personID), selector);
            if (!perInfo.getNumber().equals(empNumber)) {
                return false;
            }
            if (perInfo != null && perInfo.getEmployeeType() != null && perInfo.getEmployeeType().getInService().getValue() != 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (OprtState.VIEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState()) && this.editData != null) {
            EmpEnrollBizBillEntryCollection entryColl = this.editData.getEntrys();
            AffairForCmpUtil.setSalaryPointForEntry((IObjectCollection)entryColl, "xinDian");
        }
    }

    @Override
    public String getTarEmpTypeKey() {
        return "empType";
    }

    @Override
    public String getOldEmpTypeColumnKey() {
        return null;
    }

    @Override
    public String getOldAdminColumnKey() {
        return null;
    }

    @Override
    public String getOldPositionColumnKey() {
        return null;
    }

    @Override
    protected void propertyValueChange(KDTPropertyChangeEvent evt) throws EASBizException {
        Date enrollDate;
        super.propertyValueChange(evt);
        String oprtState = this.getOprtState();
        if (oprtState.equals(OprtState.VIEW)) {
            return;
        }
        int colIndex = evt.getColIndex();
        int rowIndex = evt.getRowIndex();
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (colIndex == this.kdtEntrys.getColumn("enrollDate").getColumnIndex()) {
            enrollDate = (Date)evt.getNewValue();
            row.getCell("bizDate").setValue((Object)enrollDate);
            Integer probation = (Integer)row.getCell("probation").getValue();
            if (enrollDate != null) {
                Date formalDate = DateTimeUtils.addMonth((Date)enrollDate, (int)probation);
                row.getCell("formalDate").setValue((Object)formalDate);
            }
        }
        if (colIndex == this.kdtEntrys.getColumn("probation").getColumnIndex()) {
            enrollDate = (Date)row.getCell("enrollDate").getValue();
            int probation = (Integer)evt.getNewValue();
            if (enrollDate != null) {
                Date proDate = DateTimeUtils.addMonth((Date)enrollDate, (int)probation);
                row.getCell("formalDate").setValue((Object)proDate);
            }
        }
        try {
            this.checkIDCardNoAndPassport(evt);
        }
        catch (Exception e) {
            this.kdtEntrys.getCell(rowIndex, colIndex).setValue(null);
            this.handUIException(e);
        }
        if (evt.getNewValue() instanceof String) {
            String newValue = (String)evt.getNewValue();
            ICell cell = this.kdtEntrys.getCell(rowIndex, colIndex);
            if (cell == null) {
                return;
            }
            ICellEditor cellEditor = cell.getEditor();
            if (cellEditor == null && (cellEditor = this.kdtEntrys.getColumn(colIndex).getEditor()) == null) {
                return;
            }
            Component comp = cellEditor.getComponent();
            if (comp instanceof KDComboBox) {
                KDComboBox comboBox = (KDComboBox)comp;
                int count = comboBox.getItemCount();
                int i = 0;
                for (i = 0; i < count; ++i) {
                    if (!newValue.equals(comboBox.getItemAt(i).toString())) continue;
                    cell.setValue(comboBox.getItemAt(i));
                    break;
                }
                if (i == count) {
                    cell.setValue(null);
                }
            }
        }
    }

    private void checkIDCardNoAndPassport(KDTPropertyChangeEvent evt) throws Exception {
        String colName = this.kdtEntrys.getColumnKey(evt.getColIndex());
        if (evt.getNewValue() instanceof String && ("IDCardNo".equals(colName) || "passportNo".equals(colName))) {
            IRow row = this.kdtEntrys.getRow(evt.getRowIndex());
            String number = (String)evt.getNewValue();
            if (number != null && !number.equals(evt.getOldValue())) {
                boolean isError;
                if ("IDCardNo".equals(colName) && evt.getOldValue() != null && evt.getOldValue() instanceof String) {
                    String _number = null;
                    _number = number.length() == 15 ? IDCardCommonUtil.IDCardNO15To18((String)number) : IDCardCommonUtil.IDCardNO18To15((String)number);
                    if (_number.equals(evt.getOldValue())) {
                        return;
                    }
                }
                if (isError = ((EmpEnrollBizBillEditUIBiz)this.biz).IDCardNoOrPassportNoEdit(row, colName, (String)evt.getNewValue())) {
                    this.kdtEntrys.getCell(evt.getRowIndex(), evt.getColIndex()).setValue(null);
                    this.kdtEntrys.getSelectManager().select(evt.getRowIndex(), evt.getColIndex());
                }
            }
        }
    }

    @Override
    protected boolean isNeedSetUserPermission() {
        return true;
    }

    @Override
    protected boolean isShowPersonDetail() {
        return false;
    }
}

