/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;

class FilterUIUtil {
    private static final long serialVersionUID = -61166L;

    FilterUIUtil() {
    }

    public static void saveData(CustomerParams params, Component comp) {
        com.kingdee.eas.hr.base.client.FilterUIUtil.saveData((CustomerParams)params, (Component)comp, null, (boolean)true);
    }

    public static void retriveData(CustomerParams params, Component comp) throws Exception {
        com.kingdee.eas.hr.base.client.FilterUIUtil.retriveData((CustomerParams)params, (Component)comp, null, (boolean)true);
    }

    public static void saveAllData(CustomerParams params, CustomerQueryPanel queryPanel) {
        com.kingdee.eas.hr.base.client.FilterUIUtil.saveAllData((CustomerParams)params, (CustomerQueryPanel)queryPanel);
    }

    public static CustomerParams saveAllData(CustomerQueryPanel queryPanel) {
        CustomerParams params = new CustomerParams();
        FilterUIUtil.saveAllData(params, queryPanel);
        return params;
    }

    public static void retriveAllData(CustomerParams params, CustomerQueryPanel queryPanel) {
        queryPanel.clear();
        com.kingdee.eas.hr.base.client.FilterUIUtil.retriveAllData((CustomerParams)params, (CustomerQueryPanel)queryPanel);
    }

    public static void setEmpF7Option(EmployeeMultiF7PromptBox f7) {
        f7.setIsSingleSelect(false);
        f7.setModal(true);
        f7.setIsShowAllAdmin(true);
        f7.showNoPositionPerson(true);
    }

    public static void setDisableColor(KDTable table) {
        Color color = Color.LIGHT_GRAY;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            IColumn column = table.getColumn(i);
            if (!column.getStyleAttributes().isLocked()) continue;
            column.getStyleAttributes().setBackground(color);
        }
    }

    public static int getSelectedRow(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        return selectBlock.getTop();
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        if (hrColumnName != null) {
            item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID);
            filter.getFilterItems().add(item);
        }
        return filter;
    }

    public static FilterInfo getS4CUFilter(String longNumberColumn, CtrlUnitInfo cu) throws BOSException, EASBizException {
        FilterInfo fi = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longNumber"));
        String longNumber = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cu.getId()), sic).getLongNumber();
        fi = new FilterInfo();
        String[] lnSecs = longNumber.split("!");
        HashSet<String> longNumberSet = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lnSecs.length; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            longNumberSet.add(sb.toString());
        }
        fi.getFilterItems().add(new FilterItemInfo(longNumberColumn, longNumberSet, CompareType.INCLUDE));
        return fi;
    }
}

