/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.service.FieldPermissionService;
import com.kingdee.eas.hr.affair.AffairRegFacadeFactory;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.FireBillEntryFactory;
import com.kingdee.eas.hr.affair.FireBillEntryInfo;
import com.kingdee.eas.hr.affair.FireBillFactory;
import com.kingdee.eas.hr.affair.FireBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairPersonPreProcessFacadeFactory;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.IAffairRegFacade;
import com.kingdee.eas.hr.affair.client.AbstractFireBillEditUI;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.affair.client.OrgFullNameRender;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.DimissionReasonFactory;
import com.kingdee.eas.hr.base.DimissionReasonInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryCollection;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class FireBillEditUI
extends AbstractFireBillEditUI {
    protected FireBillEntryInfo entryInfo = new FireBillEntryInfo();
    private KDNoteHelper appHlp = new KDNoteHelper();
    private String resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";
    public static final String FIRE_FILENAME = "/HR/OrgUnit/FireBill";
    private BOSUuid actPersonId;
    private String billId;
    private BOSUuid actEntryId;
    private EmployeeMultiF7PromptBox f7 = null;

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.prmtHROrg.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"HRORG_NOT_NULL"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        this.checkIsPersonInProcess();
        super.verifyInput(e);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext().get("enterPath") != null) {
            this.btnRemove.setEnabled(false);
        }
    }

    private void checkIsPersonInProcess() throws EASBizException, BOSException {
        String id = "";
        if (this.editData.getId() != null) {
            id = this.editData.getId().toString();
        }
        HRAffairClientUtils.checkIsPersonInProcess(this.kdtEntries, "person", this.editData.getBOSType(), id);
    }

    @Override
    protected ArrayList getNoDupColumns() {
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("person");
        return colList;
    }

    @Override
    protected ArrayList getNoNullColumns() {
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("person");
        colList.add("desireDate");
        colList.add("reason");
        colList.add("personDep");
        return colList;
    }

    @Override
    protected IObjectValue createNewData() {
        FireBillInfo info = new FireBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.nowDate != null) {
            info.setApplyDate(this.nowDate);
        }
        return info;
    }

    @Override
    protected void kdtEntries_editStopping(KDTEditEvent e) throws Exception {
        PersonInfo pInfo = null;
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntries.getColumn("person").getColumnIndex()) {
            pInfo = (PersonInfo)e.getValue();
            if (pInfo != null) {
                String billId = null;
                if (this.oprtState.equals(OprtState.EDIT)) {
                    billId = this.editData.getId() != null ? this.editData.getId().toString() : this.getUIContext().get("ID").toString();
                }
                if (HRAffairClientUtils.isPersonInProcess(this.editData.getBOSType(), this.entryInfo.getBOSType(), pInfo, billId)) {
                    e.setCancel(true);
                    throw new HRAffairException(HRAffairException.PERSON_IS_IN_PROCESS, new Object[]{pInfo.getName(), HRAffairClientUtils.PROMPT_PRESS_ESC});
                }
            }
        } else if (colIndex == this.kdtEntries.getColumn("desireDate").getColumnIndex() && e.getValue() != null && (pInfo = (PersonInfo)this.kdtEntries.getRow(e.getRowIndex()).getCell("person").getValue()) != null && HRAffairClientUtils.isDateBeforeEnrollDate(pInfo.getId().toString(), (Date)e.getValue())) {
            e.setCancel(true);
            throw new HRAffairException(HRAffairException.CAN_NOT_BEFORE_ENROLLDATE, new Object[]{this.kdtEntries.getHeadRow(0).getCell(colIndex).getValue().toString(), ""});
        }
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        DimissionReasonInfo drInfo;
        PersonInfo pInfo = null;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtEntries.getRow(e.getRowIndex());
        if (colIndex == this.kdtEntries.getColumn("reason").getColumnIndex() && (drInfo = (DimissionReasonInfo)e.getValue()) != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("dimissionReasonType.id"));
            selector.add(new SelectorItemInfo("dimissionReasonType.name"));
            selector.add(new SelectorItemInfo("dimissionReasonType.number"));
            drInfo = DimissionReasonFactory.getRemoteInstance().getDimissionReasonInfo((IObjectPK)new ObjectUuidPK(drInfo.getId()), selector);
            this.kdtEntries.getRow(rowIndex).getCell("reasonType").setValue((Object)drInfo.getDimissionReasonType());
            this.kdtEntries.getRow(rowIndex).getCell("reason").setValue((Object)drInfo);
        }
        if (colIndex == this.kdtEntries.getColumn("person").getColumnIndex()) {
            pInfo = (PersonInfo)e.getValue();
            if (pInfo != null && pInfo.getId() != null) {
                String personId = pInfo.getId().toString();
                pInfo = HRAffairClientUtils.getPersonInfo(personId);
                row.getCell("birthday").setValue((Object)pInfo.getBirthday());
                row.getCell("idCardNO").setValue((Object)pInfo.getIdCardNO());
                row.getCell("phone").setValue((Object)pInfo.getOfficePhone());
                row.getCell("gender").setValue((Object)pInfo.getGender());
                ArrayList degreeRelInfo = HRAffairClientUtils.getDegreeRelInfo(personId);
                if (degreeRelInfo != null) {
                    row.getCell("degree").setValue(degreeRelInfo.get(0));
                    row.getCell("graduateSchool").setValue(degreeRelInfo.get(1));
                    row.getCell("specialty").setValue(degreeRelInfo.get(2));
                }
                PositionMemberInfo postRelInfo = HRAffairClientUtils.getPersonMemberInfo(personId);
                PersonPositionInfo ppInfo = HRAffairClientUtils.getPersonPositionInfo(personId);
                if (ppInfo != null && ppInfo.getEnterDate() != null) {
                    row.getCell("enrollDate").setValue((Object)ppInfo.getEnterDate());
                    row.getCell("serviceYear").setValue((Object)HRAffairClientUtils.getYearDif(ppInfo.getEnterDate(), new Date()));
                    row.getCell("personDep").setValue((Object)ppInfo.getPersonDep());
                }
                if (postRelInfo != null) {
                    row.getCell("position").setValue((Object)postRelInfo.getPosition().getName());
                    row.getCell("eposition").setValue((Object)postRelInfo.getPosition());
                    row.getCell("dept").setValue((Object)postRelInfo.getPosition().getAdminOrgUnit().getDisplayName());
                    row.getCell("positionDate").setValue((Object)postRelInfo.getBeginDate());
                    TechnicalPostInfo jobTitleInfo = HRAffairClientUtils.getJobTitle(personId);
                    if (jobTitleInfo != null) {
                        row.getCell("jobTitle").setValue((Object)jobTitleInfo.getName());
                    }
                }
            } else if (e.getOldValue() != null) {
                row.getCell("birthday").setValue(null);
                row.getCell("idCardNO").setValue(null);
                row.getCell("phone").setValue(null);
                row.getCell("degree").setValue(null);
                row.getCell("graduateSchool").setValue(null);
                row.getCell("specialty").setValue(null);
                row.getCell("position").setValue(null);
                row.getCell("eposition").setValue(null);
                row.getCell("dept").setValue(null);
                row.getCell("positionDate").setValue(null);
                row.getCell("jobTitle").setValue(null);
                row.getCell("enrollDate").setValue(null);
                row.getCell("serviceYear").setValue(null);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FireBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
        try {
            KDBizPromptBox prmtAdmin = new KDBizPromptBox();
            String returnValue = null;
            returnValue = ParamManager.getParamValueIgnoreGroupControl(null, (String)"RESIGN_FIRE_RETIRE_SHOWADMINORG", null, (boolean)true);
            if (returnValue != null && "false".equalsIgnoreCase(returnValue)) {
                register.registerAdminByOrgRangePromptBox(prmtAdmin, this.kdtEntries.getColumn("personDep"));
            } else {
                register.registerAllAdminPromptBox(prmtAdmin, this.kdtEntries.getColumn("personDep"));
            }
            register.registerS4CommonQueryF7(new KDBizPromptBox(), "com.kingdee.eas.hr.base.app.DimissionReasonQuery", this.kdtEntries.getColumn("reason"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo != null && chgVo.isDiffrent() && chgVo.getNewOrg() != null && chgVo.getNewOrg() instanceof HROrgUnitInfo) {
            HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)chgVo.getNewOrg();
            this.kdtEntries.removeRows();
            HashSet<String> hroSet = new HashSet<String>();
            hroSet.add(hrOrgUnitInfo.getId().toString());
            if (this.f7 == null) {
                this.f7 = new EmployeeMultiF7PromptBox();
                this.f7.setIsSingleSelect(false);
                this.f7.setUserOrgRangeFilter(true);
                this.f7.setEnabledMultiSelection(true);
            }
            this.f7.setHROFilter(hroSet);
        }
    }

    @Override
    protected void setTableCellEditor() throws Exception {
        this.kdtEntries.getColumn("person").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("number").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("gender").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)HRAffairClientUtils.getGenderModel())));
        this.kdtEntries.getColumn("desireDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("desireDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("birthday").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("birthday").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("enrollDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("enrollDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("positionDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("positionDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("serviceYear").setEditor(EmployeeClientUtils.getIntCellEditor());
        this.kdtEntries.getColumn("serviceYear").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getIntFormatStr());
        this.kdtEntries.getColumn("remark").setEditor(EmployeeClientUtils.getTextAreaCellEditor((int)200));
        this.kdtEntries.getColumn("reasonType").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("suggestion").setEditor(EmployeeClientUtils.getTextAreaCellEditor((int)200));
        this.kdtEntries.getColumn("deptDirector").setEditor(this.getF7PerCellEditor(new EmployeeMultiF7PromptBox((IUIObject)this)));
        this.kdtEntries.getColumn("chargeLeader").setEditor(this.getF7PerCellEditor(new EmployeeMultiF7PromptBox((IUIObject)this)));
    }

    public ICellEditor getF7PerCellEditor(EmployeeMultiF7PromptBox selector) {
        KDBizPromptBox f7 = new KDBizPromptBox();
        selector.setIsSingleSelect(true);
        f7.setSelector((KDPromptSelector)selector);
        f7.setEditFormat("$number$");
        f7.setCommitFormat("$number$");
        f7.setDisplayFormat("$name$");
        f7.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        f7.setEditable(true);
        f7.setSelector((KDPromptSelector)selector);
        return new KDTDefaultCellEditor((IKDEditor)f7);
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        HRAffairClientUtils.checkIsAudited(this.editData);
        super.actionAddPerson_actionPerformed(e);
        PersonInfo personInfo = null;
        if (this.f7 == null) {
            this.f7 = new EmployeeMultiF7PromptBox();
            this.f7.setIsSingleSelect(false);
            this.f7.setUserOrgRangeFilter(true);
            this.f7.setEnabledMultiSelection(true);
        }
        this.f7.setIsPluralityIsChooseContral(HRParamUtil.getParamOfHR(null, (String)"PLURALITY_IS_CHOOSE", null));
        this.f7.show();
        if (!this.f7.isCanceled()) {
            List processedPerson;
            BatchProcessedResult result;
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.f7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.f7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
                this.kdtEntries.getSelectManager().select(0, 0);
            }
            if (this.f7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.f7.getData());
            }
            String billId = null;
            if (this.oprtState.equals(OprtState.EDIT)) {
                billId = this.editData.getId() != null ? this.editData.getId().toString() : this.getUIContext().get("ID").toString();
            }
            if ((result = HRAffairPersonPreProcessFacadeFactory.getRemoteInstance().preProcessFirePerson(persons, billId)) == null) {
                return;
            }
            if (result.isHasValidInfo()) {
                MsgBox.showWarning((Component)((Object)this), (String)result.getInvalidInfo());
            }
            if ((processedPerson = result.getResult()) != null && processedPerson.size() > 0) {
                for (int i = 0; i < processedPerson.size(); ++i) {
                    personInfo = (PersonInfo)processedPerson.get(i);
                    this.fillKdtEntryTable(personInfo);
                }
            }
            if (this.kdtEntries.getRowCount() > 0) {
                this.kdtEntries.getSelectManager().select(0, 0);
            }
        }
    }

    private void fillKdtEntryTable(PersonInfo info) throws Exception {
        if (info == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = null;
        int length = this.kdtEntries.getRowCount();
        for (int i = 0; i < length; ++i) {
            iCell = this.kdtEntries.getRow(i).getCell("person");
            if (iCell.getValue() == null || !iCell.getValue().toString().equalsIgnoreCase(info.getId().toString())) continue;
            return;
        }
        if (info != null) {
            String billId = null;
            if (this.oprtState.equals(OprtState.EDIT)) {
                billId = this.editData.getId() != null ? this.editData.getId().toString() : this.getUIContext().get("ID").toString();
            }
            if (HRAffairClientUtils.isPersonInCompleteProcess(this.editData.getBOSType(), this.entryInfo.getBOSType(), info, billId)) {
                throw new HRAffairException(HRAffairException.PERSON_FIRE_COMPLETE, new Object[]{info.getName()});
            }
            if (!HRAffairClientUtils.isPersonInProcess(this.editData.getBOSType(), this.entryInfo.getBOSType(), info, billId)) {
                iRow = this.kdtEntries.addRow();
                iCell = iRow.getCell("person");
                iCell.setValue((Object)info);
            } else {
                String billNumber = null;
                billNumber = HRAffairClientUtils.getNumberInProcessOfPerson(this.editData.getBOSType(), this.entryInfo.getBOSType(), info, "");
                if (billNumber != null) {
                    throw new HRAffairException(HRAffairException.PERSON_IN_NUMBER_PROCESS, new Object[]{info, billNumber});
                }
            }
            if (iCell.getColumnIndex() == this.kdtEntries.getColumn("person").getColumnIndex() && info != null && info.getId() != null) {
                String personId = info.getId().toString();
                info = HRAffairClientUtils.getPersonInfo(personId);
                iRow.getCell("number").setValue((Object)info.getNumber());
                iRow.getCell("birthday").setValue((Object)info.getBirthday());
                iRow.getCell("idCardNO").setValue((Object)info.getIdCardNO());
                iRow.getCell("phone").setValue((Object)info.getOfficePhone());
                iRow.getCell("gender").setValue((Object)info.getGender());
                ArrayList degreeRelInfo = HRAffairClientUtils.getDegreeRelInfo(personId);
                if (degreeRelInfo != null) {
                    iRow.getCell("degree").setValue(degreeRelInfo.get(0));
                    iRow.getCell("graduateSchool").setValue(degreeRelInfo.get(1));
                    iRow.getCell("specialty").setValue(degreeRelInfo.get(2));
                }
                PositionMemberInfo postRelInfo = HRAffairClientUtils.getPersonMemberInfo(personId);
                PersonPositionInfo ppInfo = HRAffairClientUtils.getPersonPositionInfo(personId);
                if (ppInfo != null && ppInfo.getEnterDate() != null) {
                    iRow.getCell("enrollDate").setValue((Object)ppInfo.getEnterDate());
                    iRow.getCell("serviceYear").setValue((Object)HRAffairClientUtils.getYearDif(ppInfo.getEnterDate(), new Date()));
                    iRow.getCell("personDep").setValue((Object)ppInfo.getPersonDep());
                }
                if (postRelInfo != null) {
                    iRow.getCell("position").setValue((Object)postRelInfo.getPosition().getName());
                    iRow.getCell("eposition").setValue((Object)postRelInfo.getPosition());
                    iRow.getCell("dept").setValue((Object)postRelInfo.getPosition().getAdminOrgUnit().getDisplayName());
                    if (iRow.getCell("personDep").getValue() == null) {
                        iRow.getCell("personDep").setValue((Object)postRelInfo.getPosition().getAdminOrgUnit());
                    }
                    iRow.getCell("positionDate").setValue((Object)postRelInfo.getBeginDate());
                    TechnicalPostInfo jobTitleInfo = HRAffairClientUtils.getJobTitle(personId);
                    if (jobTitleInfo != null) {
                        iRow.getCell("jobTitle").setValue((Object)jobTitleInfo.getName());
                    }
                }
            }
        }
    }

    @Override
    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        HRAffairClientUtils.checkIsAudited(this.editData);
        super.actionDelPerson_actionPerformed(e);
        if (this.kdtEntries.getRowCount() <= 0) {
            return;
        }
        int[] selectRows = FireBillEditUI.getSelectedRows(this.kdtEntries);
        this.kdtEntries.getSelectManager().setSelectMode(10);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.kdtEntries.removeRow(selectRows[i]);
        }
        if (this.kdtEntries.getRowCount() >= 0) {
            this.kdtEntries.getSelectManager().select(0, 0);
        }
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.pInfo = this.editData.getProposer();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setProposer(this.pInfo);
        IObjectCollection c = (IObjectCollection)this.editData.get("entries");
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        if (this.editData.isIsMultiEntry()) {
            this.editData.put("entries", HRAffairClientUtils.getEntriesByKDTable(this.kdtEntries, c));
        }
        String versionStr = null;
        try {
            versionStr = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (versionStr != null && versionStr.equals("hnjt") && this.editData.getBizState().equals((Object)HRAffairState.COMPLETE) && OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAffairReg.setEnabled(true);
            this.btnAffairReg.setVisible(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.displayName"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.gender"));
        sic.add(new SelectorItemInfo("entries.desireDate"));
        sic.add(new SelectorItemInfo("entries.phone"));
        sic.add(new SelectorItemInfo("entries.reasonType.id"));
        sic.add(new SelectorItemInfo("entries.reasonType.number"));
        sic.add(new SelectorItemInfo("entries.reasonType.name"));
        sic.add(new SelectorItemInfo("entries.reasonTypeType.id"));
        sic.add(new SelectorItemInfo("entries.reasonTypeType.number"));
        sic.add(new SelectorItemInfo("entries.reasonTypeType.name"));
        sic.add(new SelectorItemInfo("entries.suggestion"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.dept"));
        sic.add(new SelectorItemInfo("entries.position"));
        sic.add(new SelectorItemInfo("entries.jobTitle"));
        sic.add(new SelectorItemInfo("entries.idCardNO"));
        sic.add(new SelectorItemInfo("entries.birthday"));
        sic.add(new SelectorItemInfo("entries.graduateSchool"));
        sic.add(new SelectorItemInfo("entries.specialty"));
        sic.add(new SelectorItemInfo("entries.degree"));
        sic.add(new SelectorItemInfo("entries.enrollDate"));
        sic.add(new SelectorItemInfo("entries.positionDate"));
        sic.add(new SelectorItemInfo("entries.serviceYear"));
        sic.add(new SelectorItemInfo("entries.personDep.id"));
        sic.add(new SelectorItemInfo("entries.personDep.number"));
        sic.add(new SelectorItemInfo("entries.personDep.name"));
        sic.add(new SelectorItemInfo("entries.personDep.displayName"));
        sic.add(new SelectorItemInfo("entries.deptDirector.id"));
        sic.add(new SelectorItemInfo("entries.deptDirector.name"));
        sic.add(new SelectorItemInfo("entries.deptDirector.number"));
        sic.add(new SelectorItemInfo("entries.chargeLeader.id"));
        sic.add(new SelectorItemInfo("entries.chargeLeader.number"));
        sic.add(new SelectorItemInfo("entries.chargeLeader.name"));
        sic.add(new SelectorItemInfo("entries.eposition.id"));
        sic.add(new SelectorItemInfo("entries.eposition.number"));
        sic.add(new SelectorItemInfo("entries.eposition.name"));
        return sic;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRowAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnRowDelete.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnCopy.setEnabled(this.btnSubmit.isEnabled());
        this.btnCopy.setVisible(true);
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemCopyToColumn.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemCopyToColumn.setEnabled(this.btnSubmit.isEnabled());
        this.menuItemCopyToColumn.setVisible(true);
        this.kdtEntries.setColumnMoveable(true);
        this.setEnableByClient();
        if (this.kdtEntries.getColumn("idCardNO") != null) {
            this.kdtEntries.getColumn("idCardNO").getStyleAttributes().setNumberFormat("@");
        }
        this.setComboSubmitTypeValueByParam("Dis001");
        this.kdtEntries.getColumn("personDep").setRenderer((IBasicRender)new OrgFullNameRender());
    }

    private void setEnableByClient() {
        String clientName = null;
        try {
            clientName = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if ("hnjt".equals(clientName)) {
            this.kdtEntries.getColumn("deptDirector").getStyleAttributes().setHided(false);
            this.kdtEntries.getColumn("chargeLeader").getStyleAttributes().setHided(false);
        } else {
            this.kdtEntries.getColumn("deptDirector").getStyleAttributes().setHided(true);
            this.kdtEntries.getColumn("chargeLeader").getStyleAttributes().setHided(true);
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (size > 0) {
            sb = this.kdtEntries.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.kdtEntries.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.kdtEntries.getCell(row, column).getValue();
            int length = this.kdtEntries.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row || this.kdtEntries.getCell(i, column).getStyleAttributes().isLocked()) continue;
                iCell = this.kdtEntries.getCell(i, column);
                iCell.setValue(value);
                if (column != this.kdtEntries.getColumn("reason").getColumnIndex()) continue;
                int resonTypeColumn = this.kdtEntries.getColumn("reasonType").getColumnIndex();
                Object reasonType = this.kdtEntries.getCell(row, resonTypeColumn).getValue();
                iCell = this.kdtEntries.getCell(i, resonTypeColumn);
                iCell.setValue(reasonType);
            }
        }
    }

    @Override
    public void actionAffairReg_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (this.billId == null) {
            this.billId = this.editData.getId().toString();
        }
        if (size > 0) {
            Object value1;
            sb = this.kdtEntries.getSelectManager().get(0);
            int row = sb.getTop();
            Object value = this.kdtEntries.getCell(row, 1).getValue();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.number", value));
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)this.billId));
            filter.setMaskString(" #0 and #1 ");
            ev.setFilter(filter);
            HRBillBaseEntryCollection fireCols = FireBillEntryFactory.getRemoteInstance().getHRBillBaseEntryCollection(ev);
            if (fireCols != null && fireCols.size() > 0) {
                this.actPersonId = ((FireBillEntryInfo)fireCols.get(0)).getPerson().getId();
            }
            if ((value1 = this.kdtEntries.getCell(row, 21).getValue()) != null) {
                this.actEntryId = BOSUuid.read((String)value1.toString());
            }
        }
        if (this.actPersonId != null && this.actEntryId != null) {
            DataProvider data = new DataProvider();
            this.appHlp.printPreview(FIRE_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
        }
    }

    protected void doFieldPermission() throws Exception {
        FieldPermission fields = this.getOldFieldPermission();
        super.doFieldPermission();
        DataBinder db = this.getMyDataBinder();
        BOSObjectType bizObjectType = this.getBizType();
        IObjectPK userPK = this.getUserPk();
        IObjectPK orgPK = this.getOrgPK(null);
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        FieldPermissionService.doFieldPermission((BOSObjectType)bizObjectType, (IObjectPK)userPK, (IObjectPK)orgPK, (DataBinder)db, (FieldPermission)fields);
    }

    private DataBinder getMyDataBinder() {
        DataBinder db = new DataBinder();
        db.registerBinding("entries", FireBillEntryInfo.class, (Component)this.kdtEntries, "userObject");
        db.registerBinding("proposer", String.class, (Component)this.txtProposer, "text");
        String columnName = null;
        String key = null;
        int size = this.kdtEntries.getColumnCount();
        for (int i = 0; i < size; ++i) {
            columnName = this.kdtEntries.getColumnKey(i);
            if ("eposition".equals(columnName)) continue;
            key = "oldJob".equals(columnName) ? "oldPosition" : ("newJob".equals(columnName) ? "newPosition" : columnName);
            db.registerBinding("entries." + key, Object.class, (Component)this.kdtEntries, columnName + ".text");
        }
        return db;
    }

    public DataBinder getDataBinder() {
        return this.getMyDataBinder();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isPrepareActionSubmit() {
        return true;
    }

    public boolean isPrepareActionSave() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        OrgUnitInfo initOrg = null;
        if (this.getUIContext() != null && (initOrg = (OrgUnitInfo)this.getUIContext().get(this.getMainOrgType())) != null && initOrg instanceof HROrgUnitInfo) {
            request.put("hr_mainOrgId", (Object)initOrg.getId().toString());
        }
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    @Override
    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSave(itemAction);
        request.put("number", (Object)this.txtNumber.getText());
        request.put("actionSubmitSt", (Object)this.actionSubmit.toString());
        return request;
    }

    @Override
    protected String getPrintPath() {
        return FIRE_FILENAME;
    }

    @Override
    protected String getBaseInfoPrintQuery() {
        return "com.kingdee.eas.hr.affair.app.FireBaseInfoQuery";
    }

    @Override
    protected String getApproveInfoPrintQuery() {
        return "com.kingdee.eas.hr.affair.app.FireApproveInfoQuery";
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            try {
                IAffairRegFacade iAffairReg = AffairRegFacadeFactory.getRemoteInstance();
                if (ds.getID() != null) {
                    if (ds.getID().equals("ds10")) {
                        return iAffairReg.getAffairBillRegByEntry(AffairTypeEnum.FIRE, FireBillEditUI.this.actEntryId, BOSUuid.read((String)FireBillEditUI.this.billId));
                    }
                    if (ds.getID().equals("ds11")) {
                        return iAffairReg.getMultiApproveDecByPerson(AffairTypeEnum.FIRE, FireBillEditUI.this.actPersonId, BOSUuid.read((String)FireBillEditUI.this.billId));
                    }
                }
            }
            catch (BOSException e) {
                FireBillEditUI.this.handUIException(e);
            }
            catch (EASBizException e) {
                FireBillEditUI.this.handUIException(e);
            }
            return null;
        }
    }
}

