/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FlucInBizBillFactory;
import com.kingdee.eas.hr.affair.FlucInBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.client.AbstractFlucInBizBillEditUI;
import com.kingdee.eas.hr.affair.client.FlucInBizBillEditUIBiz;
import com.kingdee.eas.hr.affair.util.AffairForCmpUtil;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FlucInBizBillEditUI
extends AbstractFlucInBizBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FlucInBizBillEditUI.class);

    @Override
    public void initLayout() {
        super.initLayout();
        KDTextField kdtEntrys_personnelNumber_TextField = new KDTextField();
        kdtEntrys_personnelNumber_TextField.setName("kdtEntrys_personnelNumber_TextField");
        kdtEntrys_personnelNumber_TextField.setMaxLength(80);
        KDTDefaultCellEditor kdtEntrys_personnelNumber_CellEditor = new KDTDefaultCellEditor((JTextField)kdtEntrys_personnelNumber_TextField);
        this.kdtEntrys.getColumn("personnelNumber").setEditor((ICellEditor)kdtEntrys_personnelNumber_CellEditor);
    }

    @Override
    public String getTitle() {
        return EASResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label20");
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (OprtState.VIEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState()) && this.editData != null) {
            FlucInBizBillEntryCollection entryColl = this.editData.getEntrys();
            AffairForCmpUtil.setSalaryPointForEntry((IObjectCollection)entryColl, "salaryPoint");
        }
    }

    @Override
    protected IHRBillEditUIBiz getBillBiz() {
        return new FlucInBizBillEditUIBiz();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FlucInBizBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    @Override
    protected IObjectValue createNewData() {
        UserInfo info = SysContext.getSysContext().getCurrentUserInfo();
        if ("TRUE".equalsIgnoreCase((String)this.getUIContext().get("IsPersonal"))) {
            this.checkPersonInPool(info.getPerson());
        }
        FlucInBizBillInfo objectValue = new FlucInBizBillInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBillState(HRBillStateEnum.SAVED);
        objectValue.setApplier(info.getPerson());
        return objectValue;
    }

    private void checkPersonInPool(PersonInfo pInfo) {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.affair.app.EmployeePoolListQuery2");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId(), CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        exec.setObjectView(ev);
        try {
            IRowSet selectItemRowSet = exec.executeQuery();
            if (!selectItemRowSet.next()) {
                throw new HRAffairException(HRAffairException.PERSON_NOT_IN_POOL);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        ((FlucInBizBillEditUIBiz)this.biz).addEmpPoolF7(false);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        ((FlucInBizBillEditUIBiz)this.biz).addEmpPoolF7(true);
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        ((FlucInBizBillEditUIBiz)this.biz).entryEditStopped(e);
    }

    @Override
    protected void kdtEntrys_editStopping(KDTEditEvent e) throws Exception {
        ((FlucInBizBillEditUIBiz)this.biz).entryEditStopping(e);
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.FlucInBizBillEditUIFunction";
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.setSalaryPointNull();
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.setSalaryPointNull();
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public String getTarEmpTypeKey() {
        return null;
    }

    @Override
    public String getOldEmpTypeColumnKey() {
        return null;
    }

    @Override
    protected void propertyValueChange(KDTPropertyChangeEvent evt) throws EASBizException {
        Date chkEndDate;
        Integer chkLength;
        Date bizDate;
        super.propertyValueChange(evt);
        int colIndex = evt.getColIndex();
        int rowIndex = evt.getRowIndex();
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (colIndex == this.kdtEntrys.getColumn("bizDate").getColumnIndex()) {
            bizDate = (Date)row.getCell("bizDate").getValue();
            chkLength = (Integer)row.getCell("chkLength").getValue();
            if (chkLength != null && bizDate != null) {
                chkEndDate = DateTimeUtils.addMonth((Date)bizDate, (int)chkLength);
                row.getCell("chkEndDate").setValue((Object)chkEndDate);
            }
        }
        if (colIndex == this.kdtEntrys.getColumn("chkLength").getColumnIndex()) {
            bizDate = (Date)row.getCell("bizDate").getValue();
            chkLength = (Integer)evt.getNewValue();
            if (chkLength != null && bizDate != null) {
                chkEndDate = DateTimeUtils.addMonth((Date)bizDate, (int)chkLength);
                row.getCell("chkEndDate").setValue((Object)chkEndDate);
            }
        }
    }

    private void setSalaryPointNull() {
        IRow row = null;
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.kdtEntrys.getRow(i);
            if (row.getCell("salaryPoint").getStyleAttributes().isHided() || row.getCell("salaryPoint").getValue() == null) continue;
            SalariatHiberPropsInfo pointInfo = (SalariatHiberPropsInfo)row.getCell("salaryPoint").getValue();
            pointInfo.put("pointInfo", null);
        }
    }

    @Override
    protected boolean isNeedSetUserPermission() {
        return true;
    }
}

