/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.service.FieldPermissionService;
import com.kingdee.eas.hr.affair.AffairRegFacadeFactory;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairPersonPreProcessFacadeFactory;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.HireBillEntryFactory;
import com.kingdee.eas.hr.affair.HireBillEntryInfo;
import com.kingdee.eas.hr.affair.HireBillFactory;
import com.kingdee.eas.hr.affair.HireBillInfo;
import com.kingdee.eas.hr.affair.IAffairRegFacade;
import com.kingdee.eas.hr.affair.client.AbstractHireBillEditUI;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.HRBillBaseEntryCollection;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.IFixedCmpSchemePerson;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.EmpForCmpFacadeFactory;
import com.kingdee.eas.hr.emp.IEmpForCmpFacade;
import com.kingdee.eas.hr.emp.IPersonDegree;
import com.kingdee.eas.hr.emp.PersonDegreeCollection;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.SwingUtilities;

public class HireBillEditUI
extends AbstractHireBillEditUI {
    protected HireBillEntryInfo entryInfo = new HireBillEntryInfo();
    private final String AffairRes = "com.kingdee.eas.hr.affair.HRAffairResource";
    private BOSUuid actPersonId;
    private String billId;
    private BOSUuid actEntryId;
    private EmployeeMultiF7PromptBox f7 = null;
    private int rowIndex = -1;
    private String salSchemeId = "";
    private Map mapPoint = null;
    private KDBizPromptBox bizPromptBox;
    private ItemListener joblevelItemLisener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                IRow row = null;
                row = HireBillEditUI.this.kdtEntries.getRow(HireBillEditUI.this.rowIndex);
                JobLevelInfo joblevel = null;
                if (1 == e.getStateChange()) {
                    joblevel = (JobLevelInfo)e.getItem();
                    JobGradeInfo jobGrade = AffairUtil.getJobGradeByJobLevel(joblevel);
                    if ("true".equals(AffairUtil.getParamForClient("AutoGetJob", HireBillEditUI.this.getCurrentHRO()))) {
                        row.getCell("jobGrade").setValue((Object)jobGrade);
                    }
                }
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    };
    private KDNoteHelper appHlp = new KDNoteHelper();
    private String resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";
    public static final String Hire_FILENAME = "/HR/OrgUnit/HireBill";

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext().get("enterPath") != null) {
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.prmtHROrg.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"HRORG_NOT_NULL"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        this.checkIsPersonInProcess();
        super.verifyInput(e);
    }

    private void checkIsPersonInProcess() throws EASBizException, BOSException {
        String id = "";
        if (this.editData.getId() != null) {
            id = this.editData.getId().toString();
        }
        HRAffairClientUtils.checkIsPersonInProcess(this.kdtEntries, "person", this.editData.getBOSType(), id);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.pInfo = this.editData.getProposer();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setProposer(this.pInfo);
        IObjectCollection c = (IObjectCollection)this.editData.get("entries");
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        if (this.editData.isIsMultiEntry()) {
            this.editData.put("entries", HRAffairClientUtils.getEntriesByKDTable(this.kdtEntries, c));
        }
        String versionStr = null;
        try {
            versionStr = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (versionStr != null && versionStr.equals("hnjt") && this.editData.getBizState().equals((Object)HRAffairState.COMPLETE) && OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAffairReg.setEnabled(true);
            this.btnAffairReg.setVisible(true);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        HireBillInfo info = new HireBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.nowDate != null) {
            info.setApplyDate(this.nowDate);
        }
        return info;
    }

    @Override
    protected ArrayList getNoNullColumns() {
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("person");
        colList.add("hireDate");
        return colList;
    }

    @Override
    protected ArrayList getNoDupColumns() {
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("person");
        return colList;
    }

    private void getDateAfter(Date beginDate, int month) {
        DateTimeUtils.addMonth((Date)beginDate, (int)month);
    }

    private boolean isFormEmp(String personId) throws Exception {
        PersonCollection c = PersonFactory.getRemoteInstance().getPersonCollection("select employeeType.id where id = '" + personId + "'");
        return c.size() > 0 && c.get(0).getEmployeeType().getId().toString().equals("00000000-0000-0000-0000-000000000001A29E85B3");
    }

    @Override
    protected void kdtEntries_editStopping(KDTEditEvent e) throws Exception {
        PersonInfo pInfo = null;
        Object row = null;
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntries.getColumn("person").getColumnIndex() && (pInfo = (PersonInfo)e.getValue()) != null) {
            String billId = null;
            if (this.oprtState.equals(OprtState.EDIT)) {
                billId = this.editData.getId() != null ? this.editData.getId().toString() : this.getUIContext().get("ID").toString();
            }
            if (this.isFormEmp(pInfo.getId().toString())) {
                e.setCancel(true);
                throw new HRAffairException(HRAffairException.HIRE_EMPLOYEETYPE_NOT_FORMAL);
            }
            if (HRAffairClientUtils.isPersonInProcess(this.editData.getBOSType(), this.entryInfo.getBOSType(), pInfo, billId)) {
                e.setCancel(true);
                throw new HRAffairException(HRAffairException.PERSON_IS_IN_PROCESS, new Object[]{pInfo.getName(), HRAffairClientUtils.PROMPT_PRESS_ESC});
            }
        }
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        PersonInfo pInfo = null;
        IRow row = null;
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntries.getColumn("person").getColumnIndex()) {
            pInfo = (PersonInfo)e.getValue();
            if (pInfo != null) {
                JobGradeInfo jgInfo;
                ArrayList data = HRAffairClientUtils.getPersonDatas(pInfo.getId().toString());
                ArrayList postAndOrg = HRAffairClientUtils.getPersonPostAndOrgName(pInfo.getId().toString());
                ArrayList postOrg = HRAffairClientUtils.getPersonPostAndOrg(pInfo.getId().toString());
                row = this.kdtEntries.getRow(e.getRowIndex());
                if (data != null) {
                    row.getCell("number").setValue(data.get(0));
                    row.getCell("phone").setValue(data.get(1));
                    if (data.get(2) != null) {
                        row.getCell("enrollDate").setValue(data.get(2));
                    }
                    if (data.get(3) != null) {
                        row.getCell("tryoutMonth").setValue(data.get(3));
                    }
                    if (data.get(2) != null && data.get(3) != null) {
                        row.getCell("hireDate").setValue((Object)DateTimeUtils.addMonth((Date)((Date)data.get(2)), (int)((Integer)data.get(3))));
                    }
                }
                if (postAndOrg != null) {
                    row.getCell("position").setValue(postAndOrg.get(0));
                    row.getCell("dept").setValue(postAndOrg.get(postAndOrg.size() - 1));
                }
                if (postOrg != null) {
                    row.getCell("eposition").setValue((Object)((PositionInfo)postOrg.get(0)));
                }
                if ((jgInfo = HRAffairClientUtils.getJobGradeInfo(pInfo.getId().toString())) != null) {
                    row.getCell("jobGrade").setValue((Object)jgInfo);
                }
            }
        } else if (colIndex == this.kdtEntries.getColumn("newSalePoint").getColumnIndex()) {
            row = this.kdtEntries.getRow(e.getRowIndex());
            if (row.getCell("newSalePoint").getValue() != null) {
                SalariatHiberPropsInfo info = (SalariatHiberPropsInfo)row.getCell("newSalePoint").getValue();
                row.getCell("salPointSalGradeID").setValue((Object)((String)info.get("fSalPointSalGradeID")));
            } else {
                row.getCell("salPointSalGradeID").setValue(null);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return HireBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
        KDBizPromptBox jobGradePrmpt = new KDBizPromptBox();
        jobGradePrmpt.setEditable(false);
        jobGradePrmpt.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    PositionInfo psInfo = null;
                    IRow row = null;
                    row = HireBillEditUI.this.kdtEntries.getRow(HireBillEditUI.this.rowIndex);
                    psInfo = (PositionInfo)row.getCell("eposition").getValue();
                    JobGradeInfo jobGrade = (JobGradeInfo)e.getData();
                    JobLevelInfo joblevel = AffairUtil.getJobLevelByGradeAndPosition(jobGrade, psInfo);
                    if ("true".equals(AffairUtil.getParamForClient("AutoGetJob", HireBillEditUI.this.getCurrentHRO()))) {
                        row.getCell("newJobLevel").setValue((Object)joblevel);
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        register.registerJobGradePromptBox(jobGradePrmpt, this.kdtEntries.getColumn("jobGrade"));
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo != null && chgVo.isDiffrent()) {
            this.kdtEntries.removeRows();
            if (chgVo.getNewOrg() != null && chgVo.getNewOrg() instanceof HROrgUnitInfo) {
                HashSet<String> hroSet = new HashSet<String>();
                hroSet.add(((HROrgUnitInfo)chgVo.getNewOrg()).getId().toString());
                if (this.f7 == null) {
                    this.f7 = new EmployeeMultiF7PromptBox();
                    this.f7.setIsSingleSelect(false);
                    this.f7.setUserOrgRangeFilter(true);
                    this.f7.setEnabledMultiSelection(true);
                    this.f7.showOnlyTryoutPerson(true);
                }
                this.f7.setHROFilter(hroSet);
            }
            SalariatSchemeInfo info = null;
            try {
                String sql = "SELECT FSalariatScheme from T_HR_FixedCmpScheme WHERE FEnable=1 AND FHROrgUnitID='" + ((HROrgUnitInfo)chgVo.getNewOrg()).getId().toString() + "'";
                ISalariatScheme iSalariatScheme = null;
                iSalariatScheme = SalariatSchemeFactory.getRemoteInstance();
                if (iSalariatScheme.exists("where id in (" + sql + ")")) {
                    info = iSalariatScheme.getSalariatSchemeInfo("where id in (" + sql + ")");
                }
            }
            catch (Exception sql) {
                // empty catch block
            }
            this.salSchemeId = null;
            this.mapPoint = null;
            if (info != null) {
                this.salSchemeId = info.getId().toString();
                try {
                    this.mapPoint = HRUtils.getPointValueMap((String)this.salSchemeId);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
    }

    @Override
    protected void setTableCellEditor() throws Exception {
        EmployeeMultiF7PromptBox f7 = new EmployeeMultiF7PromptBox();
        f7.setIsSingleSelect(true);
        f7.setEnabledMultiSelection(false);
        f7.showOnlyTryoutPerson(true);
        this.kdtEntries.getColumn("person").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("number").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("hireDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("hireDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("tryoutMonth").setEditor(EmployeeClientUtils.getIntCellEditor((Comparable)Integer.getInteger("120")));
        this.kdtEntries.getColumn("tryoutMonth").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getIntFormatStr());
        this.kdtEntries.getColumn("hireSalary").getStyleAttributes().setHided(true);
        this.kdtEntries.getColumn("hireSalary").setEditor(EmployeeClientUtils.getDecimalCellEditor((Comparable)new BigDecimal("999999.99")));
        this.kdtEntries.getColumn("hireSalary").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getMoneyFormatStr());
        this.kdtEntries.getColumn("assessResult").setEditor(EmployeeClientUtils.getFloatCellEditor((Comparable)Float.valueOf("9999.99"), (int)2));
        this.kdtEntries.getColumn("assessResult").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getMoneyFormatStr());
        this.kdtEntries.getColumn("remark").setEditor(EmployeeClientUtils.getTextAreaCellEditor((int)200));
        this.kdtEntries.getColumn("jobGrade").setEditor(EmployeeClientUtils.getF7CellEditor((KDPromptSelector)new JobGradePromptBox((IUIObject)this)));
        this.kdtEntries.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                if (OprtState.EDIT.equals(HireBillEditUI.this.getOprtState())) {
                    for (int i = e.getSelectBlock().getBeginRow(); i <= e.getSelectBlock().getEndRow() && i >= 0; ++i) {
                        Object positionValue = HireBillEditUI.this.kdtEntries.getRow(i).getCell("eposition").getValue();
                        if (!HireBillEditUI.this.isComboxEmptyInKDT(i, "newJobLevel")) continue;
                        HireBillEditUI.this.refreshJobLevelCombo((PositionInfo)positionValue, i);
                    }
                }
            }
        });
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                HireBillEditUI.this.rowIndex = e.getRowIndex();
                if (HireBillEditUI.this.kdtEntries.getColumn("newSalePoint").getColumnIndex() == e.getColIndex() && StringUtil.isEmpty((String)HireBillEditUI.this.salSchemeId)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource", (String)"NoSalSchmInCurHro"));
                    e.setCancel(true);
                    return;
                }
                super.editStarting(e);
            }
        });
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        HRAffairClientUtils.checkIsAudited(this.editData);
        super.actionAddPerson_actionPerformed(e);
        if (this.f7 == null) {
            this.f7 = new EmployeeMultiF7PromptBox();
            this.f7.setIsSingleSelect(false);
            this.f7.setEnabledMultiSelection(true);
            this.f7.setUserOrgRangeFilter(true);
            this.f7.showOnlyTryoutPerson(true);
        }
        this.f7.setIsPluralityIsChooseContral(HRParamUtil.getParamOfHR(null, (String)"PLURALITY_IS_CHOOSE", null));
        this.f7.show();
        if (!this.f7.isCanceled()) {
            BatchProcessedResult result;
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.f7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.f7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
            }
            if (this.f7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.f7.getData());
            }
            String billId = null;
            if (this.oprtState.equals(OprtState.EDIT)) {
                billId = this.editData.getId() != null ? this.editData.getId().toString() : this.getUIContext().get("ID").toString();
            }
            if ((result = HRAffairPersonPreProcessFacadeFactory.getRemoteInstance().preProcessHirePerson(persons, billId)) == null) {
                return;
            }
            if (result.isHasValidInfo()) {
                MsgBox.showWarning((Component)((Object)this), (String)result.getInvalidInfo());
            }
            List processedPerson = result.getResult();
            this.fillKdtEntryTable(processedPerson);
            if (this.kdtEntries.getRowCount() > 0) {
                this.kdtEntries.getSelectManager().select(0, 0);
            }
        }
    }

    private void fillKdtEntryTable(List persons) throws Exception {
        if (persons == null || persons.size() <= 0) {
            return;
        }
        PersonInfo info = null;
        ICell iCell = null;
        IRow iRow = null;
        int size = persons.size();
        for (int k = 0; k < size; ++k) {
            IPerson ips;
            PositionInfo posinfo;
            ArrayList degreeRelInfo;
            PersonPositionInfo ppInfo;
            info = (PersonInfo)persons.get(k);
            boolean isHasHaved = false;
            int length = this.kdtEntries.getRowCount();
            for (int i = 0; i < length; ++i) {
                iCell = this.kdtEntries.getRow(i).getCell("person");
                if (iCell.getValue() == null || !((PersonInfo)iCell.getValue()).getId().equals((Object)info.getId())) continue;
                isHasHaved = true;
                break;
            }
            if (isHasHaved) continue;
            iRow = this.kdtEntries.addRow();
            iCell = iRow.getCell("person");
            if (iCell != null) {
                iCell.setValue((Object)info);
            }
            iRow.getCell("number").setValue((Object)info.getNumber());
            iRow.getCell("phone").setValue((Object)info.getOfficePhone());
            iRow.getCell("birthday").setValue((Object)info.getBirthday());
            iRow.getCell("gender").setValue((Object)info.getGender());
            iRow.getCell("heightDegree").setValue((Object)info.getHighestDegree());
            iRow.getCell("heightTechPost").setValue((Object)info.getHighestTechPost());
            ArrayList data = (ArrayList)info.get("personDatas");
            ArrayList postAndOrg = (ArrayList)info.get("postAndOrg");
            ArrayList postOrg = (ArrayList)info.get("postOrg");
            if (data != null) {
                if (data.get(0) != null) {
                    iRow.getCell("enrollDate").setValue(data.get(0));
                }
                if (data.get(1) != null) {
                    iRow.getCell("tryoutMonth").setValue(data.get(1));
                }
                if (data.get(0) != null && data.get(1) != null) {
                    iRow.getCell("hireDate").setValue((Object)DateTimeUtils.addMonth((Date)((Date)data.get(0)), (int)((Integer)data.get(1))));
                }
            }
            if (postAndOrg != null) {
                iRow.getCell("position").setValue(postAndOrg.get(0));
                iRow.getCell("dept").setValue(postAndOrg.get(postAndOrg.size() - 1));
            }
            if (postOrg != null) {
                PositionInfo position = (PositionInfo)postOrg.get(0);
                iRow.getCell("eposition").setValue((Object)position);
                this.refreshJobLevelCombo(position, iRow.getRowIndex());
            }
            if ((ppInfo = (PersonPositionInfo)info.get("personPosition")) != null) {
                iRow.getCell("jobStartDate").setValue((Object)ppInfo.getJobStartDate());
                iRow.getCell("jobGrade").setValue((Object)ppInfo.getJobGrade());
            }
            if (ppInfo != null) {
                iRow.getCell("jobLevel").setValue((Object)ppInfo.getJobLevel());
                iRow.getCell("years").setValue((Object)ppInfo.getLenOfActualService());
            }
            if ((degreeRelInfo = (ArrayList)info.get("degreeRelInfo")) != null) {
                iRow.getCell("specialty").setValue(degreeRelInfo.get(2));
            } else {
                StringBuffer specialtyBuf = new StringBuffer("select specialty where person.id ='");
                specialtyBuf.append(info.getId());
                specialtyBuf.append("' and isHighestDegree = 1");
                IPersonDegree iPersonDegree = PersonDegreeFactory.getRemoteInstance();
                PersonDegreeCollection personDegreeCol = iPersonDegree.getPersonDegreeCollection(specialtyBuf.toString());
                PersonDegreeInfo personDegreeInfo = null;
                if (personDegreeCol != null && personDegreeCol.size() > 0) {
                    personDegreeInfo = personDegreeCol.get(0);
                    iRow.getCell("specialty").setValue((Object)personDegreeInfo.getSpecialty());
                }
            }
            String personalID = null;
            if (info.getId() == null) continue;
            personalID = info.getId().toString();
            SalariatHiberPropsInfo shpInfo = this.getFixedCmpSchemeInfo(personalID);
            if (shpInfo != null) {
                iRow.getCell("nowSalePoint").setValue((Object)shpInfo);
                if (shpInfo.get("oldSalPointSalGradeID") != null) {
                    iRow.getCell("oldSalPointSalGradeID").setValue(shpInfo.get("oldSalPointSalGradeID"));
                }
            }
            if ((posinfo = (ips = PersonFactory.getRemoteInstance()).getPrimaryPosition(BOSUuid.read((String)personalID))).getId() == null) {
                return;
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add(new SelectorItemInfo("positionType.name"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("positionType.id"));
            entityViewInfo.getSelector().add(new SelectorItemInfo("positionType.number"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)posinfo.getId().toString()));
            entityViewInfo.setFilter(filterInfo);
            IPosition iPosition = PositionFactory.getRemoteInstance();
            PositionCollection pscol = iPosition.getPositionCollection(entityViewInfo);
            if (pscol == null || pscol.size() <= 0 || pscol.get(0).getPositionType() == null) continue;
            iRow.getCell("positionType").setValue((Object)pscol.get(0).getPositionType());
        }
    }

    @Override
    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        HRAffairClientUtils.checkIsAudited(this.editData);
        super.actionDelPerson_actionPerformed(e);
        if (this.kdtEntries.getRowCount() <= 0) {
            return;
        }
        int[] selectRows = HireBillEditUI.getSelectedRows(this.kdtEntries);
        this.kdtEntries.getSelectManager().setSelectMode(10);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.kdtEntries.removeRow(selectRows[i]);
        }
        if (this.kdtEntries.getRowCount() >= 0) {
            this.kdtEntries.getSelectManager().select(0, 0);
        }
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrg.displayName"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.number"));
        sic.add(new SelectorItemInfo("entries.dept"));
        sic.add(new SelectorItemInfo("entries.phone"));
        sic.add(new SelectorItemInfo("entries.assessResult"));
        sic.add(new SelectorItemInfo("entries.hireSalary"));
        sic.add(new SelectorItemInfo("entries.enrollDate"));
        sic.add(new SelectorItemInfo("entries.tryoutMonth"));
        sic.add(new SelectorItemInfo("entries.hireDate"));
        sic.add(new SelectorItemInfo("entries.position"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.jobGrade.name"));
        sic.add(new SelectorItemInfo("entries.jobGrade.id"));
        sic.add(new SelectorItemInfo("entries.jobGrade.number"));
        sic.add(new SelectorItemInfo("entries.gender"));
        sic.add(new SelectorItemInfo("entries.birthday"));
        sic.add(new SelectorItemInfo("entries.specialty"));
        sic.add(new SelectorItemInfo("entries.jobStartDate"));
        sic.add(new SelectorItemInfo("entries.lenOfActualService"));
        sic.add(new SelectorItemInfo("entries.highestDegree.id"));
        sic.add(new SelectorItemInfo("entries.highestDegree.number"));
        sic.add(new SelectorItemInfo("entries.highestDegree.name"));
        sic.add(new SelectorItemInfo("entries.highestTechPost.id"));
        sic.add(new SelectorItemInfo("entries.highestTechPost.number"));
        sic.add(new SelectorItemInfo("entries.highestTechPost.name"));
        sic.add(new SelectorItemInfo("entries.selfAppraise"));
        sic.add(new SelectorItemInfo("entries.leadCommment"));
        sic.add(new SelectorItemInfo("entries.suggestPost"));
        sic.add(new SelectorItemInfo("entries.suggestPostSalary"));
        sic.add(new SelectorItemInfo("entries.suggestPostValue"));
        sic.add(new SelectorItemInfo("entries.eposition.id"));
        sic.add(new SelectorItemInfo("entries.eposition.number"));
        sic.add(new SelectorItemInfo("entries.eposition.name"));
        sic.add(new SelectorItemInfo("entries.jobLevel.name"));
        sic.add(new SelectorItemInfo("entries.jobLevel.id"));
        sic.add(new SelectorItemInfo("entries.jobLevel.number"));
        sic.add(new SelectorItemInfo("entries.jobLevel.name"));
        sic.add(new SelectorItemInfo("entries.jobLevel.id"));
        sic.add(new SelectorItemInfo("entries.jobLevel.number"));
        sic.add(new SelectorItemInfo("entries.nowSalePoint.name"));
        sic.add(new SelectorItemInfo("entries.nowSalePoint.parent.name"));
        sic.add(new SelectorItemInfo("entries.nowSalePoint.id"));
        sic.add(new SelectorItemInfo("entries.nowSalePoint.number"));
        sic.add(new SelectorItemInfo("entries.newSalePoint.id"));
        sic.add(new SelectorItemInfo("entries.newSalePoint.name"));
        sic.add(new SelectorItemInfo("entries.newSalePoint.parent.name"));
        sic.add(new SelectorItemInfo("entries.newSalePoint.number"));
        sic.add(new SelectorItemInfo("entries.positionType.id"));
        sic.add(new SelectorItemInfo("entries.positionType.name"));
        sic.add(new SelectorItemInfo("entries.positionType.number"));
        sic.add(new SelectorItemInfo("entries.EXpointValue"));
        sic.add(new SelectorItemInfo("entries.newJobLevel.id"));
        sic.add(new SelectorItemInfo("entries.newJobLevel.name"));
        sic.add(new SelectorItemInfo("entries.newJobLevel.number"));
        sic.add(new SelectorItemInfo("entries.salPointSalGradeID"));
        sic.add(new SelectorItemInfo("entries.oldSalPointSalGradeID"));
        return sic;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
        this.actionAttachment.setEnabled(true);
        this.btnRowAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnRowDelete.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnCopy.setEnabled(this.btnSubmit.isEnabled());
        this.btnCopy.setVisible(true);
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemCopyToColumn.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemCopyToColumn.setEnabled(this.btnSubmit.isEnabled());
        this.menuItemCopyToColumn.setVisible(true);
        this.kdtEntries.setColumnMoveable(true);
        this.setEnableByClient();
        this.setComboSubmitTypeValueByParam("ZZ001");
        this.kdtEntries.getColumn("nowSalePoint").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("positionType").getStyleAttributes().setLocked(true);
        this.initCellEditor();
    }

    private void setEnableByClient() {
        String clientName = null;
        try {
            clientName = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if ("hnjt".equals(clientName)) {
            this.kdtEntries.getColumn("selfAppraise").getStyleAttributes().setHided(false);
            this.kdtEntries.getColumn("leadCommment").getStyleAttributes().setHided(false);
            this.kdtEntries.getColumn("suggestPost").getStyleAttributes().setHided(false);
            this.kdtEntries.getColumn("suggestPostSalary").getStyleAttributes().setHided(false);
            this.kdtEntries.getColumn("suggestPostValue").getStyleAttributes().setHided(false);
        } else {
            this.kdtEntries.getColumn("selfAppraise").getStyleAttributes().setHided(true);
            this.kdtEntries.getColumn("leadCommment").getStyleAttributes().setHided(true);
            this.kdtEntries.getColumn("suggestPost").getStyleAttributes().setHided(true);
            this.kdtEntries.getColumn("suggestPostSalary").getStyleAttributes().setHided(true);
            this.kdtEntries.getColumn("suggestPostValue").getStyleAttributes().setHided(true);
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (size > 0) {
            sb = this.kdtEntries.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.kdtEntries.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.kdtEntries.getCell(row, column).getValue();
            Object positionValue = this.kdtEntries.getRow(row).getCell("eposition").getValue();
            Object newJobLevelValue = this.kdtEntries.getRow(row).getCell("newJobLevel").getValue();
            Object jobGradeValue = this.kdtEntries.getRow(row).getCell("jobGrade").getValue();
            boolean isJobLevelCol = column == this.kdtEntries.getColumn("newJobLevel").getColumnIndex();
            boolean isJobGradeCol = column == this.kdtEntries.getColumn("jobGrade").getColumnIndex();
            int length = this.kdtEntries.getRowCount();
            for (int i = 0; i < length; ++i) {
                PositionInfo position;
                if (i == row || this.kdtEntries.getCell(i, column).getStyleAttributes().isLocked()) continue;
                iCell = this.kdtEntries.getCell(i, column);
                if (!isJobLevelCol && !isJobGradeCol) {
                    iCell.setValue(value);
                }
                if ((position = (PositionInfo)this.kdtEntries.getCell(i, "eposition").getValue()) == null || positionValue == null || !position.getId().equals((Object)((PositionInfo)positionValue).getId())) continue;
                if (isJobLevelCol) {
                    iCell.setValue(value);
                    if ("true".equals(AffairUtil.getParamForClient("AutoGetJob", this.getCurrentHRO()))) {
                        this.kdtEntries.getCell(i, "jobGrade").setValue(jobGradeValue);
                    }
                }
                if (!isJobGradeCol) continue;
                iCell.setValue(value);
                if (!"true".equals(AffairUtil.getParamForClient("AutoGetJob", this.getCurrentHRO()))) continue;
                this.kdtEntries.getCell(i, "newJobLevel").setValue(newJobLevelValue);
            }
        }
    }

    @Override
    public void actionCopySelect_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (size > 0) {
            sb = this.kdtEntries.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.kdtEntries.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.kdtEntries.getCell(row, column).getValue();
            Object positionValue = this.kdtEntries.getRow(row).getCell("eposition").getValue();
            Object newJobLevelValue = this.kdtEntries.getRow(row).getCell("newJobLevel").getValue();
            Object jobGradeValue = this.kdtEntries.getRow(row).getCell("jobGrade").getValue();
            boolean isJobLevelCol = column == this.kdtEntries.getColumn("newJobLevel").getColumnIndex();
            boolean isJobGradeCol = column == this.kdtEntries.getColumn("jobGrade").getColumnIndex();
            for (int i = 0; i < size; ++i) {
                sb = this.kdtEntries.getSelectManager().get(i);
                for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                    PositionInfo position;
                    if (this.kdtEntries.getCell(j, column).getStyleAttributes().isLocked()) continue;
                    iCell = this.kdtEntries.getCell(j, column);
                    if (!isJobLevelCol && !isJobGradeCol) {
                        iCell.setValue(value);
                    }
                    if ((position = (PositionInfo)this.kdtEntries.getCell(j, "eposition").getValue()) == null || positionValue == null || !position.getId().equals((Object)((PositionInfo)positionValue).getId())) continue;
                    if (isJobLevelCol) {
                        iCell.setValue(value);
                        if ("true".equals(AffairUtil.getParamForClient("AutoGetJob", this.getCurrentHRO()))) {
                            this.kdtEntries.getCell(j, "jobGrade").setValue(jobGradeValue);
                        }
                    }
                    if (!isJobGradeCol) continue;
                    iCell.setValue(value);
                    if (!"true".equals(AffairUtil.getParamForClient("AutoGetJob", this.getCurrentHRO()))) continue;
                    this.kdtEntries.getCell(j, "newJobLevel").setValue(newJobLevelValue);
                }
            }
        }
    }

    @Override
    public void actionAffairReg_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (this.billId == null) {
            this.billId = this.editData.getId().toString();
        }
        if (size > 0) {
            Object value1;
            sb = this.kdtEntries.getSelectManager().get(0);
            int row = sb.getTop();
            Object value = this.kdtEntries.getCell(row, 2).getValue();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.number", value));
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)this.billId));
            filter.setMaskString(" #0 and #1 ");
            ev.setFilter(filter);
            HRBillBaseEntryCollection hireCols = HireBillEntryFactory.getRemoteInstance().getHRBillBaseEntryCollection(ev);
            if (hireCols != null && hireCols.size() > 0) {
                this.actPersonId = ((HireBillEntryInfo)hireCols.get(0)).getPerson().getId();
            }
            if ((value1 = this.kdtEntries.getCell(row, 0).getValue()) != null) {
                this.actEntryId = BOSUuid.read((String)value1.toString());
            }
        }
        if (this.actPersonId != null && this.actEntryId != null) {
            DataProvider data = new DataProvider();
            this.appHlp.printPreview(Hire_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
        }
    }

    protected void doFieldPermission() throws Exception {
        FieldPermission fields = this.getOldFieldPermission();
        super.doFieldPermission();
        DataBinder db = this.getMyDataBinder();
        BOSObjectType bizObjectType = this.getBizType();
        IObjectPK userPK = this.getUserPk();
        IObjectPK orgPK = this.getOrgPK(null);
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        FieldPermissionService.doFieldPermission((BOSObjectType)bizObjectType, (IObjectPK)userPK, (IObjectPK)orgPK, (DataBinder)db, (FieldPermission)fields);
    }

    private DataBinder getMyDataBinder() {
        DataBinder db = new DataBinder();
        db.registerBinding("entries", HireBillEntryInfo.class, (Component)this.kdtEntries, "userObject");
        db.registerBinding("proposer", String.class, (Component)this.txtProposer, "text");
        String columnName = null;
        String key = null;
        int size = this.kdtEntries.getColumnCount();
        for (int i = 0; i < size; ++i) {
            columnName = this.kdtEntries.getColumnKey(i);
            if ("eposition".equals(columnName)) continue;
            key = "heightDegree".equals(columnName) ? "highestDegree" : ("heightTechPost".equals(columnName) ? "highestTechPost" : ("years".equals(columnName) ? "lenOfActualService" : columnName));
            db.registerBinding("entries." + key, Object.class, (Component)this.kdtEntries, columnName + ".text");
        }
        return db;
    }

    public DataBinder getDataBinder() {
        return this.getMyDataBinder();
    }

    @Override
    public boolean isPrepareActionSubmit() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        try {
            OrgUnitInfo initOrg = null;
            if (this.getUIContext() != null && (initOrg = (OrgUnitInfo)this.getUIContext().get(this.getMainOrgType())) != null && initOrg instanceof HROrgUnitInfo) {
                request.put("hr_mainOrgId", (Object)initOrg.getId().toString());
            }
            request.put("bizType", (Object)this.getBizType());
            request.put("nowClientDate", (Object)this.nowDate);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public boolean isPrepareActionSave() {
        return true;
    }

    @Override
    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSave(itemAction);
        request.put("number", (Object)this.txtNumber.getText());
        request.put("actionSubmitSt", (Object)this.actionSubmit.toString());
        return request;
    }

    private void refreshJobLevelCombo(PositionInfo position, int rowIndex) {
        this.refreshJobLevelCombo(position, rowIndex, "newJobLevel", this.joblevelItemLisener);
    }

    protected void initCellEditor() throws Exception {
        this.bizPromptBox = new KDBizPromptBox();
        this.bizPromptBox.setEditFormat("$name$");
        this.bizPromptBox.setDisplayFormat("$name$");
        this.bizPromptBox.setDefaultF7UIName("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        this.bizPromptBox.setSelectorCollection(sic);
        this.bizPromptBox.setEditable(false);
        SalariatPointPromptBox pointPromtBox = new SalariatPointPromptBox();
        this.bizPromptBox.setSelector((KDPromptSelector)pointPromtBox);
        this.bizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                SalariatPointPromptBox pointPromtBox = (SalariatPointPromptBox)HireBillEditUI.this.bizPromptBox.getSelector();
                pointPromtBox.putParameter("schemeID", HireBillEditUI.this.salSchemeId);
                PersonInfo personInfo = (PersonInfo)HRTableTools.getTableSelectCellValue((KDTable)HireBillEditUI.this.kdtEntries, (String)"person");
                if (personInfo != null) {
                    pointPromtBox.putParameter("FPersonID", personInfo.getId().toString());
                }
            }
        });
        this.bizPromptBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                HireBillEditUI.this.bizPromptBox.getData();
            }
        });
        this.bizPromptBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent arg0) {
                try {
                    HireBillEditUI.this.setSalPointItemValue(HireBillEditUI.this.kdtEntries.getSelectManager().getActiveRowIndex(), arg0.getData());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        this.kdtEntries.getColumn("newSalePoint").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.bizPromptBox));
    }

    private SalariatHiberPropsInfo getFixedCmpSchemeInfo(String personID) throws BOSException, EASBizException {
        IEmpForCmpFacade iEmpForCmpFacade = EmpForCmpFacadeFactory.getRemoteInstance();
        SalariatHiberPropsInfo sInfo = null;
        FixedCmpSchemeInfo info = this.getFixedCmpSchemePersonInfo(personID);
        if (info != null) {
            String tableName = info.getHorTableName();
            sInfo = iEmpForCmpFacade.getSalariatHiberPropsInfo(tableName, personID);
        }
        return sInfo;
    }

    private FixedCmpSchemeInfo getFixedCmpSchemePersonInfo(String personID) throws BOSException, EASBizException {
        IFixedCmpSchemePerson iFixedCmpSchemePerson = FixedCmpSchemePersonFactory.getRemoteInstance();
        FixedCmpSchemePersonInfo perInfo = null;
        FixedCmpSchemeInfo info = null;
        String oql = "select fixedCmpScheme.horTableName where person.id = '" + personID + "' and fixedCmpScheme.enable = 1 and fixedCmpScheme.hrOrgUnit.id='" + FrameWorkUtils.getCurrentHRUnit((Context)this.getMainOrgContext()).getId().toString() + "'";
        if (iFixedCmpSchemePerson.exists(oql)) {
            perInfo = iFixedCmpSchemePerson.getFixedCmpSchemePersonInfo(oql);
        }
        if (perInfo != null) {
            info = perInfo.getFixedCmpScheme();
        }
        return info;
    }

    private void setSalPointItemValue(int indexRow, Object obj) throws Exception {
        if (obj != null) {
            SalariatHiberPropsInfo infoSal = (SalariatHiberPropsInfo)obj;
            String id = infoSal.getId().toString();
            boolean isEnable = HRUtils.getParamValue(null, (String)"hr_cmp_011", null);
            if (isEnable) {
                if (infoSal.get("pointInfo") != null) {
                    IRow row = (IRow)infoSal.get("pointInfo");
                    IRow iRow = this.kdtEntries.getRow(indexRow);
                    CmpItemCollection coll = HRUtils.getCmpItemsByScheme((String)this.salSchemeId);
                    String number = null;
                    ICell iCell = null;
                    Object obj1 = null;
                    BigDecimal value = null;
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        number = coll.get(i).getNumber();
                        iCell = iRow.getCell("EXpointValue");
                        obj1 = row.getCell(number).getValue();
                        if (obj1 == null || iCell == null) continue;
                        value = new BigDecimal(obj1.toString());
                        iCell.setValue((Object)value.setScale(2, 4));
                    }
                    infoSal.remove("pointInfo");
                }
            } else if (this.mapPoint.get(id) != null) {
                Map pointValueMap = (Map)this.mapPoint.get(id);
                Iterator itr = pointValueMap.keySet().iterator();
                String number = null;
                while (itr.hasNext()) {
                    number = itr.next().toString();
                    this.kdtEntries.getCell(indexRow, "EXpointValue").setValue(pointValueMap.get(number));
                }
            }
        }
    }

    @Override
    protected String getPrintPath() {
        return Hire_FILENAME;
    }

    @Override
    protected String getBaseInfoPrintQuery() {
        return "com.kingdee.eas.hr.affair.app.HireBaseInfoQuery";
    }

    @Override
    protected String getApproveInfoPrintQuery() {
        return "com.kingdee.eas.hr.affair.app.HireApproveInfoQuery";
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            try {
                IAffairRegFacade iAffairReg = AffairRegFacadeFactory.getRemoteInstance();
                if (ds.getID() != null) {
                    if (ds.getID().equals("ds2")) {
                        return iAffairReg.getAffairBillRegByEntry(AffairTypeEnum.HIRE, HireBillEditUI.this.actEntryId, BOSUuid.read((String)HireBillEditUI.this.billId));
                    }
                    if (ds.getID().equals("ds3")) {
                        return iAffairReg.getMultiApproveDecByPerson(AffairTypeEnum.HIRE, HireBillEditUI.this.actPersonId, BOSUuid.read((String)HireBillEditUI.this.billId));
                    }
                }
            }
            catch (BOSException e) {
                HireBillEditUI.this.handUIException(e);
            }
            catch (EASBizException e) {
                HireBillEditUI.this.handUIException(e);
            }
            return null;
        }
    }
}

